/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.pivot;

import com.jidesoft.pivot.IPivotDataModel;
import com.jidesoft.pivot.PivotDataEditingProvider;
import com.jidesoft.pivot.PivotDataModel;
import com.jidesoft.pivot.PivotEditingProvider;
import com.jidesoft.pivot.PivotField;
import java.util.Arrays;
import java.util.List;

public abstract class AbstractPivotEditingProvider
implements PivotEditingProvider {
    private boolean _dataEditable = true;
    private boolean _rowHeaderEditable = true;
    private boolean _columnHeaderEditable = true;

    @Override
    public boolean isDataEditable() {
        return this._dataEditable;
    }

    @Override
    public void setDataEditable(boolean bl) {
        this._dataEditable = bl;
    }

    @Override
    public boolean isRowHeaderEditable() {
        return this._rowHeaderEditable;
    }

    @Override
    public void setRowHeaderEditable(boolean bl) {
        this._rowHeaderEditable = bl;
    }

    @Override
    public boolean isColumnHeaderEditable() {
        return this._columnHeaderEditable;
    }

    @Override
    public void setColumnHeaderEditable(boolean bl) {
        this._columnHeaderEditable = bl;
    }

    @Override
    public PivotDataEditingProvider getPivotRowHeaderEditingProvider() {
        return new PivotDataEditingProvider(){

            @Override
            public boolean isCellEditable(PivotDataModel pivotDataModel, int n, int n2) {
                return AbstractPivotEditingProvider.this.isRowHeaderEditable() && pivotDataModel.getRowFields().length != 0 && (!pivotDataModel.isRowDataFields() || n2 != pivotDataModel.getRowFields().length);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setValueAt(PivotDataModel pivotDataModel, Object object, int n, int n2) {
                List<Integer> list = pivotDataModel.getDataAt(n, -n2 - 1);
                if (list != null) {
                    Object[] objectArray = list.toArray(new Integer[list.size()]);
                    Arrays.sort(objectArray);
                    if (objectArray.length > 1) {
                        pivotDataModel.setAdjusting(true);
                    }
                    try {
                        for (int i = objectArray.length - 1; i >= 0; --i) {
                            int n3 = (Integer)objectArray[i];
                            AbstractPivotEditingProvider.this.setValueAt(pivotDataModel, object, n3, pivotDataModel.getRowFields()[n2].getModelIndex());
                        }
                    }
                    finally {
                        if (objectArray.length > 1) {
                            pivotDataModel.setAdjusting(false);
                            pivotDataModel.invalidateRowHeaderTableModel();
                            pivotDataModel.getDataTableModel();
                        }
                    }
                }
            }
        };
    }

    @Override
    public PivotDataEditingProvider getPivotColumnHeaderEditingProvider() {
        return new PivotDataEditingProvider(){

            @Override
            public boolean isCellEditable(PivotDataModel pivotDataModel, int n, int n2) {
                return AbstractPivotEditingProvider.this.isColumnHeaderEditable() && pivotDataModel.getColumnFields().length != 0 && (!pivotDataModel.isColumnDataFields() || n != pivotDataModel.getColumnFields().length);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setValueAt(PivotDataModel pivotDataModel, Object object, int n, int n2) {
                List<Integer> list = pivotDataModel.getDataAt(-n - 1, n2);
                if (list != null) {
                    Object[] objectArray = list.toArray(new Integer[list.size()]);
                    Arrays.sort(objectArray);
                    if (objectArray.length > 1) {
                        pivotDataModel.setAdjusting(true);
                    }
                    try {
                        for (int i = objectArray.length - 1; i >= 0; --i) {
                            int n3 = (Integer)objectArray[i];
                            AbstractPivotEditingProvider.this.setValueAt(pivotDataModel, object, n3, pivotDataModel.getColumnFields()[n].getModelIndex());
                        }
                    }
                    finally {
                        if (objectArray.length > 1) {
                            pivotDataModel.setAdjusting(false);
                            pivotDataModel.invalidateColumnHeaderTableModel();
                        }
                    }
                }
            }
        };
    }

    @Override
    public PivotDataEditingProvider getPivotDataEditingProvider() {
        return new PivotDataEditingProvider(){

            @Override
            public boolean isCellEditable(PivotDataModel pivotDataModel, int n, int n2) {
                int n3 = pivotDataModel.getDataFields().length;
                return n3 != 0 && AbstractPivotEditingProvider.this._dataEditable;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setValueAt(PivotDataModel pivotDataModel, Object object, int n, int n2) {
                int n3 = pivotDataModel.getDataFields().length;
                if (n3 == 0) {
                    return;
                }
                int n4 = pivotDataModel.isColumnDataFields() ? n2 % n3 : n % n3;
                List<Integer> list = pivotDataModel.getDataAt(n, n2);
                if (list != null && list.size() >= 1) {
                    Integer[] integerArray;
                    for (Integer n5 : integerArray = list.toArray(new Integer[list.size()])) {
                        AbstractPivotEditingProvider.this.setValueAt(pivotDataModel, object, n5, pivotDataModel.getDataFields()[n4].getModelIndex());
                    }
                } else {
                    Object[] objectArray = pivotDataModel.getRowHeaderTableModel().getKeyValuesAt(n);
                    PivotField[] pivotFieldArray = pivotDataModel.getRowFields();
                    Object[] objectArray2 = pivotDataModel.getColumnHeaderTableModel().getKeyValuesAt(n2);
                    PivotField[] pivotFieldArray2 = pivotDataModel.getColumnFields();
                    boolean bl = pivotDataModel.isSingleValueMode();
                    pivotDataModel.setSingleValueMode(false);
                    try {
                        PivotField pivotField;
                        int n6;
                        int n7 = AbstractPivotEditingProvider.this.addRow(pivotDataModel);
                        for (n6 = 0; n6 < pivotFieldArray.length && n6 < objectArray.length; ++n6) {
                            pivotField = pivotFieldArray[n6];
                            AbstractPivotEditingProvider.this.setValueAt(pivotDataModel, objectArray[n6], n7, pivotField.getModelIndex());
                        }
                        for (n6 = 0; n6 < pivotFieldArray2.length && n6 < objectArray2.length; ++n6) {
                            pivotField = pivotFieldArray2[n6];
                            AbstractPivotEditingProvider.this.setValueAt(pivotDataModel, objectArray2[n6], n7, pivotField.getModelIndex());
                        }
                        AbstractPivotEditingProvider.this.setValueAt(pivotDataModel, object, n7, pivotDataModel.getDataFields()[n4].getModelIndex());
                    }
                    finally {
                        pivotDataModel.setSingleValueMode(bl);
                    }
                }
            }
        };
    }

    @Override
    public void setValueAt(IPivotDataModel iPivotDataModel, Object object, int n, int n2) {
        iPivotDataModel.getDataSource().setValueAt(object, n, n2);
    }
}

