/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.pane;

import com.jidesoft.plaf.LookAndFeelFactory;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.plaf.basic.BasicPainter;
import com.jidesoft.swing.JideSwingUtilities;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import javax.swing.JPanel;

class TitlePane
extends JPanel {
    private BasicPainter _painter = null;
    private Rectangle rect = null;
    private Font font = new Font("Arial", 1, 16);
    private String _title = "Courier";

    public TitlePane() {
        this.setPreferredSize(new Dimension(this.getPreferredSize().width, 26));
        this.updateUI();
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this._painter = (BasicPainter)UIDefaultsLookup.get("Theme.painter");
    }

    @Override
    public void paint(Graphics graphics) {
        super.paint(graphics);
        this.rect = this.getBounds();
        this.rect.width += 6;
        this.rect.x -= 4;
        this._painter.paintChevronBackground(this, graphics, this.rect, 0, 0);
        graphics.setFont(this.font);
        graphics.setColor(Color.WHITE);
        JideSwingUtilities.drawString(this, graphics, this._title, 10, 18);
    }

    public void setTitle(String string) {
        this._title = string;
        this.repaint();
    }

    public static void main(String[] stringArray) {
        LookAndFeelFactory.installDefaultLookAndFeelAndExtension();
        JFrame jFrame = new JFrame("Test TitleBannerPane");
        TitlePane titlePane = new TitlePane();
        titlePane.setTitle("Hello world");
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)titlePane, "North");
        jFrame.getContentPane().add(jPanel);
        jFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                super.windowClosing(windowEvent);
                System.exit(0);
            }
        });
        jFrame.setSize(100, 300);
        jFrame.setVisible(true);
    }
}

