/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.pane;

import com.jidesoft.pane.BookmarkButton;
import com.jidesoft.utils.Lm;
import com.jidesoft.utils.Q;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleSelection;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.TabbedPaneUI;
import javax.swing.plaf.UIResource;

public class BookmarkPane
extends JTabbedPane {
    protected Vector<AbstractButton> _buttons = new Vector();

    public BookmarkPane() {
        this.setLayout(new BookmarkPanePaneLayout());
        this.setBorder(BorderFactory.createBevelBorder(1));
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        if (this.isOpaque()) {
            graphics.setColor(this.getBackground());
            graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
    }

    @Override
    public void updateUI() {
        Component component;
        int n;
        if (this._buttons != null) {
            for (n = 0; n < this._buttons.size(); ++n) {
                component = this._buttons.elementAt(n);
                ((AbstractButton)component).updateUI();
            }
        }
        for (n = 0; n < this.getTabCount(); ++n) {
            component = this.getComponentAt(n);
            if (!(component instanceof JComponent)) continue;
            ((JComponent)component).updateUI();
        }
    }

    public Vector<AbstractButton> getButtons() {
        return this._buttons;
    }

    @Override
    public void removeTabAt(int n) {
        AbstractButton abstractButton = this._buttons.elementAt(n);
        int n2 = this.getSelectedIndex();
        if (n2 >= this.getTabCount() - 1) {
            this.setSelectedIndex(n2 - 1);
        }
        super.removeTabAt(n);
        this._buttons.removeElementAt(n);
        this.remove(abstractButton);
    }

    @Override
    public void insertTab(String string, Icon icon, Component component, String string2, int n) {
        super.insertTab(string, icon, component, string2, n);
        AbstractButton abstractButton = this.createButton(new SwitchPageAction(string, icon));
        if (!(abstractButton instanceof UIResource)) {
            throw new IllegalArgumentException("The button returned from createButton(Actoin action) method is not an instance of UIResoruce.");
        }
        abstractButton.setToolTipText(string2);
        this._buttons.insertElementAt(abstractButton, n);
        this.add(abstractButton);
        component.setVisible(true);
    }

    protected AbstractButton createButton(Action action) {
        BookmarkButton bookmarkButton = new BookmarkButton(action);
        this.customizeButton(bookmarkButton);
        return bookmarkButton;
    }

    private void checkIndex(int n) {
        if (n < 0 || n >= this.getButtons().size()) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Tab count: " + this.getButtons().size());
        }
    }

    @Override
    public int getMnemonicAt(int n) {
        this.checkIndex(n);
        AbstractButton abstractButton = this.getButtons().get(n);
        return abstractButton.getMnemonic();
    }

    @Override
    public void setMnemonicAt(int n, int n2) {
        this.checkIndex(n);
        AbstractButton abstractButton = this.getButtons().get(n);
        abstractButton.setMnemonic(n2);
        super.setMnemonicAt(n, n2);
    }

    @Override
    public int getDisplayedMnemonicIndexAt(int n) {
        this.checkIndex(n);
        AbstractButton abstractButton = this.getButtons().get(n);
        return abstractButton.getDisplayedMnemonicIndex();
    }

    @Override
    public void setDisplayedMnemonicIndexAt(int n, int n2) {
        this.checkIndex(n);
        AbstractButton abstractButton = this.getButtons().get(n);
        abstractButton.setDisplayedMnemonicIndex(n2);
        super.setDisplayedMnemonicIndexAt(n, n2);
    }

    @Override
    public void setTitleAt(int n, String string) {
        this.checkIndex(n);
        AbstractButton abstractButton = this.getButtons().get(n);
        abstractButton.setText(string);
        super.setTitleAt(n, string);
    }

    @Override
    public String getTitleAt(int n) {
        this.checkIndex(n);
        AbstractButton abstractButton = this.getButtons().get(n);
        return abstractButton.getText();
    }

    @Override
    public Icon getIconAt(int n) {
        this.checkIndex(n);
        AbstractButton abstractButton = this.getButtons().get(n);
        return abstractButton.getIcon();
    }

    @Override
    public void setIconAt(int n, Icon icon) {
        this.checkIndex(n);
        AbstractButton abstractButton = this.getButtons().get(n);
        abstractButton.setIcon(icon);
        super.setIconAt(n, icon);
    }

    @Override
    public Icon getDisabledIconAt(int n) {
        this.checkIndex(n);
        AbstractButton abstractButton = this.getButtons().get(n);
        return abstractButton.getDisabledIcon();
    }

    @Override
    public void setDisabledIconAt(int n, Icon icon) {
        this.checkIndex(n);
        AbstractButton abstractButton = this.getButtons().get(n);
        abstractButton.setDisabledIcon(icon);
        super.setDisabledIconAt(n, icon);
    }

    @Override
    public String getToolTipTextAt(int n) {
        this.checkIndex(n);
        AbstractButton abstractButton = this.getButtons().get(n);
        return abstractButton.getToolTipText();
    }

    @Override
    public void setToolTipTextAt(int n, String string) {
        this.checkIndex(n);
        AbstractButton abstractButton = this.getButtons().get(n);
        abstractButton.setToolTipText(string);
        super.setToolTipTextAt(n, string);
    }

    @Override
    public boolean isEnabledAt(int n) {
        this.checkIndex(n);
        AbstractButton abstractButton = this.getButtons().get(n);
        return abstractButton.isEnabled();
    }

    @Override
    public void setEnabledAt(int n, boolean bl) {
        this.checkIndex(n);
        AbstractButton abstractButton = this.getButtons().get(n);
        abstractButton.setEnabled(bl);
        super.setEnabledAt(n, bl);
    }

    protected void customizeButton(AbstractButton abstractButton) {
        abstractButton.setRequestFocusEnabled(false);
        abstractButton.setFocusable(false);
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJTabbedPane();
        }
        return this.accessibleContext;
    }

    public boolean isTabSelected(int n) {
        this.checkIndex(n);
        AbstractButton abstractButton = this.getButtons().get(n);
        return abstractButton instanceof AbstractButton && abstractButton.isSelected();
    }

    public void setTabSelected(int n, boolean bl) {
        this.checkIndex(n);
        AbstractButton abstractButton = this.getButtons().get(n);
        if (abstractButton instanceof AbstractButton) {
            abstractButton.setSelected(bl);
            this.doLayout();
        }
    }

    static {
        try {
            if (Lm.class.getDeclaredMethods().length != 29 && Lm.class.getDeclaredMethods().length != 31) {
                System.err.println("The Lm class is invalid, exiting ... " + Lm.class.getDeclaredMethods().length);
                System.exit(-1);
            }
        }
        catch (Exception exception) {
            System.exit(-1);
        }
        if (!Q.zz(2)) {
            Lm.showInvalidProductMessage(BookmarkPane.class.getName(), 2);
        }
    }

    protected class AccessibleJTabbedPane
    extends JComponent.AccessibleJComponent
    implements AccessibleSelection,
    ChangeListener {
        public AccessibleJTabbedPane() {
            super(BookmarkPane.this);
            BookmarkPane.this.model.addChangeListener(this);
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            Object object = changeEvent.getSource();
            this.firePropertyChange("AccessibleSelection", null, object);
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.PAGE_TAB_LIST;
        }

        @Override
        public int getAccessibleChildrenCount() {
            return BookmarkPane.this.getTabCount();
        }

        @Override
        public Accessible getAccessibleChild(int n) {
            if (n < 0 || n >= BookmarkPane.this.getTabCount()) {
                return null;
            }
            return (Accessible)((Object)BookmarkPane.this._buttons.elementAt(n));
        }

        @Override
        public AccessibleSelection getAccessibleSelection() {
            return this;
        }

        @Override
        public Accessible getAccessibleAt(Point point) {
            int n = ((TabbedPaneUI)BookmarkPane.this.ui).tabForCoordinate(BookmarkPane.this, point.x, point.y);
            if (n == -1) {
                n = BookmarkPane.this.getSelectedIndex();
            }
            return this.getAccessibleChild(n);
        }

        @Override
        public int getAccessibleSelectionCount() {
            return 1;
        }

        @Override
        public Accessible getAccessibleSelection(int n) {
            int n2 = BookmarkPane.this.getSelectedIndex();
            if (n2 == -1) {
                return null;
            }
            return (Accessible)((Object)BookmarkPane.this._buttons.elementAt(n2));
        }

        @Override
        public boolean isAccessibleChildSelected(int n) {
            return n == BookmarkPane.this.getSelectedIndex();
        }

        @Override
        public void addAccessibleSelection(int n) {
            BookmarkPane.this.setSelectedIndex(n);
        }

        @Override
        public void removeAccessibleSelection(int n) {
        }

        @Override
        public void clearAccessibleSelection() {
        }

        @Override
        public void selectAllAccessibleSelection() {
        }
    }

    private class BookmarkPanePaneLayout
    implements LayoutManager {
        private BookmarkPanePaneLayout() {
        }

        @Override
        public void addLayoutComponent(String string, Component component) {
        }

        @Override
        public void removeLayoutComponent(Component component) {
        }

        @Override
        public Dimension preferredLayoutSize(Container container) {
            int n;
            Vector<AbstractButton> vector;
            if (!(container instanceof BookmarkPane)) {
                return new Dimension(0, 0);
            }
            Dimension dimension = null;
            BookmarkPane bookmarkPane = (BookmarkPane)container;
            if (bookmarkPane.getButtons().size() == 0) {
                dimension = new Dimension(0, 0);
            } else {
                vector = bookmarkPane.getButtons();
                n = 0;
                int n2 = 0;
                int n3 = 0;
                int n4 = 0;
                boolean bl = true;
                for (int i = 0; i < vector.size(); ++i) {
                    AbstractButton abstractButton = vector.elementAt(i);
                    int n5 = abstractButton.getPreferredSize().width;
                    int n6 = abstractButton.getPreferredSize().height;
                    if (bl) {
                        bl = false;
                        n3 += n5;
                        n4 = Math.max(n4, n6);
                        continue;
                    }
                    if (n3 + n5 > container.getWidth()) {
                        n = Math.max(n3, n);
                        n2 += n4;
                        n3 = n5;
                        n4 = n6;
                        continue;
                    }
                    n3 += n5;
                    n4 = Math.max(n4, n6);
                }
                n = Math.max(n3, n);
                Insets insets = bookmarkPane.getInsets();
                dimension = new Dimension(insets.left + insets.right + n, insets.top + insets.bottom + (n2 += n4));
            }
            vector = bookmarkPane.getButtons();
            for (n = 0; n < vector.size(); ++n) {
                AbstractButton abstractButton = vector.elementAt(n);
                if (!abstractButton.isSelected()) continue;
                dimension.height += bookmarkPane.getComponentAt((int)n).getPreferredSize().height;
            }
            return dimension;
        }

        @Override
        public Dimension minimumLayoutSize(Container container) {
            if (!(container instanceof BookmarkPane)) {
                return new Dimension(0, 0);
            }
            BookmarkPane bookmarkPane = (BookmarkPane)container;
            if (bookmarkPane.getButtons().size() == 0) {
                return new Dimension(0, 0);
            }
            Vector<AbstractButton> vector = bookmarkPane.getButtons();
            int n = 0;
            int n2 = 0;
            for (int i = 0; i < vector.size(); ++i) {
                AbstractButton abstractButton = vector.elementAt(i);
                n += abstractButton.getPreferredSize().width;
                if (n2 >= abstractButton.getPreferredSize().height) continue;
                n2 = abstractButton.getPreferredSize().height;
            }
            Insets insets = bookmarkPane.getInsets();
            return new Dimension(insets.left + insets.right + n, insets.top + insets.bottom + n2);
        }

        @Override
        public void layoutContainer(Container container) {
            AbstractButton abstractButton;
            int n;
            if (!(container instanceof BookmarkPane)) {
                return;
            }
            BookmarkPane bookmarkPane = (BookmarkPane)container;
            if (bookmarkPane.getButtons().size() == 0) {
                return;
            }
            Insets insets = bookmarkPane.getInsets();
            int n2 = BookmarkPane.this.getMinimumSize().height - insets.top - insets.bottom;
            int n3 = bookmarkPane.getWidth() - insets.left - insets.right;
            Vector<AbstractButton> vector = bookmarkPane.getButtons();
            int n4 = insets.top;
            int n5 = 0;
            int n6 = insets.left;
            for (n = 0; n < vector.size(); ++n) {
                abstractButton = vector.elementAt(n);
                int n7 = abstractButton.getPreferredSize().width;
                n5 = Math.max(n5, abstractButton.getPreferredSize().height);
                if (n != 0 && n6 + n7 > container.getWidth()) {
                    n6 = insets.left;
                    n4 += n5;
                }
                abstractButton.setBounds(n6, n4, n7, n2);
                n6 += n7;
                if (n != vector.size() - 1) continue;
                n4 += n5;
            }
            for (n = 0; n < vector.size(); ++n) {
                Component component;
                abstractButton = vector.elementAt(n);
                if (abstractButton.isSelected()) {
                    component = bookmarkPane.getComponentAt(n);
                    int n8 = component.getPreferredSize().height;
                    component.setBounds(insets.left, n4, n3, n8);
                    n4 += n8;
                    component.setVisible(true);
                    continue;
                }
                component = bookmarkPane.getComponentAt(n);
                component.setVisible(false);
            }
        }
    }

    private class SwitchPageAction
    extends AbstractAction {
        public SwitchPageAction(String string, Icon icon) {
            super(string, icon);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            BookmarkPane.this.doLayout();
            BookmarkPane.this.repaint();
        }
    }
}

