/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.pane;

import com.jidesoft.icons.IconsFactory;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.swing.JideSwingUtilities;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.geom.GeneralPath;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.plaf.UIResource;

class BookmarkButton
extends JToggleButton
implements UIResource {
    public static final long serialVersionUID = 1111112L;
    static Icon UP_ICON = IconsFactory.getImageIcon(BookmarkButton.class, "icons/up.png");
    static Icon DOWN_ICON = IconsFactory.getImageIcon(BookmarkButton.class, "icons/down.png");
    protected Color _tabRolloverBackground = new Color(255, 255, 230);
    protected Color _tabBackground = UIDefaultsLookup.getColor("control");
    protected Color _tabLineColor = UIDefaultsLookup.getColor("controlDkShadow");

    public BookmarkButton() {
    }

    public BookmarkButton(Icon icon) {
        super(icon);
    }

    public BookmarkButton(String string) {
        super(string);
    }

    public BookmarkButton(Action action) {
        super(action);
    }

    public BookmarkButton(String string, Icon icon) {
        super(string, icon);
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this._tabRolloverBackground = new Color(255, 255, 230);
        this._tabBackground = UIDefaultsLookup.getColor("control");
        this._tabLineColor = UIDefaultsLookup.getColor("controlDkShadow");
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getPreferredSize() {
        int n = SwingUtilities.computeStringWidth(this.getFontMetrics(this.getFont()), this.getText());
        int n2 = Math.max(UP_ICON.getIconHeight() + 2, 14);
        if (this.getIcon() != null) {
            n2 = Math.max(n2, this.getIcon().getIconHeight());
        }
        return new Dimension(3 + UP_ICON.getIconWidth() + (this.getIcon() != null ? this.getIcon().getIconWidth() + this.getIconTextGap() : 0) + this.getIconTextGap() + n + 3 + n2, n2);
    }

    @Override
    public void paint(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        JideSwingUtilities.setupShapeAntialiasing(graphics2D);
        if (this.isOpaque()) {
            graphics2D.setColor(this.getBackground());
            graphics2D.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
        int n = this.getWidth();
        int n2 = this.getHeight();
        float f = 1.6f;
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(0.0f, 0.0f);
        generalPath.lineTo(0.0f, n2 - 3);
        generalPath.curveTo(0.0f, n2 - 3, 1.0f, n2 - 1, 3.0f, n2 - 1);
        generalPath.lineTo((float)n - (float)n2 * f, n2 - 1);
        Point point = new Point((int)((float)n - (float)n2 * f), n2 - 1);
        Point point2 = new Point((int)((float)n - (float)(n2 * 2) * f / 3.0f), (int)(0.72 * (double)n2));
        Point point3 = new Point((int)((float)n - (float)n2 * f / 3.0f), (int)(0.22 * (double)n2));
        Point point4 = new Point(n, 0);
        generalPath.curveTo(point.x, point.y, (point.x + point2.x) / 2 + 3, (point.y + point2.y) / 2 + 2, point2.x, point2.y);
        generalPath.lineTo(point3.x, point3.y);
        generalPath.curveTo(point3.x, point3.y, (point3.x + point4.x) / 2 - 2, (point3.y + point4.y) / 2 - 2, point4.x, point4.y);
        if (this.isRolloverEnabled() && this.getModel().isRollover()) {
            graphics2D.setColor(this._tabRolloverBackground);
            graphics2D.fill(generalPath);
        } else if (this.isOpaque()) {
            graphics2D.setColor(this._tabBackground);
            graphics2D.fill(generalPath);
        }
        int n3 = 3;
        if (this.isSelected()) {
            UP_ICON.paintIcon(this, graphics, n3, (n2 - UP_ICON.getIconHeight()) / 2);
            n3 += this.getIconTextGap() + UP_ICON.getIconWidth();
        } else {
            DOWN_ICON.paintIcon(this, graphics, n3, (n2 - DOWN_ICON.getIconHeight()) / 2);
            n3 += this.getIconTextGap() + DOWN_ICON.getIconWidth();
        }
        if (this.getIcon() != null) {
            this.getIcon().paintIcon(this, graphics, n3, (n2 - this.getIcon().getIconHeight()) / 2);
            n3 += this.getIconTextGap() + this.getIcon().getIconWidth();
        }
        graphics2D.setColor(this._tabLineColor);
        graphics2D.draw(generalPath);
        graphics2D.setColor(this.getForeground());
        int n4 = this.getFontMetrics(this.getFont()).getAscent();
        graphics2D.setFont(this.getFont());
        graphics2D.drawString(this.getText(), n3, (n2 + n4) / 2 - 2);
        graphics2D.dispose();
    }
}

