/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.paging;

import com.jidesoft.grid.DefaultPageTableModel;
import com.jidesoft.grid.JideTable;
import com.jidesoft.grid.MultiTableModel;
import com.jidesoft.grid.TableModelWrapperUtils;
import com.jidesoft.grid.TableScrollPane;
import com.jidesoft.icons.IconsFactory;
import com.jidesoft.list.DefaultPageListModel;
import com.jidesoft.list.ListModelWrapperUtils;
import com.jidesoft.paging.PageNavigationEvent;
import com.jidesoft.paging.PageNavigationField;
import com.jidesoft.paging.PageNavigationListener;
import com.jidesoft.paging.PageNavigationSupport;
import com.jidesoft.swing.AutoRepeatButtonUtils;
import com.jidesoft.swing.JideBoxLayout;
import com.jidesoft.swing.JideButton;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.utils.Lm;
import com.jidesoft.utils.PortingUtils;
import com.jidesoft.utils.Q;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.NoSuchElementException;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.ListModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableModel;

public class PageNavigationBar
extends JToolBar
implements PropertyChangeListener {
    private static final Logger LOGGER;
    protected JComponent _component;
    protected PageNavigationSupport _pageNavigationSupport;
    private boolean _selectViewIndex = true;
    private Map<String, Action> _actions;
    private PageNavigationListener _pageNavigationListener;
    private boolean _selectRecord = true;
    public static final String COMMAND_FIRST = "moveToBeginning";
    public static final String COMMAND_PREVIOUS = "moveLeft";
    public static final String COMMAND_NEXT = "moveRight";
    public static final String COMMAND_LAST = "moveToEnd";
    public static final String COMMAND_GOTO = "moveTo";
    public final String CLIENT_PROPERTY_ALWAYS_DISABLED = "PageNavigationBar.alwaysDisabled";
    protected PageNavigationField _pageNavigationField;
    private transient boolean _justBeeped = false;

    protected PageNavigationBar() {
    }

    public PageNavigationBar(TableScrollPane tableScrollPane) {
        if (tableScrollPane == null) {
            return;
        }
        this._component = tableScrollPane;
        this._component.addMouseWheelListener(this.createMouseWheelListener());
        tableScrollPane.getMainTable().getSelectionModel().addListSelectionListener(this.createSelectionListener());
        this.initializeTableScrollPane(tableScrollPane);
        tableScrollPane.addPropertyChangeListener("tableModel", this);
        this.initComponents();
        this.registerKeyboardActions(this._component);
        this.updateNavigationField();
        this.updateButtonPanel();
    }

    public PageNavigationBar(JTable jTable) {
        if (jTable == null) {
            return;
        }
        this._component = jTable;
        this._component.addMouseWheelListener(this.createMouseWheelListener());
        jTable.getSelectionModel().addListSelectionListener(this.createSelectionListener());
        this.initializeTable(jTable);
        jTable.addPropertyChangeListener("model", this);
        this.initComponents();
        this.registerKeyboardActions(this._component);
        this.updateNavigationField();
        this.updateButtonPanel();
    }

    protected PageNavigationSupport createPageTableModel(TableModel tableModel, int n) {
        return new DefaultPageTableModel(tableModel, n);
    }

    public PageNavigationBar(JList jList) {
        if (jList == null) {
            return;
        }
        this._component = jList;
        this._component.addMouseWheelListener(this.createMouseWheelListener());
        jList.getSelectionModel().addListSelectionListener(this.createSelectionListener());
        this.initializeList(jList);
        jList.addPropertyChangeListener("model", this);
        this.initComponents();
        this.registerKeyboardActions(this._component);
        this.updateNavigationField();
        this.updateButtonPanel();
    }

    private void initializeTableScrollPane(TableScrollPane tableScrollPane) {
        TableModel tableModel = TableModelWrapperUtils.getActualTableModel(tableScrollPane.getTableModel(), PageNavigationSupport.class);
        int n = tableScrollPane.getMainTable().getPreferredScrollableViewportSize().height / tableScrollPane.getMainTable().getRowHeight();
        if (tableModel instanceof PageNavigationSupport) {
            this._pageNavigationSupport = (PageNavigationSupport)((Object)tableModel);
            this._pageNavigationSupport.setPageSize(n);
        } else {
            this._pageNavigationSupport = this.createPageTableModel(tableScrollPane.getTableModel(), n);
            tableScrollPane.setTableModel((MultiTableModel)((Object)this._pageNavigationSupport));
        }
        if (this._pageNavigationListener == null) {
            this._pageNavigationListener = this.createPageNavigationListener();
        }
        this._pageNavigationSupport.addPageNavigationListener(this._pageNavigationListener);
    }

    private void initializeTable(JTable jTable) {
        TableModel tableModel = TableModelWrapperUtils.getActualTableModel(jTable.getModel(), PageNavigationSupport.class);
        int n = jTable.getPreferredScrollableViewportSize().height / jTable.getRowHeight();
        if (tableModel instanceof PageNavigationSupport) {
            this._pageNavigationSupport = (PageNavigationSupport)((Object)tableModel);
            this._pageNavigationSupport.setPageSize(n);
        } else {
            this._pageNavigationSupport = this.createPageTableModel(jTable.getModel(), n);
            jTable.setModel((TableModel)((Object)this._pageNavigationSupport));
        }
        if (this._pageNavigationListener == null) {
            this._pageNavigationListener = this.createPageNavigationListener();
        }
        this._pageNavigationSupport.addPageNavigationListener(this._pageNavigationListener);
    }

    private void initializeList(JList jList) {
        ListModel listModel = ListModelWrapperUtils.getActualListModel(jList.getModel(), PageNavigationSupport.class);
        Rectangle rectangle = jList.getCellBounds(0, 0);
        int n = rectangle != null ? jList.getPreferredScrollableViewportSize().height / rectangle.height : 0;
        if (listModel instanceof PageNavigationSupport) {
            this._pageNavigationSupport = (PageNavigationSupport)((Object)listModel);
            this._pageNavigationSupport.setPageSize(n);
        } else {
            this._pageNavigationSupport = new DefaultPageListModel(jList.getModel(), n);
            jList.setModel((ListModel)((Object)this._pageNavigationSupport));
        }
        if (this._pageNavigationListener == null) {
            this._pageNavigationListener = this.createPageNavigationListener();
        }
        this._pageNavigationSupport.addPageNavigationListener(this._pageNavigationListener);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("model".equals(propertyChangeEvent.getPropertyName()) || "tableModel".equals(propertyChangeEvent.getPropertyName())) {
            this._component.removePropertyChangeListener(propertyChangeEvent.getPropertyName(), this);
            if (this._pageNavigationSupport != null && this._pageNavigationListener != null) {
                this._pageNavigationSupport.removePageNavigationListener(this._pageNavigationListener);
            }
            if (this._component instanceof JList) {
                this.initializeList((JList)this._component);
            } else if (this._component instanceof JTable) {
                this.initializeTable((JTable)this._component);
            } else if (this._component instanceof TableScrollPane) {
                this.initializeTableScrollPane((TableScrollPane)this._component);
            }
            this.updateNavigationField();
            this.updateButtonPanel();
            this._component.addPropertyChangeListener(propertyChangeEvent.getPropertyName(), this);
        }
    }

    protected void initComponents() {
        this.setOpaque(false);
        this.setFloatable(false);
        this._actions = new HashMap<String, Action>();
        this._actions.put(COMMAND_FIRST, this.createAction(COMMAND_FIRST));
        this._actions.put(COMMAND_PREVIOUS, this.createAction(COMMAND_PREVIOUS));
        this._actions.put(COMMAND_NEXT, this.createAction(COMMAND_NEXT));
        this._actions.put(COMMAND_LAST, this.createAction(COMMAND_LAST));
        ActionHandler actionHandler = new ActionHandler();
        actionHandler.putValue("ActionCommandKey", COMMAND_GOTO);
        this._actions.put(COMMAND_GOTO, actionHandler);
        this._pageNavigationField = this.createNavigationField();
        this._pageNavigationField.setName(COMMAND_GOTO);
        this._pageNavigationField.getTextField().addActionListener(this._actions.get(COMMAND_GOTO));
        this._pageNavigationField.getTextField().addFocusListener(this.createFocusListener());
        this._pageNavigationField.addChangeListener(this.createChangeListener());
        if (this._pageNavigationField.getType() == 1) {
            String string = this.getResourceString("PageNavigationBar.currentPageOfTotal");
            String string2 = MessageFormat.format(string, this._pageNavigationSupport.getPageCount(), this._pageNavigationSupport.getPageCount());
            this._pageNavigationField.setColumns(string2.length());
        } else {
            String string = this.getResourceString("PageNavigationBar.currentRecordOfTotal");
            int n = this._pageNavigationSupport.getTotalRecordCount();
            int n2 = n >= 0 ? n : this._pageNavigationSupport.getPageSize() * this._pageNavigationSupport.getCurrentPage();
            String string3 = MessageFormat.format(string, n2, n2);
            this._pageNavigationField.setColumns(string3.length());
        }
        this.setLayout(new JideBoxLayout(this, 0));
        this.add(this.createButton(this._actions.get(COMMAND_FIRST)));
        this.add(this.createButton(this._actions.get(COMMAND_PREVIOUS)));
        this.add(this.createButton(this._actions.get(COMMAND_NEXT)));
        this.add(this.createButton(this._actions.get(COMMAND_LAST)));
        this.add(this._pageNavigationField);
        this.add(Box.createGlue(), "vary");
    }

    protected ChangeListener createChangeListener() {
        return new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                PageNavigationBar.this.updateNavigationField();
                PageNavigationBar.this.updateButtonPanel();
                if (changeEvent.getSource() instanceof PageNavigationField) {
                    for (String string : PageNavigationBar.this._actions.keySet()) {
                        Action action = (Action)PageNavigationBar.this._actions.get(string);
                        PageNavigationBar.this.updateTooltipText(string, action);
                    }
                }
            }
        };
    }

    protected void updateTooltipText(String string, Action action) {
        int n = this._pageNavigationField == null ? 1 : this._pageNavigationField.getType();
        try {
            String string2 = this.getResourceString("PageNavigationBar." + string + ".tooltip");
            String string3 = MessageFormat.format(string2, this.getResourceString("PageNavigationField.field." + (n == 2 ? "record" : "page")).toLowerCase());
            if (string3 != null && string3.trim().length() > 0) {
                action.putValue("ShortDescription", string3);
            }
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
    }

    protected FocusListener createFocusListener() {
        return new FocusListener(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                PageNavigationBar.this.updateNavigationField();
                PageNavigationBar.this._pageNavigationField.getTextField().selectAll();
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                PageNavigationBar.this.updateNavigationField();
            }
        };
    }

    protected PageNavigationListener createPageNavigationListener() {
        return new PageNavigationListener(){

            @Override
            public void pageNavigationEventFired(PageNavigationEvent pageNavigationEvent) {
                PageNavigationBar.this.updateNavigationField();
                PageNavigationBar.this.updateButtonPanel();
            }
        };
    }

    protected ListSelectionListener createSelectionListener() {
        return new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!listSelectionEvent.getValueIsAdjusting() && PageNavigationBar.this._pageNavigationField.getType() == 2) {
                    PageNavigationBar.this.updateNavigationField();
                    PageNavigationBar.this.updateButtonPanel();
                }
            }
        };
    }

    protected MouseWheelListener createMouseWheelListener() {
        return new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
                switch (mouseWheelEvent.getScrollType()) {
                    case 0: {
                        if (mouseWheelEvent.isControlDown() || mouseWheelEvent.isMetaDown()) {
                            PageNavigationBar.this.gotoRecord(PageNavigationBar.this.getCurrentRecord() + PageNavigationBar.this._pageNavigationSupport.getPageSize() * mouseWheelEvent.getUnitsToScroll());
                            break;
                        }
                        PageNavigationBar.this.gotoRecord(PageNavigationBar.this.getCurrentRecord() + mouseWheelEvent.getUnitsToScroll());
                        break;
                    }
                    case 1: {
                        PageNavigationBar.this.gotoRecord(PageNavigationBar.this.getCurrentRecord() + PageNavigationBar.this._pageNavigationSupport.getPageSize() * mouseWheelEvent.getUnitsToScroll());
                    }
                }
            }
        };
    }

    protected void registerKeyboardActions(JComponent jComponent) {
        KeyStroke[] keyStrokeArray = new KeyStroke[]{KeyStroke.getKeyStroke(40, 0), KeyStroke.getKeyStroke(38, 0), KeyStroke.getKeyStroke(34, 0), KeyStroke.getKeyStroke(33, 0), KeyStroke.getKeyStroke(34, 128), KeyStroke.getKeyStroke(33, 128), KeyStroke.getKeyStroke(36, 128), KeyStroke.getKeyStroke(35, 128)};
        jComponent.registerKeyboardAction(new AbstractAction(){
            private static final long serialVersionUID = -6550729013493676340L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PageNavigationBar.this.nextRecord();
            }
        }, keyStrokeArray[0], 0);
        jComponent.registerKeyboardAction(new AbstractAction(){
            private static final long serialVersionUID = 1217786275623931897L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PageNavigationBar.this.previousRecord();
            }
        }, keyStrokeArray[1], 0);
        jComponent.registerKeyboardAction(new AbstractAction(){
            private static final long serialVersionUID = 7189245076490514878L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PageNavigationBar.this.nextPage();
            }
        }, keyStrokeArray[2], 0);
        jComponent.registerKeyboardAction(new AbstractAction(){
            private static final long serialVersionUID = 6252071064867942931L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PageNavigationBar.this.previousPage();
            }
        }, keyStrokeArray[3], 0);
        jComponent.registerKeyboardAction(new AbstractAction(){
            private static final long serialVersionUID = -1107823695182090812L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PageNavigationBar.this.lastRecordInPage();
            }
        }, keyStrokeArray[4], 0);
        jComponent.registerKeyboardAction(new AbstractAction(){
            private static final long serialVersionUID = -4880407554004818213L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PageNavigationBar.this.firstRecordInPage();
            }
        }, keyStrokeArray[5], 0);
        jComponent.registerKeyboardAction(new AbstractAction(){
            private static final long serialVersionUID = 3932257606575802109L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PageNavigationBar.this.firstRecord();
            }
        }, keyStrokeArray[6], 0);
        jComponent.registerKeyboardAction(new AbstractAction(){
            private static final long serialVersionUID = 7134970522999659483L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PageNavigationBar.this.lastRecord();
            }
        }, keyStrokeArray[7], 0);
        JideSwingUtilities.synchronizeKeyboardActions(jComponent, this._pageNavigationField, keyStrokeArray, 1);
    }

    public int getCurrentRecord() {
        int n = this.getSelectedRecordIndex();
        if (n == -1) {
            n = 0;
        }
        return this._pageNavigationSupport.getCurrentPage() * this._pageNavigationSupport.getPageSize() + n;
    }

    public void setTableModel(TableModel tableModel) {
        if (!(this._component instanceof JTable)) {
            return;
        }
        if (this._pageNavigationSupport != null) {
            this._pageNavigationSupport.removePageNavigationListener(this._pageNavigationListener);
        }
        JTable jTable = (JTable)this._component;
        TableModel tableModel2 = TableModelWrapperUtils.getActualTableModel(tableModel, PageNavigationSupport.class);
        int n = jTable.getPreferredScrollableViewportSize().height / jTable.getRowHeight();
        if (tableModel2 instanceof PageNavigationSupport) {
            this._pageNavigationSupport = (PageNavigationSupport)((Object)tableModel2);
            this._pageNavigationSupport.setPageSize(n);
        } else {
            if (tableModel2 == null) {
                tableModel2 = TableModelWrapperUtils.getActualTableModel(jTable.getModel(), PageNavigationSupport.class);
            }
            if (tableModel2 == this._pageNavigationSupport && this._pageNavigationSupport instanceof DefaultPageTableModel) {
                ((DefaultPageTableModel)this._pageNavigationSupport).setTableModel(tableModel);
            } else {
                this._pageNavigationSupport = new DefaultPageTableModel(tableModel, n);
                jTable.setModel((TableModel)((Object)this._pageNavigationSupport));
            }
        }
        this._pageNavigationSupport.removePageNavigationListener(this._pageNavigationListener);
        this._pageNavigationSupport.addPageNavigationListener(this._pageNavigationListener);
        this.updateNavigationField();
    }

    public void setListModel(ListModel listModel) {
        int n;
        if (!(this._component instanceof JList)) {
            return;
        }
        if (this._pageNavigationSupport != null) {
            this._pageNavigationSupport.removePageNavigationListener(this._pageNavigationListener);
        }
        JList jList = (JList)this._component;
        ListModel listModel2 = ListModelWrapperUtils.getActualListModel(listModel, PageNavigationSupport.class);
        int n2 = n = listModel.getSize() == 0 ? 0 : jList.getPreferredScrollableViewportSize().height / jList.getCellBounds((int)0, (int)0).height;
        if (listModel2 instanceof PageNavigationSupport) {
            this._pageNavigationSupport = (PageNavigationSupport)((Object)listModel2);
            this._pageNavigationSupport.setPageSize(n);
        } else {
            this._pageNavigationSupport = new DefaultPageListModel(listModel, n);
            jList.setModel((ListModel)((Object)this._pageNavigationSupport));
        }
        this._pageNavigationSupport.removePageNavigationListener(this._pageNavigationListener);
        this._pageNavigationSupport.addPageNavigationListener(this._pageNavigationListener);
        this.updateNavigationField();
    }

    protected PageNavigationField createNavigationField() {
        return new PageNavigationField();
    }

    public PageNavigationField getNavigationField() {
        return this._pageNavigationField;
    }

    protected void updateNavigationField() {
        if (this._pageNavigationField != null) {
            this._pageNavigationField.setEnabled(this.isEnabled());
            if (!this._pageNavigationField.getTextField().hasFocus()) {
                if (this._pageNavigationField.getType() == 1) {
                    String string = this.getResourceString("PageNavigationBar.currentPageOfTotal");
                    int n = this._pageNavigationSupport.getPageCount();
                    String string2 = MessageFormat.format(string, Math.min(n, this._pageNavigationSupport.getCurrentPage() + 1), n < 0 ? "?" : Integer.valueOf(n));
                    this._pageNavigationField.setText(string2);
                } else {
                    String string = this.getResourceString("PageNavigationBar.currentRecordOfTotal");
                    int n = this.getSelectedRecordIndex();
                    int n2 = this._pageNavigationSupport.getTotalRecordCount();
                    if (n == -1 && n2 > 0) {
                        n = 0;
                    }
                    String string3 = MessageFormat.format(string, this._pageNavigationSupport.getCurrentPage() < 0 ? 0 : this._pageNavigationSupport.getCurrentPage() * this._pageNavigationSupport.getPageSize() + n + 1, n2 < 0 ? "?" : Integer.valueOf(n2));
                    this._pageNavigationField.setText(string3);
                }
            } else {
                if (this._pageNavigationField.getType() == 1) {
                    this._pageNavigationField.setText("" + (this._pageNavigationSupport.getCurrentPage() + 1));
                } else {
                    int n = this.getSelectedRecordIndex();
                    if (n == -1) {
                        n = 0;
                    }
                    this._pageNavigationField.setText("" + (this._pageNavigationSupport.getCurrentPage() * this._pageNavigationSupport.getPageSize() + n + 1));
                }
                this._pageNavigationField.getTextField().selectAll();
            }
        }
    }

    protected AbstractButton createButton(Action action) {
        JideButton jideButton = new JideButton(action);
        jideButton.setName("" + action.getValue("ActionCommandKey"));
        jideButton.setDisabledIcon((Icon)action.getValue("disabledIcon"));
        jideButton.setRequestFocusEnabled(false);
        AutoRepeatButtonUtils.install(jideButton, 50, 200);
        return jideButton;
    }

    private Action createAction(String string) {
        ActionHandler actionHandler;
        block18: {
            String string2;
            block17: {
                ImageIcon imageIcon;
                String string3;
                block16: {
                    block15: {
                        block14: {
                            actionHandler = new ActionHandler();
                            actionHandler.putValue("ActionCommandKey", string);
                            string2 = "PageNavigationBar." + string + ".";
                            try {
                                string3 = this.getResourceString(string2 + "text");
                                if (string3 != null && string3.trim().length() > 0) {
                                    actionHandler.putValue("Name", string3);
                                }
                            }
                            catch (Exception exception) {
                                if (!LOGGER.isLoggable(Level.FINE)) break block14;
                                LOGGER.fine(exception.getMessage());
                            }
                        }
                        string3 = null;
                        try {
                            string3 = this.getResourceString(string2 + "icon");
                        }
                        catch (Exception exception) {
                            if (!LOGGER.isLoggable(Level.FINE)) break block15;
                            LOGGER.fine(exception.getMessage());
                        }
                    }
                    if (string3 == null || string3.trim().length() == 0) {
                        string3 = String.format("icons/%s.png", string);
                    }
                    imageIcon = IconsFactory.getImageIcon(PageNavigationBar.class, string3);
                    actionHandler.putValue("SmallIcon", imageIcon);
                    string3 = null;
                    try {
                        string3 = this.getResourceString(string2 + "disabledIcon");
                    }
                    catch (Exception exception) {
                        if (!LOGGER.isLoggable(Level.FINE)) break block16;
                        LOGGER.fine(exception.getMessage());
                    }
                }
                if (string3 == null || string3.trim().length() == 0) {
                    string3 = String.format("icons/%s_disabled.png", string);
                }
                imageIcon = IconsFactory.getImageIcon(PageNavigationBar.class, string3);
                actionHandler.putValue("disabledIcon", imageIcon);
                try {
                    this.updateTooltipText(string, actionHandler);
                }
                catch (Exception exception) {
                    if (!LOGGER.isLoggable(Level.FINE)) break block17;
                    LOGGER.fine(exception.getMessage());
                }
            }
            try {
                String string4 = this.getResourceString(string2 + "mnemonic");
                if (string4 != null && string4.trim().length() > 1) {
                    actionHandler.putValue("MnemonicKey", Character.valueOf(string4.charAt(0)));
                }
            }
            catch (Exception exception) {
                if (!LOGGER.isLoggable(Level.FINE)) break block18;
                LOGGER.fine(exception.getMessage());
            }
        }
        return actionHandler;
    }

    protected String getResourceString(String string) {
        return ResourceBundle.getBundle("com.jidesoft.paging.pageNavigationBar", this.getLocale()).getString(string);
    }

    public boolean isSelectViewIndex() {
        return this._selectViewIndex;
    }

    public void setSelectViewIndex(boolean bl) {
        this._selectViewIndex = bl;
    }

    public void firstPage() {
        if (this._pageNavigationSupport != null) {
            int n = this.getSelectedRecordIndex();
            this._pageNavigationSupport.firstPage();
            this.setSelectedRecordIndex(n);
            this.updateButtonPanel();
        }
    }

    public void lastPage() {
        if (this._pageNavigationSupport != null) {
            int n = this.getSelectedRecordIndex();
            this._pageNavigationSupport.lastPage();
            this.setSelectedRecordIndex(n);
            this.updateButtonPanel();
        }
    }

    protected int getPageSize() {
        return this._pageNavigationSupport.getPageSize();
    }

    public void previousPage() {
        if (this._pageNavigationSupport != null) {
            int n = this.getSelectedRecordIndex();
            this._selectRecord = false;
            try {
                this.gotoRecord(Math.max(0, this._pageNavigationSupport.getCurrentPage() * this._pageNavigationSupport.getPageSize() - this.getPageSize()));
            }
            finally {
                this._selectRecord = true;
            }
            if (this.isSelectViewIndex()) {
                this.setSelectedRecordIndex(n);
            }
        }
    }

    public void nextPage() {
        if (this._pageNavigationSupport != null) {
            int n = this.getSelectedRecordIndex();
            this._selectRecord = false;
            try {
                this.gotoRecord(Math.min(this._pageNavigationSupport.getPageCount() * this._pageNavigationSupport.getPageSize() - this.getPageSize(), this._pageNavigationSupport.getCurrentPage() * this._pageNavigationSupport.getPageSize() + this.getPageSize()));
            }
            finally {
                this._selectRecord = true;
            }
            if (this.isSelectViewIndex()) {
                this.setSelectedRecordIndex(n);
            }
        }
    }

    public void firstRecord() {
        if (this._pageNavigationSupport != null) {
            this.gotoRecord(0);
        }
    }

    public void lastRecord() {
        if (this._pageNavigationSupport != null) {
            int n = this._pageNavigationSupport.getTotalRecordCount();
            if (n > 0) {
                this.gotoRecord(n - 1);
            } else {
                this.notifyUser();
            }
        }
    }

    public void firstRecordInPage() {
        if (this._pageNavigationSupport != null) {
            this.setSelectedRecordIndex(0);
            this.updateButtonPanel();
        }
    }

    public void lastRecordInPage() {
        if (this._pageNavigationSupport != null) {
            this.setSelectedRecordIndex(this.getRecordCountInPage() - 1);
            this.updateButtonPanel();
        }
    }

    public void previousRecord() {
        this.gotoRecord(this.getCurrentRecord() - 1);
    }

    public void nextRecord() {
        if (this.getSelectedRecordIndex() == -1) {
            this.gotoRecord(this.getCurrentRecord());
        } else {
            this.gotoRecord(this.getCurrentRecord() + 1);
        }
    }

    protected void gotoPage() {
        if (this._pageNavigationSupport != null) {
            try {
                String string = this._pageNavigationField.getText();
                int n = Integer.parseInt(string) - 1;
                this._justBeeped = false;
                this.gotoPage(n);
            }
            catch (NumberFormatException numberFormatException) {
                this.notifyUser();
                this.updateNavigationField();
            }
        }
    }

    protected void gotoRecord() {
        if (this._pageNavigationSupport != null) {
            String string = this._pageNavigationField.getText();
            try {
                int n = Integer.parseInt(string) - 1;
                this._justBeeped = false;
                this.gotoRecord(n);
                if (this.getSelectedRecordIndex() < 0) {
                    this.setSelectedRecordIndex((n - this._pageNavigationSupport.getCurrentPage() * this._pageNavigationSupport.getPageSize()) % this.getPageSize());
                }
            }
            catch (NumberFormatException numberFormatException) {
                this.notifyUser();
                this.updateNavigationField();
            }
        }
    }

    protected int getRecordCountInPage() {
        if (this._component instanceof JTable) {
            return ((JTable)this._component).getRowCount();
        }
        if (this._component instanceof JList) {
            return ((JList)this._component).getModel().getSize();
        }
        return 0;
    }

    protected int getSelectedRecordIndex() {
        if (this._component instanceof JTable) {
            return ((JTable)this._component).getSelectedRow();
        }
        if (this._component instanceof JList) {
            return ((JList)this._component).getSelectedIndex();
        }
        return -1;
    }

    protected void setSelectedRecordIndex(int n) {
        if (this._component instanceof JTable) {
            ((JTable)this._component).getSelectionModel().clearSelection();
            ((JTable)this._component).getSelectionModel().setSelectionInterval(n, n);
        }
        if (this._component instanceof JList) {
            ((JList)this._component).clearSelection();
            ((JList)this._component).setSelectedIndex(n);
        }
    }

    public void gotoPage(int n) {
        if (n < 0) {
            n = 0;
            if (!this._justBeeped) {
                this._justBeeped = true;
                this.notifyUser();
            }
        } else if (this._pageNavigationSupport.getPageCount() > 0 && n > this._pageNavigationSupport.getPageCount()) {
            n = this._pageNavigationSupport.getPageCount() - 1;
            if (!this._justBeeped) {
                this._justBeeped = true;
                this.notifyUser();
            }
        } else {
            this._justBeeped = false;
        }
        if (n != this._pageNavigationSupport.getCurrentPage()) {
            int n2 = this.getSelectedRecordIndex();
            this.changeCurrentPage(n);
            if (this.isSelectViewIndex()) {
                this.setSelectedRecordIndex(n2);
            }
        } else {
            this.updateNavigationField();
        }
        this.updateButtonPanel();
    }

    protected void changeCurrentPage(int n) {
        if (this._component instanceof JideTable && ((JideTable)this._component).isEditing()) {
            ((JideTable)this._component).getCellEditor().cancelCellEditing();
        }
        this._pageNavigationSupport.setCurrentPage(n);
    }

    public int gotoRecord(int n) {
        int n2;
        if (n < 0) {
            n = 0;
            if (!this._justBeeped) {
                this._justBeeped = true;
                this.notifyUser();
            }
        } else if (this._pageNavigationSupport.getTotalRecordCount() > 0 && n >= this._pageNavigationSupport.getTotalRecordCount()) {
            n = this._pageNavigationSupport.getTotalRecordCount() - 1;
            if (!this._justBeeped) {
                this._justBeeped = true;
                this.notifyUser();
            }
        } else {
            this._justBeeped = false;
        }
        if ((n2 = this.getPageSize()) == 0) {
            n2 = 10;
        }
        boolean bl = this.getSelectedRecordIndex() != -1;
        int n3 = n / this._pageNavigationSupport.getPageSize();
        if (n3 < this._pageNavigationSupport.getCurrentPage() || n3 >= this._pageNavigationSupport.getCurrentPage() + this.getPageSize() / this._pageNavigationSupport.getPageSize() || this.getPageSize() > this._pageNavigationSupport.getPageSize() && n3 >= this._pageNavigationSupport.getPageCount() - this.getPageSize() / this._pageNavigationSupport.getPageSize()) {
            n3 = Math.min(n3, this._pageNavigationSupport.getPageCount() - this.getPageSize() / this._pageNavigationSupport.getPageSize());
            this.changeCurrentPage(n3);
        }
        int n4 = (n - this.getPageNavigationSupport().getCurrentPage() * this.getPageNavigationSupport().getPageSize()) % n2;
        if (this.isSelectViewIndex() && this.getSelectedRecordIndex() != n4 && bl && this._selectRecord) {
            this.setSelectedRecordIndex(n4);
        }
        this.updateNavigationField();
        this.updateButtonPanel();
        return n;
    }

    public void selectRecord(int n) {
        this.gotoRecord(n);
        int n2 = this.getPageSize();
        if (n2 == 0) {
            n2 = 10;
        }
        int n3 = (n - this.getPageNavigationSupport().getCurrentPage() * this.getPageNavigationSupport().getPageSize()) % n2;
        this.setSelectedRecordIndex(n3);
    }

    protected void notifyUser() {
        PortingUtils.notifyUser();
    }

    protected void updateButtonPanel() {
        if (this._pageNavigationField != null && this._pageNavigationField.getType() == 1) {
            boolean bl = this.isAtFirstPage();
            boolean bl2 = this.isAtLastPage();
            this.enableAction(COMMAND_FIRST, !bl);
            this.enableAction(COMMAND_PREVIOUS, !bl);
            this.enableAction(COMMAND_NEXT, !bl2);
            this.enableAction(COMMAND_LAST, !bl2);
        } else if (this._pageNavigationField != null) {
            boolean bl;
            boolean bl3;
            int n = this.getSelectedRecordIndex();
            if (n == -1) {
                bl3 = false;
                bl = this._pageNavigationSupport.getPageCount() < 0;
            } else {
                int n2 = n + this._pageNavigationSupport.getCurrentPage() * this._pageNavigationSupport.getPageSize();
                bl3 = n2 == 0;
                int n3 = this._pageNavigationSupport.getTotalRecordCount();
                bl = n3 >= 0 && n2 == n3 - 1;
            }
            this.enableAction(COMMAND_FIRST, !bl3);
            this.enableAction(COMMAND_PREVIOUS, !bl3);
            this.enableAction(COMMAND_NEXT, !bl);
            this.enableAction(COMMAND_LAST, !bl);
        }
    }

    protected boolean isAtLastPage() {
        return this._pageNavigationSupport == null || this._pageNavigationSupport.getPageCount() >= 0 && this._pageNavigationSupport.getCurrentPage() >= this._pageNavigationSupport.getPageCount() - this.getPageSize() / this._pageNavigationSupport.getPageSize();
    }

    protected boolean isAtFirstPage() {
        return this._pageNavigationSupport == null || this._pageNavigationSupport.getCurrentPage() <= 0;
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.updateButtonPanel();
        this.updateNavigationField();
    }

    private void enableAction(String string, boolean bl) {
        Action action = this._actions.get(string);
        if (action != null) {
            if (!Boolean.TRUE.equals(action.getValue("PageNavigationBar.alwaysDisabled")) && this.isEnabled()) {
                action.setEnabled(bl);
            } else {
                action.setEnabled(false);
            }
        }
    }

    public void setButtonVisible(String string, boolean bl) {
        boolean bl2 = true;
        for (int i = this.getComponentCount() - 1; i >= 0; --i) {
            Component component = this.getComponent(i);
            if (!(component instanceof JideButton) && !(component instanceof PageNavigationField)) continue;
            String string2 = component.getName();
            if (string.equals(string2)) {
                component.setVisible(bl);
            }
            if (!this._actions.containsKey(string2) || !component.isVisible()) continue;
            this.setVisible(true);
            bl2 = false;
        }
        if (bl2) {
            this.setVisible(false);
        }
    }

    public boolean isButtonVisible(String string) {
        for (int i = this.getComponentCount() - 1; i >= 0; --i) {
            Component component = this.getComponent(i);
            if (!string.equals(component.getName())) continue;
            return component.isVisible();
        }
        throw new NoSuchElementException();
    }

    public void setButtonEnabled(String string, boolean bl) {
        Action action = this._actions.get(string);
        if (action != null) {
            if (bl) {
                action.putValue("PageNavigationBar.alwaysDisabled", null);
            } else {
                action.putValue("PageNavigationBar.alwaysDisabled", true);
            }
        } else {
            throw new NoSuchElementException();
        }
        this.updateButtonPanel();
    }

    public boolean isButtonEnabled(String string) {
        Action action = this._actions.get(string);
        if (action != null) {
            return !Boolean.TRUE.equals(action.getValue("PageNavigationBar.alwaysDisabled"));
        }
        throw new NoSuchElementException();
    }

    public PageNavigationSupport getPageNavigationSupport() {
        return this._pageNavigationSupport;
    }

    static {
        try {
            if (Lm.class.getDeclaredMethods().length != 29 && Lm.class.getDeclaredMethods().length != 31) {
                System.err.println("The Lm class is invalid, exiting ... " + Lm.class.getDeclaredMethods().length);
                System.exit(-1);
            }
        }
        catch (Exception exception) {
            System.exit(-1);
        }
        if (!Q.zz(2048)) {
            Lm.showInvalidProductMessage(PageNavigationBar.class.getName(), 2048);
        }
        LOGGER = Logger.getLogger(PageNavigationBar.class.getName());
    }

    private class ActionHandler
    extends AbstractAction {
        private static final long serialVersionUID = 7721031106119974783L;

        private ActionHandler() {
        }

        @Override
        public synchronized void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (actionEvent.getSource() instanceof JTextField) {
                if (PageNavigationBar.this._pageNavigationField.getType() == 1) {
                    PageNavigationBar.this.gotoPage();
                } else {
                    PageNavigationBar.this.gotoRecord();
                }
                PageNavigationBar.this._pageNavigationField.getTextField().selectAll();
            } else if (PageNavigationBar.this._pageNavigationField.getType() == 1) {
                if (PageNavigationBar.COMMAND_FIRST.equals(string)) {
                    PageNavigationBar.this.firstPage();
                } else if (PageNavigationBar.COMMAND_PREVIOUS.equals(string)) {
                    PageNavigationBar.this.previousPage();
                } else if (PageNavigationBar.COMMAND_NEXT.equals(string)) {
                    PageNavigationBar.this.nextPage();
                } else if (PageNavigationBar.COMMAND_LAST.equals(string)) {
                    PageNavigationBar.this.lastPage();
                }
            } else if (PageNavigationBar.COMMAND_FIRST.equals(string)) {
                PageNavigationBar.this.firstRecord();
            } else if (PageNavigationBar.COMMAND_PREVIOUS.equals(string)) {
                PageNavigationBar.this.previousRecord();
            } else if (PageNavigationBar.COMMAND_NEXT.equals(string)) {
                PageNavigationBar.this.nextRecord();
            } else if (PageNavigationBar.COMMAND_LAST.equals(string)) {
                PageNavigationBar.this.lastRecord();
            }
        }
    }
}

