/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.navigation;

import com.jidesoft.swing.NavigationComponent;
import com.jidesoft.swing.NavigationComponentHelper;
import com.jidesoft.tooltip.ExpandedTipUtils;
import com.jidesoft.utils.Lm;
import com.jidesoft.utils.Q;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Vector;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;

public class NavigationList
extends JList
implements NavigationComponent {
    private NavigationComponentHelper _helper;
    public static final String PROPERTY_WIDE_SELECTION = "wideSelection";
    public static final String PROPERTY_EXPANDED_TIP = "expandedTip";
    private boolean _wideSelection = true;
    private boolean _expandedTip = true;

    public NavigationList() {
        this.initComponents();
    }

    public NavigationList(Vector<?> vector) {
        super(vector);
        this.initComponents();
    }

    public NavigationList(Object[] objectArray) {
        super(objectArray);
        this.initComponents();
    }

    public NavigationList(ListModel listModel) {
        super(listModel);
        this.initComponents();
    }

    private void initComponents() {
        this.setCellRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                return super.getListCellRendererComponent((JList<?>)jList, object, n, false, false);
            }
        });
        this._helper = this.createNavigationHelper();
        this._helper.setup(this);
        if (this._expandedTip) {
            ExpandedTipUtils.install(this);
        }
    }

    protected NavigationComponentHelper createNavigationHelper() {
        return new NavigationListHelper();
    }

    private Rectangle getRowBounds(int n) {
        Rectangle rectangle = this.getCellBounds(n, n);
        if (!this.isWideSelection()) {
            ListCellRenderer listCellRenderer = this.getCellRenderer();
            if (listCellRenderer == null) {
                return rectangle;
            }
            Component component = listCellRenderer.getListCellRendererComponent(this, this.getModel().getElementAt(n), n, false, false);
            rectangle.width = component.getPreferredSize().width;
        }
        return rectangle;
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        this._helper.paint(graphics, this);
    }

    public boolean isWideSelection() {
        return this._wideSelection;
    }

    public void setWideSelection(boolean bl) {
        boolean bl2 = this._wideSelection;
        if (bl != this._wideSelection) {
            this._wideSelection = bl;
            this.firePropertyChange(PROPERTY_WIDE_SELECTION, bl2, this._wideSelection);
            this._helper.repaintSelections(this);
        }
    }

    public boolean isExpandedTip() {
        return this._expandedTip;
    }

    public void setExpandedTip(boolean bl) {
        boolean bl2 = this._expandedTip;
        if (bl != this._expandedTip) {
            this._expandedTip = bl;
            this.firePropertyChange(PROPERTY_EXPANDED_TIP, bl2, this._expandedTip);
            if (this._expandedTip) {
                ExpandedTipUtils.install(this);
            } else {
                ExpandedTipUtils.uninstall(this);
            }
        }
    }

    public int getNavigationRolloverRow() {
        return this._helper.getRolloverRow();
    }

    public void setNavigationRolloverRow(int n) {
        int n2 = this._helper.getRolloverRow();
        if (n2 != n) {
            this._helper.setRolloverRow(n);
            Rectangle rectangle = this.getRowBounds(n2);
            if (rectangle != null) {
                this.repaint(rectangle);
            }
            if ((rectangle = this.getRowBounds(n)) != null) {
                this.repaint(rectangle);
            }
        }
    }

    static {
        try {
            if (Lm.class.getDeclaredMethods().length != 29 && Lm.class.getDeclaredMethods().length != 31) {
                System.err.println("The Lm class is invalid, exiting ... " + Lm.class.getDeclaredMethods().length);
                System.exit(-1);
            }
        }
        catch (Exception exception) {
            System.exit(-1);
        }
        if (!Q.zz(2)) {
            Lm.showInvalidProductMessage(NavigationList.class.getName(), 2);
        }
    }

    public class NavigationListHelper
    extends NavigationComponentHelper {
        @Override
        public Rectangle getRowBounds(int n) {
            return NavigationList.this.getRowBounds(n);
        }

        @Override
        public int rowAtPoint(Point point) {
            int n = NavigationList.this.locationToIndex(point);
            Rectangle rectangle = this.getRowBounds(n);
            if (rectangle != null && rectangle.contains(point)) {
                return n;
            }
            return -1;
        }

        @Override
        public int[] getSelectedRows() {
            return NavigationList.this.getSelectedIndices();
        }
    }
}

