/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.marker;

import com.jidesoft.marker.MarkerEvent;
import com.jidesoft.marker.MarkerEye;
import com.jidesoft.marker.MarkerEyePainter;
import com.jidesoft.marker.MarkerListener;
import com.jidesoft.marker.MarkerResource;
import com.jidesoft.marker.MarkerStripe;
import com.jidesoft.marker.MarkerStripePainter;
import com.jidesoft.marker.MarkerSupport;
import com.jidesoft.swing.JideBoxLayout;
import com.jidesoft.utils.Lm;
import com.jidesoft.utils.Q;
import java.awt.Color;
import java.awt.Component;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JPanel;

public class MarkerArea
extends JPanel
implements MarkerListener {
    private static Logger LOGGER;
    public static final int MODE_FINE = 0;
    public static final int MODE_WARNING = 100;
    public static final int MODE_ERROR = 200;
    public static final Color DEFAULT_FINE_COLOR;
    public static final Color DEFAULT_WARNING_COLOR;
    public static final Color DEFAULT_ERROR_COLOR;
    public static final Color DEFAULT_INSPECTING_COLOR;
    protected MarkerSupport _markerSupport;
    protected MarkerEye _eye;
    protected MarkerStripe _stripe;
    protected MarkerEyePainter _eyePainter;
    protected MarkerStripePainter _stripePainter;
    protected int _mode = 0;
    protected int _minimumMode = 0;
    protected boolean _inspecting;
    private boolean _clickToSelect = true;
    public static final String PROPERTY_CLICK_TO_SELECT = "clickToSelect";
    private Map<Integer, Color> _colors;

    public MarkerArea(MarkerSupport markerSupport) {
        this.setMarkerSupport(markerSupport);
        this._colors = new HashMap<Integer, Color>();
        this.registerMarkerColor(0, DEFAULT_ERROR_COLOR);
        this.registerMarkerColor(1, DEFAULT_WARNING_COLOR);
        this.setLayout(new JideBoxLayout(this, 1));
        this._eye = this.createMarkerEye();
        this._stripe = this.createMarkerStripe();
        this.add((Component)this._eye, "fix");
        this.add((Component)this._stripe, "vary");
    }

    protected MarkerStripe createMarkerStripe() {
        return new MarkerStripe(this);
    }

    protected MarkerEye createMarkerEye() {
        return new MarkerEye(this);
    }

    public MarkerStripe getMarkerStripe() {
        return this._stripe;
    }

    public MarkerEye getMarkerEye() {
        return this._eye;
    }

    public MarkerEyePainter getEyePainter() {
        return this._eyePainter;
    }

    public void setEyePainter(MarkerEyePainter markerEyePainter) {
        this._eyePainter = markerEyePainter;
        this._eye.setPainter(this._eyePainter);
    }

    public MarkerStripePainter getStripePainter() {
        return this._stripePainter;
    }

    public void setStripePainter(MarkerStripePainter markerStripePainter) {
        this._stripePainter = markerStripePainter;
        this._stripe.setPainter(this._stripePainter);
    }

    public MarkerSupport getMarkerSupport() {
        return this._markerSupport;
    }

    public void setMarkerSupport(MarkerSupport markerSupport) {
        MarkerSupport markerSupport2 = this._markerSupport;
        if (markerSupport2 != markerSupport) {
            if (markerSupport2 != null) {
                markerSupport2.getMarkerModel().removeMarkerListener(this);
            }
            this._markerSupport = markerSupport;
            if (this._markerSupport != null) {
                this._markerSupport.getMarkerModel().addMarkerListener(this);
            }
            if (this._eye != null) {
                this._eye.setMarkerSupport(this._markerSupport);
            }
            if (this._stripe != null) {
                this._stripe.setMarkerSupport(this._markerSupport);
            }
            this.repaint();
        }
    }

    @Override
    public void markerChanged(MarkerEvent markerEvent) {
        if (!markerEvent.isAdjusting()) {
            this.repaint();
        }
    }

    public boolean isInspecting() {
        return this._inspecting;
    }

    public void setInspecting(boolean bl) {
        if (LOGGER.isLoggable(Level.FINE)) {
            if (bl) {
                LOGGER.fine("Inspection started");
            } else {
                LOGGER.fine("Inspection finished");
            }
        }
        this._inspecting = bl;
        if (this._inspecting) {
            this._minimumMode = 0;
            LOGGER.fine("Set minimum mode " + this._minimumMode);
        } else {
            this.applyMinimumMode();
            this.invalidate();
            this.repaint();
        }
    }

    public int getMode() {
        return this._mode;
    }

    public void setMode(int n) {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Set mode " + n);
        }
        this._mode = n;
        this.repaint();
    }

    public void applyMinimumMode() {
        this.setMode(this._minimumMode);
        this._minimumMode = 0;
    }

    public void requireMinimumMode(int n) {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Requiring minimum mode " + n);
        }
        if (this.isInspecting() && this._minimumMode < n) {
            this._minimumMode = n;
            this.setMode(n);
            LOGGER.fine("Required minimum mode " + n);
        } else {
            LOGGER.fine("Not required " + n);
        }
    }

    public void updateMarkerAreaHeight(int n) {
        if (this._stripe != null) {
            this._stripe.setBorder(BorderFactory.createEmptyBorder(0, 0, n, 0));
        }
    }

    public String getResourceString(String string) {
        return this.getResourceBundle().getString(string);
    }

    private ResourceBundle getResourceBundle() {
        return MarkerResource.getResourceBundle(this.getLocale());
    }

    public void registerMarkerColor(int n, Color color) {
        this._colors.put(n, color);
    }

    public void unregisterMarkerColor(int n) {
        this._colors.remove(n);
    }

    public void clearMarkerColors() {
        this._colors.clear();
    }

    public Color getMarkerColor(int n) {
        Color color = this._colors.get(n);
        return color == null ? DEFAULT_WARNING_COLOR : color;
    }

    public boolean isClickToSelect() {
        return this._clickToSelect;
    }

    public void setClickToSelect(boolean bl) {
        boolean bl2 = this._clickToSelect;
        if (bl2 != bl) {
            this._clickToSelect = bl;
            this.firePropertyChange(PROPERTY_CLICK_TO_SELECT, bl2, this._clickToSelect);
        }
    }

    public void dispose() {
        this.setMarkerSupport(null);
    }

    static {
        try {
            if (Lm.class.getDeclaredMethods().length != 29 && Lm.class.getDeclaredMethods().length != 31) {
                System.err.println("The Lm class is invalid, exiting ... " + Lm.class.getDeclaredMethods().length);
                System.exit(-1);
            }
        }
        catch (Exception exception) {
            System.exit(-1);
        }
        if (!Q.zz(4)) {
            Lm.showInvalidProductMessage(MarkerArea.class.getName(), 4);
        }
        LOGGER = Logger.getLogger(MarkerArea.class.getName());
        DEFAULT_FINE_COLOR = Color.GREEN;
        DEFAULT_WARNING_COLOR = Color.YELLOW;
        DEFAULT_ERROR_COLOR = Color.RED;
        DEFAULT_INSPECTING_COLOR = Color.YELLOW;
    }
}

