/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.marker;

import com.jidesoft.marker.Marker;
import com.jidesoft.marker.MarkerEvent;
import com.jidesoft.marker.MarkerListener;
import com.jidesoft.marker.MarkerModel;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Vector;
import javax.swing.event.EventListenerList;

public class DefaultMarkerModel
implements MarkerModel,
PropertyChangeListener {
    protected List<Marker> _markers;
    private List<Marker> _markersCopy;
    private boolean _markersCopyInvalidated = true;
    protected boolean _isAdjusting;
    protected EventListenerList _listenerList = new EventListenerList();

    public DefaultMarkerModel() {
        this._markers = new Vector<Marker>();
    }

    @Override
    public synchronized List<Marker> getMarkers() {
        Collections.sort(this._markers, new Comparator<Marker>(){

            @Override
            public int compare(Marker marker, Marker marker2) {
                int n;
                int n2 = marker.getType();
                return n2 == (n = marker2.getType()) ? 0 : (n2 > n ? -1 : 1);
            }
        });
        if (this._markersCopyInvalidated) {
            this._markersCopy = Collections.unmodifiableList(new ArrayList<Marker>(this._markers));
            this._markersCopyInvalidated = false;
        }
        return this._markersCopy;
    }

    @Override
    public synchronized List<Marker> getMarkersAt(int n, int n2) {
        Vector<Marker> vector = new Vector<Marker>();
        for (Marker marker : this._markers) {
            if (marker.getStartOffset() > n2 || marker.getEndOffset() < n) continue;
            vector.add(marker);
        }
        return vector;
    }

    @Override
    public synchronized boolean isAdjusting() {
        return this._isAdjusting;
    }

    @Override
    public synchronized void setAdjusting(boolean bl) {
        this._isAdjusting = bl;
        if (!this.isAdjusting()) {
            this.fireMarkerChanged(null, 2, this.isAdjusting());
        }
    }

    @Override
    public synchronized Marker addMarker(int n, int n2, int n3, String string) {
        Marker marker = this.createMarker(n, n2, n3, string);
        marker.addPropertyChangeListener(this);
        boolean bl = this._markers.add(marker);
        if (bl) {
            this._markersCopyInvalidated = true;
            this.fireMarkerChanged(marker, 0, this.isAdjusting());
            return marker;
        }
        return null;
    }

    protected Marker createMarker(int n, int n2, int n3, String string) {
        return new Marker(n, n2, n3, string);
    }

    @Override
    public synchronized void clearMarkers() {
        if (this._markers == null) {
            return;
        }
        for (Marker marker : this._markers) {
            marker.removePropertyChangeListener(this);
        }
        if (this._markers.size() > 0) {
            this._markers.clear();
            this._markersCopyInvalidated = true;
            this._markersCopy = null;
            this.fireMarkerChanged(null, 1, this.isAdjusting());
        }
    }

    @Override
    public synchronized boolean removeMarker(Marker marker) {
        boolean bl = this._markers.remove(marker);
        if (bl) {
            if (marker != null) {
                marker.removePropertyChangeListener(this);
            }
            this._markersCopyInvalidated = true;
            this.fireMarkerChanged(marker, 1, this.isAdjusting());
        }
        return bl;
    }

    @Override
    public synchronized void updateMarker(Marker marker) {
        this.fireMarkerChanged(marker, 2, this.isAdjusting());
    }

    protected void fireMarkerChanged(Marker marker, int n, boolean bl) {
        Object[] objectArray = this._listenerList.getListenerList();
        MarkerEvent markerEvent = null;
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != MarkerListener.class) continue;
            if (markerEvent == null) {
                markerEvent = new MarkerEvent(this, marker, n, bl);
            }
            ((MarkerListener)objectArray[i + 1]).markerChanged(markerEvent);
        }
    }

    @Override
    public void addMarkerListener(MarkerListener markerListener) {
        this._listenerList.add(MarkerListener.class, markerListener);
    }

    @Override
    public void removeMarkerListener(MarkerListener markerListener) {
        this._listenerList.remove(MarkerListener.class, markerListener);
    }

    @Override
    public MarkerListener[] getMarkerListeners() {
        return (MarkerListener[])this._listenerList.getListeners(MarkerListener.class);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getSource() instanceof Marker) {
            this.updateMarker((Marker)propertyChangeEvent.getSource());
        }
    }
}

