/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.margin;

import com.jidesoft.margin.AbstractRowMarginSupport;
import com.jidesoft.margin.MarginSupport;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;

public class TextAreaRowMarginSupport
extends AbstractRowMarginSupport {
    protected JTextArea _textArea;
    private DocumentListener _documentListener;
    private PropertyChangeListener _propertyChangeListener;

    public TextAreaRowMarginSupport(JTextArea jTextArea, JScrollPane jScrollPane) {
        super(jScrollPane);
        this._textArea = jTextArea;
    }

    @Override
    public int getRowCount() {
        return this._textArea.getLineCount();
    }

    @Override
    public void scrollTo(int n, int n2, boolean bl) {
        try {
            if (n <= n2) {
                if (n2 >= this._textArea.getLineCount()) {
                    n2 = this._textArea.getLineCount() - 1;
                }
                if (bl) {
                    this._textArea.setCaretPosition(this._textArea.getLineStartOffset(n));
                    this._textArea.moveCaretPosition(this._textArea.getLineEndOffset(n2));
                } else {
                    this._textArea.setCaretPosition(this._textArea.getLineEndOffset(n2));
                }
            } else {
                if (n >= this._textArea.getLineCount()) {
                    n = this._textArea.getLineCount() - 1;
                }
                if (bl) {
                    this._textArea.setCaretPosition(this._textArea.getLineEndOffset(n));
                    this._textArea.moveCaretPosition(this._textArea.getLineStartOffset(n2));
                } else {
                    this._textArea.setCaretPosition(this._textArea.getLineStartOffset(n2));
                }
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        this._textArea.requestFocus();
    }

    @Override
    public int getRowHeight(int n) {
        return this._textArea.getFontMetrics(this._textArea.getFont()).getHeight();
    }

    @Override
    public int positionToRow(int n) {
        int n2 = this.getViewPosition();
        int n3 = this.getRowHeight(0);
        return (n2 + n) / n3;
    }

    @Override
    public int rowToPosition(int n) {
        int n2 = this.getRowHeight(0);
        int n3 = this.getViewPosition();
        return n2 * n - n3;
    }

    @Override
    public int getBaselineAdjustment() {
        return 2;
    }

    @Override
    public void installListeners(MarginSupport.RepaintCallback repaintCallback, final MarginSupport.ModelChangedCallback modelChangedCallback) {
        super.installListeners(repaintCallback, modelChangedCallback);
        if (modelChangedCallback != null) {
            if (this._documentListener == null) {
                this._documentListener = new DocumentListener(){

                    @Override
                    public void insertUpdate(DocumentEvent documentEvent) {
                        modelChangedCallback.modelChanged(documentEvent);
                    }

                    @Override
                    public void removeUpdate(DocumentEvent documentEvent) {
                        modelChangedCallback.modelChanged(documentEvent);
                    }

                    @Override
                    public void changedUpdate(DocumentEvent documentEvent) {
                        modelChangedCallback.modelChanged(documentEvent);
                    }
                };
            }
            if (this._propertyChangeListener == null) {
                this._propertyChangeListener = new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                        Object object;
                        Object object2 = propertyChangeEvent.getOldValue();
                        if (object2 instanceof Document) {
                            ((Document)object2).removeDocumentListener(TextAreaRowMarginSupport.this._documentListener);
                        }
                        if ((object = propertyChangeEvent.getNewValue()) instanceof Document) {
                            ((Document)object).addDocumentListener(TextAreaRowMarginSupport.this._documentListener);
                        }
                        modelChangedCallback.modelChanged(propertyChangeEvent);
                    }
                };
            }
            this._textArea.addPropertyChangeListener("document", this._propertyChangeListener);
            Document document = this._textArea.getDocument();
            if (document != null) {
                document.addDocumentListener(this._documentListener);
            }
        }
    }

    @Override
    public void uninstallListeners(MarginSupport.RepaintCallback repaintCallback, MarginSupport.ModelChangedCallback modelChangedCallback) {
        if (this._propertyChangeListener != null) {
            this._textArea.removePropertyChangeListener("document", this._propertyChangeListener);
        }
        if (this._documentListener != null && this._textArea.getDocument() != null) {
            this._textArea.getDocument().removeDocumentListener(this._documentListener);
        }
        super.uninstallListeners(repaintCallback, modelChangedCallback);
    }
}

