/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.lucene;

import com.jidesoft.list.FilterableListModel;
import com.jidesoft.list.QuickListFilterField;
import com.jidesoft.lucene.LuceneDocumentProvider;
import com.jidesoft.lucene.LuceneFilterField;
import com.jidesoft.lucene.LuceneFilterMenuSupport;
import com.jidesoft.lucene.LuceneFilterableListModel;
import com.jidesoft.swing.JidePopupMenu;
import javax.swing.ListModel;

public class LuceneQuickListFilterField
extends QuickListFilterField
implements LuceneFilterField {
    private boolean _luceneInputMode;
    private LuceneFilterMenuSupport _luceneFilterMenuSupport;

    public LuceneQuickListFilterField() {
        this((ListModel)null);
    }

    public LuceneQuickListFilterField(ListModel listModel) {
        super(listModel);
        this.setCaseSensitive(true);
    }

    @Override
    public void setListModel(ListModel listModel) {
        super.setListModel(listModel);
        if (this.getDisplayListModel() != null) {
            this._luceneFilterMenuSupport = new LuceneFilterMenuSupport(this, ((LuceneFilterableListModel)this.getDisplayListModel()).getLuceneSupport());
        }
    }

    @Override
    protected FilterableListModel createDisplayListModel(ListModel listModel) {
        return new LuceneFilterableListModel(listModel);
    }

    @Override
    protected JidePopupMenu createContextMenu() {
        JidePopupMenu jidePopupMenu = super.createContextMenu();
        if (this.getDisplayListModel() instanceof LuceneFilterableListModel && this._luceneFilterMenuSupport != null) {
            this._luceneFilterMenuSupport.customizePopupMenu(jidePopupMenu, null);
        }
        return jidePopupMenu;
    }

    public LuceneDocumentProvider getLuceneDocumentProvider() {
        if (this.getDisplayListModel() instanceof LuceneDocumentProvider) {
            return (LuceneDocumentProvider)((Object)this.getDisplayListModel());
        }
        return null;
    }

    @Override
    protected void prepareQuery(String string) {
        super.prepareQuery(string);
        if (this.getDisplayListModel() instanceof LuceneFilterableListModel) {
            this.parseInputText(this.isCaseSensitive() || string == null ? string : string.toLowerCase(), this.isLuceneInputMode());
        }
    }

    @Override
    public boolean isLuceneInputMode() {
        return this._luceneInputMode;
    }

    @Override
    public void setLuceneInputMode(boolean bl) {
        this._luceneInputMode = bl;
        String string = this.getSearchingText();
        if (string.length() > 0) {
            this.applyFilter(string);
        }
    }

    private void parseInputText(String string, boolean bl) {
        FilterableListModel filterableListModel = this.getDisplayListModel();
        if (filterableListModel == null || !(filterableListModel instanceof LuceneFilterableListModel)) {
            return;
        }
        String string2 = string;
        if (!bl) {
            if (!this.isValidInput(string)) {
                ((LuceneFilterableListModel)filterableListModel).getLuceneSupport().clearQuery();
                return;
            }
            string2 = "";
            string2 = string2 + "list".toLowerCase() + ":";
            if (this.isFromStart()) {
                string2 = string2 + string;
                if (!this.isFromEnd() && !"*".equals(string.substring(string.length() - 1, string.length()))) {
                    string2 = string2 + "*";
                }
            } else {
                if (!"*".equals(string.substring(0, 1))) {
                    string2 = string2 + "*";
                }
                string2 = string2 + string;
                if (!"*".equals(string.substring(string.length() - 1, string.length()))) {
                    string2 = string2 + "*";
                }
            }
        }
        ((LuceneFilterableListModel)filterableListModel).getLuceneSupport().createQuery(string2, "list");
    }

    private boolean isValidInput(String string) {
        char[] cArray;
        if (string == null || string.length() == 0) {
            return false;
        }
        for (char c : cArray = string.toCharArray()) {
            if (c == '*' || c == '?') continue;
            return true;
        }
        return false;
    }
}

