/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.lucene;

import com.jidesoft.filter.Filter;
import com.jidesoft.grid.QuickFilterField;
import com.jidesoft.list.FilterableListModel;
import com.jidesoft.list.FilterableListModelEvent;
import com.jidesoft.lucene.LuceneDocumentProvider;
import com.jidesoft.lucene.LuceneSupport;
import java.util.Arrays;
import java.util.Set;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.IndexableField;

public class LuceneFilterableListModel<E>
extends FilterableListModel<E>
implements LuceneDocumentProvider {
    private LuceneSupport _luceneSupport;
    public static final String LIST_FIELD_NAME = "list";
    private int[] _matchingRows;
    private static final long serialVersionUID = 7769300239846234981L;

    public LuceneFilterableListModel() {
    }

    public LuceneFilterableListModel(ListModel<E> listModel) {
        super(listModel);
        this.setLuceneSupport(new LuceneSupport(this));
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
        this._matchingRows = null;
        this.getLuceneSupport().startIndexing(listDataEvent.getIndex0(), this._model.getSize() - 1, false);
        super.intervalAdded(listDataEvent);
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
        this._matchingRows = null;
        this.getLuceneSupport().startIndexing(listDataEvent.getIndex0(), this._model.getSize() - 1, false);
        super.intervalRemoved(listDataEvent);
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
        this._matchingRows = null;
        this.getLuceneSupport().startIndexing(listDataEvent.getIndex0(), listDataEvent.getIndex1(), false);
        super.contentsChanged(listDataEvent);
    }

    @Override
    protected void filter() {
        if (this.getLuceneSupport().isIndexing()) {
            super.filter();
            return;
        }
        int[] nArray = this.getIndexes();
        if (this.getLuceneSupport().getQuery() == null) {
            this.convertFilterToQuery();
            if (this.getLuceneSupport().getQuery() == null) {
                super.filter();
                return;
            }
        }
        this._matchingRows = this.getMatchingRows();
        int[] nArray2 = new int[this._matchingRows.length];
        System.arraycopy(this._matchingRows, 0, nArray2, 0, this._matchingRows.length);
        this.setIndexes(nArray2);
        this.fireEvents(nArray, nArray2);
    }

    @Override
    public void fireFilterChanged(FilterableListModelEvent filterableListModelEvent) {
        super.fireFilterChanged(filterableListModelEvent);
        this.getLuceneSupport().clearQuery();
    }

    protected String convertFilterToLuceneQueryText(Filter filter) {
        String string;
        if (filter instanceof QuickFilterField.FieldFilter && (string = ((QuickFilterField.FieldFilter)filter).getSearchingText()) != null && string.length() > 0) {
            return "list:\"" + string.toLowerCase() + "\"";
        }
        return null;
    }

    protected String convertElementToString(E e) {
        if (e == null) {
            return "";
        }
        return e.toString();
    }

    private int[] getMatchingRows() {
        Set<Integer> set = this.getLuceneSupport().getMatchingRows();
        Object[] objectArray = set.toArray();
        Arrays.sort(objectArray);
        int[] nArray = new int[set.size()];
        for (int i = 0; i < set.size(); ++i) {
            nArray[i] = (Integer)objectArray[i];
        }
        return nArray;
    }

    private void convertFilterToQuery() {
        if (this._filters == null) {
            this.getLuceneSupport().clearQuery();
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = true;
        for (Filter filter : this._filters) {
            if (bl) {
                bl = false;
            } else if (this.isAndMode()) {
                stringBuilder.append(" AND ");
            } else {
                stringBuilder.append("OR");
            }
            stringBuilder.append("(");
            String string = this.convertFilterToLuceneQueryText(filter);
            if (string == null) {
                this.getLuceneSupport().clearQuery();
                return;
            }
            stringBuilder.append(string);
            stringBuilder.append(")");
        }
        if (stringBuilder.length() == 0) {
            this.getLuceneSupport().clearQuery();
            return;
        }
        this.getLuceneSupport().createQuery(stringBuilder.toString(), LIST_FIELD_NAME);
    }

    @Override
    public Document getDocument(int n) {
        if (n < 0 || n >= this.getActualModel().getSize()) {
            return null;
        }
        Document document = new Document();
        String string = this.convertElementToString(this.getActualModel().getElementAt(n));
        Field field = new Field(LIST_FIELD_NAME, string, Field.Store.YES, Field.Index.ANALYZED);
        document.add((IndexableField)field);
        return document;
    }

    @Override
    public int getDocumentCount() {
        return this.getActualModel().getSize();
    }

    @Override
    public void notifyIndexCreated() {
        this._matchingRows = this.getMatchingRows();
    }

    LuceneSupport getLuceneSupport() {
        return this._luceneSupport;
    }

    void setLuceneSupport(LuceneSupport luceneSupport) {
        this._luceneSupport = luceneSupport;
    }
}

