/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.list;

import com.jidesoft.list.CompoundListDataEvent;
import com.jidesoft.list.ListModelWrapperUtils;
import com.jidesoft.list.ListTransferHandler;
import com.jidesoft.list.UndoableListDataEvent;
import com.jidesoft.swing.UndoableSupport;
import com.jidesoft.utils.PortingUtils;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import javax.swing.AbstractAction;
import javax.swing.JList;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.UndoableEditListener;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEdit;
import javax.swing.undo.UndoableEditSupport;

public class UndoableListInstaller<E>
implements ListDataListener,
PropertyChangeListener {
    private JList<E> _list;

    public UndoableListInstaller(JList<E> jList) {
        this._list = jList;
        jList.getModel().addListDataListener(this);
        AbstractAction abstractAction = new AbstractAction(){
            private static final long serialVersionUID = -3366051410376533946L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (UndoableListInstaller.this.getUndoManager().canUndo()) {
                    UndoableListInstaller.this.getUndoManager().undo();
                } else {
                    PortingUtils.notifyUser(UndoableListInstaller.this._list);
                }
            }
        };
        AbstractAction abstractAction2 = new AbstractAction(){
            private static final long serialVersionUID = 7162675928851447532L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (UndoableListInstaller.this.getUndoManager().canRedo()) {
                    UndoableListInstaller.this.getUndoManager().redo();
                } else {
                    PortingUtils.notifyUser(UndoableListInstaller.this._list);
                }
            }
        };
        jList.addPropertyChangeListener("model", this);
        jList.getActionMap().put("undo", abstractAction);
        jList.getActionMap().put("redo", abstractAction2);
        jList.setTransferHandler(this.createDefaultTransferHandler());
    }

    protected ListTransferHandler createDefaultTransferHandler() {
        return new ListTransferHandler();
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
        this.addUndoIfNecessary(listDataEvent);
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
        this.addUndoIfNecessary(listDataEvent);
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
        this.addUndoIfNecessary(listDataEvent);
    }

    private void addUndoIfNecessary(ListDataEvent listDataEvent) {
        if (listDataEvent instanceof UndoableListDataEvent) {
            this.addUndo((UndoableListDataEvent)listDataEvent);
        } else if (listDataEvent instanceof CompoundListDataEvent && ((CompoundListDataEvent)listDataEvent).getOriginalEvent() instanceof UndoableListDataEvent) {
            this.addUndo((UndoableListDataEvent)((CompoundListDataEvent)listDataEvent).getOriginalEvent());
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("model".equals(propertyChangeEvent.getPropertyName())) {
            if (propertyChangeEvent.getOldValue() instanceof ListModel) {
                ((ListModel)propertyChangeEvent.getOldValue()).removeListDataListener(this);
            }
            if (propertyChangeEvent.getNewValue() instanceof ListModel) {
                ((ListModel)propertyChangeEvent.getNewValue()).removeListDataListener(this);
                ((ListModel)propertyChangeEvent.getNewValue()).addListDataListener(this);
            }
        }
    }

    public void addUndo(UndoableEdit undoableEdit) {
        UndoableEditSupport undoableEditSupport = this.getUndoableEditSupport();
        if (undoableEditSupport == null) {
            return;
        }
        UndoManager undoManager = this.getUndoManager();
        if (undoManager == null) {
            return;
        }
        if (undoableEdit instanceof UndoableListDataEvent && ((UndoableListDataEvent)undoableEdit).isUndoRedo()) {
            this.updateSelectionFromUndoableEdit((UndoableListDataEvent)undoableEdit);
            return;
        }
        if (undoManager.getLimit() > 0) {
            undoManager.addEdit(undoableEdit);
            undoableEditSupport.postEdit(undoableEdit);
        }
    }

    void updateSelectionFromUndoableEdit(UndoableListDataEvent undoableListDataEvent) {
        if (!(undoableListDataEvent.getSource() instanceof ListModel)) {
            return;
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        UndoableListDataEvent.ListModelEdit[] listModelEditArray = undoableListDataEvent.getEdits();
        ListModel listModel = (ListModel)undoableListDataEvent.getSource();
        for (UndoableListDataEvent.ListModelEdit listModelEdit : listModelEditArray) {
            if (listModelEdit.getType() == 2) {
                for (int i = arrayList.size() - 1; i >= 0; --i) {
                    Integer n = (Integer)arrayList.get(i);
                    if (n > listModelEdit.getRowIndex()) {
                        arrayList.remove(i);
                        arrayList.add(i, n - 1);
                        continue;
                    }
                    if (n.intValue() != listModelEdit.getRowIndex()) continue;
                    arrayList.remove(i);
                }
                continue;
            }
            arrayList.add(listModelEdit.getRowIndex());
        }
        HashSet hashSet = new HashSet();
        Integer[] integerArray = arrayList.iterator();
        while (integerArray.hasNext()) {
            int n = (Integer)integerArray.next();
            int n2 = ListModelWrapperUtils.getIndexAt(this._list.getModel(), listModel, n);
            if (n2 < 0) continue;
            hashSet.add(n2);
        }
        if (hashSet.size() > 0) {
            integerArray = hashSet.toArray(new Integer[hashSet.size()]);
            int[] nArray = new int[integerArray.length];
            for (int i = 0; i < integerArray.length; ++i) {
                nArray[i] = integerArray[i];
            }
            Arrays.sort(nArray);
            this._list.setSelectedIndices(nArray);
        } else {
            this._list.clearSelection();
        }
    }

    public UndoManager getUndoManager() {
        ListModel<E> listModel = ListModelWrapperUtils.getActualListModel(this._list.getModel(), UndoableSupport.class);
        if (listModel instanceof UndoableSupport) {
            return ((UndoableSupport)((Object)listModel)).getUndoManager();
        }
        return null;
    }

    private UndoableEditSupport getUndoableEditSupport() {
        ListModel<E> listModel = ListModelWrapperUtils.getActualListModel(this._list.getModel(), UndoableSupport.class);
        if (listModel instanceof UndoableSupport) {
            return ((UndoableSupport)((Object)listModel)).getUndoableEditSupport();
        }
        return null;
    }

    public void addUndoableEditListener(UndoableEditListener undoableEditListener) {
        UndoableEditSupport undoableEditSupport = this.getUndoableEditSupport();
        if (undoableEditSupport == null) {
            return;
        }
        undoableEditSupport.addUndoableEditListener(undoableEditListener);
    }

    public void removeUndoableEditListener(UndoableEditListener undoableEditListener) {
        UndoableEditSupport undoableEditSupport = this.getUndoableEditSupport();
        if (undoableEditSupport == null) {
            return;
        }
        undoableEditSupport.removeUndoableEditListener(undoableEditListener);
    }
}

