/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.list;

import com.jidesoft.list.EventFireListModel;
import com.jidesoft.list.ListUndoableSupport;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.UIManager;
import javax.swing.event.ListDataEvent;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;

public class UndoableListDataEvent
extends ListDataEvent
implements UndoableEdit {
    private static final long serialVersionUID = 3431442868294186078L;
    private List<ListModelEdit> _edits;
    private boolean _hasBeenDone = true;
    private boolean _alive = true;
    private boolean _undoRedo = false;
    private int _type;
    private int _index0;
    private int _index1;

    public UndoableListDataEvent(Object object, int n, int n2, int n3) {
        super(object, n, n2, n3);
    }

    public void addEdit(int n, int n2, Object object, Object object2) {
        if (this._edits == null) {
            this._edits = new ArrayList<ListModelEdit>();
        }
        this._edits.add(new ListModelEdit(n, n2, object, object2));
    }

    void removeLastEdit() {
        if (this._edits != null && this._edits.size() > 0) {
            this._edits.remove(this._edits.size() - 1);
        }
    }

    @Override
    public void die() {
        this._alive = false;
    }

    @Override
    public void undo() throws CannotUndoException {
        if (!this.canUndo()) {
            throw new CannotUndoException();
        }
        this._hasBeenDone = false;
        if (this._edits != null && this.getSource() instanceof ListUndoableSupport) {
            ((ListUndoableSupport)this.getSource()).beginCompoundEdit(true);
            for (int i = this._edits.size() - 1; i >= 0; --i) {
                ListModelEdit listModelEdit = this._edits.get(i);
                if (listModelEdit.getType() == 2) {
                    ((ListUndoableSupport)this.getSource()).undoableInsertElementAt(listModelEdit.getOldContent(), listModelEdit.getRowIndex());
                    continue;
                }
                if (listModelEdit.getType() == 1) {
                    ((ListUndoableSupport)this.getSource()).undoableRemoveElementAt(listModelEdit.getRowIndex());
                    continue;
                }
                ((ListUndoableSupport)this.getSource()).undoableSetElementAt(listModelEdit.getOldContent(), listModelEdit.getRowIndex());
            }
            ((ListUndoableSupport)this.getSource()).endCompoundEdit();
        }
    }

    @Override
    public boolean canUndo() {
        return this._alive && this._hasBeenDone;
    }

    @Override
    public void redo() throws CannotRedoException {
        if (!this.canRedo()) {
            throw new CannotRedoException();
        }
        this._hasBeenDone = true;
        if (this._edits != null && this.getSource() instanceof ListUndoableSupport) {
            ((ListUndoableSupport)this.getSource()).beginCompoundEdit(true);
            for (ListModelEdit listModelEdit : this._edits) {
                if (listModelEdit.getType() == 2) {
                    ((ListUndoableSupport)this.getSource()).undoableRemoveElementAt(listModelEdit.getRowIndex());
                    continue;
                }
                if (listModelEdit.getType() == 1) {
                    ((ListUndoableSupport)this.getSource()).undoableInsertElementAt(listModelEdit.getNewContent(), listModelEdit.getRowIndex());
                    continue;
                }
                ((ListUndoableSupport)this.getSource()).undoableSetElementAt(listModelEdit.getNewContent(), listModelEdit.getRowIndex());
            }
            ((ListUndoableSupport)this.getSource()).endCompoundEdit();
        }
    }

    @Override
    public boolean canRedo() {
        return this._alive && !this._hasBeenDone;
    }

    @Override
    public boolean addEdit(UndoableEdit undoableEdit) {
        return false;
    }

    @Override
    public boolean replaceEdit(UndoableEdit undoableEdit) {
        return false;
    }

    @Override
    public boolean isSignificant() {
        return true;
    }

    @Override
    public String getPresentationName() {
        return "";
    }

    @Override
    public String getUndoPresentationName() {
        String string = this.getPresentationName();
        string = !"".equals(string) ? UIManager.getString("AbstractUndoableEdit.undoText") + " " + string : UIManager.getString("AbstractUndoableEdit.undoText");
        return string;
    }

    @Override
    public String getRedoPresentationName() {
        String string = this.getPresentationName();
        string = !"".equals(string) ? UIManager.getString("AbstractUndoableEdit.redoText") + " " + string : UIManager.getString("AbstractUndoableEdit.redoText");
        return string;
    }

    public void setUndoRedo(boolean bl) {
        this._undoRedo = bl;
    }

    public boolean isUndoRedo() {
        return this._undoRedo;
    }

    public ListModelEdit[] getEdits() {
        return this._edits == null ? new ListModelEdit[]{} : this._edits.toArray(new ListModelEdit[this._edits.size()]);
    }

    public void setType(int n) {
        this._type = n;
    }

    @Override
    public int getType() {
        return this._type;
    }

    public void setIndex0(int n) {
        this._index0 = n;
    }

    @Override
    public int getIndex0() {
        return this._index0;
    }

    public void setIndex1(int n) {
        this._index1 = n;
    }

    @Override
    public int getIndex1() {
        return this._index1;
    }

    private static int getEventType(ListModelEdit listModelEdit) {
        return listModelEdit == null ? 0 : listModelEdit.getType();
    }

    public static void fireListDataEvent(AbstractListModel abstractListModel, ListDataEvent listDataEvent) {
        ListModelEdit[] listModelEditArray;
        if (listDataEvent.getSource() != abstractListModel || !(abstractListModel instanceof EventFireListModel)) {
            return;
        }
        if (listDataEvent instanceof UndoableListDataEvent && (listModelEditArray = ((UndoableListDataEvent)listDataEvent).getEdits()) != null) {
            int n;
            int n2;
            int n3;
            ListModelEdit listModelEdit2;
            if (listModelEditArray.length <= 0) {
                return;
            }
            if (listModelEditArray.length == 1) {
                ((UndoableListDataEvent)listDataEvent).setIndex0(listModelEditArray[0].getRowIndex());
                ((UndoableListDataEvent)listDataEvent).setIndex1(listModelEditArray[0].getRowIndex());
                ((UndoableListDataEvent)listDataEvent).setType(UndoableListDataEvent.getEventType(listModelEditArray[0]));
                ((EventFireListModel)((Object)abstractListModel)).fireListDataEvent(listDataEvent);
                return;
            }
            int n4 = Integer.MIN_VALUE;
            for (ListModelEdit listModelEdit2 : listModelEditArray) {
                n3 = UndoableListDataEvent.getEventType(listModelEdit2);
                if (n4 == Integer.MIN_VALUE) {
                    n4 = n3;
                    continue;
                }
                if (n4 == n3) continue;
                n4 = Integer.MAX_VALUE;
            }
            if (n4 == 1) {
                int n5 = -1;
                n2 = -1;
                for (ListModelEdit listModelEdit3 : listModelEditArray) {
                    int n6 = UndoableListDataEvent.getEventType(listModelEdit3);
                    if (n6 != n4 || listModelEdit3.getRowIndex() < 0) {
                        n5 = -1;
                        break;
                    }
                    if (n5 == -1 && n2 == -1) {
                        n5 = listModelEdit3.getRowIndex();
                        n2 = listModelEdit3.getRowIndex();
                        continue;
                    }
                    if (listModelEdit3.getRowIndex() >= n5 && listModelEdit3.getRowIndex() <= n2 + 1) {
                        ++n2;
                        continue;
                    }
                    n5 = -1;
                    break;
                }
                if (n5 >= 0 && n2 >= n5) {
                    ((UndoableListDataEvent)listDataEvent).setIndex0(n5);
                    ((UndoableListDataEvent)listDataEvent).setIndex1(n2);
                    ((UndoableListDataEvent)listDataEvent).setType(n4);
                    ((EventFireListModel)((Object)abstractListModel)).fireListDataEvent(listDataEvent);
                    return;
                }
            } else if (n4 == 2) {
                int n7 = -1;
                n2 = -1;
                for (n = listModelEditArray.length - 1; n >= 0; --n) {
                    listModelEdit2 = listModelEditArray[n];
                    n3 = UndoableListDataEvent.getEventType(listModelEdit2);
                    if (n3 != n4 || listModelEdit2.getRowIndex() < 0) {
                        n7 = -1;
                        break;
                    }
                    if (n7 == -1 && n2 == -1) {
                        n7 = listModelEdit2.getRowIndex();
                        n2 = listModelEdit2.getRowIndex();
                        continue;
                    }
                    if (listModelEdit2.getRowIndex() >= n7 && listModelEdit2.getRowIndex() <= n2 + 1) {
                        ++n2;
                        continue;
                    }
                    n7 = -1;
                    break;
                }
                if (n7 >= 0 && n2 >= n7) {
                    ((UndoableListDataEvent)listDataEvent).setIndex0(n7);
                    ((UndoableListDataEvent)listDataEvent).setIndex1(n2);
                    ((UndoableListDataEvent)listDataEvent).setType(n4);
                    ((EventFireListModel)((Object)abstractListModel)).fireListDataEvent(listDataEvent);
                    return;
                }
            } else if (n4 == 0) {
                int n8 = -1;
                n2 = -1;
                for (n = listModelEditArray.length - 1; n >= 0; --n) {
                    listModelEdit2 = listModelEditArray[n];
                    n3 = UndoableListDataEvent.getEventType(listModelEdit2);
                    if (n3 != n4 || listModelEdit2.getRowIndex() < 0) {
                        n8 = -1;
                        break;
                    }
                    if (n8 == -1 && n2 == -1) {
                        n8 = listModelEdit2.getRowIndex();
                        n2 = listModelEdit2.getRowIndex();
                        continue;
                    }
                    if (listModelEdit2.getRowIndex() >= n2) {
                        n2 = listModelEdit2.getRowIndex();
                        continue;
                    }
                    if (listModelEdit2.getRowIndex() > n8) continue;
                    n8 = listModelEdit2.getRowIndex();
                }
                if (n8 >= 0 && n2 >= n8 && n2 - n8 <= listModelEditArray.length) {
                    ((UndoableListDataEvent)listDataEvent).setIndex0(n8);
                    ((UndoableListDataEvent)listDataEvent).setIndex1(n2);
                    ((UndoableListDataEvent)listDataEvent).setType(n4);
                    ((EventFireListModel)((Object)abstractListModel)).fireListDataEvent(listDataEvent);
                    return;
                }
            }
            ((UndoableListDataEvent)listDataEvent).setType(0);
            ((UndoableListDataEvent)listDataEvent).setIndex0(0);
            ((UndoableListDataEvent)listDataEvent).setIndex1(abstractListModel.getSize() - 1);
        }
        ((EventFireListModel)((Object)abstractListModel)).fireListDataEvent(listDataEvent);
    }

    class ListModelEdit {
        private int _rowIndex;
        private Object _oldContent;
        private Object _newContent;
        private int _type;

        public ListModelEdit(int n, int n2, Object object, Object object2) {
            this._rowIndex = n;
            this._type = n2;
            this._oldContent = object;
            this._newContent = object2;
        }

        public int getType() {
            return this._type;
        }

        public int getRowIndex() {
            return this._rowIndex;
        }

        public Object getOldContent() {
            return this._oldContent;
        }

        public Object getNewContent() {
            return this._newContent;
        }
    }
}

