/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.list;

import com.jidesoft.list.ListModelWrapperUtils;
import com.jidesoft.list.ListUndoableSupport;
import com.jidesoft.list.ListUtils;
import com.jidesoft.swing.UndoableSupport;
import com.jidesoft.utils.BasicTransferable;
import com.jidesoft.utils.PortingUtils;
import com.jidesoft.utils.SystemInfo;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Arrays;
import javax.swing.DropMode;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.TransferHandler;

public class ListTransferHandler
extends TransferHandler {
    private static final long serialVersionUID = -5183471098824086923L;
    int[] _exportRows;
    int[] _droppedRows;
    private boolean _insertRows = false;
    private boolean _acceptImport = true;

    public ListTransferHandler(String string) {
        super(string);
    }

    public ListTransferHandler() {
    }

    @Override
    protected Transferable createTransferable(JComponent jComponent) {
        if (jComponent instanceof JList) {
            JList jList = (JList)jComponent;
            Object[] objectArray = jList.getSelectedValues();
            if (objectArray == null || objectArray.length == 0) {
                return null;
            }
            StringBuffer stringBuffer = new StringBuffer();
            StringBuffer stringBuffer2 = new StringBuffer();
            stringBuffer2.append("<html>\n<body>\n<table>\n");
            for (Object object : objectArray) {
                stringBuffer2.append("<tr>\n");
                String string = object == null ? "" : object.toString();
                stringBuffer.append(string).append("\n");
                stringBuffer2.append("  <td>").append(string).append("</td>\n");
                stringBuffer2.append("</tr>\n");
            }
            stringBuffer.deleteCharAt(stringBuffer.length() - 1);
            stringBuffer2.append("</table>\n</body>\n</html>");
            this._exportRows = jList.getSelectedIndices();
            return new BasicTransferable(stringBuffer.toString(), stringBuffer2.toString());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean importData(JComponent jComponent, Transferable transferable) {
        if (this.canImport(jComponent, transferable.getTransferDataFlavors())) {
            try {
                String string = (String)transferable.getTransferData(DataFlavor.stringFlavor);
                Field[] fieldArray = transferable.getClass().getDeclaredFields();
                boolean bl = false;
                for (Field field : fieldArray) {
                    if (!"isLocal".equals(field.getName())) continue;
                    boolean bl2 = field.isAccessible();
                    field.setAccessible(true);
                    try {
                        bl = field.getBoolean(transferable);
                        break;
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        break;
                    }
                    finally {
                        field.setAccessible(bl2);
                    }
                }
                if (!this.importString(jComponent, string, bl)) {
                    PortingUtils.notifyUser(jComponent);
                    return false;
                }
                return true;
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return false;
    }

    @Override
    public boolean canImport(JComponent jComponent, DataFlavor[] dataFlavorArray) {
        if (!(jComponent instanceof JList && jComponent.isEnabled() && this.isAcceptImport())) {
            return false;
        }
        JList jList = (JList)jComponent;
        if (SystemInfo.isJdk6Above() && (jList.getDropMode() == DropMode.INSERT_COLS || jList.getDropMode() == DropMode.ON_OR_INSERT_COLS)) {
            return false;
        }
        for (DataFlavor dataFlavor : dataFlavorArray) {
            if (!DataFlavor.stringFlavor.equals(dataFlavor)) continue;
            return true;
        }
        return false;
    }

    protected boolean importString(JComponent jComponent, String string, boolean bl) {
        if (!(jComponent instanceof JList) || !jComponent.isEnabled()) {
            return false;
        }
        JList jList = (JList)jComponent;
        ListModel listModel = ListModelWrapperUtils.getActualListModel(jList.getModel(), ListUndoableSupport.class);
        this._insertRows = false;
        if (SystemInfo.isJdk6Above() && jList.getDropLocation() != null) {
            JList.DropLocation dropLocation = jList.getDropLocation();
            this._insertRows = dropLocation.isInsert();
            int n = dropLocation.getIndex();
            int n2 = jList.getModel().getSize();
            if (n < 0 || n > n2) {
                n = n2;
            }
            String[] stringArray = string.split("\n");
            if (listModel instanceof UndoableSupport) {
                ((UndoableSupport)((Object)listModel)).beginCompoundEdit(false);
            }
            this._droppedRows = new int[stringArray.length];
            int n3 = 0;
            int n4 = ListModelWrapperUtils.getActualIndexAt(jList.getModel(), n, listModel);
            if (n4 < 0) {
                n4 = listModel.getSize();
            }
            if (listModel instanceof ListUndoableSupport) {
                for (String string2 : stringArray) {
                    if (dropLocation.isInsert()) {
                        ((ListUndoableSupport)((Object)listModel)).undoableInsertElementAt(this.convertStringToElement(jList, n4, string2), n4);
                        this._droppedRows[n3++] = n4;
                    } else {
                        if (!this.updateRow(jList, n, this.convertStringToElement(jList, n, string2))) continue;
                        this._droppedRows[n3++] = ListModelWrapperUtils.getActualIndexAt(jList.getModel(), n, listModel);
                    }
                    ++n;
                    ++n4;
                }
            }
            if (!bl && listModel instanceof ListUndoableSupport) {
                ((ListUndoableSupport)((Object)listModel)).endCompoundEdit();
                if (this._droppedRows != null) {
                    for (int i = 0; i < this._droppedRows.length; ++i) {
                        this._droppedRows[i] = ListModelWrapperUtils.getIndexAt(jList.getModel(), listModel, this._droppedRows[i]);
                    }
                }
                if (this._droppedRows != null && this._droppedRows.length > 0) {
                    this.adjustSelection(jList, this._droppedRows, this._droppedRows.length, this._droppedRows[0]);
                }
                this._droppedRows = null;
            }
        } else {
            int n;
            int[] nArray = jList.getSelectedIndices();
            if (nArray == null || nArray.length == 0) {
                return false;
            }
            String[] stringArray = string.split("\n");
            int n5 = nArray.length;
            int n6 = nArray[0];
            for (n = 1; n < nArray.length; ++n) {
                if (n6 <= nArray[n]) continue;
                n6 = nArray[n];
            }
            n = stringArray.length;
            if (n <= 0) {
                return false;
            }
            if (n5 < n) {
                n5 = n;
            } else if (n5 % n != 0) {
                n5 = n;
            }
            if (n6 + n5 > jList.getModel().getSize()) {
                return false;
            }
            if (listModel instanceof UndoableSupport) {
                ((UndoableSupport)((Object)listModel)).beginCompoundEdit(false);
            }
            for (int i = 0; i < n5; ++i) {
                String string3 = stringArray[i % n];
                int n7 = i < nArray.length ? nArray[i] : n6 + i;
                this.updateRow(jList, n7, string3);
            }
            if (listModel instanceof UndoableSupport) {
                ((UndoableSupport)((Object)listModel)).endCompoundEdit();
            }
            if (n5 != nArray.length) {
                this.adjustSelection(jList, nArray, n5, n6);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void adjustSelection(JList jList, int[] nArray, int n, int n2) {
        ListSelectionModel listSelectionModel = jList.getSelectionModel();
        listSelectionModel.setValueIsAdjusting(true);
        try {
            listSelectionModel.clearSelection();
            if (n > nArray.length) {
                listSelectionModel.addSelectionInterval(n2, n2 + n - 1);
            } else {
                for (int i = 0; i < n; ++i) {
                    listSelectionModel.addSelectionInterval(nArray[i], nArray[i]);
                }
            }
        }
        finally {
            listSelectionModel.setValueIsAdjusting(false);
        }
        ListUtils.ensureSelectionVisible(jList);
    }

    protected boolean updateRow(JList jList, int n, Object object) {
        ListUndoableSupport listUndoableSupport = (ListUndoableSupport)((Object)ListModelWrapperUtils.getActualListModel(jList.getModel(), ListUndoableSupport.class));
        if (listUndoableSupport == null || !(listUndoableSupport instanceof ListModel)) {
            return false;
        }
        n = ListModelWrapperUtils.getActualIndexAt(jList.getModel(), n, (ListModel)((Object)listUndoableSupport));
        listUndoableSupport.undoableSetElementAt(object, n);
        return true;
    }

    protected String convertElementToString(JList jList, int n, Object object) {
        return object == null ? "" : object.toString();
    }

    protected Object convertStringToElement(JList jList, int n, String string) {
        return string;
    }

    @Override
    public int getSourceActions(JComponent jComponent) {
        if (!(jComponent instanceof JList)) {
            return 0;
        }
        if (!SystemInfo.isJdk6Above()) {
            return 3;
        }
        if (((JList)jComponent).getDropLocation() != null) {
            return 2;
        }
        return 3;
    }

    @Override
    protected void exportDone(JComponent jComponent, Transferable transferable, int n) {
        super.exportDone(jComponent, transferable, n);
        this.cleanup(jComponent, n == 2);
    }

    private void cleanup(JComponent jComponent, boolean bl) {
        int n;
        if (!(jComponent instanceof JList)) {
            this.cleanUpFields();
            return;
        }
        if (!bl && !this._insertRows && this._droppedRows == null) {
            this.cleanUpFields();
            return;
        }
        JList jList = (JList)jComponent;
        ListModel listModel = ListModelWrapperUtils.getActualListModel(jList.getModel(), ListUndoableSupport.class);
        if (listModel instanceof UndoableSupport) {
            ((UndoableSupport)((Object)listModel)).beginCompoundEdit(false);
        }
        int[] nArray = null;
        if (bl && this._exportRows != null) {
            nArray = new int[this._exportRows.length];
            for (n = 0; n < this._exportRows.length; ++n) {
                nArray[n] = ListModelWrapperUtils.getActualIndexAt(jList.getModel(), this._exportRows[n], listModel);
                if (this._droppedRows == null || this._droppedRows.length <= 0 || listModel == jList.getModel() || !this._insertRows || nArray[n] < this._droppedRows[0]) continue;
                int n2 = n;
                nArray[n2] = nArray[n2] + this._droppedRows.length;
            }
        }
        if (bl && nArray != null && listModel instanceof ListUndoableSupport) {
            Arrays.sort(nArray);
            for (n = nArray.length - 1; n >= 0; --n) {
                ((ListUndoableSupport)((Object)listModel)).undoableRemoveElementAt(nArray[n]);
            }
        }
        if (nArray != null && this._droppedRows != null) {
            for (int n3 : nArray) {
                for (int i = 0; i < this._droppedRows.length; ++i) {
                    if (this._droppedRows[i] < n3) continue;
                    int n4 = i;
                    this._droppedRows[n4] = this._droppedRows[n4] - 1;
                }
            }
        }
        if (listModel instanceof UndoableSupport) {
            ((UndoableSupport)((Object)listModel)).endCompoundEdit();
        }
        if (this._droppedRows != null) {
            for (int i = 0; i < this._droppedRows.length; ++i) {
                this._droppedRows[i] = ListModelWrapperUtils.getIndexAt(jList.getModel(), listModel, this._droppedRows[i]);
            }
        }
        if (this._droppedRows != null && this._droppedRows.length > 0) {
            this.adjustSelection(jList, this._droppedRows, this._droppedRows.length, this._droppedRows[0]);
        } else {
            jList.clearSelection();
        }
        this.cleanUpFields();
    }

    void cleanUpFields() {
        this._insertRows = false;
        this._droppedRows = null;
        this._exportRows = null;
    }

    public boolean isAcceptImport() {
        return this._acceptImport;
    }

    public void setAcceptImport(boolean bl) {
        this._acceptImport = bl;
    }

    boolean isExporting() {
        return this._exportRows != null;
    }
}

