/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.list;

import com.jidesoft.grid.IndexChangeEvent;
import com.jidesoft.grid.IndexChangeListener;
import com.jidesoft.list.CompoundListDataEvent;
import com.jidesoft.list.DefaultListModelWrapper;
import com.jidesoft.list.ListUtils;
import com.jidesoft.swing.JideSwingUtilities;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JList;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class JideList
extends JList
implements IndexChangeListener,
ListDataListener {
    private static final Logger LOGGER_EVENT = Logger.getLogger(JideList.class.getName());
    int[] _savedListSelection;
    private int _processingEventSerialNumber = -1;
    private boolean _init;
    private boolean _indexChanging;
    private boolean _dataOrStructureChangeProcessed;
    private boolean _isEventInvokedOutside = false;
    boolean _needLoadRowSettings;
    boolean _loadInsertedRowsOnly;

    public JideList() {
        this.initializeList();
    }

    public JideList(ListModel listModel) {
        super(listModel);
        this.initializeList();
    }

    protected void saveListRowSettings(boolean bl) {
        if (this._isEventInvokedOutside && !bl) {
            return;
        }
        this.saveListSelection();
        if (bl) {
            this._isEventInvokedOutside = true;
        }
    }

    protected void loadListRowSettings(boolean bl) {
        if (this._isEventInvokedOutside && !bl) {
            return;
        }
        this.loadListSelection();
        this._isEventInvokedOutside = false;
    }

    void saveListSelection() {
        this._savedListSelection = this.mergeSavedListSelection(this._savedListSelection, ListUtils.saveSelection(this));
    }

    void loadListSelection() {
        ListUtils.loadSelection(this, this._savedListSelection);
    }

    private int[] mergeSavedListSelection(int[] nArray, int[] nArray2) {
        if (nArray2 == null || nArray2.length == 0) {
            return nArray;
        }
        if (nArray != null && nArray.length > 0) {
            int n;
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            int[] nArray3 = new int[nArray2.length];
            System.arraycopy(nArray2, 0, nArray3, 0, nArray2.length);
            Arrays.sort(nArray3);
            for (int i = 0; i < nArray.length; ++i) {
                n = JideSwingUtilities.binarySearch(nArray3, nArray[i]);
                if (n >= 0 && (n != 0 || nArray[i] == nArray3[0])) continue;
                arrayList.add(nArray[i]);
            }
            int[] nArray4 = new int[nArray2.length + arrayList.size()];
            System.arraycopy(nArray2, 0, nArray4, 0, nArray2.length);
            n = nArray2.length;
            int n2 = 0;
            while (n < nArray4.length) {
                nArray4[n] = (Integer)arrayList.get(n2);
                ++n;
                ++n2;
            }
            return nArray4;
        }
        return nArray2;
    }

    @Override
    public void indexChanged(IndexChangeEvent indexChangeEvent) {
        switch (indexChangeEvent.getType()) {
            case 0: {
                if (this.isIndexChanging() && LOGGER_EVENT.isLoggable(Level.FINE)) {
                    LOGGER_EVENT.fine("JideList\" should not get duplicate index changing events " + indexChangeEvent.getEventSerialNumber() + ", " + this._processingEventSerialNumber + ".");
                }
                this.saveListRowSettings(false);
                this.setIndexChanging(true);
                this.setDataOrStructureChangeProcessed(false);
                this._needLoadRowSettings = false;
                this._loadInsertedRowsOnly = false;
                this.setIndexChanging(false);
                break;
            }
            case 1: {
                if (this.isIndexChanging()) break;
                if (LOGGER_EVENT.isLoggable(Level.FINE)) {
                    LOGGER_EVENT.fine("JideList \" should not get index changed event without index changing event " + indexChangeEvent.getEventSerialNumber() + ".");
                }
                this._processingEventSerialNumber = -1;
                if (this.isDataOrStructureChangeProcessed() || this._needLoadRowSettings) {
                    // empty if block
                }
                try {
                    this.loadListRowSettings(false);
                }
                finally {
                    this._needLoadRowSettings = false;
                    this._loadInsertedRowsOnly = false;
                    if (this.getSelectionModel().getValueIsAdjusting()) {
                        this.getSelectionModel().setValueIsAdjusting(false);
                    }
                }
                this.setDataOrStructureChangeProcessed(false);
            }
        }
    }

    private void initializeList() {
        if (!this._init) {
            if (this.getModel() instanceof DefaultListModelWrapper) {
                ((DefaultListModelWrapper)this.getModel()).addIndexChangeListener(this);
                this.getModel().addListDataListener(this);
            }
            this._init = true;
        }
    }

    public void setModel(ListModel listModel) {
        if (this.getModel() instanceof DefaultListModelWrapper) {
            ((DefaultListModelWrapper)this.getModel()).removeIndexChangeListener(this);
            this.getModel().removeListDataListener(this);
        }
        super.setModel(listModel);
        if (this.getModel() instanceof DefaultListModelWrapper) {
            ((DefaultListModelWrapper)this.getModel()).addIndexChangeListener(this);
            this.getModel().addListDataListener(this);
        }
    }

    private boolean isIndexChanging() {
        return this._indexChanging;
    }

    private void setIndexChanging(boolean bl) {
        this._indexChanging = bl;
    }

    private boolean isDataOrStructureChangeProcessed() {
        return this._dataOrStructureChangeProcessed;
    }

    private void setDataOrStructureChangeProcessed(boolean bl) {
        this._dataOrStructureChangeProcessed = bl;
    }

    private void clearSavedSelections() {
        this._savedListSelection = null;
    }

    @Override
    public void setSelectionInterval(int n, int n2) {
        this.clearSavedSelections();
        super.setSelectionInterval(n, n2);
    }

    @Override
    public void addSelectionInterval(int n, int n2) {
        this.clearSavedSelections();
        super.addSelectionInterval(n, n2);
    }

    @Override
    public void removeSelectionInterval(int n, int n2) {
        this.clearSavedSelections();
        super.removeSelectionInterval(n, n2);
    }

    private void adjuestSavedSelection(ListDataEvent listDataEvent) {
        if (listDataEvent == null || this._savedListSelection == null || this._savedListSelection.length == 0) {
            return;
        }
        Arrays.sort(this._savedListSelection);
        ListDataEvent listDataEvent2 = listDataEvent;
        while (listDataEvent2 instanceof CompoundListDataEvent && ((CompoundListDataEvent)listDataEvent2).getOriginalEvent() != null) {
            listDataEvent2 = ((CompoundListDataEvent)listDataEvent2).getOriginalEvent();
        }
        int n = listDataEvent2.getIndex0();
        int n2 = listDataEvent2.getIndex1();
        switch (listDataEvent2.getType()) {
            case 0: {
                break;
            }
            case 1: {
                if (n > n2) break;
                for (int i = 0; i < this._savedListSelection.length; ++i) {
                    int n3 = i;
                    this._savedListSelection[n3] = this._savedListSelection[n3] + (this._savedListSelection[i] < n ? 0 : n2 - n + 1);
                }
                break;
            }
            case 2: {
                if (n > n2) break;
                for (int i = 0; i < this._savedListSelection.length; ++i) {
                    if (this._savedListSelection[i] >= n && this._savedListSelection[i] <= n2) {
                        this._savedListSelection[i] = -1;
                        continue;
                    }
                    if (this._savedListSelection[i] <= n2) continue;
                    int n4 = i;
                    this._savedListSelection[n4] = this._savedListSelection[n4] - (n2 - n + 1);
                }
                break;
            }
        }
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
        this.adjuestSavedSelection(listDataEvent);
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
        this.adjuestSavedSelection(listDataEvent);
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
    }
}

