/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.list;

import com.jidesoft.list.DefaultDisableableListSelectionModel;
import com.jidesoft.list.DefaultGroupableListModel;
import com.jidesoft.list.GroupListModel;
import com.jidesoft.list.GroupableListModel;
import com.jidesoft.list.GroupableListModelAdapter;
import com.jidesoft.list.GroupableListModelWrapper;
import com.jidesoft.plaf.LookAndFeelFactory;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.plaf.basic.BasicGroupListUI;
import com.jidesoft.utils.Lm;
import com.jidesoft.utils.Q;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.UIManager;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.plaf.ComponentUI;

public class GroupList
extends JList {
    private static final String uiClassID = "GroupListUI";
    public static final int HORIZONTAL = 3;
    protected boolean _groupCellSelectable = false;
    private int _layoutOrientation;
    private int _preferredColumnCount = 8;
    private ListCellRenderer _groupCellRenderer;
    private ListDataListener _handler = new ListDataHandler();

    public GroupList() {
        this(new DefaultGroupableListModel());
    }

    public GroupList(ListModel listModel) {
        this(new GroupableListModelAdapter(listModel));
    }

    public GroupList(Object[] objectArray) {
        this(Arrays.asList(objectArray));
    }

    public GroupList(List<?> list) {
        this(new GroupableListModelAdapter(list));
    }

    public String getActualUIClassID() {
        return uiClassID;
    }

    @Override
    public void updateUI() {
        if (UIDefaultsLookup.get(this.getActualUIClassID()) == null) {
            LookAndFeelFactory.installJideExtension();
        }
        try {
            Class<?> clazz = Class.forName(UIManager.getString(this.getActualUIClassID()));
            Class<JComponent> clazz2 = JComponent.class;
            Method method = clazz.getMethod("createUI", clazz2);
            if (method != null) {
                Object object = method.invoke(null, this);
                this.setUI((ComponentUI)object);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public GroupList(GroupListModel groupListModel) {
        super(groupListModel);
        groupListModel.addListDataListener(this._handler);
        this.setSelectionModel(new DefaultDisableableListSelectionModel());
        this.initDisabledSelections();
        this.setFocusTraversalKeys(0, GroupList.getManagingFocusForwardTraversalKeys());
        this.setFocusTraversalKeys(1, GroupList.getManagingFocusBackwardTraversalKeys());
    }

    public GroupList(GroupableListModel groupableListModel) {
        this(new GroupableListModelWrapper(groupableListModel));
    }

    public GroupList(Map<Object, ?> map) {
        this(GroupList.createModel(map));
    }

    static Set<KeyStroke> getManagingFocusForwardTraversalKeys() {
        HashSet<KeyStroke> hashSet = new HashSet<KeyStroke>();
        hashSet.add(KeyStroke.getKeyStroke(9, 2));
        return hashSet;
    }

    static Set<KeyStroke> getManagingFocusBackwardTraversalKeys() {
        HashSet<KeyStroke> hashSet = new HashSet<KeyStroke>();
        hashSet.add(KeyStroke.getKeyStroke(9, 3));
        return hashSet;
    }

    protected static GroupableListModel createModel(Map<Object, ?> map) {
        DefaultGroupableListModel defaultGroupableListModel = new DefaultGroupableListModel();
        int n = 0;
        for (Object object : map.keySet()) {
            Object[] objectArray;
            Object obj = map.get(object);
            if (obj instanceof Collection) {
                objectArray = ((Collection)obj).iterator();
                while (objectArray.hasNext()) {
                    Object e = objectArray.next();
                    defaultGroupableListModel.addElement(e);
                    defaultGroupableListModel.setGroupAt(object, n);
                    ++n;
                }
                continue;
            }
            if (obj.getClass().isArray()) {
                for (Object object2 : objectArray = (Object[])obj) {
                    defaultGroupableListModel.addElement(object2);
                    defaultGroupableListModel.setGroupAt(object, n);
                    ++n;
                }
                continue;
            }
            defaultGroupableListModel.addElement(obj);
            defaultGroupableListModel.setGroupAt(object, n);
            ++n;
        }
        return defaultGroupableListModel;
    }

    public void setModel(ListModel listModel) {
        this.getModel().removeListDataListener(this._handler);
        GroupListModel groupListModel = listModel instanceof GroupListModel ? (GroupListModel)listModel : (listModel instanceof GroupableListModel ? new GroupableListModelWrapper((GroupableListModel)listModel) : new GroupableListModelWrapper(new GroupableListModelAdapter(listModel)));
        super.setModel(groupListModel);
        this.initDisabledSelections();
        groupListModel.addListDataListener(this._handler);
    }

    public GroupListModel getModel() {
        return (GroupListModel)super.getModel();
    }

    public boolean isGroupCellSelectable() {
        return this._groupCellSelectable;
    }

    public void setGroupCellSelectable(boolean bl) {
        if (this._groupCellSelectable != bl) {
            boolean bl2 = this._groupCellSelectable;
            this._groupCellSelectable = bl;
            this.firePropertyChange("groupCellSelectable", bl2, bl);
        }
        this.initDisabledSelections();
    }

    public int getPreferredColumnCount() {
        return this._preferredColumnCount;
    }

    public void setPreferredColumnCount(int n) {
        if (this._preferredColumnCount != n) {
            int n2 = this._preferredColumnCount;
            this._preferredColumnCount = Math.max(0, n);
            this.firePropertyChange("preferredColumnCount", n2, n);
        }
    }

    public int getRowCount() {
        return ((BasicGroupListUI)this.getUI()).getRowCount();
    }

    public int getColumnCount(int n) {
        return ((BasicGroupListUI)this.getUI()).getColumnCount(n);
    }

    public ListCellRenderer getGroupCellRenderer() {
        return this._groupCellRenderer;
    }

    public void setGroupCellRenderer(ListCellRenderer listCellRenderer) {
        ListCellRenderer listCellRenderer2 = this._groupCellRenderer;
        this._groupCellRenderer = listCellRenderer;
        this.firePropertyChange("groupCellRenderer", listCellRenderer2, listCellRenderer);
    }

    @Override
    public void setLayoutOrientation(int n) {
        int n2 = this._layoutOrientation;
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                this._layoutOrientation = n;
                this.firePropertyChange("layoutOrientation", n2, n);
                break;
            }
            default: {
                throw new IllegalArgumentException("layoutOrientation must be one of: VERTICAL, HORIZONTAL_WRAP, VERTICAL_WRAP or HORIZONTAL");
            }
        }
    }

    @Override
    public int getLayoutOrientation() {
        return this._layoutOrientation;
    }

    public int[] getGroupCellIndices() {
        return this.getModel().getGroupCellIndices();
    }

    @Override
    public String getToolTipText(MouseEvent mouseEvent) {
        if (mouseEvent != null) {
            Rectangle rectangle;
            ListCellRenderer listCellRenderer;
            Point point = mouseEvent.getPoint();
            int n = this.locationToIndex(point);
            if (n == -1) {
                return super.getToolTipText();
            }
            ListCellRenderer listCellRenderer2 = listCellRenderer = this.getModel().isGroupRow(n) ? this.getGroupCellRenderer() : this.getCellRenderer();
            if (listCellRenderer != null && (rectangle = this.getCellBounds(n, n)) != null && rectangle.contains(point.x, point.y)) {
                ListSelectionModel listSelectionModel = this.getSelectionModel();
                Component component = listCellRenderer.getListCellRendererComponent(this, this.getModel().getElementAt(n), n, listSelectionModel.isSelectedIndex(n), this.hasFocus() && listSelectionModel.getLeadSelectionIndex() == n);
                if (component instanceof JComponent) {
                    point.translate(-rectangle.x, -rectangle.y);
                    MouseEvent mouseEvent2 = new MouseEvent(component, mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), point.x, point.y, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger());
                    String string = ((JComponent)component).getToolTipText(mouseEvent2);
                    if (string != null) {
                        return string;
                    }
                }
            }
        }
        return super.getToolTipText();
    }

    private void initDisabledSelections() {
        ListSelectionModel listSelectionModel = this.getSelectionModel();
        if (listSelectionModel instanceof DefaultDisableableListSelectionModel) {
            if (this.isGroupCellSelectable()) {
                ((DefaultDisableableListSelectionModel)listSelectionModel).setDisabledIndices(null);
            } else {
                int[] nArray = this.getModel().getGroupCellIndices();
                ((DefaultDisableableListSelectionModel)listSelectionModel).setDisabledIndices(nArray);
            }
        }
    }

    static {
        try {
            if (Lm.class.getDeclaredMethods().length != 29 && Lm.class.getDeclaredMethods().length != 31) {
                System.err.println("The Lm class is invalid, exiting ... " + Lm.class.getDeclaredMethods().length);
                System.exit(-1);
            }
        }
        catch (Exception exception) {
            System.exit(-1);
        }
        if (!Q.zz(4)) {
            Lm.showInvalidProductMessage(GroupList.class.getName(), 4);
        }
    }

    private class ListDataHandler
    implements ListDataListener {
        private ListDataHandler() {
        }

        @Override
        public void intervalAdded(ListDataEvent listDataEvent) {
            this.contentsChanged(listDataEvent);
        }

        @Override
        public void intervalRemoved(ListDataEvent listDataEvent) {
            this.contentsChanged(listDataEvent);
        }

        @Override
        public void contentsChanged(ListDataEvent listDataEvent) {
            GroupList.this.initDisabledSelections();
        }
    }
}

