/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.list;

import com.jidesoft.list.AbstractPageListModel;
import com.jidesoft.list.CompoundListDataEvent;
import com.jidesoft.list.DefaultListModelWrapper;
import com.jidesoft.list.EventFireListModel;
import com.jidesoft.list.ListModelWrapper;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class DefaultPageListModel
extends AbstractPageListModel
implements ListModelWrapper,
EventFireListModel {
    private static final long serialVersionUID = -2530531413306123693L;
    private DefaultListModelWrapper _listModelWrapper;

    public DefaultPageListModel(ListModel listModel) {
        this(listModel, 10);
    }

    public DefaultPageListModel(ListModel listModel, int n) {
        super(n);
        this._listModelWrapper = new DefaultListModelWrapper(listModel){
            private static final long serialVersionUID = 5284262701448559470L;

            @Override
            public void intervalAdded(ListDataEvent listDataEvent) {
                super.intervalAdded(listDataEvent);
                CompoundListDataEvent compoundListDataEvent = this.createCompoundListDataEvent();
                compoundListDataEvent.addEvent(new ListDataEvent(this, 1, listDataEvent.getIndex0(), listDataEvent.getIndex1()));
                CompoundListDataEvent.fireListDataEvent(DefaultPageListModel.this, compoundListDataEvent);
                DefaultPageListModel.this.setCurrentPage(Math.min(DefaultPageListModel.this.getCurrentPage(), DefaultPageListModel.this.getPageCount() - 1), true);
            }

            @Override
            public void intervalRemoved(ListDataEvent listDataEvent) {
                super.intervalRemoved(listDataEvent);
                CompoundListDataEvent compoundListDataEvent = this.createCompoundListDataEvent();
                compoundListDataEvent.addEvent(new ListDataEvent(this, 2, listDataEvent.getIndex0(), listDataEvent.getIndex1()));
                CompoundListDataEvent.fireListDataEvent(DefaultPageListModel.this, compoundListDataEvent);
                DefaultPageListModel.this.setCurrentPage(Math.min(DefaultPageListModel.this.getCurrentPage(), DefaultPageListModel.this.getPageCount() - 1), true);
            }

            @Override
            public void contentsChanged(ListDataEvent listDataEvent) {
                super.contentsChanged(listDataEvent);
                CompoundListDataEvent compoundListDataEvent = this.createCompoundListDataEvent();
                compoundListDataEvent.addEvent(new ListDataEvent(this, 0, listDataEvent.getIndex0(), listDataEvent.getIndex1()));
                CompoundListDataEvent.fireListDataEvent(DefaultPageListModel.this, compoundListDataEvent);
                DefaultPageListModel.this.setCurrentPage(Math.min(DefaultPageListModel.this.getCurrentPage(), DefaultPageListModel.this.getPageCount() - 1), true);
            }
        };
        this.pageSizeChanged(-1, this.getPageSize());
    }

    @Override
    public int getActualIndexAt(int n) {
        return this._listModelWrapper.getActualIndexAt(n);
    }

    @Override
    public int getIndexAt(int n) {
        return this._listModelWrapper.getIndexAt(n);
    }

    public ListModel getActualModel() {
        return this._listModelWrapper.getActualModel();
    }

    public void setActualModel(ListModel listModel) {
        this._listModelWrapper.setActualModel(listModel);
    }

    @Override
    public int[] getIndexes() {
        return this._listModelWrapper.getIndexes();
    }

    @Override
    public void setIndexes(int[] nArray) {
        this._listModelWrapper.setIndexes(nArray);
    }

    @Override
    void pageCountChanged(int n, int n2) {
    }

    @Override
    void pageIndexChanged(int n, int n2) {
        this.reallocateIndexes();
    }

    @Override
    public Object getElementAt(int n) {
        return this._listModelWrapper.getElementAt(n);
    }

    @Override
    public int getTotalRecordCount() {
        return this._listModelWrapper.getActualModel().getSize();
    }

    @Override
    public void setTotalRecordCount(int n) {
    }

    protected void reallocateIndexes() {
        int[] nArray = this._listModelWrapper.getIndexes();
        if (nArray == null || nArray.length != this.getPageSize()) {
            nArray = new int[this.getPageSize()];
        }
        int n = this.getCurrentPage() * this.getPageSize();
        for (int i = 0; i < nArray.length; ++i) {
            int n2 = n + i;
            nArray[i] = n2 >= this.getTotalRecordCount() ? -1 : n2;
        }
        this._listModelWrapper.setIndexes(nArray);
        CompoundListDataEvent compoundListDataEvent = this.createCompoundListDataEvent();
        compoundListDataEvent.addEvent(new ListDataEvent(this, 0, 0, this.getSize() - 1));
        CompoundListDataEvent.fireListDataEvent(this, compoundListDataEvent);
    }

    protected CompoundListDataEvent createCompoundListDataEvent() {
        return new CompoundListDataEvent(this, 0, 0, this.getSize() - 1);
    }

    @Override
    public void fireListDataEvent(ListDataEvent listDataEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != ListDataListener.class) continue;
            if (listDataEvent.getType() == 1) {
                ((ListDataListener)objectArray[i + 1]).intervalAdded(listDataEvent);
                continue;
            }
            if (listDataEvent.getType() == 2) {
                ((ListDataListener)objectArray[i + 1]).intervalRemoved(listDataEvent);
                continue;
            }
            ((ListDataListener)objectArray[i + 1]).contentsChanged(listDataEvent);
        }
    }
}

