/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.list;

import com.jidesoft.grid.IndexChangeEventGenerator;
import com.jidesoft.grid.IndexChangeListener;
import com.jidesoft.grid.IndexChangeListenerHelper;
import com.jidesoft.list.CompoundListDataEvent;
import com.jidesoft.list.EventFireListModel;
import com.jidesoft.list.ListModelWrapper;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.utils.Lm;
import com.jidesoft.utils.Q;
import java.util.EventListener;
import java.util.HashMap;
import javax.swing.AbstractListModel;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class DefaultListModelWrapper<E>
extends AbstractListModel<E>
implements ListModelWrapper<E>,
ListDataListener,
EventFireListModel,
IndexChangeEventGenerator {
    protected ListModel<E> _model;
    private IndexChangeListenerHelper _listener;
    protected int[] _indexes;
    protected transient int[] _adjustingIndexes;
    private ListDataEvent _originalEvent;
    private static final long serialVersionUID = 8123596966340769171L;

    public DefaultListModelWrapper() {
    }

    public DefaultListModelWrapper(ListModel<E> listModel) {
        this.setActualModel(listModel);
    }

    @Override
    public void setActualModel(ListModel<E> listModel) {
        if (listModel == null) {
            throw new IllegalArgumentException("model passed to DefaultListModelWrapper cannot be null");
        }
        if (this._listener == null) {
            this._listener = new IndexChangeListenerHelper(this);
        }
        if (this._model instanceof IndexChangeEventGenerator) {
            ((IndexChangeEventGenerator)((Object)this._model)).removeIndexChangeListener(this._listener);
        }
        if (this.getActualModel() != null) {
            this.getActualModel().removeListDataListener(this);
        }
        this._model = listModel;
        if (this._model instanceof IndexChangeEventGenerator) {
            ((IndexChangeEventGenerator)((Object)this._model)).addIndexChangeListener(this._listener);
        }
        if (this.getActualModel() != null) {
            this.reallocateIndexes();
            this.getActualModel().addListDataListener(this);
        }
    }

    @Override
    public ListModel<E> getActualModel() {
        return this._model;
    }

    @Override
    public int getActualIndexAt(int n) {
        int[] nArray = this.getIndexes();
        if (nArray == null) {
            return n;
        }
        if (n < 0 || n >= nArray.length) {
            return -1;
        }
        return nArray[n];
    }

    @Override
    public int getIndexAt(int n) {
        int[] nArray = this.getIndexes();
        if (nArray == null) {
            return n;
        }
        for (int i = 0; i < nArray.length; ++i) {
            int n2 = nArray[i];
            if (n2 != n) continue;
            return i;
        }
        return -1;
    }

    @Override
    public E getElementAt(int n) {
        int[] nArray = this.getIndexes();
        if (n < 0 || n >= nArray.length) {
            return null;
        }
        int n2 = nArray[n];
        return n2 < 0 || n2 >= this._model.getSize() ? null : (E)this._model.getElementAt(n2);
    }

    @Override
    public int getSize() {
        int[] nArray = this.getIndexes();
        if (nArray == null) {
            return 0;
        }
        return nArray.length;
    }

    public void reallocateIndexes() {
        int n = this._model.getSize();
        this._indexes = new int[n];
        for (int i = 0; i < n; ++i) {
            this._indexes[i] = i;
        }
    }

    @Override
    public int[] getIndexes() {
        return this._adjustingIndexes != null ? this._adjustingIndexes : this._indexes;
    }

    @Override
    public void setIndexes(int[] nArray) {
        this._indexes = nArray;
    }

    protected void fireEvents(int[] nArray, int[] nArray2) {
        this.fireEvents(nArray, nArray2, false);
    }

    void fireEvents(int[] nArray, int[] nArray2, boolean bl) {
        int[] nArray3;
        if (bl) {
            CompoundListDataEvent compoundListDataEvent = this.createCompoundListDataEvent();
            int n = Math.min(nArray.length, nArray2.length);
            if (nArray.length > nArray2.length) {
                compoundListDataEvent.addEvent(new ListDataEvent(this, 2, nArray2.length, nArray.length - 1));
            } else if (nArray.length < nArray2.length) {
                compoundListDataEvent.addEvent(new ListDataEvent(this, 1, nArray.length, nArray2.length - 1));
            }
            if (n > 0) {
                compoundListDataEvent.addEvent(new ListDataEvent(this, 0, 0, n - 1));
            }
            CompoundListDataEvent.fireListDataEvent(this, compoundListDataEvent);
            return;
        }
        if (JideSwingUtilities.equals(nArray, nArray2, true)) {
            return;
        }
        if (nArray.length > 100 || nArray2.length > 100) {
            CompoundListDataEvent compoundListDataEvent = this.createCompoundListDataEvent();
            int n = Math.min(nArray.length, nArray2.length);
            if (nArray.length > nArray2.length) {
                compoundListDataEvent.addEvent(new ListDataEvent(this, 2, nArray2.length, nArray.length - 1));
            } else if (nArray.length < nArray2.length) {
                compoundListDataEvent.addEvent(new ListDataEvent(this, 1, nArray.length, nArray2.length - 1));
            }
            if (n > 0) {
                compoundListDataEvent.addEvent(new ListDataEvent(this, 0, 0, n - 1));
            }
            CompoundListDataEvent.fireListDataEvent(this, compoundListDataEvent);
            return;
        }
        CompoundListDataEvent compoundListDataEvent = this.createCompoundListDataEvent();
        int[] nArray4 = nArray;
        int n = -1;
        for (int i = nArray.length - 1; i >= 0; --i) {
            if (this.getIndexAt(nArray[i]) == -1) {
                if (n != -1) continue;
                n = i;
                continue;
            }
            if (n == -1) continue;
            nArray3 = new int[nArray4.length - (n - i)];
            System.arraycopy(nArray4, 0, nArray3, 0, i + 1);
            if (nArray4.length - n - 1 > 0) {
                System.arraycopy(nArray4, n + 1, nArray3, i + 1, nArray4.length - n - 1);
            }
            this._adjustingIndexes = nArray3;
            compoundListDataEvent.addEvent(new ListDataEvent(this, 2, i + 1, n));
            this._adjustingIndexes = null;
            nArray4 = nArray3;
            n = -1;
        }
        if (n != -1) {
            compoundListDataEvent.addEvent(new ListDataEvent(this, 2, 0, n));
        }
        HashMap<Integer, String> hashMap = new HashMap<Integer, String>();
        nArray3 = nArray;
        int n2 = nArray3.length;
        for (int i = 0; i < n2; ++i) {
            int n3 = nArray3[i];
            hashMap.put(n3, "");
        }
        int n4 = -1;
        for (n2 = 0; n2 < nArray2.length; ++n2) {
            if (hashMap.get(nArray2[n2]) == null) {
                if (n4 != -1) continue;
                n4 = n2;
                continue;
            }
            if (n4 == -1) continue;
            int[] nArray5 = new int[nArray4.length + (n2 - n4)];
            System.arraycopy(nArray2, 0, nArray5, 0, n2);
            System.arraycopy(nArray4, n4, nArray5, n2, nArray4.length - n4);
            this._adjustingIndexes = nArray5;
            compoundListDataEvent.addEvent(new ListDataEvent(this, 1, n4, n2 - 1));
            this._adjustingIndexes = null;
            nArray4 = nArray5;
            n4 = -1;
        }
        if (n4 != -1) {
            compoundListDataEvent.addEvent(new ListDataEvent(this, 1, n4, nArray2.length - 1));
        }
        CompoundListDataEvent.fireListDataEvent(this, compoundListDataEvent);
        hashMap.clear();
    }

    protected CompoundListDataEvent createCompoundListDataEvent() {
        CompoundListDataEvent compoundListDataEvent = new CompoundListDataEvent(this, 0, 0, this.getSize() - 1);
        compoundListDataEvent.setOriginalEvent(this._originalEvent);
        return compoundListDataEvent;
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
        this._originalEvent = listDataEvent;
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
        this._originalEvent = listDataEvent;
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
        this._originalEvent = listDataEvent;
    }

    @Override
    public void fireListDataEvent(ListDataEvent listDataEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != ListDataListener.class) continue;
            if (listDataEvent.getType() == 1) {
                ((ListDataListener)objectArray[i + 1]).intervalAdded(listDataEvent);
                continue;
            }
            if (listDataEvent.getType() == 2) {
                ((ListDataListener)objectArray[i + 1]).intervalRemoved(listDataEvent);
                continue;
            }
            ((ListDataListener)objectArray[i + 1]).contentsChanged(listDataEvent);
        }
    }

    int fireIndexChanging() {
        return this.fireIndexChanging(false);
    }

    int fireIndexChanging(boolean bl) {
        int n = -1;
        if (this._listener != null) {
            return this._listener.fireIndexChangeEvent(this, 0, -1, false, bl);
        }
        return n;
    }

    protected void fireIndexChanged(int n) {
        if (this._listener != null) {
            this._listener.fireIndexChangeEvent(this, 1, n, false, false);
        }
    }

    @Override
    public void addIndexChangeListener(IndexChangeListener indexChangeListener) {
        if (!JideSwingUtilities.isListenerRegistered(this.listenerList, IndexChangeListener.class, (EventListener)indexChangeListener)) {
            this.listenerList.add(IndexChangeListener.class, indexChangeListener);
        }
    }

    @Override
    public void removeIndexChangeListener(IndexChangeListener indexChangeListener) {
        this.listenerList.remove(IndexChangeListener.class, indexChangeListener);
    }

    @Override
    public IndexChangeListener[] getIndexChangeListeners() {
        return (IndexChangeListener[])this.listenerList.getListeners(IndexChangeListener.class);
    }

    static {
        try {
            if (Lm.class.getDeclaredMethods().length != 29 && Lm.class.getDeclaredMethods().length != 31) {
                System.err.println("The Lm class is invalid, exiting ... " + Lm.class.getDeclaredMethods().length);
                System.exit(-1);
            }
        }
        catch (Exception exception) {
            System.exit(-1);
        }
        if (!Q.zz(4)) {
            Lm.showInvalidProductMessage(DefaultListModelWrapper.class.getName(), 4);
        }
    }
}

