/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.list;

import com.jidesoft.grid.TableModelWrapperUtils;
import com.jidesoft.list.ListModelWrapperUtils;
import java.util.EventListener;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class DefaultDisableableListSelectionModel
extends DefaultListSelectionModel {
    protected Set<Integer> _disabledIndices;
    protected DefaultListSelectionModel _delegate;
    private JTable _table;
    private JList _list;

    public DefaultDisableableListSelectionModel(JTable jTable) {
        this();
        this._table = jTable;
    }

    public DefaultDisableableListSelectionModel(JList jList) {
        this();
        this._list = jList;
    }

    public DefaultDisableableListSelectionModel() {
        this.ensureInitialized();
        this._delegate = new DefaultListSelectionModel();
        this._delegate.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                DefaultDisableableListSelectionModel.this.fireValueChanged(listSelectionEvent.getFirstIndex(), listSelectionEvent.getLastIndex(), listSelectionEvent.getValueIsAdjusting());
            }
        });
    }

    private void ensureInitialized() {
        if (this._disabledIndices == null) {
            this._disabledIndices = new TreeSet<Integer>();
        }
    }

    public void setDisabledIndices(int[] nArray) {
        this._disabledIndices.clear();
        if (nArray != null) {
            for (int n : nArray) {
                this._disabledIndices.add(n);
            }
        }
    }

    public void setDisabledSelectionInterval(int n, int n2) {
        this._disabledIndices.clear();
        this.addDisabledSelectionInterval(n, n2);
    }

    public void addDisabledSelectionInterval(int n, int n2) {
        for (int i = n; i <= n2; ++i) {
            this._disabledIndices.add(i);
        }
    }

    public void removeDisabledSelectionInterval(int n, int n2) {
        TreeSet<Integer> treeSet = new TreeSet<Integer>();
        int n3 = 0;
        for (int n4 : this._disabledIndices) {
            if (n3 < n || n2 < n3) {
                treeSet.add(n4);
            }
            ++n3;
        }
        this._disabledIndices = treeSet;
    }

    public void removeDisabledIndexInterval(int n, int n2) {
        for (int i = n; i <= n2; ++i) {
            this._disabledIndices.remove(i);
        }
    }

    public int[] getDisabledIndices() {
        int[] nArray = new int[this._disabledIndices.size()];
        int n = 0;
        Iterator<Integer> iterator = this._disabledIndices.iterator();
        while (iterator.hasNext()) {
            int n2;
            nArray[n] = n2 = iterator.next().intValue();
            ++n;
        }
        return nArray;
    }

    @Override
    public boolean isSelectedIndex(int n) {
        if (this._table != null) {
            int n2 = TableModelWrapperUtils.getActualRowAt(this._table.getModel(), n);
            return this.originalIsSelectedIndex(n) && !this._disabledIndices.contains(n2);
        }
        if (this._list != null) {
            int n3 = ListModelWrapperUtils.getActualIndexAt(this._list.getModel(), n);
            return this.originalIsSelectedIndex(n) && !this._disabledIndices.contains(n3);
        }
        return this.originalIsSelectedIndex(n) && !this._disabledIndices.contains(n);
    }

    @Override
    public boolean isSelectionEmpty() {
        int n = this.originalGetMaxSelectionIndex();
        if (n == -1) {
            return true;
        }
        for (int i = 0; i <= n; ++i) {
            if (!this.isSelectedIndex(i)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int getMinSelectionIndex() {
        int n;
        int n2 = this.originalGetMaxSelectionIndex();
        int n3 = n;
        for (n = this.originalGetMinSelectionIndex(); n < n2 && !this.isSelectedIndex(n); ++n) {
        }
        if (n >= n2) {
            return n3;
        }
        return n;
    }

    @Override
    public int getMaxSelectionIndex() {
        int n;
        int n2 = this.originalGetMinSelectionIndex();
        for (n = this.originalGetMaxSelectionIndex(); n > n2 && !this.isSelectedIndex(n); --n) {
        }
        return n;
    }

    protected int originalGetMinSelectionIndex() {
        return this._delegate.getMinSelectionIndex();
    }

    protected int originalGetMaxSelectionIndex() {
        return this._delegate.getMaxSelectionIndex();
    }

    @Override
    public boolean getValueIsAdjusting() {
        return this._delegate.getValueIsAdjusting();
    }

    @Override
    public int getSelectionMode() {
        return this._delegate.getSelectionMode();
    }

    @Override
    public void setSelectionMode(int n) {
        this._delegate.setSelectionMode(n);
    }

    protected boolean originalIsSelectedIndex(int n) {
        return this._delegate.isSelectedIndex(n);
    }

    protected boolean originalIsSelectionEmpty() {
        return this._delegate.isSelectionEmpty();
    }

    @Override
    public void addListSelectionListener(ListSelectionListener listSelectionListener) {
        this.listenerList.add(ListSelectionListener.class, listSelectionListener);
    }

    @Override
    public void removeListSelectionListener(ListSelectionListener listSelectionListener) {
        this.listenerList.remove(ListSelectionListener.class, listSelectionListener);
    }

    @Override
    public ListSelectionListener[] getListSelectionListeners() {
        return this._delegate.getListSelectionListeners();
    }

    @Override
    public <T extends EventListener> T[] getListeners(Class<T> clazz) {
        return this.listenerList.getListeners(clazz);
    }

    @Override
    public void setLeadAnchorNotificationEnabled(boolean bl) {
        this._delegate.setLeadAnchorNotificationEnabled(bl);
    }

    @Override
    public boolean isLeadAnchorNotificationEnabled() {
        return this._delegate.isLeadAnchorNotificationEnabled();
    }

    @Override
    public void clearSelection() {
        this._delegate.clearSelection();
    }

    @Override
    public void setSelectionInterval(int n, int n2) {
        this._delegate.setSelectionInterval(n, n2);
    }

    @Override
    public void addSelectionInterval(int n, int n2) {
        this._delegate.addSelectionInterval(n, n2);
    }

    @Override
    public void removeSelectionInterval(int n, int n2) {
        this._delegate.removeSelectionInterval(n, n2);
    }

    @Override
    public void insertIndexInterval(int n, int n2, boolean bl) {
        this._delegate.insertIndexInterval(n, n2, bl);
    }

    @Override
    public void removeIndexInterval(int n, int n2) {
        this._delegate.removeIndexInterval(n, n2);
    }

    @Override
    public void setValueIsAdjusting(boolean bl) {
        this._delegate.setValueIsAdjusting(bl);
    }

    @Override
    public String toString() {
        return this._delegate.toString();
    }

    @Override
    public DefaultDisableableListSelectionModel clone() {
        DefaultDisableableListSelectionModel defaultDisableableListSelectionModel = new DefaultDisableableListSelectionModel();
        defaultDisableableListSelectionModel._delegate = this._delegate;
        defaultDisableableListSelectionModel._disabledIndices = this._disabledIndices;
        return defaultDisableableListSelectionModel;
    }

    @Override
    public int getAnchorSelectionIndex() {
        return this._delegate.getAnchorSelectionIndex();
    }

    @Override
    public int getLeadSelectionIndex() {
        return this._delegate.getLeadSelectionIndex();
    }

    @Override
    public void setAnchorSelectionIndex(int n) {
        this._delegate.setAnchorSelectionIndex(n);
    }

    @Override
    public void moveLeadSelectionIndex(int n) {
        this._delegate.moveLeadSelectionIndex(n);
    }

    @Override
    public void setLeadSelectionIndex(int n) {
        this._delegate.setLeadSelectionIndex(n);
    }
}

