/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.list;

import com.jidesoft.list.EventFireListModel;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;

public class CompoundListDataEvent
extends ListDataEvent {
    private static final long serialVersionUID = -7745660047707291321L;
    private List<ListDataEvent> _events;
    private ListDataEvent _originalEvent;
    private boolean _debug;
    private List<StackTraceElement[]> _eventAddedStack;

    public CompoundListDataEvent(Object object, int n, int n2, int n3) {
        super(object, n, n2, n3);
    }

    public void addEvent(ListDataEvent listDataEvent) {
        this.addEvent(-1, listDataEvent);
    }

    public void addEvent(int n, ListDataEvent listDataEvent) {
        if (this._events == null) {
            this._events = new ArrayList<ListDataEvent>();
        }
        if (n < 0 || n >= this._events.size()) {
            this._events.add(listDataEvent);
        } else {
            this._events.add(n, listDataEvent);
        }
        if (this._debug) {
            if (this._eventAddedStack == null) {
                this._eventAddedStack = new ArrayList<StackTraceElement[]>();
            }
            if (n < 0 || n >= this._eventAddedStack.size()) {
                this._eventAddedStack.add(Thread.getAllStackTraces().get(Thread.currentThread()));
            } else {
                this._eventAddedStack.add(n, Thread.getAllStackTraces().get(Thread.currentThread()));
            }
        }
    }

    public void removeEvent(int n) {
        if (this._events == null || n < 0 || n >= this._events.size()) {
            return;
        }
        this._events.remove(n);
        if (this._debug && this._eventAddedStack != null && n >= 0 && n < this._eventAddedStack.size()) {
            this._eventAddedStack.remove(n);
        }
    }

    public ListDataEvent[] getEvents() {
        if (this._events == null) {
            return new ListDataEvent[0];
        }
        return this._events.toArray(new ListDataEvent[this._events.size()]);
    }

    protected String printDebugInfo() {
        StringBuffer stringBuffer = new StringBuffer();
        ListDataEvent[] listDataEventArray = this.getEvents();
        for (int i = 0; i < listDataEventArray.length; ++i) {
            ListDataEvent listDataEvent = listDataEventArray[i];
            stringBuffer.append("ListDataEvent [type=").append(listDataEvent.getType()).append(",index0=").append(listDataEvent.getIndex0()).append(",index1=").append(listDataEvent.getIndex1());
            stringBuffer.append("] at: \r\n");
            if (this._eventAddedStack != null && i < this._eventAddedStack.size()) {
                StackTraceElement[] stackTraceElementArray = this._eventAddedStack.get(i);
                for (int j = 2; j < stackTraceElementArray.length; ++j) {
                    StackTraceElement stackTraceElement = stackTraceElementArray[j];
                    if (stackTraceElement.toString().contains("CompoundListDataEvent")) continue;
                    stringBuffer.append(stackTraceElement).append("\r\n");
                }
            } else {
                stringBuffer.append("Not Recorded. \r\n");
            }
            stringBuffer.append("\r\n");
        }
        return stringBuffer.toString();
    }

    public static void fireListDataEvent(EventFireListModel eventFireListModel, ListDataEvent listDataEvent) {
        if (listDataEvent.getSource() != eventFireListModel) {
            return;
        }
        if (listDataEvent instanceof CompoundListDataEvent) {
            ListDataEvent[] listDataEventArray = ((CompoundListDataEvent)listDataEvent).getEvents();
            if (listDataEventArray != null) {
                ListDataEvent[] listDataEventArray2;
                int n;
                int n2;
                if (listDataEventArray.length <= 0) {
                    return;
                }
                if (listDataEventArray.length == 1) {
                    ListDataEvent listDataEvent2 = listDataEventArray[0];
                    CompoundListDataEvent compoundListDataEvent = new CompoundListDataEvent(eventFireListModel, listDataEvent2.getType(), listDataEvent2.getIndex0(), listDataEvent2.getIndex1());
                    compoundListDataEvent.setOriginalEvent(((CompoundListDataEvent)listDataEvent).getOriginalEvent());
                    eventFireListModel.fireListDataEvent(compoundListDataEvent);
                    return;
                }
                int n3 = Integer.MIN_VALUE;
                for (ListDataEvent listDataEvent3 : listDataEventArray) {
                    n2 = listDataEvent3.getType();
                    if (n3 == Integer.MIN_VALUE) {
                        n3 = n2;
                        continue;
                    }
                    if (n3 == n2) continue;
                    n3 = Integer.MAX_VALUE;
                }
                if (n3 == 1) {
                    int n4 = -1;
                    n = -1;
                    Object object = listDataEventArray;
                    int n5 = ((ListDataEvent[])object).length;
                    for (n2 = 0; n2 < n5; ++n2) {
                        ListDataEvent listDataEvent4 = object[n2];
                        if (listDataEvent4.getType() != n3 || listDataEvent4.getIndex0() < 0 || listDataEvent4.getIndex1() < 0) {
                            n4 = -1;
                            break;
                        }
                        if (n4 == -1 && n == -1) {
                            n4 = listDataEvent4.getIndex0();
                            n = listDataEvent4.getIndex1();
                            continue;
                        }
                        if (listDataEvent4.getIndex0() >= n4 && listDataEvent4.getIndex0() <= n + 1) {
                            n += listDataEvent4.getIndex1() - listDataEvent4.getIndex0() + 1;
                            continue;
                        }
                        n4 = -1;
                        break;
                    }
                    if (n4 >= 0 && n >= n4) {
                        object = new CompoundListDataEvent(eventFireListModel, 1, n4, n);
                        ((CompoundListDataEvent)object).setOriginalEvent(((CompoundListDataEvent)listDataEvent).getOriginalEvent());
                        eventFireListModel.fireListDataEvent((ListDataEvent)object);
                        return;
                    }
                } else if (n3 == 2) {
                    int n6 = -1;
                    n = -1;
                    for (int i = listDataEventArray.length - 1; i >= 0; --i) {
                        ListDataEvent listDataEvent3;
                        listDataEvent3 = listDataEventArray[i];
                        if (listDataEvent3.getType() != n3 || listDataEvent3.getIndex0() < 0 || listDataEvent3.getIndex1() < 0) {
                            n6 = -1;
                            break;
                        }
                        if (n6 == -1 && n == -1) {
                            n6 = listDataEvent3.getIndex0();
                            n = listDataEvent3.getIndex1();
                            continue;
                        }
                        if (listDataEvent3.getIndex0() >= n6 && listDataEvent3.getIndex0() <= n + 1) {
                            n += listDataEvent3.getIndex1() - listDataEvent3.getIndex0() + 1;
                            continue;
                        }
                        n6 = -1;
                        break;
                    }
                    if (n6 >= 0 && n >= n6) {
                        CompoundListDataEvent compoundListDataEvent = new CompoundListDataEvent(eventFireListModel, 2, n6, n);
                        compoundListDataEvent.setOriginalEvent(((CompoundListDataEvent)listDataEvent).getOriginalEvent());
                        eventFireListModel.fireListDataEvent(compoundListDataEvent);
                        return;
                    }
                }
                CompoundListDataEvent compoundListDataEvent = new CompoundListDataEvent(eventFireListModel, 0, 0, ((ListModel)((Object)eventFireListModel)).getSize() - 1);
                compoundListDataEvent.setOriginalEvent(((CompoundListDataEvent)listDataEvent).getOriginalEvent());
                for (ListDataEvent listDataEvent4 : listDataEventArray2 = ((CompoundListDataEvent)listDataEvent).getEvents()) {
                    compoundListDataEvent.addEvent(listDataEvent4);
                }
                eventFireListModel.fireListDataEvent(compoundListDataEvent);
                return;
            }
            if (((CompoundListDataEvent)listDataEvent).isDebug()) {
                System.err.println(((CompoundListDataEvent)listDataEvent).printDebugInfo());
            }
        }
        eventFireListModel.fireListDataEvent(listDataEvent);
    }

    public boolean isOriginalChanged() {
        return this._originalEvent != null;
    }

    public ListDataEvent getOriginalEvent() {
        return this._originalEvent;
    }

    public void setOriginalEvent(ListDataEvent listDataEvent) {
        this._originalEvent = listDataEvent;
    }

    public boolean isDebug() {
        return this._debug;
    }

    public void setDebug(boolean bl) {
        this._debug = bl;
    }
}

