/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.list;

import com.jidesoft.list.ListUndoableSupport;
import com.jidesoft.list.UndoableListDataEvent;
import java.util.Arrays;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEditSupport;

public abstract class AbstractUndoableListModel
extends AbstractListModel
implements ListUndoableSupport {
    private static final long serialVersionUID = 1963154415953823107L;
    private UndoableListDataEvent _event;
    private List<ListDataListener> _listeners;
    private UndoManager _undoManager;
    private UndoableEditSupport _undoableEditSupport;

    @Override
    public void undoableInsertElementAt(Object object, int n) {
        if (this._event != null) {
            this._event.addEdit(n, 1, null, object);
        }
        if (!this.insertElementAtImpl(object, n) && this._event != null) {
            this._event.removeLastEdit();
        }
    }

    @Override
    public void undoableRemoveElementAt(int n) {
        if (this._event != null) {
            this._event.addEdit(n, 2, this.getElementAt(n), null);
        }
        if (!this.removeElementAtImpl(n) && this._event != null) {
            this._event.removeLastEdit();
        }
    }

    @Override
    public void undoableSetElementAt(Object object, int n) {
        if (this._event != null) {
            this._event.addEdit(n, 0, this.getElementAt(n), object);
        }
        if (!this.setElementAtImpl(object, n) && this._event != null) {
            this._event.removeLastEdit();
        }
    }

    @Override
    public UndoManager getUndoManager() {
        if (this._undoManager == null) {
            this._undoManager = new UndoManager();
        }
        return this._undoManager;
    }

    @Override
    public UndoableEditSupport getUndoableEditSupport() {
        if (this._undoableEditSupport == null) {
            this._undoableEditSupport = new UndoableEditSupport();
        }
        return this._undoableEditSupport;
    }

    @Override
    public void beginCompoundEdit(boolean bl) {
        if (this._event == null) {
            this._listeners = Arrays.asList(this.getListDataListeners());
            for (ListDataListener listDataListener : this._listeners) {
                this.removeListDataListener(listDataListener);
            }
            this._event = new UndoableListDataEvent(this, 0, 0, this.getSize() - 1);
            this._event.setUndoRedo(bl);
        }
    }

    @Override
    public void endCompoundEdit() {
        if (this._listeners != null) {
            for (ListDataListener listDataListener : this._listeners) {
                this.addListDataListener(listDataListener);
            }
            this._listeners = null;
        }
        if (this._event != null) {
            UndoableListDataEvent.fireListDataEvent(this, this._event);
            this._event = null;
        }
    }

    @Override
    public void fireListDataEvent(ListDataEvent listDataEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != ListDataListener.class) continue;
            if (listDataEvent.getType() == 1) {
                ((ListDataListener)objectArray[i + 1]).intervalAdded(listDataEvent);
                continue;
            }
            if (listDataEvent.getType() == 2) {
                ((ListDataListener)objectArray[i + 1]).intervalRemoved(listDataEvent);
                continue;
            }
            ((ListDataListener)objectArray[i + 1]).contentsChanged(listDataEvent);
        }
    }

    public abstract boolean insertElementAtImpl(Object var1, int var2);

    public abstract boolean removeElementAtImpl(int var1);

    public abstract boolean setElementAtImpl(Object var1, int var2);
}

