/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.grid;

import com.jidesoft.grid.ContextSensitiveTableSearchable;
import com.jidesoft.grid.IExpandableTreeTableModel;
import com.jidesoft.grid.Row;
import com.jidesoft.grid.TreeTable;
import com.jidesoft.swing.event.SearchableEvent;
import java.util.List;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;

public class TreeTableSearchable
extends ContextSensitiveTableSearchable {
    private boolean _recursive = false;
    private boolean _ignoreTableModelEvent = false;

    public TreeTableSearchable(JTable jTable) {
        super(jTable);
        this.setMainIndex(0);
    }

    public boolean isRecursive() {
        return this._recursive;
    }

    public void setRecursive(boolean bl) {
        this._recursive = bl;
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        if (!this._ignoreTableModelEvent) {
            super.tableChanged(tableModelEvent);
        } else {
            this.fireSearchableEvent(new SearchableEvent(this, 3005));
        }
    }

    @Override
    protected void setSelectedIndex(int n, boolean bl) {
        if (!(this._component instanceof TreeTable)) {
            super.setSelectedIndex(n, bl);
            return;
        }
        TreeTable treeTable = (TreeTable)this._component;
        if (this.isNonContiguousCellSelection() || this.isColumnSelectionAllowed(treeTable) || !this.isRowSelectionAllowed(treeTable)) {
            super.setSelectedIndex(n, bl);
            return;
        }
        if (n != -1) {
            Row row = (Row)this.getElementAt(n);
            this._ignoreTableModelEvent = true;
            treeTable.setSelectedRow(row);
            this._ignoreTableModelEvent = false;
        }
    }

    @Override
    protected int getSelectedIndex() {
        if (!this.isRecursive() || !(this._component instanceof TreeTable)) {
            return super.getSelectedIndex();
        }
        TreeTable treeTable = (TreeTable)this._component;
        if (this.isNonContiguousCellSelection() || this.isColumnSelectionAllowed(treeTable) || !this.isRowSelectionAllowed(treeTable)) {
            return super.getSelectedIndex();
        }
        int n = treeTable.getSelectedRow();
        if (n != -1 && treeTable.getTreeTableModel() instanceof IExpandableTreeTableModel) {
            IExpandableTreeTableModel iExpandableTreeTableModel = (IExpandableTreeTableModel)((Object)treeTable.getTreeTableModel());
            return iExpandableTreeTableModel.getRows(true).indexOf(treeTable.getRowAt(n));
        }
        return n;
    }

    @Override
    protected int getElementCount() {
        if (!(this._component instanceof TreeTable)) {
            return super.getElementCount();
        }
        TreeTable treeTable = (TreeTable)this._component;
        if (this.isNonContiguousCellSelection() || this.isColumnSelectionAllowed(treeTable) || !this.isRowSelectionAllowed(treeTable)) {
            return super.getElementCount();
        }
        if (treeTable.getTreeTableModel() instanceof IExpandableTreeTableModel) {
            IExpandableTreeTableModel iExpandableTreeTableModel = (IExpandableTreeTableModel)((Object)((TreeTable)this._component).getTreeTableModel());
            return iExpandableTreeTableModel.getRows(this.isRecursive()).size();
        }
        return 0;
    }

    @Override
    protected Object getElementAt(int n) {
        if (!(this._component instanceof TreeTable)) {
            return super.getElementAt(n);
        }
        TreeTable treeTable = (TreeTable)this._component;
        if (this.isNonContiguousCellSelection() || this.isColumnSelectionAllowed(treeTable) || !this.isRowSelectionAllowed(treeTable)) {
            return super.getElementAt(n);
        }
        if (treeTable.getTreeTableModel() instanceof IExpandableTreeTableModel) {
            IExpandableTreeTableModel iExpandableTreeTableModel = (IExpandableTreeTableModel)((Object)((TreeTable)this._component).getTreeTableModel());
            List list = iExpandableTreeTableModel.getRows(this.isRecursive());
            if (n >= 0 && n < list.size()) {
                return list.get(n);
            }
        }
        return null;
    }
}

