/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.grid;

import com.jidesoft.converter.ConverterContext;
import com.jidesoft.grid.CellStyle;
import com.jidesoft.grid.CompoundTableModelEvent;
import com.jidesoft.grid.ContextSensitiveTableModel;
import com.jidesoft.grid.EditorContext;
import com.jidesoft.grid.Expandable;
import com.jidesoft.grid.ExpandableRow;
import com.jidesoft.grid.IExpandableTreeTableModel;
import com.jidesoft.grid.IndexChangeEvent;
import com.jidesoft.grid.IndexChangeEventGenerator;
import com.jidesoft.grid.IndexChangeListener;
import com.jidesoft.grid.MultiTableModel;
import com.jidesoft.grid.RootExpandableRow;
import com.jidesoft.grid.Row;
import com.jidesoft.grid.RowCellStyleProvider;
import com.jidesoft.grid.TableModelWrapperUtils;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.utils.CachedVector;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.tree.TreePath;

public abstract class TreeTableModel<T extends Row>
extends AbstractTableModel
implements ContextSensitiveTableModel,
MultiTableModel,
IExpandableTreeTableModel<T>,
IndexChangeEventGenerator {
    private static final long serialVersionUID = 6479508210097994269L;
    private List<T> _rows;
    private ExpandableRow _root;
    private boolean _filterParent = true;
    protected boolean _filtersApplied = false;
    private boolean _autoExpand = false;
    private transient boolean _isAdjusting = false;
    private RowCellStyleProvider _rowCellStyleProvider;

    public TreeTableModel() {
        this.setOriginalRows(new ArrayList());
    }

    public TreeTableModel(List<? extends T> list) {
        this.setOriginalRows(list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOriginalRows(List<? extends T> list) {
        if (list == null) {
            list = new ArrayList<T>();
        }
        for (Row row : list) {
            row.setParent((ExpandableRow)this.getRoot());
        }
        ((ExpandableRow)this.getRoot()).setChildren(list);
        int n = this.fireIndexChanging(true);
        try {
            this._rows = this.buildRows(this.getOriginalRows());
            this.fireTableDataChanged();
        }
        finally {
            this.fireIndexChanged(n);
        }
    }

    protected List<T> buildRows(List<? extends T> list) {
        List<T> list2 = this.createRows();
        if (list != null) {
            for (Row row : list) {
                if (row instanceof ExpandableRow) {
                    this.add(list2, (T)((ExpandableRow)row));
                    continue;
                }
                this.add(list2, row);
            }
        }
        return list2;
    }

    protected List<T> createRows() {
        return new Vector();
    }

    @Override
    public void refresh() {
        this.refresh(true, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void refresh(boolean bl, boolean bl2) {
        if (this.getOriginalRows() != null) {
            if (bl) {
                int n = this.fireIndexChanging(true);
                try {
                    this._rows = this.buildRows(this.getOriginalRows());
                    if (bl2) {
                        CompoundTableModelEvent compoundTableModelEvent = this.createCompoundTableModelEvent();
                        compoundTableModelEvent.addEvent(new TableModelEvent(this));
                        CompoundTableModelEvent.fireTableModelEvent(this, compoundTableModelEvent);
                    }
                    this.fireTableDataChanged();
                }
                finally {
                    this.fireIndexChanged(n);
                }
            } else {
                this._rows = this.buildRows(this.getOriginalRows());
            }
        }
    }

    protected boolean shouldBeFiltered(T t) {
        return false;
    }

    void add(List<T> list, ExpandableRow expandableRow) {
        list.add(expandableRow);
        if (expandableRow.isExpanded() && expandableRow.hasChildren()) {
            int n = this.getChildCount(expandableRow);
            for (int i = 0; i < n; ++i) {
                Row row = (Row)this.getChild(expandableRow, i);
                if (row == null || this.shouldBeFiltered(row)) continue;
                if (row instanceof ExpandableRow) {
                    this.add(list, (T)((ExpandableRow)row));
                    continue;
                }
                this.add(list, row);
            }
        }
    }

    private void add(List<T> list, T t) {
        list.add(t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setChildren(T t, List<? extends T> list) {
        if (!(t instanceof Expandable)) {
            return;
        }
        Expandable expandable = (Expandable)t;
        boolean bl = false;
        int n = this.fireIndexChanging(true);
        try {
            expandable.removeAllChildren();
            int n2 = this.getRowIndex(t);
            bl = false;
            if (expandable.isExpanded()) {
                bl = true;
                int n3 = expandable.getNumberOfVisibleExpandable() - 1;
                expandable.setExpanded(false);
                if (n3 > 0) {
                    this.fireTableRowsDeleted(n2 + 1, n2 + n3);
                }
            }
            expandable.setChildren(list);
        }
        finally {
            this.fireIndexChanged(n);
        }
        if (bl) {
            this.expandRow((ExpandableRow)expandable, true);
        }
    }

    public void addRow(T t, T t2) {
        this.addRow(t, -1, t2);
    }

    public void addRow(T t, int n, T t2) {
        if (!(t instanceof Expandable)) {
            return;
        }
        Expandable expandable = (Expandable)t;
        expandable.addChild(n, t2);
    }

    public void addRow(T t) {
        this.addRow((Row)this.getRoot(), -1, t);
    }

    public void addRow(int n, T t) {
        this.addRow(n, t, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRow(int n, T t, boolean bl) {
        int n2 = this.fireIndexChanging(true);
        try {
            Expandable expandable;
            if (this.getRowCount() == 0) {
                n = 0;
            } else if (n == -1) {
                n = bl ? 0 : this.getRowCount() - 1;
            }
            T t2 = this.getRowAt(n);
            if (t2 == null) {
                expandable = (Expandable)this.getRoot();
            } else {
                expandable = t2.getParent();
                if (expandable == null) {
                    return;
                }
            }
            int n3 = expandable.getChildIndex(t2);
            if (bl) {
                expandable.addChild(n3, t);
            } else {
                expandable.addChild(n3 + 1, t);
            }
        }
        finally {
            this.fireIndexChanged(n2);
        }
    }

    public void addRows(T t, List<? extends T> list) {
        this.addRows(t, -1, list);
    }

    @Override
    public void addRows(T t, int n, List<? extends T> list) {
        if (!(t instanceof Expandable)) {
            return;
        }
        Expandable expandable = (Expandable)t;
        expandable.addChildren(n, list);
    }

    public void addRows(List<? extends T> list) {
        this.addRows((Row)this.getRoot(), -1, list);
    }

    public void addRows(int n, List<? extends T> list) {
        this.addRows(n, list, false);
    }

    public void addRows(int n, List<? extends T> list, boolean bl) {
        Expandable expandable;
        if (this.getRowCount() == 0) {
            n = 0;
        } else if (n == -1) {
            n = bl ? 0 : this.getRowCount() - 1;
        }
        T t = this.getRowAt(n);
        if (t == null) {
            expandable = (Expandable)this.getRoot();
        } else {
            expandable = t.getParent();
            if (expandable == null) {
                return;
            }
        }
        int n2 = expandable.getChildIndex(t);
        if (bl) {
            expandable.addChildren(n2, list);
        } else {
            expandable.addChildren(n2 + 1, list);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRow(T t) {
        int n = this.fireIndexChanging(true);
        try {
            if (t != null && t.getParent() != null) {
                Expandable expandable = t.getParent();
                expandable.removeChild(t);
            }
        }
        finally {
            this.fireIndexChanged(n);
        }
    }

    @Override
    public void removeRow(int n) {
        T t = this.getRowAt(n);
        if (t != null) {
            this.removeRow(t);
        }
    }

    public void moveUpRow(T t) {
        if (t != null && t.getParent() != null) {
            Expandable expandable = t.getParent();
            expandable.moveUpChild(t);
        }
    }

    public void moveDownRow(T t) {
        if (t != null && t.getParent() != null) {
            Expandable expandable = t.getParent();
            expandable.moveDownChild(t);
        }
    }

    public List<T> getRows() {
        if (this._rows == null) {
            throw new IllegalStateException("Please call setOriginalRows(List rows) to populate the data first.");
        }
        return this._rows;
    }

    public boolean isInitialized() {
        return this._rows != null;
    }

    public List<T> getOriginalRows() {
        return ((ExpandableRow)this.getRoot()).getChildren();
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        T t = this.getRowAt(n);
        if (t == null) {
            return;
        }
        t.setValueAt(object, n2);
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        T t = this.getRowAt(n);
        return t != null && t.isCellEditable(n2);
    }

    @Override
    public int getRowCount() {
        if (this._rows != null) {
            return this.getRows().size();
        }
        return 0;
    }

    public int getRowCount(boolean bl) {
        if (!bl) {
            return this.getRowCount();
        }
        int n = 0;
        List<T> list = this.getOriginalRows();
        for (Row row : list) {
            n += this.getRowCount(row);
        }
        return n;
    }

    private int getRowCount(T t) {
        int n = 1;
        if (t instanceof Expandable && ((Expandable)t).hasChildren()) {
            for (int i = 0; i < ((Expandable)t).getChildrenCount(); ++i) {
                Row row = (Row)((Expandable)t).getChildAt(i);
                n += this.getRowCount(row);
            }
        }
        return n;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        T t = this.getRowAt(n);
        if (t == null) {
            return "-";
        }
        return t.getValueAt(n2);
    }

    public T getRowAt(int n) {
        if (n < 0 || n >= this.getRows().size()) {
            return null;
        }
        return (T)((Row)this.getRows().get(n));
    }

    @Override
    public int getRowIndex(T t) {
        if (t == null || this._rows == null) {
            return -1;
        }
        return this.getRows().indexOf(t);
    }

    public void expandTreePath(TreePath treePath) {
        this.expandTreePath(treePath, true);
    }

    private void expandTreePath(TreePath treePath, boolean bl) {
        if (treePath == null) {
            return;
        }
        if (treePath.getParentPath() != null) {
            this.expandTreePath(treePath.getParentPath(), bl);
        }
        if (treePath.getLastPathComponent() instanceof ExpandableRow) {
            this.expandRow((ExpandableRow)treePath.getLastPathComponent(), true, bl);
        }
    }

    protected CompoundTableModelEvent createCompoundTableModelEvent() {
        return new CompoundTableModelEvent(this);
    }

    @Override
    public void expandRow(ExpandableRow expandableRow, boolean bl) {
        this.expandRow(expandableRow, bl, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void expandRow(ExpandableRow expandableRow, boolean bl, boolean bl2) {
        if (!expandableRow.isExpandable()) {
            return;
        }
        int n = this.getRowIndex(expandableRow);
        if (n == -1) {
            expandableRow.setExpanded(bl);
            this.refresh(bl2, false);
            return;
        }
        int n2 = 0;
        if (bl2) {
            n2 = this.fireIndexChanging(true);
        }
        try {
            CompoundTableModelEvent compoundTableModelEvent = this.createCompoundTableModelEvent();
            if (!expandableRow.isExpanded() && bl) {
                expandableRow.setExpanded(true);
                ArrayList arrayList = new ArrayList();
                this.add((List<T>)arrayList, (T)expandableRow);
                int n3 = arrayList.size() - 1;
                if (n3 == 0) {
                    super.fireTableRowsUpdated(n, n);
                    return;
                }
                this.invalidateCache(1, n + 1, arrayList.size());
                for (int i = 1; i < arrayList.size(); ++i) {
                    Row row = (Row)arrayList.get(i);
                    this.getRows().add(n + i, row);
                }
                this.cacheAll(1, n + 1, arrayList.size());
                CompoundTableModelEvent compoundTableModelEvent2 = new CompoundTableModelEvent(this, n + 1, n + n3, -1, 1);
                compoundTableModelEvent.addEvent(compoundTableModelEvent2);
                compoundTableModelEvent.setOriginalEvent(compoundTableModelEvent2);
                arrayList.clear();
            } else if (expandableRow.isExpanded() && !bl) {
                ArrayList arrayList = new ArrayList();
                this.add((List<T>)arrayList, (T)expandableRow);
                int n4 = arrayList.size() - 1;
                expandableRow.setExpanded(false);
                if (n4 == 0) {
                    super.fireTableRowsUpdated(n, n);
                    return;
                }
                this.invalidateCache(-1, n + 1, n4);
                for (int i = 0; i < n4; ++i) {
                    this.getRows().remove(n + 1);
                }
                this.cacheAll(-1, n + 1, n4);
                CompoundTableModelEvent compoundTableModelEvent3 = new CompoundTableModelEvent(this, n + 1, n + n4, -1, -1);
                compoundTableModelEvent.addEvent(compoundTableModelEvent3);
                compoundTableModelEvent.setOriginalEvent(compoundTableModelEvent3);
            }
            compoundTableModelEvent.addEvent(new TableModelEvent(this, n, n, -1, 0));
            if (bl2) {
                CompoundTableModelEvent.fireTableModelEvent(this, compoundTableModelEvent);
            }
        }
        finally {
            if (bl2) {
                this.fireIndexChanged(n2);
            }
        }
    }

    protected void cacheAll(int n, int n2, int n3) {
        if (this.getRows() instanceof CachedVector) {
            ((CachedVector)this.getRows()).cacheAll();
        }
    }

    protected void invalidateCache(int n, int n2, int n3) {
        if (this.getRows() instanceof CachedVector) {
            ((CachedVector)this.getRows()).invalidateCache();
        }
    }

    protected int[] getRowsNeedUpdated(int n, int n2) {
        int n3 = n;
        int n4 = n2;
        for (int i = n; i <= n2; ++i) {
            int n5;
            Row row;
            Object object = this.getRowAt(i);
            int n6 = this.getRowIndex(row);
            for (row = (Row)((Object)object.getParent()); row != null && row != this.getRoot() && n6 != -1; row = (Row)((Object)row.getParent())) {
                object = row;
                n6 = this.getRowIndex(row);
            }
            if (this.getRowIndex(object) < n3) {
                n3 = this.getRowIndex(object);
            }
            if (!(object instanceof Expandable)) continue;
            Object object2 = object = this.getRowAt(i);
            int n7 = this.getRowIndex(object2);
            while (object2 instanceof Expandable && ((Expandable)object2).hasChildren() && n7 != -1 && (n5 = ((Expandable)object2).getChildrenCount()) > 0) {
                object2 = (Row)((Expandable)object2).getChildAt(n5 - 1);
                n7 = this.getRowIndex(object2);
            }
            if (this.getRowIndex(object2) <= n4) continue;
            n4 = this.getRowIndex(object2);
        }
        return new int[]{n3, n4};
    }

    @Override
    public void fireTableRowsUpdated(int n, int n2) {
        int[] nArray = this.getRowsNeedUpdated(n, n2);
        if (nArray != null && nArray.length == 2) {
            int n3 = nArray[0];
            int n4 = nArray[1];
            super.fireTableRowsUpdated(n3, n4);
        }
    }

    @Override
    public void expandAll() {
        this.expandRows(this.getRows(), true);
    }

    @Override
    public void expandFirstLevel() {
        this.expandRows(this.getOriginalRows(), false);
    }

    @Override
    public void expandNextLevel() {
        this.expandRows(this.getRows(), false);
    }

    public void expandRows(List<? extends T> list, boolean bl) {
        this.expandAll(list, bl, true, true);
    }

    private void expandAll(Expandable expandable, boolean bl, boolean bl2) {
        if (expandable != null && expandable.hasChildren()) {
            for (int i = 0; i < expandable.getChildrenCount(); ++i) {
                Row row = (Row)expandable.getChildAt(i);
                if (!(row instanceof Expandable) || !((Expandable)((Object)row)).isExpandable() || !((Expandable)((Object)row)).hasChildren()) continue;
                ((Expandable)((Object)row)).setExpanded(true);
                if (!bl) continue;
                this.expandAll((Expandable)((Object)row), true, false);
            }
            if (bl2) {
                this.refresh(true, true);
            }
        }
    }

    void expandAll(List<? extends T> list, boolean bl, boolean bl2, boolean bl3) {
        if (list != null) {
            for (Row row : list) {
                if (!(row instanceof Expandable) || !((Expandable)((Object)row)).isExpandable() || !((Expandable)((Object)row)).hasChildren()) continue;
                ((Expandable)((Object)row)).setExpanded(true);
                if (!bl) continue;
                this.expandAll((Expandable)((Object)row), true, false);
            }
            if (bl2) {
                this.refresh(bl3, true);
            }
        }
    }

    @Override
    public void collapseAll() {
        this.collapseRows(this.getRows(), true);
    }

    @Override
    public void collapseFirstLevel() {
        this.collapseAll(this.getOriginalRows(), true, false, true);
    }

    @Override
    public void collapseLastLevel() {
        this.collapseRows(this.getRows(), false);
    }

    public void collapseRows(List<? extends T> list, boolean bl) {
        this.collapseAll(list, false, bl, true);
    }

    private void collapseAll(Expandable expandable, boolean bl, boolean bl2) {
        for (int i = 0; i < expandable.getChildrenCount(); ++i) {
            Row row = (Row)expandable.getChildAt(i);
            if (!(row instanceof Expandable) || !((Expandable)((Object)row)).isExpandable() || !((Expandable)((Object)row)).hasChildren()) continue;
            ((Expandable)((Object)row)).setExpanded(false);
            if (!bl) continue;
            this.collapseAll((Expandable)((Object)row), false, false);
        }
        if (bl2) {
            this.refresh(true, true);
        }
    }

    void collapseAll(List<? extends T> list, boolean bl, boolean bl2, boolean bl3) {
        for (Row row : list) {
            if (!(row instanceof Expandable) || !((Expandable)((Object)row)).isExpandable() || !((Expandable)((Object)row)).hasChildren()) continue;
            if (bl || bl2 || !this.hasExpandedChildren(row)) {
                ((Expandable)((Object)row)).setExpanded(false);
            }
            if (!bl2) continue;
            this.collapseAll((Expandable)((Object)row), false, false);
        }
        if (bl3) {
            this.refresh(true, true);
        }
    }

    private boolean hasExpandedChildren(Object object) {
        int n = this.getChildCount(object);
        for (int i = 0; i < n; ++i) {
            Object object2 = this.getChild(object, i);
            if (!(object2 instanceof Expandable) || !((Expandable)object2).isExpanded()) continue;
            return true;
        }
        return false;
    }

    @Override
    public ConverterContext getConverterContextAt(int n, int n2) {
        T t = this.getRowAt(n);
        if (t != null) {
            return t.getConverterContextAt(n2);
        }
        return null;
    }

    @Override
    public EditorContext getEditorContextAt(int n, int n2) {
        T t = this.getRowAt(n);
        if (t != null) {
            return t.getEditorContextAt(n2);
        }
        return null;
    }

    @Override
    public Class<?> getCellClassAt(int n, int n2) {
        Class<?> clazz;
        T t = this.getRowAt(n);
        if (t != null && (clazz = t.getCellClassAt(n2)) != null) {
            return clazz;
        }
        return this.getColumnClass(n2);
    }

    @Override
    public Object getRoot() {
        if (this._root == null) {
            this._root = this.createRoot();
        }
        return this._root;
    }

    protected ExpandableRow createRoot() {
        return new RootExpandableRow(this);
    }

    @Override
    public Object getChild(Object object, int n) {
        if (object instanceof Expandable) {
            return ((Expandable)object).getChildAt(n);
        }
        return null;
    }

    @Override
    public int getChildCount(Object object) {
        if (object instanceof Expandable) {
            return ((Expandable)object).getChildrenCount();
        }
        return 0;
    }

    public int getIndexOfChild(Object object, Object object2) {
        if (object instanceof Expandable) {
            return ((Expandable)object).getChildIndex(object2);
        }
        return 0;
    }

    public boolean isLeaf(Object object) {
        return !(object instanceof Expandable);
    }

    public boolean isFilterParent() {
        return this._filterParent;
    }

    public void setFilterParent(boolean bl) {
        this._filterParent = bl;
    }

    public void setFiltersApplied(boolean bl) {
        this._filtersApplied = bl;
        this.refresh();
    }

    public boolean isFiltersApplied() {
        return this._filtersApplied;
    }

    public boolean isAutoExpand() {
        return this._autoExpand;
    }

    public boolean isAutoExpand(Expandable expandable) {
        return this.isAutoExpand();
    }

    public void setAutoExpand(boolean bl) {
        this._autoExpand = bl;
    }

    @Override
    public int getColumnType(int n) {
        return 0;
    }

    @Override
    public int getTableIndex(int n) {
        return 0;
    }

    @Override
    public List<T> getRows(boolean bl) {
        if (!bl) {
            return this.getRows();
        }
        ArrayList arrayList = new ArrayList();
        List<T> list = this.getOriginalRows();
        for (Row row : list) {
            this.addRecursively(arrayList, row);
        }
        return arrayList;
    }

    private void addRecursively(List<T> list, T t) {
        list.add(t);
        if (t instanceof Expandable && ((Expandable)t).hasChildren()) {
            for (int i = 0; i < ((Expandable)t).getChildrenCount(); ++i) {
                Row row = (Row)((Expandable)t).getChildAt(i);
                this.addRecursively(list, row);
            }
        }
    }

    @Override
    public boolean isAdjusting() {
        return this._isAdjusting;
    }

    public void setAdjusting(boolean bl) {
        this._isAdjusting = bl;
    }

    protected CellStyle getCellStyleFromRowCellStyleProvider(int n, int n2) {
        CellStyle cellStyle;
        T t;
        RowCellStyleProvider rowCellStyleProvider = this.getRowCellStyleProvider();
        if (rowCellStyleProvider != null && (t = this.getRowAt(n)) != null && (cellStyle = rowCellStyleProvider.getRowCellStyleAt((Row)t, n, n2)) != null) {
            return cellStyle;
        }
        return null;
    }

    public RowCellStyleProvider getRowCellStyleProvider() {
        return this._rowCellStyleProvider;
    }

    public void setRowCellStyleProvider(RowCellStyleProvider rowCellStyleProvider) {
        this._rowCellStyleProvider = rowCellStyleProvider;
    }

    @Override
    public Map<Object, Boolean> getExpansionState() {
        HashMap<Object, Boolean> hashMap = new HashMap<Object, Boolean>();
        List<T> list = this.getRows();
        HashMap<Expandable, Object> hashMap2 = new HashMap<Expandable, Object>();
        int n = 0;
        while (n < list.size()) {
            Row row;
            Row row2 = row = (Row)list.get(n);
            Object object = (PathList)hashMap2.get(row.getParent());
            object = object == null ? new PathList() : ((PathList)object).clone();
            if (row instanceof Expandable && ((Expandable)((Object)row2)).isExpanded()) {
                int n2;
                ((ArrayList)object).add((Expandable)((Object)row2));
                hashMap2.put((Expandable)((Object)row2), ((PathList)object).clone());
                while (((Expandable)((Object)row2)).isExpanded()) {
                    int n3;
                    n2 = ((Expandable)((Object)row2)).getChildrenCount();
                    for (n3 = 0; n3 < n2; ++n3) {
                        Row row3 = (Row)((Expandable)((Object)row2)).getChildAt(n3);
                        if (!(row3 instanceof Expandable) || !((Expandable)((Object)row3)).isExpanded()) continue;
                        ((ArrayList)object).add((Expandable)((Object)row3));
                        hashMap2.put((Expandable)((Object)row3), ((PathList)object).clone());
                        row2 = row3;
                        break;
                    }
                    if (n3 < n2) continue;
                    break;
                }
                if (((Expandable)((Object)row2)).isExpanded()) {
                    TreePath treePath = ((ArrayList)object).size() <= 1 ? new TreePath(row2) : new TreePath(((ArrayList)object).toArray());
                    hashMap.put(treePath, true);
                }
                n = (n2 = this.getRowIndex(row2) + TableModelWrapperUtils.getVisibleChildrenCount(this, row2)) <= n ? n + 1 : n2;
                continue;
            }
            ++n;
        }
        hashMap2.clear();
        return hashMap;
    }

    @Override
    public void setExpansionState(Map<Object, Boolean> map) {
        if (map == null) {
            return;
        }
        CompoundTableModelEvent compoundTableModelEvent = this.createCompoundTableModelEvent();
        this.collapseAll(this.getRows(), false, true, false);
        this._rows = this.buildRows(this.getOriginalRows());
        compoundTableModelEvent.addEvent(new TableModelEvent(this));
        Set<Object> set = map.keySet();
        for (Object object : set) {
            this.expandTreePath((TreePath)object, false);
        }
        CompoundTableModelEvent.fireTableModelEvent(this, compoundTableModelEvent);
    }

    @Override
    public void addIndexChangeListener(IndexChangeListener indexChangeListener) {
        if (!JideSwingUtilities.isListenerRegistered(this.listenerList, IndexChangeListener.class, (EventListener)indexChangeListener)) {
            this.listenerList.add(IndexChangeListener.class, indexChangeListener);
        }
    }

    @Override
    public void removeIndexChangeListener(IndexChangeListener indexChangeListener) {
        this.listenerList.remove(IndexChangeListener.class, indexChangeListener);
    }

    protected int fireIndexChanging(boolean bl) {
        IndexChangeListener[] indexChangeListenerArray = (IndexChangeListener[])this.getListeners(IndexChangeListener.class);
        int n = Double.valueOf(Math.random() * 10000.0).intValue();
        for (IndexChangeListener indexChangeListener : indexChangeListenerArray) {
            indexChangeListener.indexChanged(new IndexChangeEvent(this, 0, n, false, bl));
        }
        return n;
    }

    protected void fireIndexChanged(int n) {
        IndexChangeListener[] indexChangeListenerArray;
        for (IndexChangeListener indexChangeListener : indexChangeListenerArray = (IndexChangeListener[])this.getListeners(IndexChangeListener.class)) {
            indexChangeListener.indexChanged(new IndexChangeEvent(this, 1, n, false, false));
        }
    }

    @Override
    public IndexChangeListener[] getIndexChangeListeners() {
        return new IndexChangeListener[0];
    }

    private class PathList<T>
    extends ArrayList<T>
    implements Cloneable {
        private static final long serialVersionUID = -2536239523993040525L;

        private PathList() {
        }

        @Override
        public PathList<T> clone() {
            super.clone();
            PathList<T> pathList = new PathList<T>();
            for (int i = 0; i < this.size(); ++i) {
                pathList.add(this.get(i));
            }
            return pathList;
        }
    }
}

