/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.grid;

import com.jidesoft.grid.CategorizedTable;
import com.jidesoft.grid.CellRendererPaneEx;
import com.jidesoft.grid.Expandable;
import com.jidesoft.grid.ExpandableCell;
import com.jidesoft.grid.ExpandableRow;
import com.jidesoft.grid.FilterableTreeTableModel;
import com.jidesoft.grid.IExpandableTreeTableModel;
import com.jidesoft.grid.Node;
import com.jidesoft.grid.RootExpandableRow;
import com.jidesoft.grid.Row;
import com.jidesoft.grid.TableModelWrapperUtils;
import com.jidesoft.grid.TreeTable;
import com.jidesoft.grid.TreeTableCellRenderer;
import com.jidesoft.grid.TreeTableUtils;
import com.jidesoft.jdk.JdkSpecificClass;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.swing.JideSwingUtilities;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.plaf.UIResource;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;

public class TreeExpandablePanel
extends CellRendererPaneEx {
    public static final int TEXT_ICON_GAP = 0;
    public static final int LEFT_MARGIN = 16;
    public static final int CELL_HEIGHT = 16;
    protected ExpandableCell _expandableCell;
    protected Node _node;
    protected JTable _table;
    protected Icon _expandedIcon;
    protected Icon _collapsedIcon;
    protected Color _disabledForeground;
    protected Color _disabledBackground;
    protected boolean _paintLines;
    protected boolean _showRootHandles;
    protected boolean _respectRendererPreferredSize;
    protected boolean _paintLeafNodeLines;
    protected boolean _lineTypeDashed;
    protected Color _lineColor;
    protected int _indent;
    protected boolean _isSelected;
    protected boolean _hasFocus;
    private int _columnWidth;
    private final int TOP = 1;
    private final int BOTTOM = 2;
    private final int RIGHT = 4;
    private static final BasicStroke DOTTED_STROKE = new BasicStroke(1.0f, 2, 1, 1.0f, new float[]{0.0f, 2.0f, 0.0f, 2.0f}, 1.0f);
    private static final BasicStroke DOTTED_STROKE_HORIZONTAL = new BasicStroke(1.0f, 2, 1, 1.0f, new float[]{0.0f, 2.0f, 0.0f, 2.0f}, 0.0f);

    public TreeExpandablePanel(JTable jTable) {
        this._table = jTable;
        this.initComponents();
    }

    @Deprecated
    public TreeExpandablePanel(JTable jTable, Icon icon, Icon icon2, Color color, Color color2) {
        this._table = jTable;
        this._expandedIcon = icon;
        this._collapsedIcon = icon2;
        this._disabledBackground = color;
        this._disabledForeground = color2;
        this.initComponents();
    }

    protected void initComponents() {
        this._lineTypeDashed = UIDefaultsLookup.getBoolean("Tree.lineTypeDashed");
        this.applyComponentOrientation(this._table.getComponentOrientation());
    }

    @Override
    public void setEnabled(boolean bl) {
        TableCellRenderer tableCellRenderer;
        TableCellRenderer tableCellRenderer2;
        super.setEnabled(bl);
        if (this._table instanceof TreeTable && this._table.getRowCount() > 0 && (tableCellRenderer2 = this._table.getCellRenderer(0, ((TreeTable)this._table).getExpandableColumnViewIndex())) instanceof TreeTableCellRenderer && (tableCellRenderer = ((TreeTableCellRenderer)tableCellRenderer2).getActualCellRenderer()) instanceof JComponent) {
            ((JComponent)((Object)tableCellRenderer)).setEnabled(bl);
        }
    }

    public void setExpandableCell(ExpandableCell expandableCell) {
        this._expandableCell = expandableCell;
        this._node = expandableCell;
    }

    public void setNode(Node node) {
        this._node = node;
    }

    private int getLeftMargin() {
        return this._table instanceof TreeTable ? ((TreeTable)this._table).getLeftMargin() : 16;
    }

    @Override
    public void paint(Graphics graphics) {
        Object object;
        int n;
        super.paint(graphics);
        this._lineTypeDashed = UIDefaultsLookup.getBoolean("Tree.lineTypeDashed");
        IExpandableTreeTableModel iExpandableTreeTableModel = null;
        TableModel tableModel = null;
        if (this._table instanceof TreeTable) {
            this._lineColor = ((TreeTable)this._table).getTreeLineColor();
            this._paintLines = ((TreeTable)this._table).isShowTreeLines();
            this._paintLeafNodeLines = ((TreeTable)this._table).isShowLeafNodeTreeLines();
            this._showRootHandles = ((TreeTable)this._table).getShowsRootHandles();
            this._respectRendererPreferredSize = ((TreeTable)this._table).isRespectRenderPreferredHeight();
            n = ((TreeTable)this._table).getIndent();
            tableModel = this._table.getModel();
            iExpandableTreeTableModel = (IExpandableTreeTableModel)((Object)((TreeTable)this._table).getTreeTableModel());
        } else {
            n = this.getLeftMargin();
        }
        boolean bl = this._table.getComponentOrientation().isLeftToRight();
        int n2 = this._node.getLevel() * n;
        int n3 = -1;
        if (this._table instanceof TreeTable) {
            n3 = ((TreeTable)this._table).getHorizontalLegPosition(this.getHeight());
        }
        if (n3 == -1) {
            n3 = this.getHeight() / 2;
        }
        Rectangle rectangle = null;
        if (this._actualRenderer != null && this._actualRenderer.isOpaque() && Boolean.TRUE.equals(this._table.getClientProperty("TreeTable.doNotPaintCellContentBackground"))) {
            object = (Graphics2D)graphics.create();
            rectangle = this.paintCellContent((Graphics)object, n, bl, n2, n3);
            Rectangle rectangle2 = new Rectangle(0, 0, this.getWidth(), this.getHeight());
            Rectangle rectangle3 = ((Graphics)object).getClipBounds();
            Rectangle rectangle4 = new Rectangle(rectangle3);
            ((Graphics)object).setClip(SwingUtilities.computeIntersection(rectangle2.x, rectangle2.y, rectangle2.width, rectangle.y - rectangle2.y, rectangle3));
            this.paintBackground((Graphics)object);
            rectangle3 = (Rectangle)rectangle4.clone();
            ((Graphics)object).setClip(SwingUtilities.computeIntersection(rectangle2.x, rectangle.y + rectangle.height, rectangle2.width, rectangle2.height - rectangle.y - rectangle.height, rectangle3));
            this.paintBackground((Graphics)object);
            rectangle3 = (Rectangle)rectangle4.clone();
            ((Graphics)object).setClip(SwingUtilities.computeIntersection(rectangle2.x, rectangle.y, rectangle.x - rectangle2.x, rectangle.height, rectangle3));
            this.paintBackground((Graphics)object);
            rectangle3 = (Rectangle)rectangle4.clone();
            ((Graphics)object).setClip(SwingUtilities.computeIntersection(rectangle.x + rectangle.width, rectangle.y, rectangle2.width - rectangle.width - rectangle.x, rectangle.height, rectangle3));
            this.paintBackground((Graphics)object);
            ((Graphics)object).dispose();
        } else {
            this.paintBackground(graphics);
            this.paintCellContent(graphics, n, bl, n2, n3);
        }
        this.paintFocus(graphics);
        object = this._table.getClientProperty("TreeTable.paintTreeLineOnTreeTable");
        if (!(this._table instanceof TreeTable) || object instanceof Boolean && !((Boolean)object).booleanValue()) {
            this.paintIconAndLines(graphics, iExpandableTreeTableModel, tableModel, n, bl, n2, n3, rectangle);
        }
    }

    private void paintIconAndLines(Graphics graphics, IExpandableTreeTableModel iExpandableTreeTableModel, TableModel tableModel, int n, boolean bl, int n2, int n3, Rectangle rectangle) {
        int n4;
        int n5;
        Object object;
        Icon icon = null;
        boolean bl2 = this.isExpandIconVisible(this._table);
        int n6 = 0;
        int n7 = 0;
        if (bl2 && this._node instanceof Expandable && ((Expandable)this._node).hasChildren() && (this._showRootHandles || this._node.getLevel() > 0)) {
            icon = ((Expandable)this._node).isExpanded() && ((Expandable)this._node).getChildrenCount() > 0 ? (this._table instanceof TreeTable && this._node instanceof Row ? ((CategorizedTable)this._table).getExpandedIcon(((TreeTable)this._table).getRowIndex((Row)this._node)) : ((CategorizedTable)this._table).getExpandedIcon()) : (!((Expandable)this._node).isExpanded() ? (this._table instanceof TreeTable && this._node instanceof Row ? ((CategorizedTable)this._table).getCollapsedIcon(((TreeTable)this._table).getRowIndex((Row)this._node)) : ((CategorizedTable)this._table).getCollapsedIcon()) : null);
            if (icon != null) {
                object = this._table.getModel();
                while (object != null && this._node instanceof Row) {
                    if (!((object = TableModelWrapperUtils.getActualTableModel((TableModel)object, FilterableTreeTableModel.class)) instanceof FilterableTreeTableModel)) continue;
                    if (!((FilterableTreeTableModel)object).isKeepAllChildren() && ((FilterableTreeTableModel)object).hasFilter() && ((FilterableTreeTableModel)object).isFiltersApplied()) {
                        if (TreeTableUtils.hasDescendant((TableModel)object, (Row)this._node, false, true)) break;
                        icon = null;
                        break;
                    }
                    object = ((FilterableTreeTableModel)object).getActualModel();
                }
            }
            if (icon != null) {
                n6 = icon.getIconWidth();
                n7 = icon.getIconHeight();
            }
        }
        if (this._paintLines && (this._showRootHandles || this._node.getLevel() > 0)) {
            object = this._node.getParent();
            for (n5 = this._node.getLevel() - 1; n5 >= 0; --n5) {
                if (object.getParent() == null) continue;
                if (this.hasNextSibling((Row)object, iExpandableTreeTableModel, tableModel)) {
                    n4 = this._showRootHandles ? n5 * n + this.getLeftMargin() / 2 - 1 : n5 * n - this.getLeftMargin() / 2 - 1;
                    this.paintLine(graphics, new Point(bl ? n4 : this.getWidth() - n4, n3 + (rectangle != null ? rectangle.height / 2 : 0)), 3, this.getWidth(), this.getHeight(), n, bl, 0, 0);
                }
                object = object.getParent();
            }
            if (this._node instanceof Expandable && ((Expandable)this._node).hasChildren() && ((Expandable)this._node).isExpanded()) {
                n5 = this._node.getLevel() + 1;
                n4 = this._showRootHandles ? n5 * n + this.getLeftMargin() / 2 - 1 : n5 * n - this.getLeftMargin() / 2 - 1;
                this.paintLine(graphics, new Point(bl ? n4 : this.getWidth() - n4, n3 + (rectangle != null ? rectangle.height / 2 : 0)), 2, this.getWidth(), this.getHeight(), n, bl, n6, n7);
            }
            n5 = 0;
            if (this._node instanceof Expandable || this._paintLeafNodeLines) {
                if (this._node instanceof Expandable && ((Expandable)this._node).hasChildren() || this._paintLeafNodeLines || !this.hasNextSibling((Row)this._node, iExpandableTreeTableModel, tableModel)) {
                    n5 |= 4;
                }
                if (this._node.getParent() != null) {
                    if (this.hasPrevSibling((Row)this._node, iExpandableTreeTableModel, tableModel) || !(this._node.getParent() instanceof RootExpandableRow)) {
                        n5 |= 1;
                    }
                    if (this.hasNextSibling((Row)this._node, iExpandableTreeTableModel, tableModel)) {
                        n5 |= 2;
                    }
                }
            }
            n4 = this._showRootHandles ? n2 + this.getLeftMargin() / 2 - 1 : n2 - this.getLeftMargin() / 2 - 1;
            this.paintLine(graphics, new Point(bl ? n4 : this.getWidth() - n4, n3), n5, this.getWidth(), this.getHeight(), this.getLeftMargin(), bl, n6, n7);
        }
        if (icon != null) {
            int n8 = this._showRootHandles ? n2 + (this.getLeftMargin() - icon.getIconWidth()) / 2 : n2 - (icon.getIconWidth() + this.getLeftMargin()) / 2;
            n5 = bl ? n8 : this.getWidth() - n2 - icon.getIconWidth() - (this.getLeftMargin() - icon.getIconWidth()) / 2;
            n4 = -(this.getHeight() + 1) % 2;
            int n9 = n3 - icon.getIconHeight() / 2 + n4;
            if (JdkSpecificClass.isSynthIcon(icon)) {
                JdkSpecificClass.paintTableCellIcon(this._table, icon, graphics, n5, n9);
            } else {
                icon.paintIcon(this, graphics, n5, n9);
            }
        }
    }

    private Rectangle paintCellContent(Graphics graphics, int n, boolean bl, int n2, int n3) {
        int n4;
        int n5 = this._showRootHandles ? n2 + this.getLeftMargin() : n2;
        int n6 = this.getWidth() - n5;
        if (this._actualRenderer != null) {
            Rectangle rectangle;
            if (this._table instanceof TreeTable && this._node instanceof Row) {
                int n7 = n - ((TreeTable)this._table).getIndent((Row)this._node);
                n5 -= n7;
                n6 += n7;
            }
            this._actualRenderer.applyComponentOrientation(this._table.getComponentOrientation());
            Rectangle rectangle2 = rectangle = bl ? new Rectangle(n5, 0, n6, this.getHeight()) : new Rectangle(0, 0, n6, this.getHeight());
            if (this._respectRendererPreferredSize) {
                int n8 = Math.min(this._actualRenderer.getPreferredSize().height, rectangle.height);
                rectangle.y = Math.max(0, n3 - n8 / 2);
                rectangle.height = n8;
            }
            this.paintComponent(graphics, this._actualRenderer, this._table, rectangle.x, rectangle.y, rectangle.width, rectangle.height, true);
            return rectangle;
        }
        graphics.setFont(this._table.getFont());
        if (this.isSelected()) {
            graphics.setColor(this._table.getSelectionForeground());
        } else if (this._expandableCell != null && this._expandableCell.isEditable()) {
            graphics.setColor(this._table.getForeground());
        } else {
            graphics.setColor(((CategorizedTable)this._table).getDisabledForeground());
        }
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n9 = (this.getHeight() - fontMetrics.getHeight()) / 2 + fontMetrics.getAscent() + 1;
        String string = this._expandableCell == null ? "" : this._expandableCell.toString();
        int n10 = SwingUtilities.computeStringWidth(fontMetrics, string);
        if (n10 > n6) {
            int n11;
            String string2 = "...";
            n4 = SwingUtilities.computeStringWidth(fontMetrics, string2);
            for (n11 = 0; n11 < string.length() && (n4 += fontMetrics.charWidth(string.charAt(n11))) <= n6; ++n11) {
            }
            string = string.substring(0, n11) + string2;
            n10 = SwingUtilities.computeStringWidth(fontMetrics, string);
        }
        int n12 = n2 + n + 0;
        if (this._table instanceof TreeTable && this._node instanceof Row) {
            n4 = n - ((TreeTable)this._table).getIndent((Row)this._node);
            n12 -= n4;
        }
        JideSwingUtilities.drawString(this._table, graphics, string, bl ? n12 : this.getWidth() - n12 - n10, n9);
        return null;
    }

    private boolean hasNextSibling(Row row, IExpandableTreeTableModel iExpandableTreeTableModel, TableModel tableModel) {
        if (tableModel == iExpandableTreeTableModel) {
            return row.getNextSibling() != null;
        }
        boolean bl = true;
        ExpandableRow expandableRow = (ExpandableRow)row.getParent();
        int n = expandableRow.getChildrenCount();
        int n2 = iExpandableTreeTableModel.getRowIndex(row);
        int n3 = TableModelWrapperUtils.getRowAt(tableModel, (TableModel)((Object)iExpandableTreeTableModel), n2);
        for (int i = n - 1; i >= 0; --i) {
            int n4;
            int n5;
            Row row2 = (Row)expandableRow.getChildAt(i);
            if (row2 == row || (n5 = TableModelWrapperUtils.getRowAt(tableModel, (TableModel)((Object)iExpandableTreeTableModel), n4 = iExpandableTreeTableModel.getRowIndex(row2))) < 0 || n5 <= n3) continue;
            bl = false;
            break;
        }
        return !bl;
    }

    private boolean hasPrevSibling(Row row, IExpandableTreeTableModel iExpandableTreeTableModel, TableModel tableModel) {
        if (tableModel == iExpandableTreeTableModel) {
            return row.getPreviousSibling() != null;
        }
        boolean bl = true;
        ExpandableRow expandableRow = (ExpandableRow)row.getParent();
        int n = expandableRow.getChildrenCount();
        int n2 = iExpandableTreeTableModel.getRowIndex(row);
        int n3 = TableModelWrapperUtils.getRowAt(tableModel, (TableModel)((Object)iExpandableTreeTableModel), n2);
        for (int i = 0; i < n; ++i) {
            int n4;
            int n5;
            Row row2 = (Row)expandableRow.getChildAt(i);
            if (row2 == row || (n5 = TableModelWrapperUtils.getRowAt(tableModel, (TableModel)((Object)iExpandableTreeTableModel), n4 = iExpandableTreeTableModel.getRowIndex(row2))) < 0 || n5 >= n3) continue;
            bl = false;
            break;
        }
        return !bl;
    }

    protected void paintFocus(Graphics graphics) {
        Color color = super.getBackground();
        if (this.isSelected()) {
            super.setBackground(this._table.getSelectionBackground());
        } else {
            super.setBackground(color);
        }
        if (this.isHasFocus()) {
            Border border = UIDefaultsLookup.getBorder(this.isSelected() ? "Table.focusSelectedCellHighlightBorder" : "Table.focusCellHighlightBorder");
            if (border == null) {
                border = UIDefaultsLookup.getBorder("Table.focusCellHighlightBorder");
            }
            if (border != null) {
                try {
                    border.paintBorder(this, graphics, 0, 0, this.getWidth(), this.getHeight());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        super.setBackground(color);
    }

    protected void paintBackground(Graphics graphics) {
        if (this.isPaintBackground()) {
            if (this._actualRenderer != null && this._actualRenderer.isOpaque() && !(this._actualRenderer.getBackground() instanceof UIResource)) {
                graphics.setColor(this._actualRenderer.getBackground());
            } else {
                graphics.setColor(this.getBackground());
            }
            graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
    }

    public boolean isSelected() {
        return this._isSelected;
    }

    public void setSelected(boolean bl) {
        this._isSelected = bl;
    }

    public boolean isHasFocus() {
        return this._hasFocus;
    }

    public void setHasFocus(boolean bl) {
        this._hasFocus = bl;
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(0, 0);
    }

    public int getColumnWidth() {
        return this._columnWidth;
    }

    public void setColumnWidth(int n) {
        this._columnWidth = n;
    }

    @Override
    public Dimension getPreferredSize() {
        int n = (this._node == null ? 0 : this._node.getLevel()) * this.getLeftMargin() + this.getLeftMargin() + 0 + 1;
        if (this._actualRenderer != null) {
            Dimension dimension = this._actualRenderer.getPreferredSize();
            this._actualRenderer.setSize(this.getColumnWidth() - n, dimension.height);
            dimension = this._actualRenderer.getPreferredSize();
            dimension.width += n;
            return dimension;
        }
        FontMetrics fontMetrics = this.getFontMetrics(this._table.getFont());
        String string = this._expandableCell.toString();
        int n2 = SwingUtilities.computeStringWidth(fontMetrics, string);
        return new Dimension(n2 + n, fontMetrics.getHeight() + 2);
    }

    void paintLine(Graphics graphics, Point point, int n, int n2, int n3, int n4, boolean bl, int n5, int n6) {
        Color color = graphics.getColor();
        graphics.setColor(this._lineColor);
        Stroke stroke = ((Graphics2D)graphics).getStroke();
        int n7 = -(n3 + 1) % 2;
        if (this._lineTypeDashed) {
            ((Graphics2D)graphics).setStroke(DOTTED_STROKE);
        }
        if ((n & 1) != 0) {
            graphics.drawLine(point.x, point.y - n6 / 2 + n7, point.x, 0);
        }
        if ((n & 2) != 0) {
            graphics.drawLine(point.x, point.y + n6 / 2, point.x, n3);
        }
        if (this._lineTypeDashed) {
            ((Graphics2D)graphics).setStroke(DOTTED_STROKE_HORIZONTAL);
        }
        if ((n & 4) != 0) {
            if (bl) {
                graphics.drawLine(point.x + n5 / 2, point.y + n7, point.x + n4 / 2, point.y + n7);
            } else {
                graphics.drawLine(point.x - n5 / 2 - 1, point.y + n7, point.x - n4 / 2 - 1, point.y + n7);
            }
        }
        if (this._lineTypeDashed) {
            ((Graphics2D)graphics).setStroke(stroke);
        }
        graphics.setColor(color);
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        if (this._actualRenderer != null) {
            this._actualRenderer.setFont(font);
        }
    }

    @Override
    public String getToolTipText(MouseEvent mouseEvent) {
        if (this._actualRenderer instanceof JComponent) {
            return ((JComponent)this._actualRenderer).getToolTipText(mouseEvent);
        }
        return "";
    }

    public boolean isExpandIconVisible(JTable jTable) {
        return !(jTable instanceof CategorizedTable) || ((CategorizedTable)jTable).isExpandIconVisible();
    }
}

