/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.grid;

import com.jidesoft.converter.ObjectConverterManager;
import com.jidesoft.filter.Filter;
import com.jidesoft.filter.RegexFilter;
import com.jidesoft.filter.WildcardFilter;
import com.jidesoft.grid.FilterableTableModel;
import com.jidesoft.grid.FilterableTreeTableModel;
import com.jidesoft.grid.IExpandableTreeTableModel;
import com.jidesoft.grid.ShrinkSearchableSupport;
import com.jidesoft.grid.TableModelWrapperUtils;
import com.jidesoft.swing.Searchable;
import com.jidesoft.swing.TableSearchable;
import java.beans.PropertyChangeEvent;
import java.util.regex.Pattern;
import javax.swing.JTable;
import javax.swing.table.TableModel;

public class TableShrinkSearchableSupport
extends ShrinkSearchableSupport {
    private FilterableTableModel _filterableTableModel;

    public TableShrinkSearchableSupport(Searchable searchable) {
        super(searchable);
        if (this._searchable == null || !(this._searchable instanceof TableSearchable)) {
            throw new IllegalArgumentException("The searchable instance should be TableSearchable for TableShrinkSearchableSupport");
        }
    }

    @Override
    protected boolean needReinstallFilterableModel(PropertyChangeEvent propertyChangeEvent) {
        return propertyChangeEvent.getSource() == this._searchable.getComponent() && propertyChangeEvent.getNewValue() != this._filterableTableModel;
    }

    @Override
    public void installFilterableModel() {
        if (this._searchable.getComponent() instanceof JTable) {
            if (!this._searchable.isSearchableListenerInstalled(this)) {
                this._searchable.addSearchableListener(this);
            }
            this._filterableTableModel = this.createFilterableTableModel(((JTable)this._searchable.getComponent()).getModel());
            this._filterableTableModel.setAndMode(false);
            this._searchable.getComponent().removePropertyChangeListener("model", this);
            ((JTable)this._searchable.getComponent()).setModel(this._filterableTableModel);
            this._searchable.getComponent().addPropertyChangeListener("model", this);
        }
    }

    protected FilterableTableModel createFilterableTableModel(TableModel tableModel) {
        if (TableModelWrapperUtils.getActualTableModel(tableModel, IExpandableTreeTableModel.class) != null) {
            return new FilterableTreeTableModel(tableModel);
        }
        return new FilterableTableModel(tableModel);
    }

    @Override
    public void uninstallFilterableModel() {
        this._searchable.getComponent().removePropertyChangeListener("model", this);
        if (this._filterableTableModel != null) {
            this._searchable.removeSearchableListener(this);
            ((JTable)this._searchable.getComponent()).setModel(this._filterableTableModel.getActualModel());
            this._filterableTableModel = null;
        }
    }

    @Override
    protected void applyFilter(String string) {
        if (this._filterableTableModel == null) {
            return;
        }
        this._filterableTableModel.clearFilters();
        if (string != null && string.length() > 0) {
            Object object;
            if (this._searchable.isWildcardEnabled() && (object = this._searchable.getWildcardSupport()) != null) {
                string = object.convert(string);
            }
            object = new WildcardFilter(string){
                private static final long serialVersionUID = 3292118432657792865L;

                @Override
                protected String convertElementToString(Object object) {
                    Object object2 = this.getObjectGrouper() == null ? object : this.getObjectGrouper().getValue(object);
                    String string = TableShrinkSearchableSupport.this.convertElementToString(object2);
                    if (string == null) {
                        string = super.convertElementToString(object);
                    }
                    return string != null ? string : ObjectConverterManager.toString(object2);
                }

                @Override
                protected Pattern createRegexPattern() {
                    return Pattern.compile(this.isBeginWith() ? "^" + this.getPattern() : this.getPattern(), this.isCaseSensitive() ? 0 : 2);
                }
            };
            ((RegexFilter)object).setBeginWith(this._searchable.isFromStart());
            ((RegexFilter)object).setEndWith(false);
            if (((TableSearchable)this._searchable).getMainIndex() == -1) {
                this._filterableTableModel.addFilter((Filter)object);
            } else {
                this._filterableTableModel.addFilter(((TableSearchable)this._searchable).getMainIndex(), (Filter)object);
                for (int n : ((TableSearchable)this._searchable).getSearchColumnIndices()) {
                    this._filterableTableModel.addFilter(n, (Filter)object);
                }
            }
        }
        this._filterableTableModel.setFiltersApplied(true);
    }

    private boolean isColumnSelectionAllowed() {
        JTable jTable = (JTable)this._searchable.getComponent();
        return ((TableSearchable)this._searchable).getSearchColumnIndices().length == 1 && jTable.getColumnSelectionAllowed() && !jTable.getRowSelectionAllowed();
    }

    private boolean isRowSelectionAllowed() {
        JTable jTable = (JTable)this._searchable.getComponent();
        return ((TableSearchable)this._searchable).getSearchColumnIndices().length == 1 && !jTable.getColumnSelectionAllowed() && jTable.getRowSelectionAllowed();
    }

    @Override
    protected int getActualIndexAt(int n) {
        if (this._filterableTableModel == null || n < 0) {
            return n;
        }
        if (this.isColumnSelectionAllowed()) {
            return n;
        }
        if (this.isRowSelectionAllowed()) {
            return this._filterableTableModel.getActualRowAt(n);
        }
        int n2 = this._filterableTableModel.getColumnCount();
        int n3 = this._filterableTableModel.getActualRowAt(n / n2);
        int n4 = n % n2;
        if (n3 >= 0) {
            return n3 * n2 + n4;
        }
        return -1;
    }

    @Override
    protected int getVisualIndexAt(int n) {
        if (this._filterableTableModel == null || n < 0) {
            return n;
        }
        if (this.isColumnSelectionAllowed()) {
            return n;
        }
        if (this.isRowSelectionAllowed()) {
            return this._filterableTableModel.getVisualRowAt(n);
        }
        int n2 = this._filterableTableModel.getColumnCount();
        int n3 = this._filterableTableModel.getActualRowAt(n / n2);
        int n4 = n % n2;
        if (n3 >= 0) {
            return n3 * n2 + n4;
        }
        return -1;
    }
}

