/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.grid;

import com.jidesoft.swing.JideSwingUtilities;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JTable;
import javax.swing.event.MouseInputListener;
import javax.swing.table.JTableHeader;

abstract class TableResizer
implements PropertyChangeListener {
    protected JTable _table;
    protected final boolean _onTableHeader;

    public TableResizer(JTable jTable) {
        this(jTable, false);
    }

    public TableResizer(JTable jTable, boolean bl) {
        this._table = jTable;
        this._onTableHeader = bl;
        this.install();
    }

    public void install() {
        MouseInputListener mouseInputListener = this.createMouseInputListener();
        if (this._onTableHeader) {
            this.installMouseInputListener(this._table.getTableHeader(), mouseInputListener);
            this._table.addPropertyChangeListener("tableHeader", this);
        } else {
            this.installMouseInputListener(this._table, mouseInputListener);
        }
        this._table.putClientProperty(this.getClientProperty(), mouseInputListener);
    }

    private void installMouseInputListener(Component component, MouseInputListener mouseInputListener) {
        if (component != null && mouseInputListener != null) {
            JideSwingUtilities.insertMouseListener(component, mouseInputListener, 0);
            JideSwingUtilities.insertMouseMotionListener(component, mouseInputListener, 0);
        }
    }

    public void uninstall() {
        Object object = this._table.getClientProperty(this.getClientProperty());
        if (object instanceof MouseInputListener) {
            if (this._onTableHeader) {
                this._table.removePropertyChangeListener("tableHeader", this);
                this.uninstallMouseInputListener(this._table.getTableHeader(), (MouseInputListener)object);
            } else {
                this.uninstallMouseInputListener(this._table, (MouseInputListener)object);
            }
        }
        this._table.putClientProperty(this.getClientProperty(), null);
    }

    private void uninstallMouseInputListener(Component component, MouseInputListener mouseInputListener) {
        if (component != null && mouseInputListener != null) {
            component.removeMouseListener(mouseInputListener);
            component.removeMouseMotionListener(mouseInputListener);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        Object object;
        if ("tableHeader".equals(propertyChangeEvent.getPropertyName()) && (object = this._table.getClientProperty(this.getClientProperty())) instanceof MouseInputListener) {
            JTableHeader jTableHeader;
            if (propertyChangeEvent.getOldValue() instanceof JTableHeader) {
                jTableHeader = (JTableHeader)propertyChangeEvent.getOldValue();
                this.uninstallMouseInputListener(jTableHeader, (MouseInputListener)object);
            }
            if (propertyChangeEvent.getNewValue() instanceof JTableHeader) {
                jTableHeader = (JTableHeader)propertyChangeEvent.getNewValue();
                this.installMouseInputListener(jTableHeader, (MouseInputListener)object);
            }
        }
    }

    abstract String getClientProperty();

    abstract MouseInputListener createMouseInputListener();
}

