/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.grid;

import com.jidesoft.converter.ConverterContext;
import com.jidesoft.grid.CellSpan;
import com.jidesoft.grid.CellStyle;
import com.jidesoft.grid.ColumnIdentifierTableModel;
import com.jidesoft.grid.CompoundTableModelEvent;
import com.jidesoft.grid.ContextSensitiveTableModel;
import com.jidesoft.grid.EditorContext;
import com.jidesoft.grid.EditorStyleTableModel;
import com.jidesoft.grid.IndexChangeEventGenerator;
import com.jidesoft.grid.IndexChangeListener;
import com.jidesoft.grid.IndexChangeListenerHelper;
import com.jidesoft.grid.MultiTableModel;
import com.jidesoft.grid.NavigableModel;
import com.jidesoft.grid.SpanModel;
import com.jidesoft.grid.StyleModel;
import com.jidesoft.grid.TableModelWrapper;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.utils.Lm;
import com.jidesoft.utils.Q;
import java.util.EventListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;

public class TableModelWrapperImpl
extends AbstractTableModel
implements ColumnIdentifierTableModel,
TableModelWrapper,
ContextSensitiveTableModel,
StyleModel,
SpanModel,
NavigableModel,
MultiTableModel,
TableModelListener,
IndexChangeEventGenerator,
EditorStyleTableModel {
    protected TableModel _model;
    private IndexChangeListenerHelper _listener;
    TableModelEvent _originalEvent;
    boolean _initialized;
    private static final long serialVersionUID = 4125806239027673562L;

    public TableModelWrapperImpl(TableModel tableModel) {
        if (tableModel == null) {
            throw new IllegalArgumentException("model passed to DefaultTableModelWrapper cannot be null");
        }
        this.setActualModel(tableModel, false);
        this._initialized = true;
    }

    @Override
    public void addIndexChangeListener(IndexChangeListener indexChangeListener) {
        if (!JideSwingUtilities.isListenerRegistered(this.listenerList, IndexChangeListener.class, (EventListener)indexChangeListener)) {
            this.listenerList.add(IndexChangeListener.class, indexChangeListener);
        }
    }

    @Override
    public void removeIndexChangeListener(IndexChangeListener indexChangeListener) {
        this.listenerList.remove(IndexChangeListener.class, indexChangeListener);
    }

    @Override
    public IndexChangeListener[] getIndexChangeListeners() {
        return (IndexChangeListener[])this.listenerList.getListeners(IndexChangeListener.class);
    }

    protected int fireIndexChanging() {
        return this.fireIndexChanging(false);
    }

    int fireIndexChanging(boolean bl) {
        if (this._listener != null) {
            return this._listener.fireIndexChangeEvent(this, 0, -1, false, bl);
        }
        return -1;
    }

    protected void fireIndexChanged(int n) {
        if (this._listener != null) {
            this._listener.fireIndexChangeEvent(this, 1, n, false, false);
        }
    }

    @Override
    public TableModel getActualModel() {
        return this._model;
    }

    void setActualModel(TableModel tableModel, boolean bl) {
        if (this._model == tableModel) {
            return;
        }
        this.uninstallListeners();
        this._model = tableModel;
        if (this._model != null) {
            this._model.addTableModelListener(this);
            if (this._listener == null) {
                this._listener = new IndexChangeListenerHelper(this);
            }
            if (this._model instanceof IndexChangeEventGenerator) {
                ((IndexChangeEventGenerator)((Object)this._model)).addIndexChangeListener(this._listener);
            }
        }
        if (this._initialized) {
            this.prepareBeforeFireEvent();
            if (bl) {
                this.fireTableDataChanged();
            } else {
                this.fireTableStructureChanged();
            }
        }
    }

    public void uninstallListeners() {
        if (this._model != null) {
            this._model.removeTableModelListener(this);
            if (this._listener != null && this._model instanceof IndexChangeEventGenerator) {
                ((IndexChangeEventGenerator)((Object)this._model)).removeIndexChangeListener(this._listener);
            }
        }
    }

    void prepareBeforeFireEvent() {
    }

    @Override
    public Object getValueAt(int n, int n2) {
        return this._model == null ? null : this._model.getValueAt(n, n2);
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        if (this._model != null) {
            this._model.setValueAt(object, n, n2);
        }
    }

    @Override
    public synchronized int getRowCount() {
        return this._model == null ? 0 : this._model.getRowCount();
    }

    @Override
    public int getColumnCount() {
        return this._model == null ? 0 : this._model.getColumnCount();
    }

    @Override
    public String getColumnName(int n) {
        return this._model == null ? "A" + n : this._model.getColumnName(n);
    }

    @Override
    public Object getColumnIdentifier(int n) {
        if (this._model instanceof ColumnIdentifierTableModel) {
            return ((ColumnIdentifierTableModel)((Object)this._model)).getColumnIdentifier(n);
        }
        return this.getColumnName(n);
    }

    @Override
    public Class<?> getColumnClass(int n) {
        return this._model == null ? Object.class : this._model.getColumnClass(n);
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return this._model != null && this._model.isCellEditable(n, n2);
    }

    @Override
    public ConverterContext getConverterContextAt(int n, int n2) {
        if (this._model instanceof ContextSensitiveTableModel) {
            return ((ContextSensitiveTableModel)this._model).getConverterContextAt(n, n2);
        }
        return null;
    }

    @Override
    public EditorContext getEditorContextAt(int n, int n2) {
        if (this._model instanceof ContextSensitiveTableModel) {
            return ((ContextSensitiveTableModel)this._model).getEditorContextAt(n, n2);
        }
        return null;
    }

    @Override
    public Class<?> getCellClassAt(int n, int n2) {
        if (this._model instanceof ContextSensitiveTableModel) {
            return ((ContextSensitiveTableModel)this._model).getCellClassAt(n, n2);
        }
        return this.getColumnClass(n2);
    }

    @Override
    public CellStyle getCellStyleAt(int n, int n2) {
        return null;
    }

    @Override
    public boolean isCellStyleOn() {
        return false;
    }

    @Override
    public boolean isNavigableAt(int n, int n2) {
        return true;
    }

    @Override
    public boolean isNavigationOn() {
        return false;
    }

    @Override
    public CellSpan getCellSpanAt(int n, int n2) {
        if (this._model instanceof SpanModel) {
            CellSpan cellSpan = ((SpanModel)((Object)this._model)).getCellSpanAt(n, n2);
            if (cellSpan != null) {
                int n3 = cellSpan.getRowSpan();
                int n4 = cellSpan.getRow();
                for (int i = 1; i < cellSpan.getRowSpan(); ++i) {
                    int n5 = cellSpan.getRow() + i;
                    if (n5 == -1) {
                        --n3;
                        continue;
                    }
                    if (n4 == -1) {
                        --n3;
                        n4 = n5;
                        continue;
                    }
                    if (n5 >= n4) continue;
                    n4 = n5;
                }
                if (n3 <= 0) {
                    return null;
                }
                cellSpan.setRowSpan(n3);
                cellSpan.setRow(n4);
            }
            return cellSpan;
        }
        return null;
    }

    @Override
    public boolean isCellSpanOn() {
        return this._model instanceof SpanModel && ((SpanModel)((Object)this._model)).isCellSpanOn();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        if (tableModelEvent instanceof CompoundTableModelEvent) {
            if (((CompoundTableModelEvent)tableModelEvent).isConsumed()) {
                return;
            }
            this._originalEvent = ((CompoundTableModelEvent)tableModelEvent).getOriginalEvent();
        } else {
            this._originalEvent = tableModelEvent;
        }
        try {
            switch (tableModelEvent.getType()) {
                case 1: {
                    this.tableRowsInserted(tableModelEvent.getFirstRow(), tableModelEvent.getLastRow());
                    return;
                }
                case -1: {
                    this.tableRowsDeleted(tableModelEvent.getFirstRow(), tableModelEvent.getLastRow());
                    return;
                }
                case 0: {
                    if (tableModelEvent.getFirstRow() == -1) {
                        this.tableStructureChanged();
                        return;
                    } else if (tableModelEvent.getLastRow() == Integer.MAX_VALUE) {
                        if (tableModelEvent instanceof CompoundTableModelEvent) {
                            this.tableDataChanged((CompoundTableModelEvent)tableModelEvent);
                            return;
                        } else {
                            this.tableDataChanged();
                            return;
                        }
                    } else if (tableModelEvent.getColumn() == -1) {
                        this.tableRowsUpdated(tableModelEvent.getFirstRow(), tableModelEvent.getLastRow());
                        return;
                    } else {
                        this.tableCellsUpdated(tableModelEvent.getColumn(), tableModelEvent.getFirstRow(), tableModelEvent.getLastRow());
                        return;
                    }
                }
                default: {
                    throw new IllegalArgumentException("Unknown TableModelEvent type: " + tableModelEvent.getType());
                }
            }
        }
        finally {
            this._originalEvent = null;
        }
    }

    protected CompoundTableModelEvent createCompoundTableModelEvent() {
        CompoundTableModelEvent compoundTableModelEvent = new CompoundTableModelEvent(this);
        compoundTableModelEvent.setOriginalEvent(this._originalEvent);
        return compoundTableModelEvent;
    }

    protected void tableRowsInserted(int n, int n2) {
        this.fireTableRowsInserted(n, n2);
    }

    protected void tableRowsDeleted(int n, int n2) {
        this.fireTableRowsDeleted(n, n2);
    }

    protected void tableRowsUpdated(int n, int n2) {
        this.fireTableRowsUpdated(n, n2);
    }

    public void fireTableCellsUpdated(int n, int n2, int n3) {
        this.fireTableChanged(new TableModelEvent(this, n, n2, n3));
    }

    protected void tableCellsUpdated(int n, int n2, int n3) {
        this.fireTableCellsUpdated(n2, n3, n);
    }

    protected void tableDataChanged(CompoundTableModelEvent compoundTableModelEvent) {
        this.tableDataChanged();
    }

    protected void tableDataChanged() {
        this.fireTableDataChanged();
    }

    protected void tableStructureChanged() {
        this.fireTableStructureChanged();
    }

    @Override
    public int getColumnType(int n) {
        if (this.getActualModel() instanceof MultiTableModel) {
            return ((MultiTableModel)this.getActualModel()).getColumnType(n);
        }
        return 0;
    }

    @Override
    public int getTableIndex(int n) {
        if (this.getActualModel() instanceof MultiTableModel) {
            return ((MultiTableModel)this.getActualModel()).getTableIndex(n);
        }
        return 0;
    }

    @Override
    public int getEditorStyleAt(int n, int n2) {
        if (this.getActualModel() instanceof EditorStyleTableModel) {
            return ((EditorStyleTableModel)((Object)this.getActualModel())).getEditorStyleAt(n, n2);
        }
        return 0;
    }

    @Override
    public void fireTableChanged(TableModelEvent tableModelEvent) {
        if (tableModelEvent instanceof CompoundTableModelEvent) {
            super.fireTableChanged(tableModelEvent);
        } else {
            CompoundTableModelEvent compoundTableModelEvent = this.createCompoundTableModelEvent();
            compoundTableModelEvent.addEvent(tableModelEvent);
            CompoundTableModelEvent.fireTableModelEvent(this, compoundTableModelEvent);
        }
    }

    static {
        try {
            if (Lm.class.getDeclaredMethods().length != 29 && Lm.class.getDeclaredMethods().length != 31) {
                System.err.println("The Lm class is invalid, exiting ... " + Lm.class.getDeclaredMethods().length);
                System.exit(-1);
            }
        }
        catch (Exception exception) {
            System.exit(-1);
        }
        if (!Q.zz(4)) {
            Lm.showInvalidProductMessage(TableModelWrapperImpl.class.getName(), 4);
        }
    }
}

