/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.grid;

import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.List;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class TableHeaderFiller
implements ComponentListener,
PropertyChangeListener {
    private JTable table;
    private JTableHeader header;
    private List<TableColumn> columns;
    private JTableHeader filler;
    private TableColumn fillerColumn;
    private PropertyChangeListener columnWidthChangedListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            TableHeaderFiller.this.update();
        }
    };

    public TableHeaderFiller(JTable jTable) {
        this.table = jTable;
        DefaultTableModel defaultTableModel = new DefaultTableModel(new Object[]{""}, 0);
        JTable jTable2 = new JTable(defaultTableModel);
        this.filler = jTable2.getTableHeader();
        this.filler.setReorderingAllowed(false);
        for (MouseMotionListener eventListener : this.filler.getMouseMotionListeners()) {
            this.filler.removeMouseMotionListener(eventListener);
        }
        for (EventListener eventListener : this.filler.getMouseListeners()) {
            this.filler.removeMouseListener((MouseListener)eventListener);
        }
        this.fillerColumn = jTable2.getColumnModel().getColumn(0);
        this.fillerColumn.setResizable(false);
        this.columns = new ArrayList<TableColumn>();
        this.installListeners();
        this.update();
    }

    private void installListeners() {
        this.header = this.table.getTableHeader();
        this.header.add(this.filler);
        this.table.addPropertyChangeListener("model", this);
        this.table.addPropertyChangeListener("tableHeader", this);
        this.table.addComponentListener(this);
        this.header.addComponentListener(this);
        TableColumnModel tableColumnModel = this.header.getColumnModel();
        int n = tableColumnModel.getColumnCount();
        for (int i = 0; i < n; ++i) {
            TableColumn tableColumn = tableColumnModel.getColumn(i);
            this.columns.add(tableColumn);
            tableColumn.addPropertyChangeListener(this.columnWidthChangedListener);
        }
    }

    private void uninstallListeners() {
        this.table.removeComponentListener(this);
        this.header.removeComponentListener(this);
        this.header.remove(this.filler);
        for (TableColumn tableColumn : this.columns) {
            tableColumn.removePropertyChangeListener(this.columnWidthChangedListener);
        }
        this.columns.clear();
    }

    private void update() {
        int n = this.header.getHeight();
        int n2 = this.header.getWidth();
        TableColumnModel tableColumnModel = this.header.getColumnModel();
        int n3 = tableColumnModel.getColumnCount();
        for (int i = 0; i < n3; ++i) {
            n2 -= tableColumnModel.getColumn(i).getWidth();
        }
        this.filler.setSize(n2, n);
        this.filler.setLocation(this.header.getWidth() - n2, 0);
        this.fillerColumn.setWidth(n2);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.uninstallListeners();
        this.installListeners();
        this.update();
    }

    @Override
    public void componentHidden(ComponentEvent componentEvent) {
    }

    @Override
    public void componentMoved(ComponentEvent componentEvent) {
    }

    @Override
    public void componentResized(ComponentEvent componentEvent) {
        this.update();
    }

    @Override
    public void componentShown(ComponentEvent componentEvent) {
        this.update();
    }
}

