/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.grid;

import com.jidesoft.grid.CellStyle;
import com.jidesoft.grid.CellStyleTable;
import com.jidesoft.grid.FlashCellStyle;
import com.jidesoft.grid.JideTable;
import com.jidesoft.grid.StyleModel;
import com.jidesoft.grid.TableModelWrapperImpl;
import com.jidesoft.grid.TableModelWrapperUtils;
import com.jidesoft.swing.Flashable;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class TableFlashable
extends Flashable {
    public static final int ALL_VISIBLE_CELLS = 0;
    public static final int ONLY_FLASH_CELLS = 1;
    private int _flashArea = 0;
    private FlashCellStyle[] _flashCellStyles;
    private int[] _possibleFlashColumns = null;
    private int[] _modelColumns = null;

    public TableFlashable(CellStyleTable cellStyleTable, FlashCellStyle[] flashCellStyleArray) {
        this(cellStyleTable, flashCellStyleArray, null);
    }

    public TableFlashable(CellStyleTable cellStyleTable, FlashCellStyle[] flashCellStyleArray, int[] nArray) {
        super(cellStyleTable);
        this._flashCellStyles = flashCellStyleArray;
        this.setPossibleFlashColumns(nArray);
    }

    public int getFlashArea() {
        return this._flashArea;
    }

    public void setFlashArea(int n) {
        this._flashArea = n;
    }

    public FlashCellStyle[] getFlashCellStyles() {
        return this._flashCellStyles;
    }

    public void setFlashCellStyles(FlashCellStyle[] flashCellStyleArray) {
        this._flashCellStyles = flashCellStyleArray;
    }

    @Deprecated
    public int[] getPosisbleFlashColumns() {
        return this.getPossibleFlashColumns();
    }

    public int[] getPossibleFlashColumns() {
        return this._possibleFlashColumns;
    }

    @Deprecated
    public void setPosisbleFlashColumns(int[] nArray) {
        this.setPossibleFlashColumns(nArray);
    }

    public void setPossibleFlashColumns(int[] nArray) {
        this._possibleFlashColumns = nArray;
        if (this._possibleFlashColumns != null) {
            this._modelColumns = new int[this._possibleFlashColumns.length];
            System.arraycopy(this._possibleFlashColumns, 0, this._modelColumns, 0, this._possibleFlashColumns.length);
        }
    }

    @Override
    public void flash() {
        Object object;
        for (int i = 0; i < this.getFlashCellStyles().length; ++i) {
            object = this.getFlashCellStyles()[i];
            ((FlashCellStyle)object).setFlashOn(TableFlashable.getSynchronizedFlashFlag());
        }
        if (!(this.getComponent() instanceof CellStyleTable)) {
            return;
        }
        int[] nArray = this.getPossibleFlashColumns();
        object = (CellStyleTable)this.getComponent();
        Rectangle rectangle = ((JComponent)object).getVisibleRect();
        int n = ((JideTable)object).rowAtPoint(new Point(rectangle.x, rectangle.y));
        int n2 = ((JideTable)object).rowAtPoint(new Point(rectangle.x + rectangle.width, rectangle.y + rectangle.height));
        TableModel tableModel = ((JTable)object).getModel();
        switch (this.getFlashArea()) {
            case 0: {
                if (nArray == null) {
                    int n3 = 0;
                    if (tableModel instanceof TableModelWrapperImpl) {
                        n3 = ((TableModelWrapperImpl)tableModel).fireIndexChanging();
                    }
                    if (tableModel instanceof AbstractTableModel) {
                        ((AbstractTableModel)tableModel).fireTableDataChanged();
                    }
                    if (!(tableModel instanceof TableModelWrapperImpl)) break;
                    ((TableModelWrapperImpl)tableModel).fireIndexChanged(n3);
                    break;
                }
                if (n == -1) {
                    n = 0;
                }
                if (n2 == -1) {
                    n2 = tableModel.getRowCount() - 1;
                }
                if (!(tableModel instanceof AbstractTableModel)) break;
                for (int i = n; i <= n2; ++i) {
                    for (int n4 : this._modelColumns) {
                        ((AbstractTableModel)tableModel).fireTableCellUpdated(i, n4);
                    }
                }
                break;
            }
            case 1: {
                if (nArray == null) {
                    this._modelColumns = new int[((JTable)object).getColumnModel().getColumnCount()];
                    for (int i = 0; i < ((JTable)object).getColumnModel().getColumnCount(); ++i) {
                        TableColumn tableColumn = ((JTable)object).getColumnModel().getColumn(i);
                        this._modelColumns[i] = tableColumn.getModelIndex();
                    }
                } else {
                    System.arraycopy(nArray, 0, this._modelColumns, 0, nArray.length);
                }
                int[] nArray2 = new int[this._modelColumns.length];
                for (int i = 0; i < this._modelColumns.length; ++i) {
                    nArray2[i] = ((JTable)object).convertColumnIndexToView(this._modelColumns[i]);
                }
                TableModel tableModel2 = ((CellStyleTable)object).getStyleModel();
                while (tableModel2 != null) {
                    if (tableModel2 instanceof StyleModel && ((StyleModel)((Object)tableModel2)).isCellStyleOn()) {
                        if (n == -1) {
                            n = 0;
                        }
                        if (n2 == -1) {
                            n2 = tableModel.getRowCount() - 1;
                        }
                        if (tableModel instanceof AbstractTableModel) {
                            for (int i = n; i < n2; ++i) {
                                int n5 = TableModelWrapperUtils.getActualRowAt(tableModel, i, tableModel2);
                                for (int j = 0; j < this._modelColumns.length; ++j) {
                                    int n6;
                                    CellStyle cellStyle;
                                    if (nArray2[j] == -1 || !((cellStyle = ((StyleModel)((Object)tableModel2)).getCellStyleAt(n5, n6 = this._modelColumns[j])) instanceof FlashCellStyle)) continue;
                                    ((AbstractTableModel)tableModel).fireTableCellUpdated(i, n6);
                                }
                            }
                        }
                    }
                    tableModel2 = ((CellStyleTable)object).getNextStyleModel(tableModel2);
                }
                break;
            }
        }
    }

    @Override
    public void clearFlashing() {
        FlashCellStyle[] flashCellStyleArray;
        for (FlashCellStyle flashCellStyle : flashCellStyleArray = this.getFlashCellStyles()) {
            flashCellStyle.setFlashOn(false);
        }
    }
}

