/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.grid;

import com.jidesoft.comparator.ObjectComparatorManager;
import com.jidesoft.converter.ConverterContext;
import com.jidesoft.dialog.AbstractDialogPage;
import com.jidesoft.dialog.ButtonPanel;
import com.jidesoft.filter.CustomFilterEditor;
import com.jidesoft.filter.Filter;
import com.jidesoft.filter.FilterFactoryManager;
import com.jidesoft.filter.NotFilter;
import com.jidesoft.filter.ObjectGrouperSupport;
import com.jidesoft.filter.ValueEditor;
import com.jidesoft.grid.ContextSensitiveTableModel;
import com.jidesoft.grid.FilterEditor;
import com.jidesoft.grid.FilterableTableModel;
import com.jidesoft.grid.IFilterableTableModel;
import com.jidesoft.grouper.ObjectGrouper;
import com.jidesoft.icons.IconsFactory;
import com.jidesoft.list.StyledListCellRenderer;
import com.jidesoft.swing.JideBoxLayout;
import com.jidesoft.swing.JideButton;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.swing.SearchableUtils;
import com.jidesoft.swing.StyleRange;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

public class TableCustomFilterEditor
extends AbstractDialogPage
implements TableModelListener,
FilterEditor {
    private TableModel _tableModel;
    private TableModel _actualTableModel;
    protected CustomFilterEditor _editor;
    private FilterFactoryManager _filterFactoryManager;
    private JComboBox _columnComboBox;
    protected JList _list;
    private DefaultListModel _filterItemModel;
    protected JLabel _filtersLabel;
    protected JButton _replaceButton;
    protected JButton _removeButton;
    protected JButton _applyButton;
    protected JButton _addButton;
    protected JButton _clearButton;
    private Boolean _and;
    private boolean _collapsed = false;
    private boolean _collapsible = true;
    protected int _style = 0;
    public static final int STYLE_FILTER_LIST = 0;
    public static final int STYLE_INLINE_EDITOR = 1;
    private String[] _columnNames;
    private IFilterableTableModel _filterableTableModel;
    protected List<FilterPanel> _filterPanels;
    private ActionListener _applyFilterActionListener;
    private ActionListener _clearFilterActionListener;
    protected JToggleButton _andButton;
    public final String PROPERTY_COLLAPSIBLE = "collapsible";
    public final String PROPERTY_COLLAPSED = "collapsed";
    public static final int BUTTON_ALL = 255;
    public static final int BUTTON_CLEAR_FILTER = 1;
    public static final int BUTTON_APPLY_FILTER = 2;
    public static final int BUTTON_COMPOUND_METHOD = 4;
    public static final int BUTTON_REMOVE_ITEM = 8;
    private int[] _columnIndices = null;
    private int _visibleButtons = 255;
    private ObjectGrouper _objectGrouper;

    public TableCustomFilterEditor(TableModel tableModel) {
        this(tableModel, 0);
    }

    public TableCustomFilterEditor(TableModel tableModel, int n) {
        this._style = n;
        this._tableModel = tableModel;
        this._filterItemModel = new DefaultListModel();
        this._tableModel.addTableModelListener(this);
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        if (tableModelEvent == null || tableModelEvent.getFirstRow() == -1 && tableModelEvent.getColumn() == -1 && tableModelEvent.getType() == 0) {
            this.lazyInitialize();
        }
    }

    @Override
    public void lazyInitialize() {
        this.initComponents();
    }

    protected void initComponents() {
        this.removeAll();
        IFilterableTableModel.FilterItem[] filterItemArray = this.internalGetFilterItems();
        boolean bl = this._filterableTableModel != null && this._filterableTableModel.isAndMode();
        this._filterFactoryManager = this.createFilterFactoryManager();
        this._actualTableModel = this._tableModel;
        this.initializeColumnNames();
        this._filterableTableModel = this.createFilterableTableModel(this._tableModel);
        if (this._and == null) {
            this._and = this._filterableTableModel.isAndMode();
        } else {
            this._filterableTableModel.setAndMode(this._and);
        }
        this._filterItemModel.clear();
        switch (this._style) {
            case 0: {
                this.setLayout(new BorderLayout(6, 6));
                this.add(this.createDefinitionPanel(), "First");
                this.add(this.createListPanel());
                this.setFilterItems(filterItemArray);
                this.updateAndButton();
                this.doLayout();
                this.revalidate();
                this.repaint();
                break;
            }
            case 1: {
                this.setLayout(new GridLayout(0, 1, 6, 6));
                this.setFilterItems(filterItemArray);
            }
        }
    }

    private void initializeColumnNames() {
        int[] nArray = this.getColumnIndices();
        if (nArray == null) {
            this._columnNames = new String[this._actualTableModel.getColumnCount()];
            for (int i = 0; i < this._columnNames.length; ++i) {
                this._columnNames[i] = this.getColumnName(this._actualTableModel, i);
            }
        } else {
            this._columnNames = new String[nArray.length];
            for (int i = 0; i < nArray.length; ++i) {
                this._columnNames[i] = this.getColumnName(this._actualTableModel, nArray[i]);
            }
        }
    }

    private void updateFilterItemPanelFromFilterItems(IFilterableTableModel.FilterItem[] filterItemArray) {
        if (this._filterPanels == null) {
            this._filterPanels = new ArrayList<FilterPanel>();
        } else {
            for (FilterPanel filterPanel : this._filterPanels) {
                this.remove(filterPanel);
            }
            this._filterPanels.clear();
        }
        int n = filterItemArray.length > 1 && this.isCollapsed() ? 1 : filterItemArray.length;
        for (int i = 0; i < n; ++i) {
            IFilterableTableModel.FilterItem filterItem = filterItemArray[i];
            this.add(this.createFilterItemPanel(filterItem, i, n));
        }
        if (filterItemArray.length == 0) {
            this.add(this.createFilterItemPanel(null, filterItemArray.length, 1));
        }
    }

    protected IFilterableTableModel createFilterableTableModel(TableModel tableModel) {
        return new FilterableTableModel(tableModel);
    }

    @Override
    public Filter[] getFilters() {
        Filter[] filterArray = null;
        IFilterableTableModel.FilterItem[] filterItemArray = this.internalGetFilterItems();
        if (filterItemArray != null) {
            filterArray = new Filter[filterItemArray.length];
            for (int i = 0; i < filterItemArray.length; ++i) {
                filterArray[i] = filterItemArray[i].getFilter();
                if (filterArray[i] instanceof ObjectGrouperSupport) {
                    ((ObjectGrouperSupport)((Object)filterArray[i])).setObjectGrouper(this.getObjectGrouper());
                }
                if (!(filterArray[i] instanceof NotFilter) || !(((NotFilter)filterArray[i]).getFilter() instanceof ObjectGrouperSupport)) continue;
                ((ObjectGrouperSupport)((Object)((NotFilter)filterArray[i]).getFilter())).setObjectGrouper(this.getObjectGrouper());
            }
        }
        return filterArray;
    }

    @Override
    public void setFilters(Filter[] filterArray) {
        this._filterItemModel.removeAllElements();
        if (filterArray != null && filterArray.length > 0) {
            for (Filter filter : filterArray) {
                if (filter instanceof IFilterableTableModel.FilterItem) {
                    this._filterItemModel.addElement(filter);
                    continue;
                }
                IFilterableTableModel.FilterItem filterItem = new IFilterableTableModel.FilterItem(filter);
                if (this.getColumnIndices() != null && this.getColumnIndices().length > 0) {
                    for (int n : this.getColumnIndices()) {
                        if (n < 0) continue;
                        filterItem.setColumn(n);
                    }
                }
                this._filterItemModel.addElement(filterItem);
            }
        }
    }

    @Deprecated
    public int[] getColumnIndex() {
        return this._columnIndices;
    }

    @Deprecated
    public void setColumnIndex(int[] nArray) {
        this._columnIndices = nArray;
        Object object = null;
        if (this._columnComboBox != null) {
            object = this._columnComboBox.getSelectedItem();
        }
        this.initializeColumnNames();
        if (this._columnComboBox != null) {
            this._columnComboBox.setModel(new DefaultComboBoxModel<String>(this._columnNames));
            if (this._columnNames.length >= 1) {
                if (object == null) {
                    this._columnComboBox.setSelectedItem(this._columnNames[0]);
                } else {
                    int n;
                    for (n = 0; n < this._columnNames.length && !JideSwingUtilities.equals(this._columnNames[n], object); ++n) {
                    }
                    if (n >= this._columnNames.length) {
                        this._columnComboBox.setSelectedIndex(0);
                    } else {
                        this._columnComboBox.setSelectedIndex(n);
                    }
                }
                if (this._editor != null && this._editor.getParent() instanceof JPanel) {
                    this._editor = this.updateEditor((String)this._columnComboBox.getSelectedItem(), (JPanel)this._editor.getParent(), this._filterableTableModel, this._editor);
                }
            }
        }
        this._columnComboBox.setEnabled(nArray == null || nArray.length > 1);
    }

    public int[] getColumnIndices() {
        return this.getColumnIndex();
    }

    public void setColumnIndices(int[] nArray) {
        this.setColumnIndex(nArray);
    }

    public int getVisibleButtons() {
        return this._visibleButtons;
    }

    public void setVisibleButtons(int n) {
        if (this._visibleButtons != n) {
            this._visibleButtons = n;
            this.initComponents();
        }
    }

    public ObjectGrouper getObjectGrouper() {
        return this._objectGrouper;
    }

    @Override
    public void setObjectGrouper(ObjectGrouper objectGrouper) {
        this._objectGrouper = objectGrouper;
    }

    protected boolean shouldGoButtonBeVisible(int n, int n2) {
        return n2 == 1 || n == n2 - 1 || this.isCollapsed() && n == 0;
    }

    protected boolean shouldClearButtonBeVisible(int n, int n2) {
        return n2 == 1 || n == n2 - 1 || this.isCollapsed() && n == 0;
    }

    public boolean isCollapsible() {
        return this._collapsible;
    }

    public void setCollapsible(boolean bl) {
        boolean bl2 = this._collapsible;
        if (bl2 != bl) {
            this._collapsible = bl;
            this.firePropertyChange("collapsible", bl2, bl);
            if (this._filterPanels.size() > 0) {
                FilterPanel filterPanel = this._filterPanels.get(0);
                filterPanel.updateCollapseButton();
            }
        }
    }

    public boolean isCollapsed() {
        return this._collapsed;
    }

    public void setCollapsed(boolean bl) {
        boolean bl2;
        if (this.isCollapsible() && (bl2 = this._collapsed) != bl) {
            this._collapsed = bl;
            this.firePropertyChange("collapsed", bl2, bl);
            int n = this._filterPanels.size();
            for (int i = 0; i < n; ++i) {
                FilterPanel filterPanel = this._filterPanels.get(i);
                if (i != 0) {
                    filterPanel.setVisible(!bl);
                    if (bl) {
                        this.remove(filterPanel);
                    } else {
                        this.add(filterPanel);
                    }
                }
                filterPanel.updateIndex(i, n);
            }
            this.doLayout();
            this.revalidate();
            this.repaint();
        }
    }

    protected Component createFilterItemPanel(IFilterableTableModel.FilterItem filterItem, int n, int n2) {
        FilterPanel filterPanel = new FilterPanel(filterItem, n, n2);
        this._filterPanels.add(n, filterPanel);
        return filterPanel;
    }

    private void updateFilterPanels() {
        int n = this.getComponentCount();
        for (int i = 0; i < n; ++i) {
            Component component = this.getComponent(i);
            if (!(component instanceof FilterPanel)) continue;
            ((FilterPanel)component).updateIndex(i, n);
            ((FilterPanel)component).updateCollapseButton();
        }
    }

    public void saveFilterItems() {
        if (this._style == 1) {
            this._filterItemModel.clear();
            int n = this._filterPanels.size();
            for (int i = 0; i < n; ++i) {
                FilterPanel filterPanel = this._filterPanels.get(i);
                this._filterItemModel.addElement(this.getFilterItem(filterPanel._comboBox, filterPanel._editor));
            }
        }
    }

    private Component createDefinitionPanel() {
        final JPanel jPanel = new JPanel(new BorderLayout(6, 6));
        this._columnComboBox = this.createColumnComboBox(this._columnNames);
        JLabel jLabel = new JLabel(this.getResourceString("FilterEditor.column"));
        jLabel.setDisplayedMnemonic(this.getResourceString("FilterEditor.column.mnemonic").charAt(0));
        jPanel.add((Component)JideSwingUtilities.createTopPanel(JideSwingUtilities.createLabeledComponent(jLabel, this._columnComboBox, "First")), "Before");
        this._columnComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    String string = "" + itemEvent.getItem();
                    TableCustomFilterEditor.this._editor = TableCustomFilterEditor.this.updateEditor(string, jPanel, TableCustomFilterEditor.this._filterableTableModel, TableCustomFilterEditor.this._editor);
                }
            }
        });
        this._editor = this.updateEditor("" + this._columnComboBox.getSelectedItem(), jPanel, this._filterableTableModel, this._editor);
        ButtonPanel buttonPanel = new ButtonPanel(11);
        this._addButton = new JButton(new AbstractAction(this.getResourceString("FilterEditor.add")){
            private static final long serialVersionUID = 563125241570287601L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                IFilterableTableModel.FilterItem filterItem = TableCustomFilterEditor.this.getFilterItem(TableCustomFilterEditor.this._columnComboBox, TableCustomFilterEditor.this._editor);
                if (filterItem != null) {
                    TableCustomFilterEditor.this._filterItemModel.addElement(filterItem);
                }
            }
        });
        this._addButton.setMnemonic(this.getResourceString("FilterEditor.add.mnemonic").charAt(0));
        this._replaceButton = new JButton(new AbstractAction(this.getResourceString("FilterEditor.replace")){
            private static final long serialVersionUID = -5580794636838313891L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                IFilterableTableModel.FilterItem filterItem;
                int n = TableCustomFilterEditor.this._list.getSelectedIndex();
                if (n != -1 && (filterItem = TableCustomFilterEditor.this.getFilterItem(TableCustomFilterEditor.this._columnComboBox, TableCustomFilterEditor.this._editor)) != null) {
                    TableCustomFilterEditor.this._filterItemModel.set(n, filterItem);
                }
            }
        });
        this._replaceButton.setMnemonic(this.getResourceString("FilterEditor.replace.mnemonic").charAt(0));
        this._replaceButton.setEnabled(false);
        buttonPanel.addButton(this._replaceButton);
        buttonPanel.addButton(this._addButton);
        jPanel.add((Component)buttonPanel, "Last");
        return jPanel;
    }

    protected JComboBox createColumnComboBox(String[] stringArray) {
        JComboBox<String> jComboBox = new JComboBox<String>(stringArray);
        jComboBox.setName("CompactField");
        SearchableUtils.installSearchable(jComboBox);
        jComboBox.setEditable(false);
        return jComboBox;
    }

    protected FilterFactoryManager createFilterFactoryManager() {
        FilterFactoryManager filterFactoryManager = new FilterFactoryManager();
        filterFactoryManager.registerDefaultFilterFactories(this.getStyle() != 1);
        return filterFactoryManager;
    }

    protected String getColumnName(TableModel tableModel, int n) {
        return tableModel.getColumnName(n);
    }

    private CustomFilterEditor updateEditor(String string, JPanel jPanel, IFilterableTableModel iFilterableTableModel, CustomFilterEditor customFilterEditor) {
        int n = this.findColumnIndex(string);
        if (n != -1) {
            int n2 = -1;
            Component[] componentArray = jPanel.getComponents();
            int n3 = componentArray.length;
            for (int i = 0; i < n3; ++i) {
                Component component = componentArray[i];
                if (!(component instanceof CustomFilterEditor)) continue;
                jPanel.remove(component);
                n2 = i;
                break;
            }
            if (n >= 0 && n < this._actualTableModel.getColumnCount()) {
                Class<?> clazz = this._actualTableModel.getColumnClass(n);
                ConverterContext converterContext = this._actualTableModel instanceof ContextSensitiveTableModel ? ((ContextSensitiveTableModel)this._actualTableModel).getConverterContextAt(0, n) : null;
                customFilterEditor = this.createCustomFilterEditor(this._filterFactoryManager, clazz, converterContext, iFilterableTableModel.getPossibleValues(n, ObjectComparatorManager.getComparator(this._actualTableModel.getColumnClass(n))));
                if (n2 == -1) {
                    jPanel.add(customFilterEditor);
                } else {
                    jPanel.add((Component)customFilterEditor, n2);
                }
            }
            jPanel.doLayout();
            jPanel.revalidate();
            jPanel.repaint();
            return customFilterEditor;
        }
        return null;
    }

    protected CustomFilterEditor createCustomFilterEditor(FilterFactoryManager filterFactoryManager, Class clazz, ConverterContext converterContext, Object[] objectArray) {
        CustomFilterEditor customFilterEditor = new CustomFilterEditor(filterFactoryManager, clazz, converterContext, objectArray){

            @Override
            protected ValueEditor createValueEditor(Class clazz, ConverterContext converterContext, Object[] objectArray) {
                return TableCustomFilterEditor.this.createValueEditor(clazz, converterContext, objectArray);
            }
        };
        customFilterEditor.setSingleLineMode(this._style == 1);
        return customFilterEditor;
    }

    protected ValueEditor createValueEditor(Class clazz, ConverterContext converterContext, Object[] objectArray) {
        return new ValueEditor(clazz, converterContext, objectArray);
    }

    protected Component createListPanel() {
        this._list = new JList(this._filterItemModel);
        this._list.setCellRenderer(new StyledListCellRenderer(){

            @Override
            protected void customizeStyledLabel(JList jList, Object object, int n, boolean bl, boolean bl2) {
                if (object instanceof IFilterableTableModel.FilterItem) {
                    int n2;
                    IFilterableTableModel.FilterItem filterItem = (IFilterableTableModel.FilterItem)object;
                    this.clearStyleRanges();
                    String string = TableCustomFilterEditor.this.getColumnName(TableCustomFilterEditor.this._actualTableModel, filterItem.getColumn());
                    String string2 = filterItem.getFilter().getName();
                    if (string2 == null) {
                        string2 = filterItem.getFilter().getClass().getSimpleName();
                    }
                    if ((n2 = string2.indexOf(" | ")) != -1) {
                        String string3 = string2.substring(0, n2);
                        this.addStyleRange(new StyleRange(string.length() + 1, string3.length(), 1));
                        this.setText(string + " " + string3 + " " + string2.substring(n2 + 3));
                    } else {
                        this.addStyleRange(new StyleRange(string.length() + 1, string2.length(), 1));
                        this.setText(string + " " + string2);
                    }
                } else {
                    super.customizeStyledLabel(jList, object, n, bl, bl2);
                }
            }
        });
        this._list.setVisibleRowCount(4);
        ButtonPanel buttonPanel = new ButtonPanel(11);
        if ((4 & this.getVisibleButtons()) != 0) {
            this._andButton = new JToggleButton(this.getResourceString("FilterEditor.and.text"));
            this._andButton.addActionListener(new AbstractAction(){
                private static final long serialVersionUID = -7912967668407982207L;

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    TableCustomFilterEditor.this.setAnd(!TableCustomFilterEditor.this.isAnd());
                    TableCustomFilterEditor.this.updateAndButton();
                }
            });
            buttonPanel.addButton((AbstractButton)this._andButton, "HELP");
        }
        if ((8 & this.getVisibleButtons()) != 0) {
            this._removeButton = new JButton(new AbstractAction(this.getResourceString("FilterEditor.remove")){
                private static final long serialVersionUID = -908045929494519071L;

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    int[] nArray = TableCustomFilterEditor.this._list.getSelectedIndices();
                    for (int i = nArray.length - 1; i >= 0; --i) {
                        int n = nArray[i];
                        TableCustomFilterEditor.this._filterItemModel.removeElementAt(n);
                    }
                }
            });
            this._removeButton.setMnemonic(this.getResourceString("FilterEditor.remove.mnemonic").charAt(0));
            this._removeButton.setEnabled(false);
            buttonPanel.addButton(this._removeButton);
        }
        if ((1 & this.getVisibleButtons()) != 0) {
            this._clearButton = new JButton(new AbstractAction(this.getResourceString("FilterEditor.clear")){
                private static final long serialVersionUID = 4551449282917080305L;

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ActionListener actionListener = TableCustomFilterEditor.this.getClearFilterActionListener();
                    if (actionListener != null) {
                        actionListener.actionPerformed(actionEvent);
                    }
                }
            });
            this._clearButton.setMnemonic(this.getResourceString("FilterEditor.clear.mnemonic").charAt(0));
            buttonPanel.addButton(this._clearButton);
        }
        if ((2 & this.getVisibleButtons()) != 0) {
            this._applyButton = new JButton(new AbstractAction(this.getResourceString("FilterEditor.apply")){
                private static final long serialVersionUID = 388509703998133194L;

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ActionListener actionListener = TableCustomFilterEditor.this.getApplyFilterActionListener();
                    if (actionListener != null) {
                        actionListener.actionPerformed(actionEvent);
                    }
                }
            });
            this._applyButton.setMnemonic(this.getResourceString("FilterEditor.apply.mnemonic").charAt(0));
            buttonPanel.addButton(this._applyButton);
        }
        this._list.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                int n = TableCustomFilterEditor.this._list.getSelectedIndex();
                if ((8 & TableCustomFilterEditor.this.getVisibleButtons()) != 0) {
                    TableCustomFilterEditor.this._removeButton.setEnabled(n != -1);
                }
                if (n != -1) {
                    IFilterableTableModel.FilterItem filterItem = (IFilterableTableModel.FilterItem)TableCustomFilterEditor.this._filterItemModel.getElementAt(n);
                    TableCustomFilterEditor.this._columnComboBox.setSelectedItem(TableCustomFilterEditor.this.getColumnName(TableCustomFilterEditor.this._actualTableModel, filterItem.getColumn()));
                    TableCustomFilterEditor.this._editor.setFilter(filterItem.getFilter());
                }
                TableCustomFilterEditor.this._replaceButton.setEnabled(n != -1);
            }
        });
        JPanel jPanel = new JPanel(new BorderLayout(2, 2));
        this._filtersLabel = new JLabel(this.getResourceString("FilterEditor.filterList"));
        this._filtersLabel.setDisplayedMnemonic(this.getResourceString("FilterEditor.filterList.mnemonic").charAt(0));
        this._filtersLabel.setLabelFor(this._list);
        jPanel.add((Component)this._filtersLabel, "First");
        jPanel.add(new JScrollPane(this._list));
        jPanel.add((Component)buttonPanel, "Last");
        return jPanel;
    }

    private void updateAndButton() {
        if (this._andButton != null) {
            if (this.isAnd()) {
                this._andButton.setText(this.getResourceString("FilterEditor.and.text"));
            } else {
                this._andButton.setText(this.getResourceString("FilterEditor.or.text"));
            }
        }
    }

    private IFilterableTableModel.FilterItem getFilterItem(JComboBox jComboBox, CustomFilterEditor customFilterEditor) {
        Filter filter;
        String string;
        int n;
        if (jComboBox != null && (n = this.findColumnIndex(string = "" + jComboBox.getSelectedItem())) != -1 && (filter = customFilterEditor.getFilter()) != null) {
            return new IFilterableTableModel.FilterItem(n, filter);
        }
        return null;
    }

    private int findColumnIndex(String string) {
        int n = -1;
        for (int i = 0; i < this._actualTableModel.getColumnCount(); ++i) {
            if (!string.equals(this.getColumnName(this._actualTableModel, i))) continue;
            n = i;
            break;
        }
        return n;
    }

    private IFilterableTableModel.FilterItem[] internalGetFilterItems() {
        int n = this._filterItemModel.size();
        IFilterableTableModel.FilterItem[] filterItemArray = new IFilterableTableModel.FilterItem[n];
        for (int i = 0; i < n; ++i) {
            filterItemArray[i] = (IFilterableTableModel.FilterItem)this._filterItemModel.getElementAt(i);
        }
        return filterItemArray;
    }

    public IFilterableTableModel.FilterItem[] getFilterItems() {
        this.saveFilterItems();
        return this.internalGetFilterItems();
    }

    public void setFilterItems(IFilterableTableModel.FilterItem[] filterItemArray) {
        this._filterItemModel.clear();
        for (IFilterableTableModel.FilterItem filterItem : filterItemArray) {
            this._filterItemModel.addElement(filterItem);
        }
        if (this.getStyle() == 1) {
            this.removeAll();
            this.updateFilterItemPanelFromFilterItems(filterItemArray);
            this.updateAndButton();
            this.doLayout();
            this.revalidate();
            this.repaint();
        }
    }

    public ListModel getFilterItemModel() {
        return this._filterItemModel;
    }

    public IFilterableTableModel getFilterableTableModel() {
        return this._filterableTableModel;
    }

    public FilterFactoryManager getFilterFactoryManager() {
        return this._filterFactoryManager;
    }

    protected String getResourceString(String string) {
        return ResourceBundle.getBundle("com.jidesoft.filter.filterEditor", this.getLocale()).getString(string);
    }

    public int getStyle() {
        return this._style;
    }

    public void setStyle(int n) {
        if (this._style != n) {
            this._style = n;
            this.initComponents();
        }
    }

    public ActionListener getApplyFilterActionListener() {
        if (this._applyFilterActionListener == null) {
            this._applyFilterActionListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    TableCustomFilterEditor.this._filterableTableModel.clearFilters();
                    TableCustomFilterEditor.this.saveFilterItems();
                    IFilterableTableModel.FilterItem[] filterItemArray = TableCustomFilterEditor.this.getFilterItems();
                    TableCustomFilterEditor.this._filterableTableModel.setAndMode(TableCustomFilterEditor.this.isAnd());
                    for (IFilterableTableModel.FilterItem filterItem : filterItemArray) {
                        if (filterItem == null || filterItem.getFilter() == null) continue;
                        TableCustomFilterEditor.this._filterableTableModel.addFilter(filterItem);
                    }
                    TableCustomFilterEditor.this._filterableTableModel.setFiltersApplied(true);
                }
            };
        }
        return this._applyFilterActionListener;
    }

    public void setApplyFilterActionListener(ActionListener actionListener) {
        this._applyFilterActionListener = actionListener;
    }

    public ActionListener getClearFilterActionListener() {
        if (this._clearFilterActionListener == null) {
            this._clearFilterActionListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    TableCustomFilterEditor.this._filterableTableModel.clearFilters();
                    TableCustomFilterEditor.this._filterableTableModel.setFiltersApplied(true);
                    TableCustomFilterEditor.this.initComponents();
                }
            };
        }
        return this._clearFilterActionListener;
    }

    public void setClearFilterActionListener(ActionListener actionListener) {
        this._clearFilterActionListener = actionListener;
    }

    public boolean isAnd() {
        return this._and == null || this._and != false;
    }

    public void setAnd(boolean bl) {
        this._and = bl;
        if (this._style == 0) {
            this.updateAndButton();
        } else if (this._style == 1) {
            for (FilterPanel filterPanel : this._filterPanels) {
                filterPanel.updateAndButton();
            }
        }
    }

    public class FilterPanel
    extends JPanel {
        public JComboBox _comboBox;
        public CustomFilterEditor _editor;
        public int _index;
        public int _total;
        public IFilterableTableModel.FilterItem _item;
        public JButton _goButton;
        public JButton _clearButton;
        public JButton _removeButton;
        public JButton _addButton;
        public JideButton _collapseButton;
        public JComboBox _andButton;
        public JLabel _filterLabel;
        private JPanel _panel;

        public FilterPanel(IFilterableTableModel.FilterItem filterItem, int n, int n2) {
            this._index = n;
            this._item = filterItem;
            this._total = n2;
            this.setName("FilterItemPanel");
            this.setLayout(new JideBoxLayout(this, 0, 2));
            this.initComponents();
            if (filterItem != null) {
                this._editor.setFilter(filterItem.getFilter());
            }
        }

        private void initComponents() {
            this.createCollapsibleButton();
            this.createAndButton();
            this.createFilterLabel();
            int n = this._andButton.getPreferredSize().width;
            int n2 = this._collapseButton.getPreferredSize().width + this._filterLabel.getPreferredSize().width + 4;
            this._panel = new JPanel(new BorderLayout(4, 4));
            if (this._index == 0) {
                this._panel.add((Component)this._collapseButton, "Before");
                this._panel.add((Component)this._filterLabel, "Center");
                this.add((Component)this._panel, "fix");
            } else {
                this.add((Component)this._andButton, "fix");
                this._andButton.setEnabled(this._index == 1);
            }
            int n3 = n - n2;
            if (n3 > 0) {
                this._panel.setBorder(BorderFactory.createEmptyBorder(0, n3, 0, 0));
            }
            this.updateAndButton();
            Dimension dimension = new Dimension(Math.max(n, n2), this._andButton.getPreferredSize().height);
            this._andButton.setPreferredSize(dimension);
            this._andButton.setMinimumSize(dimension);
            this._andButton.setMaximumSize(dimension);
            this._comboBox = TableCustomFilterEditor.this.createColumnComboBox(TableCustomFilterEditor.this._columnNames);
            if (this._item != null) {
                this._comboBox.setSelectedItem(TableCustomFilterEditor.this.getColumnName(TableCustomFilterEditor.this._actualTableModel, this._item.getColumn()));
            }
            this.add(this._comboBox);
            this._comboBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    if (itemEvent.getStateChange() == 1) {
                        String string = "" + itemEvent.getItem();
                        FilterPanel.this._editor = TableCustomFilterEditor.this.updateEditor(string, FilterPanel.this, TableCustomFilterEditor.this._filterableTableModel, null);
                        if (FilterPanel.this._item != null) {
                            FilterPanel.this._item.setColumn(FilterPanel.this._comboBox.getSelectedIndex());
                        }
                    }
                }
            });
            this._editor = TableCustomFilterEditor.this.updateEditor("" + this._comboBox.getSelectedItem(), this, TableCustomFilterEditor.this._filterableTableModel, null);
            this._removeButton = new JButton(new AbstractAction(){
                private static final long serialVersionUID = -4217044571297871091L;

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    TableCustomFilterEditor.this.setCollapsed(false);
                    Object object = actionEvent.getSource();
                    if (object instanceof Component) {
                        Container container = SwingUtilities.getAncestorOfClass(FilterPanel.class, (Component)object);
                        container.getParent().remove(container);
                        TableCustomFilterEditor.this._filterPanels.remove((FilterPanel)container);
                    }
                    TableCustomFilterEditor.this._filterItemModel.removeElement(FilterPanel.this._item);
                    TableCustomFilterEditor.this.updateFilterPanels();
                    TableCustomFilterEditor.this.doLayout();
                    TableCustomFilterEditor.this.revalidate();
                    TableCustomFilterEditor.this.repaint();
                }
            });
            this.customizeButton(this._removeButton);
            this._removeButton.setIcon(IconsFactory.getImageIcon(TableCustomFilterEditor.class, "icons/remove.png"));
            this._removeButton.setDisabledIcon(IconsFactory.getImageIcon(TableCustomFilterEditor.class, "icons/remove_disabled.png"));
            this._removeButton.setEnabled(this._total > 1);
            this._removeButton.setName("CompactButton");
            this.add(this._removeButton);
            this._addButton = new JButton(new AbstractAction(){
                private static final long serialVersionUID = 7039269938504847465L;

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    TableCustomFilterEditor.this.setCollapsed(false);
                    TableCustomFilterEditor.this._filterItemModel.add(FilterPanel.this._index, null);
                    TableCustomFilterEditor.this.add(TableCustomFilterEditor.this.createFilterItemPanel(null, FilterPanel.this._index + 1, FilterPanel.this.getComponentCount() + 1), FilterPanel.this._index + 1);
                    TableCustomFilterEditor.this.updateFilterPanels();
                    TableCustomFilterEditor.this.doLayout();
                    TableCustomFilterEditor.this.revalidate();
                    TableCustomFilterEditor.this.repaint();
                }
            });
            this.customizeButton(this._addButton);
            this._addButton.setIcon(IconsFactory.getImageIcon(TableCustomFilterEditor.class, "icons/add.png"));
            this._addButton.setDisabledIcon(IconsFactory.getImageIcon(TableCustomFilterEditor.class, "icons/add_disabled.png"));
            this._addButton.setName("CompactButton");
            this.add(this._addButton);
            this._goButton = new JButton(new AbstractAction(TableCustomFilterEditor.this.getResourceString("FilterEditor.go")){
                private static final long serialVersionUID = -7519987690195292108L;

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ActionListener actionListener = TableCustomFilterEditor.this.getApplyFilterActionListener();
                    if (actionListener != null) {
                        actionListener.actionPerformed(actionEvent);
                    }
                }
            });
            this._goButton.setMnemonic(TableCustomFilterEditor.this.getResourceString("FilterEditor.go.mnemonic").charAt(0));
            this._goButton.setName("CompactButton");
            this.add(this._goButton);
            this._goButton.setVisible(this._total == 1 || this._index == this._total - 1);
            if ((1 & TableCustomFilterEditor.this.getVisibleButtons()) != 0) {
                this._clearButton = new JButton(new AbstractAction(TableCustomFilterEditor.this.getResourceString("FilterEditor.clear")){
                    private static final long serialVersionUID = -8011863987580373543L;

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        ActionListener actionListener = TableCustomFilterEditor.this.getClearFilterActionListener();
                        if (actionListener != null) {
                            actionListener.actionPerformed(actionEvent);
                        }
                    }
                });
                this._clearButton.setMnemonic(TableCustomFilterEditor.this.getResourceString("FilterEditor.clear.mnemonic").charAt(0));
                this._clearButton.setName("CompactButton");
                this.add(this._clearButton);
                this._clearButton.setVisible(this._total == 1 || this._index == this._total - 1);
            }
            this.add(Box.createGlue(), "vary");
        }

        private void createFilterLabel() {
            if (this._filterLabel == null) {
                this._filterLabel = new JLabel(TableCustomFilterEditor.this.getResourceString("FilterEditor.filters"));
            }
        }

        private void customizeButton(JButton jButton) {
            jButton.setHideActionText(true);
            jButton.setMargin(new Insets(3, 3, 1, 2));
        }

        public void updateAndButton() {
            if (this._andButton != null) {
                this._andButton.setSelectedIndex(TableCustomFilterEditor.this.isAnd() ? 0 : 1);
            }
        }

        private void createAndButton() {
            if (this._andButton == null) {
                this._andButton = new JComboBox<Object>(new Object[]{TableCustomFilterEditor.this.getResourceString("FilterEditor.and.text"), TableCustomFilterEditor.this.getResourceString("FilterEditor.or.text")});
                this._andButton.setName("CompactField");
                this._andButton.addItemListener(new ItemListener(){

                    @Override
                    public void itemStateChanged(ItemEvent itemEvent) {
                        if (itemEvent.getStateChange() == 1) {
                            TableCustomFilterEditor.this.setAnd(FilterPanel.this._andButton.getSelectedIndex() == 0);
                        }
                    }
                });
            }
        }

        public void updateIndex(int n, int n2) {
            if (n != this._index || this._total != n2) {
                if (n == 0) {
                    if (this._andButton != null) {
                        this.remove(this._andButton);
                    }
                    if (this._collapseButton == null) {
                        this.createCollapsibleButton();
                    }
                    if (this._filterLabel == null) {
                        this.createFilterLabel();
                    }
                    this._panel.removeAll();
                    if (this._filterLabel.getParent() == null) {
                        this._panel.add((Component)this._filterLabel, "Center");
                    }
                    if (this._collapseButton.getParent() == null) {
                        this._panel.add((Component)this._collapseButton, "Before");
                    }
                    this.add(this._panel, "fix", 0);
                } else {
                    if (this._panel != null) {
                        this.remove(this._panel);
                    }
                    if (this._andButton == null) {
                        this.createAndButton();
                    }
                    if (this._andButton.getParent() == null) {
                        this.add(this._andButton, "fix", 0);
                    }
                    this._andButton.setEnabled(n == 1);
                }
                this._removeButton.setEnabled(n2 > 1);
            }
            this._goButton.setVisible(TableCustomFilterEditor.this.shouldGoButtonBeVisible(n, n2));
            this._clearButton.setVisible(TableCustomFilterEditor.this.shouldClearButtonBeVisible(n, n2));
            this._index = n;
            this._total = n2;
        }

        private void createCollapsibleButton() {
            if (this._collapseButton == null) {
                this._collapseButton = new JideButton(new AbstractAction(){
                    private static final long serialVersionUID = -4265129428753780124L;

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        TableCustomFilterEditor.this.setCollapsed(!TableCustomFilterEditor.this.isCollapsed());
                        FilterPanel.this.updateCollapseButton();
                    }
                });
                this.updateCollapseButton();
            }
        }

        public void updateCollapseButton() {
            if (this._collapseButton != null) {
                if (!TableCustomFilterEditor.this.isCollapsible()) {
                    this._collapseButton.setIcon(IconsFactory.getImageIcon(TableCustomFilterEditor.class, "icons/blank.png"));
                    this._collapseButton.setEnabled(false);
                } else if (TableCustomFilterEditor.this._filterPanels != null && TableCustomFilterEditor.this._filterPanels.size() <= 1) {
                    this._collapseButton.setIcon(IconsFactory.getImageIcon(TableCustomFilterEditor.class, "icons/blank.png"));
                    this._collapseButton.setEnabled(false);
                } else {
                    this._collapseButton.setIcon(IconsFactory.getImageIcon(TableCustomFilterEditor.class, TableCustomFilterEditor.this.isCollapsed() ? "icons/expand.png" : "icons/collapse.png"));
                    this._collapseButton.setEnabled(true);
                }
            }
        }
    }
}

