/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.grid;

import com.jidesoft.grid.JideTable;
import com.jidesoft.grid.TableResizer;
import com.jidesoft.grid.TableUtils;
import com.jidesoft.swing.AutoScroll;
import java.applet.Applet;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.IllegalComponentStateException;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.event.MouseInputAdapter;
import javax.swing.event.MouseInputListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;

public class TableColumnResizer
extends TableResizer {
    public static Cursor _resizeCursor = Cursor.getPredefinedCursor(11);
    private int _mouseXOffset;
    private Cursor _otherCursor = _resizeCursor;
    public static final int OFFSET = 3;
    private TableColumn _resizingColumn = null;
    private int _originalWidth = -1;
    private int _originalViewPosition = -1;
    private static final String KEY = "columnResizer";

    public TableColumnResizer(JTable jTable) {
        super(jTable);
    }

    @Override
    String getClientProperty() {
        return KEY;
    }

    @Override
    public MouseInputListener createMouseInputListener() {
        return new MouseInputAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                Container container;
                Point point;
                int n;
                JTableHeader jTableHeader;
                AutoScroll autoScroll = AutoScroll.getAutoScroll(TableColumnResizer.this._table);
                if (autoScroll != null) {
                    autoScroll.setEnabled(false);
                }
                if ((jTableHeader = TableColumnResizer.this._table.getTableHeader()) != null) {
                    jTableHeader.setDraggedColumn(null);
                    jTableHeader.setResizingColumn(null);
                    jTableHeader.setDraggedDistance(0);
                }
                if ((n = TableColumnResizer.this._table.columnAtPoint(point = mouseEvent.getPoint())) == -1) {
                    return;
                }
                TableColumn tableColumn = TableUtils.getResizingColumn(TableColumnResizer.this._table, point, n);
                if (!TableUtils.isTableColumnResizable(TableColumnResizer.this._table, tableColumn)) {
                    return;
                }
                if (jTableHeader != null) {
                    jTableHeader.setResizingColumn(tableColumn);
                } else {
                    TableColumnResizer.this._resizingColumn = tableColumn;
                }
                TableColumnResizer.this._originalWidth = tableColumn.getWidth();
                if (TableColumnResizer.this._table.getParent() != null && (container = TableColumnResizer.this._table.getParent().getParent()) != null && container instanceof JScrollPane && !container.getComponentOrientation().isLeftToRight()) {
                    JViewport jViewport = ((JScrollPane)container).getViewport();
                    TableColumnResizer.this._originalViewPosition = TableColumnResizer.this._table.getWidth() - (jViewport.getViewPosition().x + jViewport.getWidth());
                }
                if (TableColumnResizer.this._table.getComponentOrientation().isLeftToRight()) {
                    TableColumnResizer.this._mouseXOffset = point.x - tableColumn.getWidth();
                } else {
                    TableColumnResizer.this._mouseXOffset = ((TableColumnResizer)TableColumnResizer.this).convertPointToScreen((Point)point, (Component)TableColumnResizer.this._table).x;
                }
                mouseEvent.consume();
            }

            private void swapCursor() {
                if (TableColumnResizer.this._table instanceof JideTable && !((JideTable)TableColumnResizer.this._table).isColumnResizable() && TableColumnResizer.this._otherCursor == TableColumnResizer.this._table.getCursor()) {
                    return;
                }
                Cursor cursor = TableColumnResizer.this._table.getCursor();
                if (cursor == TableColumnResizer.this._otherCursor) {
                    TableColumnResizer.this._otherCursor = _resizeCursor;
                }
                TableColumnResizer.this._table.setCursor(TableColumnResizer.this._otherCursor);
                TableColumnResizer.this._otherCursor = cursor;
            }

            @Override
            public void mouseMoved(MouseEvent mouseEvent) {
                if (TableUtils.isTableColumnResizable(TableColumnResizer.this._table, TableColumnResizer.this.getResizingColumn(mouseEvent.getPoint())) != (TableColumnResizer.this._table.getCursor() == _resizeCursor)) {
                    this.swapCursor();
                }
            }

            @Override
            public void mouseDragged(MouseEvent mouseEvent) {
                int n = mouseEvent.getX();
                JTableHeader jTableHeader = TableColumnResizer.this._table.getTableHeader();
                TableColumn tableColumn = jTableHeader != null ? jTableHeader.getResizingColumn() : TableColumnResizer.this._resizingColumn;
                boolean bl = TableColumnResizer.this._table.getComponentOrientation().isLeftToRight();
                if (tableColumn != null) {
                    Container container;
                    int n2 = bl ? n - TableColumnResizer.this._mouseXOffset : TableColumnResizer.this._originalWidth + (TableColumnResizer.this._mouseXOffset - ((TableColumnResizer)TableColumnResizer.this).convertPointToScreen((Point)mouseEvent.getPoint(), (Component)TableColumnResizer.this._table).x);
                    if (TableColumnResizer.this._table.getTableHeader() == null) {
                        tableColumn.setMinWidth(n2);
                        tableColumn.setMaxWidth(n2);
                    }
                    tableColumn.setWidth(n2);
                    if (TableColumnResizer.this._table.getParent() == null || (container = TableColumnResizer.this._table.getParent().getParent()) == null || !(container instanceof JScrollPane)) {
                        return;
                    }
                    if (!container.getComponentOrientation().isLeftToRight() && !bl) {
                        JViewport jViewport = ((JScrollPane)container).getViewport();
                        int n3 = jViewport.getWidth();
                        Point point = jViewport.getViewPosition();
                        point.x = Math.max(0, TableColumnResizer.this._table.getWidth() - (TableColumnResizer.this._originalViewPosition + n3));
                        jViewport.setViewPosition(point);
                    }
                    mouseEvent.consume();
                }
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                if (TableColumnResizer.this._originalWidth != -1) {
                    mouseEvent.consume();
                }
                TableColumnResizer.this._originalViewPosition = -1;
                TableColumnResizer.this._originalWidth = -1;
                JTableHeader jTableHeader = TableColumnResizer.this._table.getTableHeader();
                if (jTableHeader != null) {
                    jTableHeader.setResizingColumn(null);
                    jTableHeader.setDraggedColumn(null);
                } else {
                    TableColumnResizer.this._resizingColumn = null;
                }
                AutoScroll autoScroll = AutoScroll.getAutoScroll(TableColumnResizer.this._table);
                if (autoScroll != null) {
                    autoScroll.setEnabled(true);
                }
            }
        };
    }

    public boolean isResizing() {
        JTableHeader jTableHeader = this._table.getTableHeader();
        return jTableHeader != null && jTableHeader.getResizingColumn() != null || this._resizingColumn != null;
    }

    private TableColumn getResizingColumn(Point point) {
        return TableUtils.getResizingColumn(this._table, point, this._table.columnAtPoint(point));
    }

    private Point convertPointToScreen(Point point, Component component) {
        Point point2 = new Point(point);
        do {
            int n;
            int n2;
            if (component instanceof JComponent) {
                n2 = component.getX();
                n = component.getY();
            } else if (component instanceof Applet || component instanceof Window || component instanceof JFrame) {
                try {
                    Point point3 = component.getLocationOnScreen();
                    n2 = point3.x;
                    n = point3.y;
                }
                catch (IllegalComponentStateException illegalComponentStateException) {
                    n2 = component.getX();
                    n = component.getY();
                }
            } else {
                n2 = component.getX();
                n = component.getY();
            }
            point2.x += n2;
            point2.y += n;
        } while (!(component instanceof Window) && !(component instanceof JFrame) && !(component instanceof Applet) && (component = component.getParent()) != null);
        return point2;
    }
}

