/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.grid;

import com.jidesoft.grid.ColumnIdentifierTableModel;
import com.jidesoft.grid.DefaultGroupTableModel;
import com.jidesoft.grid.GridResource;
import com.jidesoft.grid.GroupModelProvider;
import com.jidesoft.grid.GroupTable;
import com.jidesoft.grid.GroupTableColumn;
import com.jidesoft.grid.NestedTableHeader;
import com.jidesoft.grid.TableColumnChooser;
import com.jidesoft.grid.TableColumnChooserDialog;
import com.jidesoft.grid.TableColumnGroup;
import com.jidesoft.grid.TableHeaderPopupMenuCustomizer;
import com.jidesoft.grid.TableHeaderPopupMenuInstaller;
import com.jidesoft.grid.TableModelWrapper;
import com.jidesoft.grid.TableModelWrapperUtils;
import com.jidesoft.grid.TableScrollPane;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.swing.StyledLabel;
import com.jidesoft.swing.StyledLabelBuilder;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class TableColumnChooserPopupMenuCustomizer
implements TableHeaderPopupMenuCustomizer {
    public static final String CLIENT_PROPERTY_CLICK_COLUMN_INDEX = "TableColumnChooser.clickColumnIndex";
    public static final String CONTEXT_MENU_HIDE = "TableColumnChooser.hide";
    public static final String CONTEXT_MENU_SHOW_ALL = "TableColumnChooser.showAll";
    public static final String CONTEXT_MENU_OTHER_COLUMNS = "TableColumnChooser.otherColumns";
    public static final String CONTEXT_MENU_RESET_COLUMNS = "TableColumnChooser.resetColumns";
    public static final String CONTEXT_MENU_MORE = "TableColumnChooser.more";
    private int[] _hiddenColumns;
    private int[] _fixedColumns;
    private int[] _favoriteColumns;
    private String[] _displayColumnNames;
    protected Locale _locale;

    public String[] getDisplayColumnNames() {
        return this._displayColumnNames;
    }

    public void setDisplayColumnNames(String[] stringArray) {
        this._displayColumnNames = stringArray;
    }

    public int[] getHiddenColumns() {
        return this._hiddenColumns;
    }

    public void setHiddenColumns(int[] nArray) {
        this._hiddenColumns = nArray;
    }

    public int[] getFixedColumns() {
        return this._fixedColumns;
    }

    public void setFixedColumns(int[] nArray) {
        this._fixedColumns = nArray;
    }

    public int[] getFavoriteColumns() {
        return this._favoriteColumns;
    }

    public void setFavoriteColumns(int[] nArray) {
        this._favoriteColumns = nArray;
    }

    protected String getResourceString(String string) {
        return GridResource.getResourceBundle(this._locale != null ? this._locale : Locale.getDefault()).getString(string);
    }

    protected String getDisplayColumnName(JTable jTable, int n) {
        String string;
        String[] stringArray = this.getDisplayColumnNames();
        if (stringArray != null) {
            string = stringArray[n];
        } else {
            String string2 = jTable.getModel().getColumnName(n);
            StyledLabel styledLabel = string2 == null ? null : StyledLabelBuilder.createStyledLabel(string2);
            String string3 = string = styledLabel == null ? string2 : styledLabel.getText();
        }
        return string != null ? (string.length() > 100 ? string.substring(0, 100) + "..." : string) : null;
    }

    protected Object getIdentifier(JTable jTable, int n) {
        int n2 = jTable.convertColumnIndexToView(n);
        if (n2 >= 0) {
            return jTable.getColumnModel().getColumn(n2).getIdentifier();
        }
        Object object = jTable.getClientProperty("HiddenIdentifiersList");
        if (object instanceof List) {
            for (Object e : (List)object) {
                Object object2 = jTable.getClientProperty("TableColumnIdentifier:" + e);
                if (!(object2 instanceof TableColumn) || ((TableColumn)object2).getModelIndex() != n) continue;
                return e;
            }
        }
        if (jTable.getModel() instanceof ColumnIdentifierTableModel) {
            return ((ColumnIdentifierTableModel)((Object)jTable.getModel())).getColumnIdentifier(n);
        }
        return jTable.getModel().getColumnName(n);
    }

    @Override
    public void customizePopupMenu(JTableHeader jTableHeader, JPopupMenu jPopupMenu, int n) {
        int n2;
        JMenuItem jMenuItem;
        Object object2;
        int n3;
        final JTable jTable = jTableHeader.getTable();
        final int[] nArray = this.getFixedColumns();
        final int[] nArray2 = this.getHiddenColumns();
        if (nArray != null) {
            Arrays.sort(nArray);
        }
        if (nArray2 != null) {
            Arrays.sort(nArray2);
        }
        TableColumn tableColumn = this.getClickingTableColumn(jTableHeader, n);
        final int n4 = n >= 0 ? jTable.convertColumnIndexToModel(n) : n;
        int n5 = TableColumnChooser.getVisibleColumns(jTable).size();
        JMenuItem jMenuItem2 = null;
        this._locale = jTableHeader.getLocale();
        TableModel tableModel = TableModelWrapperUtils.getActualTableModel(jTable.getModel(), GroupModelProvider.class);
        if (tableColumn != null) {
            int n6 = n3 = tableModel instanceof TableModelWrapper ? TableModelWrapperUtils.getActualColumnAt(jTable.getModel(), n4, ((TableModelWrapper)((Object)tableModel)).getActualModel()) : n4;
            if (!(nArray != null && Arrays.binarySearch(nArray, n3) >= 0 || nArray2 != null && Arrays.binarySearch(nArray2, n3) >= 0)) {
                int n7 = n4;
                if (n4 >= 0 && tableModel instanceof DefaultGroupTableModel && jTable instanceof GroupTable && !((GroupTable)jTable).isSpecialColumnsHidable()) {
                    object2 = jTable.getModel().getColumnName(n4);
                    if (JideSwingUtilities.equals(((DefaultGroupTableModel)tableModel).getSeparateGroupColumnName(), object2) || JideSwingUtilities.equals(((DefaultGroupTableModel)tableModel).getCountColumnName(), object2)) {
                        n7 = -1;
                    }
                }
                if (n7 >= 0) {
                    jMenuItem = new JMenuItem();
                    jMenuItem.setAction(new AbstractAction(this.getResourceString(CONTEXT_MENU_HIDE) + " \"" + this.getDisplayColumnName(jTable, n4) + "\""){
                        private static final long serialVersionUID = 5868830487767687905L;

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            TableColumnChooserPopupMenuCustomizer.this.hideColumn(jTable, n4);
                        }
                    });
                    jMenuItem.setName(CONTEXT_MENU_HIDE);
                    jPopupMenu.add(jMenuItem);
                    jMenuItem.setEnabled(n5 > 1);
                }
            }
        }
        n3 = 0;
        JTable[] jTableArray = TableColumnChooser.getAllTables(jTable);
        for (JTable object3 : jTableArray) {
            if (!TableColumnChooser.hasHiddenColumns(object3)) continue;
            n3 = 1;
            break;
        }
        object2 = TableColumnChooser.getColumnGroups(jTable);
        if (n3 != 0) {
            jMenuItem = new JMenuItem(new AbstractAction(this.getResourceString(CONTEXT_MENU_SHOW_ALL)){
                private static final long serialVersionUID = -9005537818593413134L;

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    List list = TableColumnChooserPopupMenuCustomizer.this.getColumnsToHide(jTable);
                    TableColumnChooserPopupMenuCustomizer.this.showAllColumns(jTable);
                    TableColumnChooserPopupMenuCustomizer.this.hideHiddenColumns(list, jTable);
                }
            });
            jMenuItem.setName(CONTEXT_MENU_SHOW_ALL);
            jPopupMenu.add(jMenuItem);
        }
        TableHeaderPopupMenuInstaller.addSeparatorIfNecessary(jPopupMenu);
        JMenu jMenu = new JMenu(this.getResourceString(CONTEXT_MENU_OTHER_COLUMNS));
        jMenu.setName(CONTEXT_MENU_OTHER_COLUMNS);
        int n8 = 0;
        Set<Integer> set = TableColumnChooser.getVisibleColumns(jTable);
        ArrayList<JCheckBoxMenuItem> arrayList = new ArrayList<JCheckBoxMenuItem>();
        ArrayList<JCheckBoxMenuItem> arrayList2 = new ArrayList<JCheckBoxMenuItem>();
        for (int jMenuItemArray = 0; jMenuItemArray < this.getColumnCount(jTable); ++jMenuItemArray) {
            int n7;
            Object bl;
            int jMenuItemArray2;
            int n9 = jMenuItemArray2 = tableModel instanceof TableModelWrapper ? TableModelWrapperUtils.getActualColumnAt(jTable.getModel(), jMenuItemArray, ((TableModelWrapper)((Object)tableModel)).getActualModel()) : jMenuItemArray;
            if (nArray2 != null && Arrays.binarySearch(nArray2, jMenuItemArray2) >= 0) continue;
            if (tableModel instanceof DefaultGroupTableModel && jTable instanceof GroupTable && !((GroupTable)jTable).isSpecialColumnsHidable()) {
                int groupTableColumn = TableModelWrapperUtils.getActualColumnAt(jTable.getModel(), jMenuItemArray, tableModel);
                bl = tableModel.getColumnName(groupTableColumn);
                if (JideSwingUtilities.equals(((DefaultGroupTableModel)tableModel).getSeparateGroupColumnName(), bl) || JideSwingUtilities.equals(((DefaultGroupTableModel)tableModel).getCountColumnName(), bl)) continue;
            }
            if (object2 != null && ((Vector)object2).size() > 0) {
                GroupTableColumn jCheckBoxMenuItem = new GroupTableColumn(jMenuItemArray);
                jCheckBoxMenuItem = GroupTableColumn.getGroupPopupMenuFlag((Vector<TableColumn>)object2, jCheckBoxMenuItem);
                if (jCheckBoxMenuItem._index0 >= 0) {
                    if (jCheckBoxMenuItem._leavesAhead0 != 0) continue;
                    bl = this.customizePopupMenuForGroup(jTableHeader, n, (TableColumnGroup)((Vector)object2).get(jCheckBoxMenuItem._index0), jMenuItem2);
                    jMenu.add((JMenuItem)bl);
                    continue;
                }
            }
            JCheckBoxMenuItem object6 = new JCheckBoxMenuItem(this.getDisplayColumnName(jTable, jMenuItemArray));
            object6.setName(this.getDisplayColumnName(jTable, jMenuItemArray));
            boolean n13 = set.contains(jMenuItemArray);
            final JTable jTable2 = TableColumnChooser.getActualTable(jTable, jMenuItemArray);
            if (jTable.getClientProperty("TableScrollPane.Parent") != null) {
                n7 = TableColumnChooser.getActualIndex(jTable, jMenuItemArray);
                object6.putClientProperty(CLIENT_PROPERTY_CLICK_COLUMN_INDEX, n7);
            } else {
                object6.putClientProperty(CLIENT_PROPERTY_CLICK_COLUMN_INDEX, n == -1 ? jMenuItemArray : n);
            }
            n7 = jMenuItemArray;
            final Object object = this.getIdentifier(jTable, jMenuItemArray) != null ? this.getIdentifier(jTable, jMenuItemArray) : jTable.getModel().getColumnName(jMenuItemArray);
            object6.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    AbstractButton abstractButton = (AbstractButton)actionEvent.getSource();
                    boolean bl = abstractButton.isSelected();
                    if (!bl) {
                        TableColumnChooserPopupMenuCustomizer.this.hideColumn(jTable2, n7);
                    } else {
                        TableColumnChooserPopupMenuCustomizer.this.showColumn(jTable2, n7, object);
                    }
                }
            });
            object6.setSelected(n13);
            if (n8 == 0 && (nArray == null || nArray.length == 0) && n13 && n5 <= 1) {
                object6.setEnabled(false);
                n8 = 1;
            } else if (nArray != null && nArray.length != 0) {
                object6.setEnabled(Arrays.binarySearch(nArray, jMenuItemArray2) < 0);
            }
            int[] nArray3 = this.getFavoriteColumns();
            if (nArray3 == null || Arrays.binarySearch(nArray3, jMenuItemArray2) >= 0) {
                arrayList.add(object6);
                continue;
            }
            arrayList2.add(object6);
        }
        JMenuItem[] jMenuItemArray = arrayList.toArray(new JMenuItem[arrayList.size()]);
        JMenuItem[] jMenuItemArray2 = arrayList2.toArray(new JMenuItem[arrayList2.size()]);
        Object object = jTable.getClientProperty("ColumnSortOrder");
        if (object instanceof Integer) {
            int n22 = (Integer)object;
            switch (n22) {
                case 1: {
                    Arrays.sort(jMenuItemArray, new Comparator<JMenuItem>(){

                        @Override
                        public int compare(JMenuItem jMenuItem, JMenuItem jMenuItem2) {
                            return jMenuItem.getText().compareToIgnoreCase(jMenuItem2.getText());
                        }
                    });
                    Arrays.sort(jMenuItemArray2, new Comparator<JMenuItem>(){

                        @Override
                        public int compare(JMenuItem jMenuItem, JMenuItem jMenuItem2) {
                            return jMenuItem.getText().compareToIgnoreCase(jMenuItem2.getText());
                        }
                    });
                    break;
                }
                case -1: {
                    Arrays.sort(jMenuItemArray, new Comparator<JMenuItem>(){

                        @Override
                        public int compare(JMenuItem jMenuItem, JMenuItem jMenuItem2) {
                            return jMenuItem2.getText().compareToIgnoreCase(jMenuItem.getText());
                        }
                    });
                    Arrays.sort(jMenuItemArray2, new Comparator<JMenuItem>(){

                        @Override
                        public int compare(JMenuItem jMenuItem, JMenuItem jMenuItem2) {
                            return jMenuItem2.getText().compareToIgnoreCase(jMenuItem.getText());
                        }
                    });
                }
            }
        }
        for (n2 = 0; n2 < jMenuItemArray.length; ++n2) {
            jPopupMenu.add(jMenuItemArray[n2]);
        }
        for (n2 = 0; n2 < jMenuItemArray2.length; ++n2) {
            jMenu.add(jMenuItemArray2[n2]);
        }
        if (jMenu.getPopupMenu().getComponentCount() > 0) {
            jPopupMenu.add(jMenu);
        }
        jPopupMenu.addSeparator();
        jMenuItem = new JMenuItem(new AbstractAction(this.getResourceString(CONTEXT_MENU_RESET_COLUMNS)){
            private static final long serialVersionUID = 1363294215712070529L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                List list = TableColumnChooserPopupMenuCustomizer.this.getColumnsToHide(jTable);
                TableColumnChooser.resetColumnsToDefault(jTable);
                TableColumnChooserPopupMenuCustomizer.this.hideHiddenColumns(list, jTable);
            }
        });
        jMenuItem.setName(CONTEXT_MENU_RESET_COLUMNS);
        jPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(new AbstractAction(this.getResourceString(CONTEXT_MENU_MORE)){
            private static final long serialVersionUID = 4928261057050416186L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Dialog dialog = TableColumnChooserPopupMenuCustomizer.this.createMoreDialog(jTable, nArray, nArray2);
                if (dialog != null) {
                    dialog.setVisible(true);
                }
            }
        });
        jMenuItem.setName(CONTEXT_MENU_MORE);
        jPopupMenu.add(jMenuItem);
    }

    protected Dialog createMoreDialog(JTable jTable, int[] nArray, int[] nArray2) {
        Window window = JideSwingUtilities.getWindowForComponent(jTable);
        TableColumnChooserDialog tableColumnChooserDialog = this.createTableColumnChooserDialog(window, GridResource.getResourceBundle(jTable.getLocale()).getString("TableColumnChooser.dialogTitle"), jTable);
        if (tableColumnChooserDialog == null) {
            return null;
        }
        tableColumnChooserDialog.setFixedColumns(nArray);
        tableColumnChooserDialog.setHiddenColumns(nArray2);
        tableColumnChooserDialog.setDescriptions(this.getDisplayColumnNames());
        tableColumnChooserDialog.pack();
        Component component = JideSwingUtilities.getScrollPane(jTable);
        tableColumnChooserDialog.setLocationRelativeTo(component == null ? jTable : component);
        return tableColumnChooserDialog;
    }

    private TableColumn getClickingTableColumn(JTableHeader jTableHeader, int n) {
        if (jTableHeader == null) {
            return null;
        }
        if (n >= 0 && n < jTableHeader.getColumnModel().getColumnCount()) {
            return jTableHeader.getColumnModel().getColumn(n);
        }
        TableColumnGroup tableColumnGroup = null;
        if (jTableHeader instanceof NestedTableHeader && n <= -2) {
            NestedTableHeader nestedTableHeader = (NestedTableHeader)jTableHeader;
            Vector vector = nestedTableHeader._columnGroups;
            if (vector != null) {
                for (int i = 0 - n; i >= 2; i /= 10) {
                    tableColumnGroup = (TableColumnGroup)vector.get(i % 10 - 2);
                    vector = tableColumnGroup._columns;
                }
            }
        }
        return tableColumnGroup;
    }

    private JMenu customizePopupMenuForGroup(JTableHeader jTableHeader, int n, TableColumnGroup tableColumnGroup, JMenuItem jMenuItem) {
        int[] nArray;
        String string = tableColumnGroup.getHeaderValue().toString();
        if (string != null && string.length() > 100) {
            string = string.substring(0, 100) + "...";
        }
        JMenu jMenu = new JMenu(string);
        Vector vector = tableColumnGroup._columns;
        if (vector == null) {
            return jMenu;
        }
        int[] nArray2 = this.getFixedColumns();
        if (nArray2 != null) {
            Arrays.sort(nArray2);
        }
        if ((nArray = this.getHiddenColumns()) != null) {
            Arrays.sort(nArray);
        }
        JTable jTable = jTableHeader.getTable();
        int[] nArray3 = this.getFavoriteColumns();
        int n2 = TableColumnChooser.getVisibleColumns(jTable).size();
        Set<Integer> set = TableColumnChooser.getVisibleColumns(jTable);
        TableColumn tableColumn = this.getClickingTableColumn(jTableHeader, n);
        for (int i = 0; i < vector.size(); ++i) {
            Object e = vector.get(i);
            if (!(e instanceof TableColumn)) continue;
            TableColumn tableColumn2 = (TableColumn)e;
            final int n3 = tableColumn2.getModelIndex();
            if (nArray != null && Arrays.binarySearch(nArray, n3) >= 0) continue;
            if (tableColumn2 instanceof TableColumnGroup) {
                jMenu.add(this.customizePopupMenuForGroup(jTableHeader, n, (TableColumnGroup)tableColumn2, jMenuItem));
                continue;
            }
            if (nArray3 != null && Arrays.binarySearch(nArray3, n3) >= 0) continue;
            final JTable jTable2 = TableColumnChooser.getActualTable(jTable, n3);
            boolean bl = set.contains(n3);
            String string2 = this.getDisplayColumnName(jTable, n3);
            JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(string2);
            jCheckBoxMenuItem.setName(string2);
            if (jTable.getClientProperty("TableScrollPane.Parent") != null) {
                int n4 = TableColumnChooser.getActualIndex(jTable, n3);
                jCheckBoxMenuItem.putClientProperty(CLIENT_PROPERTY_CLICK_COLUMN_INDEX, n4);
            } else {
                jCheckBoxMenuItem.putClientProperty(CLIENT_PROPERTY_CLICK_COLUMN_INDEX, n == -1 ? n3 : n);
            }
            final Object object = this.getIdentifier(jTable, n3) != null ? this.getIdentifier(jTable, n3) : jTable.getModel().getColumnName(n3);
            jCheckBoxMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    AbstractButton abstractButton = (AbstractButton)actionEvent.getSource();
                    boolean bl = abstractButton.isSelected();
                    if (!bl) {
                        TableColumnChooserPopupMenuCustomizer.this.hideColumn(jTable2, n3);
                    } else {
                        TableColumnChooserPopupMenuCustomizer.this.showColumn(jTable2, n3, object);
                    }
                }
            });
            jCheckBoxMenuItem.setSelected(bl);
            if ((nArray2 == null || nArray2.length == 0) && bl && n2 <= 1) {
                jCheckBoxMenuItem.setEnabled(false);
            } else if (nArray2 != null && nArray2.length != 0) {
                jCheckBoxMenuItem.setEnabled(Arrays.binarySearch(nArray2, n3) < 0);
            }
            jMenu.add(jCheckBoxMenuItem);
        }
        return jMenu;
    }

    private boolean isColumnInGroup(TableColumn tableColumn, TableColumnGroup tableColumnGroup) {
        if (tableColumn == null || tableColumnGroup == null || tableColumnGroup._columns == null) {
            return false;
        }
        if (tableColumnGroup._columns.contains(tableColumn)) {
            return true;
        }
        for (Object e : tableColumnGroup._columns) {
            if (!(e instanceof TableColumnGroup) || !this.isColumnInGroup(tableColumn, (TableColumnGroup)e)) continue;
            return true;
        }
        return false;
    }

    private List<Integer> getColumnsToHide(JTable jTable) {
        ArrayList<Integer> arrayList;
        block9: {
            arrayList = new ArrayList<Integer>();
            if (this._hiddenColumns == null) break block9;
            if (jTable.getClientProperty("TableScrollPane.Parent") instanceof TableScrollPane) {
                TableScrollPane tableScrollPane = (TableScrollPane)jTable.getClientProperty("TableScrollPane.Parent");
                for (int n : this._hiddenColumns) {
                    int n2 = tableScrollPane.getModel().getColumnType(n);
                    JTable jTable2 = null;
                    if (n2 == 1) {
                        jTable2 = tableScrollPane.getRowHeaderTable();
                    } else if (n2 == 2) {
                        jTable2 = tableScrollPane.getRowFooterTable();
                    } else if (n2 == 0) {
                        jTable2 = tableScrollPane.getMainTable();
                    }
                    if (jTable2 == null || jTable2.convertColumnIndexToView(n) >= 0) continue;
                    arrayList.add(n);
                }
            } else {
                for (int n : this._hiddenColumns) {
                    if (jTable.convertColumnIndexToView(n) >= 0) continue;
                    arrayList.add(n);
                }
            }
        }
        return arrayList;
    }

    private void hideNonFixedColumns(int[] nArray, JTable jTable) {
        int n;
        int n2;
        if (nArray == null || jTable == null) {
            return;
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int[] nArray2 = nArray;
        int n3 = nArray2.length;
        for (n2 = 0; n2 < n3; ++n2) {
            n = nArray2[n2];
            arrayList.add(n);
        }
        int n4 = jTable.getModel().getColumnCount();
        if (jTable.getClientProperty("TableScrollPane.Parent") instanceof TableScrollPane) {
            TableScrollPane tableScrollPane = (TableScrollPane)jTable.getClientProperty("TableScrollPane.Parent");
            for (n2 = 0; n2 < n4; ++n2) {
                n = tableScrollPane.getModel().getColumnType(n2);
                JTable jTable2 = null;
                if (n == 1) {
                    jTable2 = tableScrollPane.getRowHeaderTable();
                } else if (n == 2) {
                    jTable2 = tableScrollPane.getRowFooterTable();
                } else if (n == 0) {
                    jTable2 = tableScrollPane.getMainTable();
                }
                if (jTable2 == null || arrayList.contains(n2)) continue;
                TableColumnChooser.hideColumn(jTable2, n2);
            }
        } else {
            for (n3 = 0; n3 < n4; ++n3) {
                if (arrayList.contains(n3)) continue;
                TableColumnChooser.hideColumn(jTable, n3);
            }
        }
    }

    private void hideHiddenColumns(List<Integer> list, JTable jTable) {
        if (jTable.getClientProperty("TableScrollPane.Parent") instanceof TableScrollPane) {
            TableScrollPane tableScrollPane = (TableScrollPane)jTable.getClientProperty("TableScrollPane.Parent");
            for (int n : list) {
                int n2 = tableScrollPane.getModel().getColumnType(n);
                JTable jTable2 = null;
                if (n2 == 1) {
                    jTable2 = tableScrollPane.getRowHeaderTable();
                } else if (n2 == 2) {
                    jTable2 = tableScrollPane.getRowFooterTable();
                } else if (n2 == 0) {
                    jTable2 = tableScrollPane.getMainTable();
                }
                if (jTable2 == null) continue;
                TableColumnChooser.hideColumn(jTable2, n);
            }
        } else {
            for (int n : list) {
                TableColumnChooser.hideColumn(jTable, n);
            }
        }
    }

    protected TableColumnChooserDialog createTableColumnChooserDialog(Window window, String string, JTable jTable) {
        if (window instanceof Frame) {
            return new TableColumnChooserDialog((Frame)window, string, jTable);
        }
        if (window instanceof Dialog) {
            return new TableColumnChooserDialog((Dialog)window, string, jTable);
        }
        return null;
    }

    protected int getColumnCount(JTable jTable) {
        return jTable.getModel().getColumnCount();
    }

    protected void showAllColumns(JTable jTable) {
        JTable[] jTableArray;
        for (JTable jTable2 : jTableArray = TableColumnChooser.getAllTables(jTable)) {
            if (!TableColumnChooser.hasHiddenColumns(jTable2)) continue;
            TableColumnChooser.showAllColumns(jTable2);
        }
    }

    protected void hideColumn(JTable jTable, int n) {
        TableColumnChooser.hideColumn(jTable, n);
    }

    @Deprecated
    protected void showColumn(JTable jTable, int n) {
        TableColumnChooser.showColumn(jTable, n, -1);
    }

    protected void showColumn(JTable jTable, int n, Object object) {
        TableColumnChooser.showColumn(jTable, "" + object, n, -1);
    }

    private boolean isFixed(int n) {
        int[] nArray = this.getFixedColumns();
        if (nArray != null && n >= 0) {
            for (int n2 : nArray) {
                if (n2 != n) continue;
                return true;
            }
        }
        return false;
    }
}

