/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.grid;

import com.jidesoft.dialog.ButtonPanel;
import com.jidesoft.dialog.StandardDialog;
import com.jidesoft.grid.DefaultGroupTableModel;
import com.jidesoft.grid.GridResource;
import com.jidesoft.grid.GroupTable;
import com.jidesoft.grid.GroupTableColumn;
import com.jidesoft.grid.TableColumnChooser;
import com.jidesoft.grid.TableColumnGroup;
import com.jidesoft.grid.TableModelWrapperUtils;
import com.jidesoft.grid.TableScrollPane;
import com.jidesoft.list.DefaultDualListModel;
import com.jidesoft.list.DualList;
import com.jidesoft.list.ListModelWrapperUtils;
import com.jidesoft.list.SortableListModel;
import com.jidesoft.swing.CheckBoxList;
import com.jidesoft.swing.CheckBoxTree;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.swing.JideTitledBorder;
import com.jidesoft.swing.PartialEtchedBorder;
import com.jidesoft.swing.SearchableUtils;
import com.jidesoft.swing.StyledLabel;
import com.jidesoft.swing.StyledLabelBuilder;
import com.jidesoft.tree.TreeUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.AbstractListModel;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.TableColumn;
import javax.swing.text.Position;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class TableColumnChooserDialog
extends StandardDialog {
    protected JTable _table;
    protected CheckBoxList _list;
    protected CheckBoxTree _tree;
    protected DualList _dualList;
    protected boolean[] _hidableColumns;
    protected String[] _descriptions;
    protected int[] _fixedColumns;
    protected List<Integer> _hiddenColumns;
    protected JLabel _label;
    JButton _okButton;
    private Action _okAction;
    private int[] _columnIndices;
    private int[] _searchingColumnIndices;
    static final String LABEL_TEXT_NORMAL = "TableColumnChooserDialog.dispayMessage";
    static final String LABEL_TEXT_ERROR = "TableColumnChooserDialog.errorMessage";

    public TableColumnChooserDialog(Dialog dialog, String string, JTable jTable) throws HeadlessException {
        super(dialog, string);
        this._table = jTable;
    }

    public TableColumnChooserDialog(Frame frame, String string, JTable jTable) throws HeadlessException {
        super(frame, string);
        this._table = jTable;
    }

    private String getDisplayName(int n) {
        if (this.getDescriptions() != null && this.getDescriptions().length > n && this.getDescriptions()[n] != null) {
            return this.getDescriptions()[n];
        }
        return this.getName(n);
    }

    @Override
    public JComponent createBannerPanel() {
        return null;
    }

    @Override
    public JComponent createContentPanel() {
        if (this._table == null) {
            return null;
        }
        Object object = this._table.getClientProperty("ColumnChooserDialogStyle");
        if (object == null) {
            JTable jTable;
            JTable[] jTableArray;
            JTable[] jTableArray2 = jTableArray = TableColumnChooser.getAllTables(this._table);
            int n = jTableArray2.length;
            for (int i = 0; i < n && (object = (jTable = jTableArray2[i]).getClientProperty("ColumnChooserDialogStyle")) == null; ++i) {
            }
        }
        if (object != null) {
            if (object.equals("Tree")) {
                return this.createCheckBoxTreeContentPanel();
            }
            if (object.equals("DualList")) {
                return this.createDualListContentPanel();
            }
        }
        return this.createCheckBoxListContentPanel();
    }

    private JComponent createDualListContentPanel() {
        ArrayList<JTable> arrayList;
        DefaultDualListModel defaultDualListModel = new DefaultDualListModel(){
            private static final long serialVersionUID = -3138418055765941126L;

            @Override
            public int getSize() {
                return TableColumnChooserDialog.this._table.getModel().getColumnCount();
            }

            public Object getElementAt(int n) {
                if (n >= TableColumnChooserDialog.this._table.getModel().getColumnCount() || n < 0) {
                    return null;
                }
                return TableColumnChooserDialog.this.getDisplayName(n);
            }
        };
        if (this.getHiddenColumns() != null) {
            arrayList = this.getHiddenColumns().iterator();
            while (arrayList.hasNext()) {
                int n = (Integer)arrayList.next();
                defaultDualListModel.addFreezeIndex(n);
            }
        }
        if (this.getFixedColumns() != null) {
            for (ArrayList arrayList2 : (ArrayList<JTable>)this.getFixedColumns()) {
                defaultDualListModel.addFreezeIndex((int)arrayList2);
            }
        }
        this._dualList = new DualList(defaultDualListModel);
        arrayList = new ArrayList<JTable>();
        if (this._table.getClientProperty("TableScrollPane.Parent") instanceof TableScrollPane) {
            TableScrollPane tableScrollPane = (TableScrollPane)this._table.getClientProperty("TableScrollPane.Parent");
            arrayList.add(tableScrollPane.getRowHeaderTable());
            arrayList.add(tableScrollPane.getMainTable());
            arrayList.add(tableScrollPane.getRowFooterTable());
        } else {
            arrayList.add(this._table);
        }
        for (JTable jTable : arrayList) {
            for (int i = 0; i < jTable.getColumnCount(); ++i) {
                int n = jTable.convertColumnIndexToModel(i);
                defaultDualListModel.addSelectionInterval(n, n);
            }
        }
        this._dualList.setVisibleRowCount(10);
        defaultDualListModel.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (TableColumnChooserDialog.this._okAction != null) {
                    TableColumnChooserDialog.this._okAction.setEnabled(TableColumnChooserDialog.this._dualList.getSelectedIndices().length > 0);
                }
            }
        });
        this._dualList.getOriginalListPane().setBorder(new JideTitledBorder(new PartialEtchedBorder(1, 1), this.getResourceString("TableColumnChooserDialog.availableColumns")));
        this._dualList.getSelectedListPane().setBorder(new JideTitledBorder(new PartialEtchedBorder(1, 1), this.getResourceString("TableColumnChooserDialog.visibleColumns")));
        JPanel jPanel = new JPanel(new BorderLayout(5, 5));
        jPanel.add((Component)this._dualList, "Center");
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 6, 10));
        return jPanel;
    }

    private JComponent createCheckBoxListContentPanel() {
        Integer n;
        AbstractListModel abstractListModel = new AbstractListModel(){
            private static final long serialVersionUID = -3138418055765941126L;

            @Override
            public int getSize() {
                List<Integer> list = TableColumnChooserDialog.this.getHiddenColumns();
                return TableColumnChooserDialog.this._table.getModel().getColumnCount() - (list != null ? list.size() : 0);
            }

            @Override
            public Object getElementAt(int n) {
                if ((n = TableColumnChooserDialog.this.getActualModelIndex(n)) >= TableColumnChooserDialog.this._table.getModel().getColumnCount()) {
                    return null;
                }
                return TableColumnChooserDialog.this.getDisplayName(n);
            }
        };
        SortableListModel sortableListModel = new SortableListModel(abstractListModel);
        Object object = this._table.getClientProperty("ColumnSortOrder");
        if (object instanceof Integer && ((n = (Integer)object) == 0 || n == 1 || n == -1)) {
            sortableListModel.setSortOrder(n);
        }
        this._list = new CheckBoxList(sortableListModel){

            @Override
            public int getNextMatch(String string, int n, Position.Bias bias) {
                return -1;
            }

            @Override
            public Dimension getPreferredScrollableViewportSize() {
                Dimension dimension = super.getPreferredScrollableViewportSize();
                return new Dimension(300, dimension.height);
            }

            @Override
            public boolean isCheckBoxEnabled(int n) {
                int n2 = ListModelWrapperUtils.getActualIndexAt(this.getModel(), n);
                int n3 = TableColumnChooserDialog.this.getActualModelIndex(n2);
                if (TableColumnChooserDialog.this.getColumnIndices() != null && !TableColumnChooserDialog.this.isColumnIndex(n3)) {
                    return false;
                }
                boolean[] blArray = TableColumnChooserDialog.this.getHidableColumns();
                int[] nArray = TableColumnChooserDialog.this.getFixedColumns();
                if (blArray != null) {
                    return n3 < 0 || blArray.length <= n3 || !blArray[n3];
                }
                if (nArray != null) {
                    for (int n4 : nArray) {
                        if (n4 != n3) continue;
                        return false;
                    }
                }
                return true;
            }
        };
        for (int i = 0; i < this._table.getModel().getColumnCount(); ++i) {
            if (this.getColumnIndices() != null && !this.isColumnIndex(i) || this.getSearchingColumnIndices() != null && !this.isSearchingColumnIndex(i) || !this.isColumnVisible(i)) continue;
            int n2 = ListModelWrapperUtils.getIndexAt(this._list.getModel(), this.getViewListIndex(i));
            this._list.getCheckBoxListSelectionModel().addSelectionInterval(n2, n2);
        }
        this._list.setVisibleRowCount(10);
        SearchableUtils.installSearchable(this._list);
        final String string = this.getLabelText(LABEL_TEXT_NORMAL);
        final String string2 = this.getLabelText(LABEL_TEXT_ERROR);
        this._list.getCheckBoxListSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (TableColumnChooserDialog.this._okAction == null || TableColumnChooserDialog.this._label == null) {
                    return;
                }
                if (TableColumnChooserDialog.this._hiddenColumns != null && TableColumnChooserDialog.this._hiddenColumns.size() >= 1) {
                    return;
                }
                if (TableColumnChooserDialog.this.getSelectedColumns().length == 0) {
                    TableColumnChooserDialog.this._label.setText(string2);
                    TableColumnChooserDialog.this._label.setForeground(Color.RED);
                    TableColumnChooserDialog.this._okAction.setEnabled(false);
                } else {
                    TableColumnChooserDialog.this._label.setText(string);
                    TableColumnChooserDialog.this._label.setForeground(Color.BLACK);
                    TableColumnChooserDialog.this._okAction.setEnabled(true);
                }
            }
        });
        this._label = new JLabel(string);
        JPanel jPanel = new JPanel(new BorderLayout(5, 5));
        jPanel.add((Component)this._label, "First");
        jPanel.add((Component)new JScrollPane(this._list), "Center");
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 6, 10));
        return jPanel;
    }

    String getLabelText(String string) {
        if (string == null) {
            return this.getResourceString(LABEL_TEXT_NORMAL);
        }
        return this.getResourceString(string);
    }

    private ColumnMutableTreeNode composeGroupNode(TableColumnGroup tableColumnGroup, GroupTableColumn groupTableColumn) {
        if (tableColumnGroup == null) {
            return null;
        }
        ColumnMutableTreeNode columnMutableTreeNode = new ColumnMutableTreeNode(tableColumnGroup.getHeaderValue());
        Vector vector = tableColumnGroup._columns;
        for (Object e : vector) {
            ColumnMutableTreeNode columnMutableTreeNode2;
            if (!(e instanceof TableColumnGroup)) {
                String string = ((TableColumn)e).getHeaderValue().toString();
                columnMutableTreeNode2 = new ColumnMutableTreeNode(string, groupTableColumn._modelIndex++);
            } else {
                columnMutableTreeNode2 = this.composeGroupNode((TableColumnGroup)e, groupTableColumn);
            }
            columnMutableTreeNode.add(columnMutableTreeNode2);
        }
        return columnMutableTreeNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JComponent createCheckBoxTreeContentPanel() {
        Serializable serializable;
        String string = "";
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(string);
        if (this._table != null) {
            serializable = new DefaultTreeModel(defaultMutableTreeNode);
            this.buildTreeNodes(this._table, defaultMutableTreeNode);
            this._tree = new CheckBoxTree((TreeModel)((Object)serializable)){

                @Override
                public Dimension getPreferredScrollableViewportSize() {
                    return new Dimension(300, 300);
                }

                @Override
                public boolean isCheckBoxVisible(TreePath treePath) {
                    Object object = treePath.getLastPathComponent();
                    int n = -1;
                    if (object instanceof ColumnMutableTreeNode) {
                        n = ((ColumnMutableTreeNode)object).getModelIndex();
                    }
                    if (n >= 0 && TableColumnChooserDialog.this.getColumnIndices() != null && !TableColumnChooserDialog.this.isColumnIndex(n)) {
                        return false;
                    }
                    return super.isCheckBoxVisible(treePath);
                }

                @Override
                public boolean isCheckBoxEnabled(TreePath treePath) {
                    Object object = treePath.getLastPathComponent();
                    int n = -1;
                    if (object instanceof ColumnMutableTreeNode) {
                        n = ((ColumnMutableTreeNode)object).getModelIndex();
                    }
                    if (n >= 0 && TableColumnChooserDialog.this.getColumnIndices() != null && !TableColumnChooserDialog.this.isColumnIndex(n)) {
                        return false;
                    }
                    return !TableColumnChooserDialog.this.isHidable(n) && !TableColumnChooserDialog.this.isFixed(n);
                }
            };
            if (this._tree.getActualCellRenderer() instanceof DefaultTreeCellRenderer) {
                DefaultTreeCellRenderer defaultTreeCellRenderer = (DefaultTreeCellRenderer)this._tree.getActualCellRenderer();
                defaultTreeCellRenderer.setLeafIcon(null);
                defaultTreeCellRenderer.setIcon(null);
            }
            this._tree.setClickInCheckBoxOnly(true);
            this._tree.setRootVisible(false);
            this._tree.setRowHeight(-1);
            SearchableUtils.installSearchable(this._tree);
            TreeUtils.expandAll(this._tree, true);
            for (int i = 0; i < this._table.getModel().getColumnCount(); ++i) {
                int n;
                if (this.getColumnIndices() != null && !this.isColumnIndex(i) || this.getSearchingColumnIndices() != null && !this.isSearchingColumnIndex(i) || (n = this.convertColumnIndexToView(this._table, i)) < 0) continue;
                int n2 = GroupTableColumn.getViewTreeIndex(this._tree, i);
                this._tree.getCheckBoxTreeSelectionModel().addSelectionPath(this._tree.getPathForRow(n2));
            }
            TreeSelectionListener treeSelectionListener = new TreeSelectionListener(){

                @Override
                public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                    Object[] objectArray;
                    int[] nArray = TableColumnChooserDialog.this.getFixedColumns();
                    if (nArray != null) {
                        objectArray = nArray;
                        int n = objectArray.length;
                        for (int i = 0; i < n; ++i) {
                            int n2 = objectArray[i];
                            if (n2 < 0) continue;
                            int n3 = GroupTableColumn.getViewTreeIndex(TableColumnChooserDialog.this._tree, n2);
                            TableColumnChooserDialog.this._tree.getCheckBoxTreeSelectionModel().addSelectionPath(TableColumnChooserDialog.this._tree.getPathForRow(n3));
                        }
                    }
                    if (TableColumnChooserDialog.this.getColumnIndices() != null && (objectArray = (Object[])TableColumnChooserDialog.this._tree.getCheckBoxTreeSelectionModel().getSelectionPaths()) != null) {
                        for (int n : objectArray) {
                            int n4;
                            if (!TableColumnChooserDialog.this._tree.getModel().isLeaf(n.getLastPathComponent()) || !(n.getLastPathComponent() instanceof ColumnMutableTreeNode) || TableColumnChooserDialog.this.isColumnIndex(n4 = ((ColumnMutableTreeNode)n.getLastPathComponent()).getModelIndex())) continue;
                            TableColumnChooserDialog.this._tree.getCheckBoxTreeSelectionModel().removeSelectionPath((TreePath)n);
                        }
                    }
                    if (TableColumnChooserDialog.this._okAction == null) {
                        return;
                    }
                    TableColumnChooserDialog.this._okAction.setEnabled(TableColumnChooserDialog.this.getSelectedColumns().length > 0);
                    if (TableColumnChooserDialog.this._label == null) {
                        return;
                    }
                    if (TableColumnChooserDialog.this.getSelectedColumns().length > 0) {
                        TableColumnChooserDialog.this._label.setText(TableColumnChooserDialog.this.getLabelText(TableColumnChooserDialog.LABEL_TEXT_NORMAL));
                        TableColumnChooserDialog.this._label.setForeground(Color.BLACK);
                    } else {
                        TableColumnChooserDialog.this._label.setText(TableColumnChooserDialog.this.getLabelText(TableColumnChooserDialog.LABEL_TEXT_ERROR));
                        TableColumnChooserDialog.this._label.setForeground(Color.RED);
                    }
                }
            };
            try {
                this._tree.getCheckBoxTreeSelectionModel().removeTreeSelectionListener(treeSelectionListener);
            }
            finally {
                this._tree.getCheckBoxTreeSelectionModel().addTreeSelectionListener(treeSelectionListener);
            }
            this._tree.setVisibleRowCount(10);
            SearchableUtils.installSearchable(this._tree);
        }
        this._label = new JLabel(this.getLabelText(LABEL_TEXT_NORMAL));
        serializable = new JPanel(new BorderLayout(5, 5));
        ((Container)serializable).add(this._label, "First");
        ((Container)serializable).add(new JScrollPane(this._tree), "Center");
        ((JComponent)serializable).setBorder(BorderFactory.createEmptyBorder(10, 10, 6, 10));
        return serializable;
    }

    private int convertColumnIndexToView(JTable jTable, int n) {
        if (jTable == null || jTable.getModel() == null || n < 0) {
            return -1;
        }
        int n2 = 0;
        JTable[] jTableArray = TableColumnChooser.getAllMasterTables(jTable);
        boolean bl = false;
        for (JTable jTable2 : jTableArray) {
            int n3 = jTable2.convertColumnIndexToView(n);
            if (n3 >= 0) {
                n2 += n3;
                bl = true;
                break;
            }
            n2 += jTable2.getColumnModel().getColumnCount();
        }
        if (!bl) {
            return -1;
        }
        return n2;
    }

    private void buildTreeNodes(JTable jTable, DefaultMutableTreeNode defaultMutableTreeNode) {
        if (jTable == null || jTable.getModel() == null || defaultMutableTreeNode == null) {
            return;
        }
        Vector<TableColumn> vector = TableColumnChooser.getColumnGroups(jTable);
        for (int i = 0; i < jTable.getModel().getColumnCount(); ++i) {
            ColumnMutableTreeNode columnMutableTreeNode = null;
            GroupTableColumn groupTableColumn = new GroupTableColumn(i);
            groupTableColumn = GroupTableColumn.getGroupPopupMenuFlag(vector, groupTableColumn);
            if (groupTableColumn._index0 < 0) {
                String string = this.getDisplayName(i);
                columnMutableTreeNode = new ColumnMutableTreeNode(string, i);
            } else if (groupTableColumn._leavesAhead0 == 0 && vector != null && vector.get(groupTableColumn._index0) != null) {
                columnMutableTreeNode = this.composeGroupNode((TableColumnGroup)vector.get(groupTableColumn._index0), groupTableColumn);
            }
            if (columnMutableTreeNode == null) continue;
            defaultMutableTreeNode.add(columnMutableTreeNode);
        }
    }

    protected String getResourceString(String string) {
        return GridResource.getResourceBundle(this._table != null ? this._table.getLocale() : Locale.getDefault()).getString(string);
    }

    @Override
    public ButtonPanel createButtonPanel() {
        ButtonPanel buttonPanel = new ButtonPanel();
        buttonPanel.setBorder(BorderFactory.createEmptyBorder(0, 10, 6, 10));
        this._okAction = this.getOkAction();
        AbstractAction abstractAction = new AbstractAction(JideSwingUtilities.getCancelString(this._table == null ? null : this._table.getLocale())){
            private static final long serialVersionUID = 3793307448572209387L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TableColumnChooserDialog.this.setDialogResult(-1);
                TableColumnChooserDialog.this.setVisible(false);
            }
        };
        this._okButton = new JButton(this._okAction);
        buttonPanel.addButton((AbstractButton)this._okButton, "AFFIRMATIVE");
        buttonPanel.addButton((AbstractButton)new JButton(abstractAction), "CANCEL");
        this.setDefaultCancelAction(abstractAction);
        this.setDefaultAction(this._okAction);
        this.getRootPane().setDefaultButton(this._okButton);
        return buttonPanel;
    }

    protected Action getOkAction() {
        return new AbstractAction(JideSwingUtilities.getOKString(this._table.getLocale())){
            private static final long serialVersionUID = 1051918942053460016L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (TableColumnChooserDialog.this._tree != null) {
                    TableColumnChooserDialog.this.showOrHideColumns(TableColumnChooserDialog.this.getSelectedModelIndices(TableColumnChooserDialog.this.getSelectedColumns()));
                } else if (TableColumnChooserDialog.this._list != null) {
                    TableColumnChooserDialog.this.showOrHideColumns(TableColumnChooserDialog.this.getSelectedModelIndices(TableColumnChooserDialog.this.getSelectedColumns()));
                } else if (TableColumnChooserDialog.this._dualList != null) {
                    int[] nArray = TableColumnChooserDialog.this.getSelectedColumns();
                    TableColumnChooser.reorderColumns(TableColumnChooserDialog.this._table, nArray);
                }
                TableColumnChooserDialog.this.setDialogResult(0);
                TableColumnChooserDialog.this.setVisible(false);
            }
        };
    }

    public int[] getSelectedColumns() {
        if (this._tree != null) {
            int n;
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            for (int i = 0; i < this._table.getModel().getColumnCount(); ++i) {
                n = GroupTableColumn.getViewTreeIndex(this._tree, i);
                if (!this._tree.getCheckBoxTreeSelectionModel().isRowSelected(n)) continue;
                arrayList.add(i);
            }
            int[] nArray = new int[arrayList.size()];
            for (n = 0; n < arrayList.size(); ++n) {
                nArray[n] = Integer.parseInt(((Integer)arrayList.get(n)).toString());
            }
            return nArray;
        }
        if (this._list != null) {
            int[] nArray = this._list.getCheckBoxListSelectedIndices();
            for (int i = 0; i < nArray.length; ++i) {
                int n;
                nArray[i] = n = ListModelWrapperUtils.getActualIndexAt(this._list.getModel(), nArray[i]);
            }
            return nArray;
        }
        if (this._dualList != null) {
            return this._dualList.getSelectedIndices();
        }
        return new int[0];
    }

    public boolean[] getHidableColumns() {
        return this._hidableColumns;
    }

    public void setHidableColumns(boolean[] blArray) {
        this._hidableColumns = blArray;
    }

    public int[] getFixedColumns() {
        return this._fixedColumns;
    }

    public void setFixedColumns(int[] nArray) {
        this._fixedColumns = nArray;
    }

    public List<Integer> getHiddenColumns() {
        return this._hiddenColumns;
    }

    public void setHiddenColumns(int[] nArray) {
        this._hiddenColumns = new ArrayList<Integer>();
        if (nArray != null) {
            for (int n : nArray) {
                this._hiddenColumns.add(n);
            }
        }
        Object object = (DefaultGroupTableModel)TableModelWrapperUtils.getActualTableModel(this._table.getModel(), DefaultGroupTableModel.class);
        if (this._table instanceof GroupTable && !((GroupTable)this._table).isSpecialColumnsHidable() && object != null) {
            String string = ((DefaultGroupTableModel)object).getSeparateGroupColumnName();
            String string2 = ((DefaultGroupTableModel)object).getCountColumnName();
            for (int n = 0; n < this._table.getModel().getColumnCount(); ++n) {
                if (this._hiddenColumns.contains(n) || !JideSwingUtilities.equals(this._table.getModel().getColumnName(n), string) && !JideSwingUtilities.equals(this._table.getModel().getColumnName(n), string2)) continue;
                this._hiddenColumns.add(n);
            }
        }
    }

    public String[] getDescriptions() {
        return this._descriptions;
    }

    public void setDescriptions(String[] stringArray) {
        this._descriptions = stringArray;
    }

    private int getViewListIndex(int n) {
        if (n >= this._table.getModel().getColumnCount()) {
            return -1;
        }
        List<Integer> list = this.getHiddenColumns();
        if (list == null || list.size() == 0) {
            return n;
        }
        if (list.contains(n)) {
            return -1;
        }
        int n2 = n;
        for (int i = 0; i < n; ++i) {
            if (!list.contains(i)) continue;
            --n2;
        }
        return n2;
    }

    private int getActualModelIndex(int n) {
        List<Integer> list = this.getHiddenColumns();
        if (list == null || list.size() == 0) {
            return n;
        }
        int n2 = 0;
        for (int i = 0; i < this._table.getModel().getColumnCount(); ++i) {
            if (list.contains(i)) continue;
            if (n2 == n) {
                return i;
            }
            ++n2;
        }
        System.err.println("View index should not be larger than column count in the model.");
        return -1;
    }

    int[] getSelectedModelIndices(int[] nArray) {
        Object object;
        HashSet<Integer> hashSet = new HashSet<Integer>();
        if (this.getHiddenColumns() != null) {
            object = this.getHiddenColumns().iterator();
            while (object.hasNext()) {
                int n = (Integer)object.next();
                if (!TableColumnChooser.isVisibleColumn(this._table, n)) continue;
                hashSet.add(n);
            }
        }
        for (int n : nArray) {
            hashSet.add(this.getActualModelIndex(n));
        }
        object = hashSet.toArray(new Integer[hashSet.size()]);
        Arrays.sort((Object[])object);
        int[] nArray2 = new int[hashSet.size()];
        for (int i = 0; i < hashSet.size(); ++i) {
            nArray2[i] = (Integer)object[i];
        }
        return nArray2;
    }

    protected String getName(int n) {
        String string = this._table.getModel().getColumnName(n);
        StyledLabel styledLabel = StyledLabelBuilder.createStyledLabel(string);
        return styledLabel == null ? string : styledLabel.getText();
    }

    protected boolean isColumnVisible(int n) {
        return TableColumnChooser.isVisibleColumn(this._table, n);
    }

    protected void showOrHideColumns(int[] nArray) {
        TableColumnChooser.showColumns(this._table, nArray);
    }

    private boolean isHidable(int n) {
        boolean[] blArray = this.getHidableColumns();
        if (blArray != null) {
            return blArray.length <= n || !blArray[n];
        }
        return false;
    }

    private boolean isFixed(int n) {
        int[] nArray = this.getFixedColumns();
        if (nArray != null && n >= 0) {
            for (int n2 : nArray) {
                if (n2 != n) continue;
                return true;
            }
        }
        return false;
    }

    int[] getSearchingColumnIndices() {
        return this._searchingColumnIndices;
    }

    void setSearchingColumnIndices(int[] nArray) {
        this._searchingColumnIndices = nArray;
    }

    int[] getColumnIndices() {
        return this._columnIndices;
    }

    void setColumnIndices(int[] nArray) {
        this._columnIndices = nArray;
    }

    private boolean isColumnIndex(int n) {
        int[] nArray = this.getColumnIndices();
        if (nArray != null && n >= 0) {
            for (int n2 : nArray) {
                if (n2 != n) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isSearchingColumnIndex(int n) {
        int[] nArray = this.getSearchingColumnIndices();
        if (nArray != null && n >= 0) {
            for (int n2 : nArray) {
                if (n2 != n) continue;
                return true;
            }
        }
        return false;
    }

    class ColumnMutableTreeNode
    extends DefaultMutableTreeNode {
        private static final long serialVersionUID = 5552738927153411574L;
        private int _modelIndex;

        public ColumnMutableTreeNode() {
            this._modelIndex = -1;
        }

        public ColumnMutableTreeNode(Object object) {
            super(object, true);
            this._modelIndex = -1;
        }

        public ColumnMutableTreeNode(Object object, int n) {
            super(object, true);
            this._modelIndex = -1;
            this.setModelIndex(n);
        }

        public int getModelIndex() {
            return this._modelIndex;
        }

        public void setModelIndex(int n) {
            this._modelIndex = n;
        }
    }
}

