/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.grid;

import com.jidesoft.grid.CellSpan;
import com.jidesoft.grid.CellSpanTable;
import com.jidesoft.grid.NestedTableHeader;
import com.jidesoft.grid.TableResizer;
import com.jidesoft.grid.TableUtils;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.JTable;
import javax.swing.event.MouseInputAdapter;
import javax.swing.event.MouseInputListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;

public class TableColumnAutoResizer
extends TableResizer {
    protected static final String KEY = "columnAutoResizer";

    public TableColumnAutoResizer(JTable jTable) {
        this(jTable, true);
    }

    public TableColumnAutoResizer(JTable jTable, boolean bl) {
        super(jTable, bl);
    }

    @Override
    String getClientProperty() {
        return KEY;
    }

    @Override
    public MouseInputListener createMouseInputListener() {
        return new MouseInputAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    int n;
                    Point point = mouseEvent.getPoint();
                    if (TableColumnAutoResizer.this._onTableHeader) {
                        if (TableColumnAutoResizer.this._table.getTableHeader() == null) {
                            return;
                        }
                        n = TableColumnAutoResizer.this._table.getTableHeader().columnAtPoint(point);
                    } else {
                        n = TableColumnAutoResizer.this._table.columnAtPoint(point);
                    }
                    if (n != -1) {
                        TableColumn[] tableColumnArray;
                        for (TableColumn tableColumn : tableColumnArray = TableColumnAutoResizer.this.getResizingColumn(TableColumnAutoResizer.this._table, point, n)) {
                            TableColumnAutoResizer.this.resizeColumn(tableColumn);
                        }
                    }
                }
            }
        };
    }

    protected void resizeColumn(TableColumn tableColumn) {
        if (TableUtils.isTableColumnResizable(this._table, tableColumn)) {
            TableUtils.autoResizeColumn(this._table, this._table.convertColumnIndexToView(tableColumn.getModelIndex()), this._onTableHeader);
        }
    }

    private TableColumn[] getResizingColumn(JTable jTable, Point point, int n) {
        CellSpan cellSpan;
        int n2;
        if (n == -1) {
            return new TableColumn[0];
        }
        JTableHeader jTableHeader = jTable.getTableHeader();
        if (this._onTableHeader && jTableHeader == null) {
            return new TableColumn[0];
        }
        Rectangle rectangle = this._onTableHeader ? jTableHeader.getHeaderRect(n) : jTable.getCellRect(this._table.rowAtPoint(point), n, true);
        rectangle.grow(-3, 0);
        if (rectangle.contains(point)) {
            return new TableColumn[0];
        }
        int n3 = rectangle.x + rectangle.width / 2;
        boolean bl = this._onTableHeader ? jTableHeader.getComponentOrientation().isLeftToRight() : jTable.getComponentOrientation().isLeftToRight();
        if (bl) {
            n2 = point.x < n3 ? n - 1 : n;
        } else {
            int n4 = n2 = point.x < n3 ? n : n - 1;
        }
        if (n2 == -1) {
            return new TableColumn[0];
        }
        if (this._onTableHeader) {
            int n5;
            int n6;
            NestedTableHeader nestedTableHeader;
            CellSpan cellSpan2;
            if (jTableHeader instanceof NestedTableHeader && (cellSpan2 = (nestedTableHeader = (NestedTableHeader)jTableHeader).getCellSpanAt(n6 = point.y / (n5 = nestedTableHeader.getSize().height / nestedTableHeader.getRowCount()), n2)) != null && cellSpan2.getColumnSpan() != 1) {
                int n7 = cellSpan2.getColumnSpan();
                TableColumn[] tableColumnArray = new TableColumn[n7];
                int n8 = cellSpan2.getColumn();
                for (int i = 0; i < n7; ++i) {
                    tableColumnArray[i] = jTableHeader.getColumnModel().getColumn(n8 + i);
                }
                return tableColumnArray;
            }
            TableColumn[] tableColumnArray = new TableColumn[]{jTableHeader.getColumnModel().getColumn(n2)};
            return tableColumnArray;
        }
        if (jTable instanceof CellSpanTable && ((CellSpanTable)jTable).isCellSpanOn() && (cellSpan = ((CellSpanTable)jTable).getCellSpanAt(this._table.rowAtPoint(point), n2)) != null && cellSpan.getColumnSpan() > 1) {
            int n9 = cellSpan.getColumnSpan();
            TableColumn[] tableColumnArray = new TableColumn[n9];
            int n10 = cellSpan.getColumn();
            for (int i = 0; i < n9; ++i) {
                tableColumnArray[i] = this._table.getColumnModel().getColumn(n10 + i);
            }
            return tableColumnArray;
        }
        TableColumn[] tableColumnArray = new TableColumn[]{this._table.getColumnModel().getColumn(n2)};
        return tableColumnArray;
    }
}

