/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.grid;

import com.jidesoft.converter.ConverterContext;
import com.jidesoft.grid.ContextSensitiveTableModel;
import com.jidesoft.grid.DefaultGroupRow;
import com.jidesoft.grid.DefaultGroupTableModel;
import com.jidesoft.grid.EditorContext;
import com.jidesoft.grid.Expandable;
import com.jidesoft.grid.ExpandableRow;
import com.jidesoft.grid.GroupTableSummaryCalculator;
import com.jidesoft.grid.Row;
import com.jidesoft.grid.SummaryCalculator;
import com.jidesoft.grid.SummaryProvider;
import com.jidesoft.grid.TreeTableModel;
import com.jidesoft.range.BigDecimalRange;
import com.jidesoft.range.BooleanRange;
import com.jidesoft.range.IntegerRange;
import com.jidesoft.range.LongRange;
import com.jidesoft.range.NumericRange;
import com.jidesoft.range.StringRange;
import com.jidesoft.range.TimeRange;
import com.jidesoft.utils.TypeUtils;
import javax.swing.table.TableModel;

public class SummaryGroupRow
extends DefaultGroupRow {
    private Object[] _cachedValues;

    @Override
    public Object getValueAt(int n) {
        TreeTableModel treeTableModel = this.getTreeTableModel();
        if (!(treeTableModel instanceof DefaultGroupTableModel)) {
            return null;
        }
        boolean bl = false;
        DefaultGroupTableModel defaultGroupTableModel = (DefaultGroupTableModel)treeTableModel;
        int n2 = defaultGroupTableModel.getActualColumnAt(n);
        if (defaultGroupTableModel.isFirstColumn(n) && defaultGroupTableModel.isDisplayGroupValueOnFirstColumn()) {
            bl = true;
        }
        if (!bl && this.shouldShowSummary(treeTableModel, n2)) {
            if (this._cachedValues == null || n >= this._cachedValues.length) {
                this._cachedValues = new Object[treeTableModel.getColumnCount()];
            }
            if (this._cachedValues[n] != null) {
                if (this._cachedValues[n] instanceof NullValue) {
                    return null;
                }
                return this._cachedValues[n];
            }
            int n3 = ((SummaryProvider)((Object)treeTableModel)).getSummaryTypeAt(n2);
            if (n3 == -2) {
                return null;
            }
            SummaryCalculator summaryCalculator = defaultGroupTableModel.getSummaryCalculator();
            if (summaryCalculator == null) {
                return null;
            }
            summaryCalculator.clear();
            this.addValueRecursively(treeTableModel, summaryCalculator, this, n);
            Object object = summaryCalculator.getSummaryResult(n3);
            this._cachedValues[n] = object == null ? new NullValue() : object;
            return object;
        }
        return super.getValueAt(n);
    }

    protected void addValueRecursively(TreeTableModel treeTableModel, SummaryCalculator summaryCalculator, ExpandableRow expandableRow, int n) {
        for (int i = 0; i < expandableRow.getChildrenCount(); ++i) {
            Object object = expandableRow.getChildAt(i);
            if (object instanceof ExpandableRow) {
                this.addValueRecursively(treeTableModel, summaryCalculator, (ExpandableRow)object, n);
                continue;
            }
            if (!(object instanceof Row)) continue;
            if (summaryCalculator instanceof GroupTableSummaryCalculator) {
                ((GroupTableSummaryCalculator)summaryCalculator).addValue(treeTableModel, (Row)object, n, ((Row)object).getValueAt(n));
                continue;
            }
            summaryCalculator.addValue(((Row)object).getValueAt(n));
        }
    }

    protected boolean shouldShowSummary(TreeTableModel treeTableModel, int n) {
        boolean bl = treeTableModel instanceof DefaultGroupTableModel;
        if (!bl) {
            return false;
        }
        DefaultGroupTableModel defaultGroupTableModel = (DefaultGroupTableModel)treeTableModel;
        boolean bl2 = defaultGroupTableModel.isSummaryMode();
        if (!bl2) {
            return false;
        }
        boolean bl3 = defaultGroupTableModel.isColumnGrouped(n);
        if (bl3) {
            int n2;
            int n3 = this.getNumberOfConditions();
            if (n3 < (n2 = defaultGroupTableModel.getGroupColumnCount())) {
                for (int i = 0; i < n3; ++i) {
                    if (defaultGroupTableModel.getGroupColumnAt(i) != n) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        return true;
    }

    @Override
    public Class<?> getCellClassAt(int n) {
        TreeTableModel treeTableModel = this.getTreeTableModel();
        int n2 = n;
        DefaultGroupTableModel defaultGroupTableModel = null;
        if (treeTableModel instanceof DefaultGroupTableModel) {
            defaultGroupTableModel = (DefaultGroupTableModel)treeTableModel;
            n2 = defaultGroupTableModel.getActualColumnAt(n);
        }
        if (defaultGroupTableModel != null) {
            boolean bl = false;
            if (defaultGroupTableModel.isFirstColumn(n) && defaultGroupTableModel.isDisplayGroupValueOnFirstColumn()) {
                bl = true;
            }
            if (!bl && this.shouldShowSummary(treeTableModel, n2)) {
                int n3 = defaultGroupTableModel.getSummaryTypeAt(n2);
                Class<?> clazz = treeTableModel.getColumnClass(n);
                if (n3 == 6) {
                    return Long.class;
                }
                if (n3 == -2) {
                    return Object.class;
                }
                if (n3 == 7) {
                    if (TypeUtils.isIntegerType(clazz)) {
                        return IntegerRange.class;
                    }
                    if (TypeUtils.isLongType(clazz)) {
                        return LongRange.class;
                    }
                    if (TypeUtils.isBigDecimalType(clazz)) {
                        return BigDecimalRange.class;
                    }
                    if (TypeUtils.isStringType(clazz)) {
                        return StringRange.class;
                    }
                    if (TypeUtils.isBooleanType(clazz)) {
                        return BooleanRange.class;
                    }
                    if (TypeUtils.isNumericType(clazz)) {
                        return NumericRange.class;
                    }
                    if (TypeUtils.isTemporalType(clazz)) {
                        return TimeRange.class;
                    }
                    return Object.class;
                }
                if (n3 == 0 && TypeUtils.isTemporalType(clazz)) {
                    return TimeRange.class;
                }
                return clazz;
            }
        }
        return this.getClass();
    }

    @Override
    public ConverterContext getConverterContextAt(int n) {
        TreeTableModel treeTableModel = this.getTreeTableModel();
        int n2 = n;
        DefaultGroupTableModel defaultGroupTableModel = null;
        if (treeTableModel instanceof DefaultGroupTableModel) {
            defaultGroupTableModel = (DefaultGroupTableModel)treeTableModel;
            n2 = defaultGroupTableModel.getActualColumnAt(n);
        }
        if (defaultGroupTableModel != null) {
            boolean bl = false;
            if (defaultGroupTableModel.isFirstColumn(n) && defaultGroupTableModel.isDisplayGroupValueOnFirstColumn()) {
                bl = true;
            }
            if (!bl && this.shouldShowSummary(treeTableModel, n2)) {
                int n3 = ((SummaryProvider)((Object)treeTableModel)).getSummaryTypeAt(n2);
                if (n3 == 6 || n3 == -2) {
                    return null;
                }
                TableModel tableModel = ((DefaultGroupTableModel)treeTableModel).getActualModel();
                if (tableModel instanceof ContextSensitiveTableModel && tableModel.getRowCount() > 0) {
                    return ((ContextSensitiveTableModel)tableModel).getConverterContextAt(0, n2);
                }
            }
        }
        return super.getConverterContextAt(n);
    }

    @Override
    public EditorContext getEditorContextAt(int n) {
        TreeTableModel treeTableModel = this.getTreeTableModel();
        int n2 = n;
        DefaultGroupTableModel defaultGroupTableModel = null;
        if (treeTableModel instanceof DefaultGroupTableModel) {
            defaultGroupTableModel = (DefaultGroupTableModel)treeTableModel;
            n2 = defaultGroupTableModel.getActualColumnAt(n);
        }
        if (defaultGroupTableModel != null) {
            boolean bl = false;
            if (defaultGroupTableModel.isFirstColumn(n) && defaultGroupTableModel.isDisplayGroupValueOnFirstColumn()) {
                bl = true;
            }
            if (!bl && this.shouldShowSummary(treeTableModel, n)) {
                int n3 = ((SummaryProvider)((Object)treeTableModel)).getSummaryTypeAt(n);
                if (n3 == 6 || n3 == -2) {
                    return null;
                }
                TableModel tableModel = ((DefaultGroupTableModel)treeTableModel).getActualModel();
                if (tableModel instanceof ContextSensitiveTableModel && tableModel.getRowCount() > 0) {
                    return ((ContextSensitiveTableModel)tableModel).getEditorContextAt(0, n2);
                }
            }
        }
        return super.getEditorContextAt(n);
    }

    @Override
    public void setExpanded(boolean bl) {
        super.setExpanded(bl);
        if (bl) {
            this.invalidateSummaryCache();
        }
    }

    public void invalidateSummaryCache() {
        this._cachedValues = null;
        if (this.isExpanded()) {
            int n = this.getChildrenCount();
            for (int i = 0; i < n; ++i) {
                Object object = this.getChildAt(i);
                if (!(object instanceof SummaryGroupRow)) continue;
                ((SummaryGroupRow)object).invalidateSummaryCache();
            }
        }
    }

    void invalidateSummaryCacheToRoot() {
        this._cachedValues = null;
        Expandable expandable = this.getParent();
        if (expandable instanceof SummaryGroupRow) {
            ((SummaryGroupRow)expandable).invalidateSummaryCacheToRoot();
        }
    }

    private class NullValue {
    }
}

