/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.grid;

import com.jidesoft.grid.CellStyleTableHeader;
import com.jidesoft.grid.ISortableTableModel;
import com.jidesoft.grid.SortableTable;
import com.jidesoft.grid.SortableTableHeaderCellDecorator;
import com.jidesoft.grid.TableHeaderCellDecorator;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.plaf.basic.ThemePainter;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class SortableTableHeader
extends CellStyleTableHeader {
    private static final String uiClassID = "SortableTableHeaderUI";
    private static final String uiDelegateClassID = "TableHeader.sortableTableHeaderUIDelegate";
    private boolean _showSortArrow = true;
    private TableHeaderCellDecorator _sortableTableHeaderCellDecorator;
    public static final String PROPERTY_SHOW_SORT_ARROW = "showSortArrow";

    public SortableTableHeader(TableColumnModel tableColumnModel) {
        super(tableColumnModel);
        this.addCellDecorator(this.getSortableTableHeaderCellDecorator());
    }

    public SortableTableHeader(JTable jTable) {
        this(jTable.getColumnModel());
        this.setTable(jTable);
        this.addCellDecorator(this.getSortableTableHeaderCellDecorator());
    }

    @Override
    public String getActualUIClassID() {
        return uiClassID;
    }

    @Override
    public String getUIDelegateClassID() {
        return uiDelegateClassID;
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        this.customizeForSynthetica();
        super.paintComponent(graphics);
    }

    private void customizeForSynthetica() {
        SortableTable sortableTable = null;
        if (this.getTable() instanceof SortableTable) {
            sortableTable = (SortableTable)this.getTable();
        }
        if (sortableTable == null) {
            return;
        }
        ISortableTableModel iSortableTableModel = sortableTable.getSortableTableModel();
        if (iSortableTableModel == null) {
            sortableTable.putClientProperty("SORTABLE_TABLE_SORTED_COLUMNS", null);
            return;
        }
        List<ISortableTableModel.SortItem> list = iSortableTableModel.getSortingColumns();
        if (list.size() == 0) {
            sortableTable.putClientProperty("SORTABLE_TABLE_SORTED_COLUMNS", null);
            return;
        }
        int[] nArray = new int[list.size()];
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            ISortableTableModel.SortItem sortItem = list.get(i);
            nArray[i] = sortableTable.convertColumnIndexToView(sortItem.getColumn());
        }
        sortableTable.putClientProperty("SORTABLE_TABLE_SORTED_COLUMNS", nArray);
        sortableTable.putClientProperty("SORTABLE_TABLE_PAINT_SORT_BACKGROUND", true);
    }

    @Deprecated
    protected void paintSortArrows(Graphics graphics) {
        SortableTable sortableTable = null;
        if (this.getTable() instanceof SortableTable) {
            sortableTable = (SortableTable)this.getTable();
        }
        if (sortableTable == null) {
            return;
        }
        ISortableTableModel iSortableTableModel = sortableTable.getSortableTableModel();
        if (iSortableTableModel == null) {
            return;
        }
        List<ISortableTableModel.SortItem> list = iSortableTableModel.getSortingColumns();
        if (list.size() == 0) {
            return;
        }
        TableColumn tableColumn = this.getDraggedColumn();
        for (int i = 0; i < list.size(); ++i) {
            ISortableTableModel.SortItem sortItem = list.get(i);
            int n = sortItem.getColumn();
            if (n < 0) continue;
            boolean bl = false;
            if (tableColumn != null && tableColumn.getModelIndex() == n) {
                bl = true;
            }
            if ((n = sortableTable.convertColumnIndexToView(n)) == -1) continue;
            boolean bl2 = sortItem.isAscending();
            Rectangle rectangle = this.getHeaderRect(n);
            if (bl) {
                rectangle.x += this.getDraggedDistance();
            }
            this.paintSortArrow(this, sortableTable, graphics, rectangle, sortableTable.isShowSortOrderNumber() || list.size() > 1 ? i : -1, bl2);
        }
    }

    @Deprecated
    protected void paintSortArrow(JComponent jComponent, SortableTable sortableTable, Graphics graphics, Rectangle rectangle, int n, boolean bl) {
        Icon icon = this.createSortIcon(sortableTable, bl);
        boolean bl2 = sortableTable.isMultiColumnSortable();
        Color color = sortableTable.getSortOrderForeground() != null ? sortableTable.getSortOrderForeground() : jComponent.getForeground();
        Object object = UIDefaultsLookup.get("Theme.painter");
        if (object instanceof ThemePainter) {
            ((ThemePainter)object).paintSortableTableHeaderColumn(sortableTable.getTableHeader(), graphics, rectangle, 0, 0, bl ? 1 : 2, icon, n, color, bl2);
        }
    }

    protected Icon createSortIcon(SortableTable sortableTable, boolean bl) {
        return sortableTable.createSortIcon(bl);
    }

    public boolean isShowSortArrow() {
        return this._showSortArrow;
    }

    public void setShowSortArrow(boolean bl) {
        boolean bl2 = this._showSortArrow;
        if (bl2 != bl) {
            this._showSortArrow = bl;
            if (this._showSortArrow) {
                this.addCellDecorator(this.getSortableTableHeaderCellDecorator());
            } else {
                this.removeCellDecorator(this.getSortableTableHeaderCellDecorator());
            }
            this.firePropertyChange(PROPERTY_SHOW_SORT_ARROW, bl2, this._showSortArrow);
        }
    }

    public TableHeaderCellDecorator getSortableTableHeaderCellDecorator() {
        if (this._sortableTableHeaderCellDecorator == null) {
            this._sortableTableHeaderCellDecorator = this.createSortableTableHeaderCellDecorator();
        }
        return this._sortableTableHeaderCellDecorator;
    }

    protected TableHeaderCellDecorator createSortableTableHeaderCellDecorator() {
        return new SortableTableHeaderCellDecorator();
    }
}

