/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.grid;

import com.jidesoft.comparator.AlphanumComparator;
import com.jidesoft.comparator.CharSequenceComparator;
import com.jidesoft.comparator.ComparatorContext;
import com.jidesoft.comparator.NumberComparator;
import com.jidesoft.grid.GridResource;
import com.jidesoft.swing.JideBoxLayout;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.utils.TypeUtils;
import java.awt.GridLayout;
import java.util.ResourceBundle;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class SortOrderEditor
extends JPanel {
    private Class<?> _type;
    private JRadioButton _ascendingRadioButton;
    private JRadioButton _descendingRadioButton;
    private JComboBox _contextComboBox;

    public SortOrderEditor() {
        this.initComponents();
    }

    public SortOrderEditor(Class<?> clazz) {
        this._type = clazz;
        this.initComponents();
    }

    public Class<?> getType() {
        return this._type;
    }

    public void setType(Class<?> clazz) {
        this._type = clazz;
        this.removeAll();
        this.initComponents();
        this.revalidate();
        this.repaint();
    }

    protected void initComponents() {
        this.setLayout(new JideBoxLayout(this, 0, 6));
        ResourceBundle resourceBundle = GridResource.getResourceBundle(this.getLocale());
        if (this._type != null) {
            this._ascendingRadioButton = new JRadioButton(resourceBundle.getString("SortOrderEditor.ascending"));
            this._descendingRadioButton = new JRadioButton(resourceBundle.getString("SortOrderEditor.descending"));
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add(this._ascendingRadioButton);
            buttonGroup.add(this._descendingRadioButton);
            JPanel jPanel = new JPanel(new GridLayout(2, 1));
            jPanel.add(this._ascendingRadioButton);
            jPanel.add(this._descendingRadioButton);
            this.add(jPanel);
        }
        this._contextComboBox = this.createContextComboBox(this._type);
        if (this._contextComboBox != null) {
            this.add(new JLabel(resourceBundle.getString("SortOrderEditor.options")));
            this.add(JideSwingUtilities.createCenterPanel(this._contextComboBox));
        }
        this.add(Box.createGlue(), "vary");
    }

    protected JComboBox createContextComboBox(Class<?> clazz) {
        JComboBox<String> jComboBox = null;
        ResourceBundle resourceBundle = GridResource.getResourceBundle(this.getLocale());
        if (this.isCharSequence(clazz)) {
            jComboBox = clazz == String.class ? new JComboBox<String>(new String[]{resourceBundle.getString("Comparator.string.default"), resourceBundle.getString("Comparator.string.ignoreCase"), resourceBundle.getString("Comparator.string.localeSpecific"), resourceBundle.getString("Comparator.string.localeSpecificIgnoreCase"), resourceBundle.getString("Comparator.string.containNumber"), resourceBundle.getString("Comparator.string.containNumberIgnoreCase")}) : new JComboBox<String>(new String[]{resourceBundle.getString("Comparator.string.default"), resourceBundle.getString("Comparator.string.ignoreCase"), resourceBundle.getString("Comparator.string.containNumber"), resourceBundle.getString("Comparator.string.containNumberIgnoreCase")});
            jComboBox.setEditable(false);
        } else if (this.isNumber(clazz)) {
            jComboBox = new JComboBox<String>(new String[]{resourceBundle.getString("Comparator.number.actual"), resourceBundle.getString("Comparator.number.absolute")});
            jComboBox.setEditable(false);
        }
        return jComboBox;
    }

    private boolean isNumber(Class<?> clazz) {
        return clazz != null && (Number.class.isAssignableFrom(clazz) || TypeUtils.isPrimitive(clazz) && clazz != Character.TYPE);
    }

    private boolean isCharSequence(Class<?> clazz) {
        return clazz != null && CharSequence.class.isAssignableFrom(clazz);
    }

    public boolean isAscending() {
        return this._ascendingRadioButton.isSelected();
    }

    public void setAscending(boolean bl) {
        if (bl) {
            this._ascendingRadioButton.setSelected(true);
        } else {
            this._descendingRadioButton.setSelected(true);
        }
    }

    public ComparatorContext getComparatorContext() {
        if (this.isCharSequence(this._type)) {
            if (this._type == String.class) {
                int n = this._contextComboBox.getSelectedIndex();
                switch (n) {
                    case 0: {
                        return CharSequenceComparator.CONTEXT;
                    }
                    case 1: {
                        return CharSequenceComparator.CONTEXT_IGNORE_CASE;
                    }
                    case 2: {
                        return null;
                    }
                    case 3: {
                        return new ComparatorContext("Ignorecase");
                    }
                    case 4: {
                        return AlphanumComparator.CONTEXT;
                    }
                    case 5: {
                        return AlphanumComparator.CONTEXT_IGNORE_CASE;
                    }
                }
            } else {
                int n = this._contextComboBox.getSelectedIndex();
                switch (n) {
                    case 0: {
                        return CharSequenceComparator.CONTEXT;
                    }
                    case 1: {
                        return CharSequenceComparator.CONTEXT_IGNORE_CASE;
                    }
                    case 2: {
                        return AlphanumComparator.CONTEXT;
                    }
                    case 3: {
                        return AlphanumComparator.CONTEXT_IGNORE_CASE;
                    }
                }
            }
        } else if (this.isNumber(this._type)) {
            boolean bl = this._contextComboBox.getSelectedIndex() == 1;
            return bl ? NumberComparator.CONTEXT_ABSOLUTE : null;
        }
        return null;
    }

    public void setComparatorContext(ComparatorContext comparatorContext) {
        if (this.isCharSequence(this._type)) {
            if (CharSequenceComparator.CONTEXT.equals(comparatorContext)) {
                this._contextComboBox.setSelectedIndex(0);
            } else if (CharSequenceComparator.CONTEXT_IGNORE_CASE.equals(comparatorContext)) {
                this._contextComboBox.setSelectedIndex(1);
            } else if (this._type == String.class) {
                if (ComparatorContext.DEFAULT_CONTEXT.equals(comparatorContext) || comparatorContext == null) {
                    this._contextComboBox.setSelectedIndex(2);
                } else if (new ComparatorContext("Ignorecase").equals(comparatorContext)) {
                    this._contextComboBox.setSelectedIndex(3);
                } else if (AlphanumComparator.CONTEXT.equals(comparatorContext)) {
                    this._contextComboBox.setSelectedIndex(4);
                } else if (AlphanumComparator.CONTEXT_IGNORE_CASE.equals(comparatorContext)) {
                    this._contextComboBox.setSelectedIndex(5);
                }
            } else if (AlphanumComparator.CONTEXT.equals(comparatorContext)) {
                this._contextComboBox.setSelectedIndex(2);
            } else if (AlphanumComparator.CONTEXT_IGNORE_CASE.equals(comparatorContext)) {
                this._contextComboBox.setSelectedIndex(3);
            }
        } else if (this.isNumber(this._type)) {
            if (NumberComparator.CONTEXT_ABSOLUTE.equals(comparatorContext)) {
                this._contextComboBox.setSelectedIndex(1);
            } else {
                this._contextComboBox.setSelectedIndex(0);
            }
        }
    }
}

