/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.grid;

import com.jidesoft.comparator.ComparatorContext;
import com.jidesoft.grid.SortOrderEditor;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.swing.SearchableUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.table.TableModel;

public class SortItemEditor
extends JPanel {
    private JComboBox _columnComboBox;
    private TableModel _tableModel;
    private SortOrderEditor _sortOrderEditor;

    public SortItemEditor(TableModel tableModel) {
        this._tableModel = tableModel;
        this.initComponents();
    }

    public ComparatorContext getComparatorContext() {
        return this._sortOrderEditor.getComparatorContext();
    }

    public void setComparatorContext(ComparatorContext comparatorContext) {
        this._sortOrderEditor.setComparatorContext(comparatorContext);
    }

    public boolean isAscending() {
        return this._sortOrderEditor.isAscending();
    }

    public void setAscending(boolean bl) {
        this._sortOrderEditor.setAscending(bl);
    }

    public int getSelectedColumnIndex() {
        return this._columnComboBox.getSelectedIndex() - 1;
    }

    public void setSelectedColumnIndex(int n) {
        this._columnComboBox.setSelectedIndex(n + 1);
    }

    protected void initComponents() {
        String[] stringArray = this.getAvailableColumnNames();
        this._columnComboBox = new JComboBox<String>(stringArray);
        SearchableUtils.installSearchable(this._columnComboBox);
        this._columnComboBox.setSelectedItem(null);
        this._columnComboBox.setEditable(false);
        this._columnComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    int n = SortItemEditor.this._columnComboBox.getSelectedIndex();
                    if (n != 0) {
                        Class<?> clazz = SortItemEditor.this._tableModel.getColumnClass(n - 1);
                        SortItemEditor.this._sortOrderEditor.setType(clazz);
                    } else {
                        SortItemEditor.this._sortOrderEditor.setType(null);
                    }
                }
            }
        });
        this.setLayout(new BorderLayout(10, 10));
        this.add((Component)JideSwingUtilities.createCenterPanel(this._columnComboBox), "Before");
        this._sortOrderEditor = new SortOrderEditor();
        this.add((Component)this._sortOrderEditor, "Center");
        this._columnComboBox.setSelectedIndex(0);
    }

    protected String[] getAvailableColumnNames() {
        String[] stringArray = new String[this._tableModel.getColumnCount() + 1];
        stringArray[0] = "";
        for (int i = 0; i < this._tableModel.getColumnCount(); ++i) {
            stringArray[i + 1] = this._tableModel.getColumnName(i);
        }
        return stringArray;
    }

    @Override
    public void setEnabled(boolean bl) {
        JideSwingUtilities.setEnabledRecursively(this, bl);
        super.setEnabled(bl);
    }
}

