/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.grid;

import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.utils.PortingUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.NumberFormat;
import java.text.ParseException;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JFormattedTextField;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.NumberFormatter;

class SliderForInteger
extends JPanel
implements ChangeListener,
PropertyChangeListener {
    private JSlider _slider;
    private JFormattedTextField _valueField;
    private int _min;
    private int _max;

    public SliderForInteger() {
        this(0, 100);
    }

    public SliderForInteger(int n, int n2) {
        this._min = n;
        this._max = n2;
        this.initComponents();
    }

    protected void initComponents() {
        NumberFormat numberFormat = NumberFormat.getIntegerInstance();
        NumberFormatter numberFormatter = new NumberFormatter(numberFormat);
        numberFormatter.setMinimum(Integer.valueOf(this._min));
        numberFormatter.setMaximum(Integer.valueOf(this._max));
        this._valueField = new JFormattedTextField(numberFormatter);
        this._valueField.setHorizontalAlignment(11);
        this._valueField.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
        this._valueField.setValue(this._min);
        this._valueField.setColumns((int)(Math.log(this._max) / Math.log(10.0)) + 2);
        this._valueField.addPropertyChangeListener(this);
        this._valueField.getInputMap().put(KeyStroke.getKeyStroke(10, 0), "check");
        this._valueField.getActionMap().put("check", new AbstractAction(){
            private static final long serialVersionUID = -7773292884860379571L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!SliderForInteger.this._valueField.isEditValid()) {
                    PortingUtils.notifyUser();
                    SliderForInteger.this._valueField.selectAll();
                } else {
                    try {
                        SliderForInteger.this._valueField.commitEdit();
                    }
                    catch (ParseException parseException) {
                        // empty catch block
                    }
                }
            }
        });
        this._slider = new JSlider(this._min, this._max, this._min);
        this._slider.setBorder(BorderFactory.createEmptyBorder());
        JideSwingUtilities.setComponentTransparent(this._slider);
        this._slider.addChangeListener(this);
        this.setupLayout(this._slider, this._valueField);
    }

    JSlider getSlider() {
        return this._slider;
    }

    protected void setupLayout(JSlider jSlider, JTextField jTextField) {
        this.setLayout(new BorderLayout());
        this.add((Component)jSlider, "Center");
        this.add((Component)jTextField, "After");
    }

    public int getValue() {
        return this._slider.getValue();
    }

    public void setValue(int n) {
        this._slider.setValue(n);
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        JSlider jSlider = (JSlider)changeEvent.getSource();
        int n = jSlider.getValue();
        if (!jSlider.getValueIsAdjusting()) {
            this._valueField.setValue(n);
        } else {
            this._valueField.setText(String.valueOf(n));
        }
    }

    public JFormattedTextField getTextField() {
        return this._valueField;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("value".equals(propertyChangeEvent.getPropertyName())) {
            Number number = (Number)propertyChangeEvent.getNewValue();
            if (this._slider != null && number != null) {
                this._slider.setValue(number.intValue());
            }
        }
    }
}

