/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.grid;

import com.jidesoft.swing.Searchable;
import com.jidesoft.swing.event.SearchableEvent;
import com.jidesoft.swing.event.SearchableListener;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComboBox;
import javax.swing.JComponent;

public abstract class ShrinkSearchableSupport
implements SearchableListener,
PropertyChangeListener {
    protected final Searchable _searchable;
    public static final String CLIENT_PROPERTY_SHRINK_SEARCHABLE_SUPPORT = "ShrinkSearchableSupport";

    public ShrinkSearchableSupport(Searchable searchable) {
        this._searchable = searchable;
        Component component = this._searchable.getComponent();
        if (component != null) {
            if (component instanceof JComponent) {
                Object object = ((JComponent)component).getClientProperty(CLIENT_PROPERTY_SHRINK_SEARCHABLE_SUPPORT);
                if (object instanceof ShrinkSearchableSupport) {
                    ((ShrinkSearchableSupport)object).uninstallFilterableModel();
                }
                ((JComponent)component).putClientProperty(CLIENT_PROPERTY_SHRINK_SEARCHABLE_SUPPORT, this);
            }
            component.addPropertyChangeListener("model", this);
        }
        this.installFilterableModel();
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (this.needReinstallFilterableModel(propertyChangeEvent)) {
            this.installFilterableModel();
        }
    }

    protected boolean needReinstallFilterableModel(PropertyChangeEvent propertyChangeEvent) {
        return false;
    }

    @Override
    public void searchableEventFired(SearchableEvent searchableEvent) {
        if (searchableEvent.getID() == 3004 || searchableEvent.getID() == 3000) {
            this._searchable.setProcessModelChangeEvent(false);
            int n = this.getActualIndexAt((Integer)searchableEvent.getMatchingObject());
            this.applyFilter(searchableEvent.getSearchingText());
            int n2 = this.getVisualIndexAt(n);
            if (this.isRestoreSelection(n, n2) && n2 >= 0) {
                Component component = this._searchable.getComponent();
                if (component instanceof JComboBox) {
                    if (!((JComboBox)component).isEditable()) {
                        this._searchable.adjustSelectedIndex(n2, false);
                    }
                } else {
                    this._searchable.adjustSelectedIndex(n2, false);
                }
            }
            this._searchable.setProcessModelChangeEvent(true);
        }
    }

    protected boolean isRestoreSelection(int n, int n2) {
        return true;
    }

    protected String convertElementToString(Object object) {
        return this._searchable.convertToString(object);
    }

    protected abstract int getActualIndexAt(int var1);

    protected abstract int getVisualIndexAt(int var1);

    public abstract void installFilterableModel();

    public abstract void uninstallFilterableModel();

    protected abstract void applyFilter(String var1);
}

