/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.grid;

import com.jidesoft.converter.ConverterContext;
import com.jidesoft.converter.ObjectConverterManager;
import com.jidesoft.filter.Filter;
import com.jidesoft.grid.AbstractTableFilter;
import com.jidesoft.grid.ContextSensitiveTableModel;
import com.jidesoft.grid.DefaultGroupRow;
import com.jidesoft.grid.DefaultGroupTableModel;
import com.jidesoft.grid.FilterableTableModel;
import com.jidesoft.grid.FilterableTreeTableModel;
import com.jidesoft.grid.IExpandableTreeTableModel;
import com.jidesoft.grid.IFilterableTableModel;
import com.jidesoft.grid.QuickFilterField;
import com.jidesoft.grid.TableColumnChooserDialog;
import com.jidesoft.grid.TableModelWrapperUtils;
import com.jidesoft.grid.TableUtils;
import com.jidesoft.swing.JidePopupMenu;
import com.jidesoft.swing.JideSwingUtilities;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.JTable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class QuickTableFilterField
extends QuickFilterField
implements TableModelListener,
PropertyChangeListener {
    private transient TableModel _tableModel;
    private transient IFilterableTableModel _displayTableModel;
    private int[] _columnIndices;
    private String[] _displayNames;
    private int[] _searchingColumnIndices;
    protected Set<Integer> _actualSearchingColumnIndices;
    private int _searchingColumnIndex = -1;
    protected String _text;
    protected transient JTable _table;
    private TableColumnModelListener _columnModelListener;
    public static final String PROPERTY_SEARCHING_COLUMNS = "searchingColumns";
    private boolean _objectConverterManagerEnabled = false;
    private boolean _objectConverterManagerEnabledConfigured = false;
    private static final String CONTEXT_MENU_MORE = "TableColumnChooser.more";
    static final String LABEL_TEXT_NORMAL = "TableColumnChooserDialog.displayMessageForFilterField";
    private static final long serialVersionUID = -9085746251483021190L;
    private Set<Integer> _oldActualSearchingColumnIndices;
    private Filter _oldFilter = null;

    public QuickTableFilterField() {
        this(null, null, null);
    }

    public QuickTableFilterField(TableModel tableModel) {
        this(tableModel, null, null);
    }

    public QuickTableFilterField(TableModel tableModel, int[] nArray) {
        this(tableModel, nArray, null);
    }

    public QuickTableFilterField(TableModel tableModel, int[] nArray, String[] stringArray) {
        this.setTableModel(tableModel);
        this._displayNames = stringArray;
        this._actualSearchingColumnIndices = new HashSet<Integer>();
        this.setColumnIndices(nArray);
    }

    private void verifyColumnIndices() {
        if (this._displayNames != null && this._columnIndices != null && this._displayNames.length != this._columnIndices.length) {
            throw new IllegalArgumentException("The columnIndices and menuItemNames array should have the same length.");
        }
        if (this._columnIndices != null) {
            for (int i = this._columnIndices.length - 1; i >= 0; --i) {
                for (int j = i - 1; j >= 0; --j) {
                    if (this._columnIndices[i] != this._columnIndices[j]) continue;
                    throw new IllegalArgumentException("The columnIndices contains two equal column indices.");
                }
            }
        }
    }

    public int[] getColumnIndices() {
        return this._columnIndices;
    }

    public void setColumnIndices(int[] nArray) {
        this._columnIndices = nArray;
        if (!this.isIndicesValid(this._columnIndices)) {
            throw new IllegalArgumentException("The columnIndices array contains invalid column index.");
        }
        this.verifyColumnIndices();
        this.generateActualSearchingColumnIndices(this._searchingColumnIndices);
    }

    public String[] getDisplayNames() {
        return this._displayNames;
    }

    public void setDisplayNames(String[] stringArray) {
        this._displayNames = stringArray;
        this.verifyColumnIndices();
    }

    private void columnNameMenuItemSelected(JMenuItem jMenuItem, int n) {
        Integer[] integerArray;
        int[] nArray;
        Integer[] integerArray2 = this._actualSearchingColumnIndices.toArray(new Integer[this._actualSearchingColumnIndices.size()]);
        if (jMenuItem.isSelected()) {
            if (this.isSearchingAllColumns()) {
                nArray = new int[]{n};
            } else {
                integerArray = new HashSet();
                int[] objectArray = this.getSearchingColumnIndices();
                int n2 = objectArray.length;
                for (int i = 0; i < n2; ++i) {
                    int n3 = objectArray[i];
                    integerArray.add(n3);
                }
                integerArray.add(n);
                Integer[] objectArray2 = integerArray.toArray(new Integer[integerArray.size()]);
                nArray = new int[objectArray2.length];
                for (n2 = 0; n2 < objectArray2.length; ++n2) {
                    nArray[n2] = objectArray2[n2];
                }
            }
        } else {
            this._actualSearchingColumnIndices.remove(n);
            if (this._actualSearchingColumnIndices.size() == 0) {
                nArray = new int[]{};
            } else {
                integerArray = new HashSet();
                int[] nArray2 = this.getSearchingColumnIndices();
                int n4 = nArray2.length;
                for (int i = 0; i < n4; ++i) {
                    int n5 = nArray2[i];
                    if (n5 == n) continue;
                    integerArray.add(n5);
                }
                Integer[] integerArray3 = integerArray.toArray(new Integer[integerArray.size()]);
                nArray = new int[integerArray3.length];
                for (n4 = 0; n4 < integerArray3.length; ++n4) {
                    nArray[n4] = integerArray3[n4];
                }
            }
        }
        this.setSearchingColumnIndices(nArray);
        integerArray = this._actualSearchingColumnIndices.toArray(new Integer[this._actualSearchingColumnIndices.size()]);
        if (!JideSwingUtilities.equals(integerArray2, integerArray, true)) {
            this.firePropertyChange(PROPERTY_SEARCHING_COLUMNS, integerArray2, integerArray);
        }
        this.applyFilter();
    }

    @Override
    protected JidePopupMenu createContextMenu() {
        IFilterableTableModel iFilterableTableModel;
        JMenuItem jMenuItem;
        JidePopupMenu jidePopupMenu = new JidePopupMenu();
        if (this._tableModel != null) {
            Component component;
            String string;
            int n;
            int n2;
            boolean bl = this._tableModel.getColumnCount() <= 1;
            boolean bl2 = this.isSearchingAllColumns();
            if (!bl && this.getColumnIndices() != null && this.getColumnIndices().length == 1) {
                bl = true;
            }
            if (!bl) {
                final JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(this.getResourceString("Search.all"));
                jCheckBoxMenuItem.setSelected(bl2);
                jCheckBoxMenuItem.setName("Search.all");
                jCheckBoxMenuItem.addActionListener(new AbstractAction(){
                    private static final long serialVersionUID = 2025548201180071495L;

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        if (jCheckBoxMenuItem.isSelected()) {
                            QuickTableFilterField.this.setSearchingColumnIndices(null);
                            QuickTableFilterField.this.applyFilter();
                        }
                    }
                });
                jidePopupMenu.add(jCheckBoxMenuItem);
            }
            if (this.getColumnIndices() == null || this.getColumnIndices().length == 0) {
                for (n2 = 0; n2 < this._tableModel.getColumnCount(); ++n2) {
                    n = n2;
                    if (!this._displayTableModel.isColumnVisible(n)) continue;
                    string = this._displayNames != null && n < this._displayNames.length ? this._displayNames[n] : this._tableModel.getColumnName(n);
                    component = new JCheckBoxMenuItem(string);
                    component.setName(string);
                    ((AbstractButton)component).addActionListener(new AbstractAction((JMenuItem)component, n){
                        private static final long serialVersionUID = 5318289783184898572L;
                        final /* synthetic */ JMenuItem val$columnMenuItem;
                        final /* synthetic */ int val$index;
                        {
                            this.val$columnMenuItem = jMenuItem;
                            this.val$index = n;
                        }

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            QuickTableFilterField.this.columnNameMenuItemSelected(this.val$columnMenuItem, this.val$index);
                        }
                    });
                    ((AbstractButton)component).setSelected(this._actualSearchingColumnIndices.contains(n) && !bl2 || bl);
                    ((JMenuItem)component).setEnabled(!bl);
                    jidePopupMenu.add((JMenuItem)component);
                }
            } else {
                for (n2 = 0; n2 < this.getColumnIndices().length; ++n2) {
                    n = this.getColumnIndices()[n2];
                    if (!this._displayTableModel.isColumnVisible(n) || (string = this._displayNames != null ? this._displayNames[n2] : this._tableModel.getColumnName(n)) == null) continue;
                    component = new JCheckBoxMenuItem(string);
                    component.setName(string);
                    ((AbstractButton)component).addActionListener(new AbstractAction((JMenuItem)component, n){
                        private static final long serialVersionUID = -8556426498629734834L;
                        final /* synthetic */ JMenuItem val$columnMenuItem;
                        final /* synthetic */ int val$index;
                        {
                            this.val$columnMenuItem = jMenuItem;
                            this.val$index = n;
                        }

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            QuickTableFilterField.this.columnNameMenuItemSelected(this.val$columnMenuItem, this.val$index);
                        }
                    });
                    ((AbstractButton)component).setSelected(this._actualSearchingColumnIndices.contains(n) && !bl2 || bl);
                    ((JMenuItem)component).setEnabled(!bl);
                    jidePopupMenu.add((JMenuItem)component);
                }
            }
        }
        if (this.getTable() != null) {
            jMenuItem = new JMenuItem(new AbstractAction(this.getResourceString(CONTEXT_MENU_MORE)){
                private static final long serialVersionUID = 4928261057050416186L;

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Window window = JideSwingUtilities.getWindowForComponent(QuickTableFilterField.this.getTable());
                    TableColumnChooserDialog tableColumnChooserDialog = QuickTableFilterField.this.createFilterChooserDialog(window, QuickTableFilterField.this.getResourceString("Filter.FilterChooserDialogTitle"), QuickTableFilterField.this.getTable());
                    if (tableColumnChooserDialog == null) {
                        return;
                    }
                    tableColumnChooserDialog.setColumnIndices(QuickTableFilterField.this.getColumnIndices());
                    tableColumnChooserDialog.setSearchingColumnIndices(QuickTableFilterField.this.getSearchingColumnIndices());
                    tableColumnChooserDialog.pack();
                    tableColumnChooserDialog.setLocationRelativeTo(window == null ? QuickTableFilterField.this.getTable() : window);
                    tableColumnChooserDialog.setVisible(true);
                }
            });
            jMenuItem.setName(CONTEXT_MENU_MORE);
            jidePopupMenu.add(jMenuItem);
        }
        if (jidePopupMenu.getComponentCount() > 0) {
            Component[] componentArray;
            jidePopupMenu.addSeparator();
            JidePopupMenu jidePopupMenu2 = super.createContextMenu();
            for (Component component : componentArray = jidePopupMenu2.getComponents()) {
                jidePopupMenu.add(component);
            }
        } else {
            jidePopupMenu = super.createContextMenu();
        }
        if ((iFilterableTableModel = this.getDisplayTableModel()) instanceof FilterableTreeTableModel) {
            jidePopupMenu.addSeparator();
            final FilterableTreeTableModel filterableTreeTableModel = (FilterableTreeTableModel)iFilterableTableModel;
            jMenuItem = jidePopupMenu.add(new JCheckBoxMenuItem(this.getResourceString("Filter.keepParentRow.text")));
            jMenuItem.setMnemonic(this.getResourceString("Filter.keepParentRow.mnemonic").charAt(0));
            jMenuItem.setName("Filter.keepParentRow");
            jMenuItem.setSelected(filterableTreeTableModel.isKeepParentNode());
            jMenuItem.addActionListener(new AbstractAction(){
                private static final long serialVersionUID = -3945522516637473104L;

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
                    filterableTreeTableModel.setKeepParentNode(jMenuItem.isSelected());
                    if (QuickTableFilterField.this._searchingText != null && QuickTableFilterField.this._searchingText.length() != 0) {
                        QuickTableFilterField.this.setConfigurationChanged(true);
                        QuickTableFilterField.this.applyFilter();
                    }
                }
            });
            jMenuItem = jidePopupMenu.add(new JCheckBoxMenuItem(this.getResourceString("Filter.keepAllChildren.text")));
            jMenuItem.setMnemonic(this.getResourceString("Filter.keepAllChildren.mnemonic").charAt(0));
            jMenuItem.setName("Filter.keepAllChildren");
            jMenuItem.setSelected(filterableTreeTableModel.isKeepAllChildren());
            jMenuItem.addActionListener(new AbstractAction(){
                private static final long serialVersionUID = 8528828078810424802L;

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
                    filterableTreeTableModel.setKeepAllChildren(jMenuItem.isSelected());
                    if (QuickTableFilterField.this._searchingText != null && QuickTableFilterField.this._searchingText.length() != 0) {
                        QuickTableFilterField.this.setConfigurationChanged(true);
                        QuickTableFilterField.this.applyFilter();
                    }
                }
            });
        }
        return jidePopupMenu;
    }

    @Override
    public void applyFilter() {
        if (!("".equals(this.getSearchingText()) && "".equals(this._searchingText) || this._filter == null || !(this._filter instanceof FieldTableFilter))) {
            ((FieldTableFilter)this._filter).setSearchingText(this.getSearchingText());
        }
        super.applyFilter();
    }

    @Override
    public void applyFilter(String string) {
        if (this.getDisplayTableModel() != null) {
            this.changeFilter();
            this.getDisplayTableModel().setFiltersApplied(true);
            if (this.getTable() != null) {
                TableUtils.ensureRowSelectionVisible(this.getTable());
            }
            this.adjustMismatchColor(this.getDisplayTableModel().getRowCount() != 0);
        }
    }

    protected void changeFilter() {
        IFilterableTableModel iFilterableTableModel = this.getDisplayTableModel();
        if (this._oldFilter != null) {
            if (this._oldActualSearchingColumnIndices == null || this.isSearchingAllColumns(this._oldActualSearchingColumnIndices)) {
                this.removeFilter(iFilterableTableModel, -2, this._oldFilter);
            } else {
                for (int n : this._oldActualSearchingColumnIndices) {
                    this.removeFilter(iFilterableTableModel, n, this._oldFilter);
                }
            }
        }
        this._oldFilter = this.getFilter();
        if (this._oldActualSearchingColumnIndices == null) {
            this._oldActualSearchingColumnIndices = new HashSet<Integer>();
        }
        this._oldActualSearchingColumnIndices.clear();
        this._oldActualSearchingColumnIndices.addAll(this._actualSearchingColumnIndices);
        if (this._oldFilter != null) {
            if (this.isSearchingAllColumns(this._oldActualSearchingColumnIndices)) {
                this.addFilter(iFilterableTableModel, -2, this._oldFilter);
            } else {
                for (int n : this._oldActualSearchingColumnIndices) {
                    this.addFilter(iFilterableTableModel, n, this._oldFilter);
                }
            }
        }
    }

    protected void removeFilter(IFilterableTableModel iFilterableTableModel, int n, Filter filter) {
        iFilterableTableModel.removeFilter(n, filter);
    }

    protected void addFilter(IFilterableTableModel iFilterableTableModel, int n, Filter filter) {
        iFilterableTableModel.addFilter(n, filter);
    }

    public void setTableModel(TableModel tableModel) {
        if (this._tableModel != null) {
            this._tableModel.removeTableModelListener(this);
        }
        if (tableModel != null) {
            this._tableModel = tableModel;
            this._tableModel.addTableModelListener(this);
            this._displayTableModel = this.createFilterableTableModel(this._tableModel);
            this._displayTableModel.setAndMode(false);
            this.generateActualSearchingColumnIndices(this._searchingColumnIndices);
        }
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        if ((tableModelEvent == null || tableModelEvent.getFirstRow() == -1 && tableModelEvent.getColumn() == -1 && tableModelEvent.getType() == 0) && TableModelWrapperUtils.getActualTableModel(this._tableModel, DefaultGroupTableModel.class) == null) {
            this.generateActualSearchingColumnIndices(this._searchingColumnIndices);
        }
    }

    protected IFilterableTableModel createFilterableTableModel(TableModel tableModel) {
        return this.createDisplayTableModel(tableModel);
    }

    @Deprecated
    protected FilterableTableModel createDisplayTableModel(TableModel tableModel) {
        if (TableModelWrapperUtils.getActualTableModel(tableModel, IExpandableTreeTableModel.class) != null) {
            return new FilterableTreeTableModel(tableModel){
                private static final long serialVersionUID = -8908994354516796651L;

                @Override
                public boolean isColumnVisible(int n) {
                    return QuickTableFilterField.this.shouldColumnBeIncluded(n) && super.isColumnVisible(n);
                }
            };
        }
        return new FilterableTableModel(tableModel){
            private static final long serialVersionUID = -3186172862847068947L;

            @Override
            public boolean isColumnVisible(int n) {
                return QuickTableFilterField.this.shouldColumnBeIncluded(n) && super.isColumnVisible(n);
            }
        };
    }

    protected boolean shouldColumnBeIncluded(int n) {
        boolean bl;
        boolean bl2 = bl = this.getTable() == null || this.getTable().convertColumnIndexToView(n) != -1;
        if (bl && this._columnIndices != null) {
            if (this._tableModel instanceof DefaultGroupTableModel && (n = ((DefaultGroupTableModel)this._tableModel).getActualColumnAt(n)) == 0 && ((DefaultGroupTableModel)this._tableModel).hasGroupColumns()) {
                return bl;
            }
            for (int n2 : this._columnIndices) {
                if (n2 != n) continue;
                return bl;
            }
            return false;
        }
        return bl;
    }

    public TableModel getTableModel() {
        return this._tableModel;
    }

    public IFilterableTableModel getDisplayTableModel() {
        return this._displayTableModel;
    }

    public int[] getActualSearchingColumnIndices() {
        if (this._actualSearchingColumnIndices == null || this._actualSearchingColumnIndices.size() == 0) {
            return new int[0];
        }
        Object[] objectArray = this._actualSearchingColumnIndices.toArray();
        Arrays.sort(objectArray);
        int[] nArray = new int[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            nArray[i] = (Integer)objectArray[i];
        }
        return nArray;
    }

    public int[] getSearchingColumnIndices() {
        return this._searchingColumnIndices == null ? this.getActualSearchingColumnIndices() : this._searchingColumnIndices;
    }

    public void setSearchingColumnIndices(int[] nArray) {
        this._searchingColumnIndices = nArray;
        if (!this.isIndicesValid(this._searchingColumnIndices)) {
            this._searchingColumnIndices = null;
        }
        this.generateActualSearchingColumnIndices(this._searchingColumnIndices);
    }

    private boolean isIndicesValid(int[] nArray) {
        if (nArray != null && nArray.length > 0 && this._displayTableModel != null) {
            int n = this._displayTableModel.getColumnCount();
            for (int n2 : nArray) {
                if (n2 < n && n2 >= 0) continue;
                return false;
            }
        }
        return true;
    }

    private void generateActualSearchingColumnIndices(int[] nArray) {
        Integer[] integerArray;
        if (this._displayTableModel == null) {
            return;
        }
        Integer[] integerArray2 = null;
        if (this._actualSearchingColumnIndices == null) {
            this._actualSearchingColumnIndices = new HashSet<Integer>();
        } else {
            integerArray2 = this._actualSearchingColumnIndices.toArray(new Integer[this._actualSearchingColumnIndices.size()]);
            this._actualSearchingColumnIndices.clear();
        }
        int[] nArray2 = this.getColumnIndices();
        if (nArray == null) {
            for (int i = this._displayTableModel.getColumnCount() - 1; i >= 0; --i) {
                this._actualSearchingColumnIndices.add(i);
            }
        } else {
            for (int n : nArray) {
                this._actualSearchingColumnIndices.add(n);
            }
        }
        if (nArray2 != null) {
            HashSet<Integer> hashSet = new HashSet<Integer>();
            for (int n : nArray2) {
                hashSet.add(n);
            }
            this._actualSearchingColumnIndices.retainAll(hashSet);
        }
        if (!JideSwingUtilities.equals(integerArray2, integerArray = this._actualSearchingColumnIndices.toArray(new Integer[this._actualSearchingColumnIndices.size()]), true)) {
            this.firePropertyChange(PROPERTY_SEARCHING_COLUMNS, integerArray2, integerArray);
        }
    }

    protected boolean isSearchingAllColumns() {
        return this.isSearchingAllColumns(this._actualSearchingColumnIndices);
    }

    private boolean isSearchingAllColumns(Set<Integer> set) {
        if (set == null) {
            return true;
        }
        int[] nArray = this.getColumnIndices();
        return nArray == null ? set.size() == this._displayTableModel.getColumnCount() : set.size() == nArray.length;
    }

    @Deprecated
    public int getSearchingColumnIndex() {
        return this._searchingColumnIndex;
    }

    @Deprecated
    public void setSearchingColumnIndex(int n) {
        this._searchingColumnIndex = n;
        int[] nArray = new int[]{this._searchingColumnIndex};
        this.setSearchingColumnIndices(nArray);
    }

    public JTable getTable() {
        return this._table;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (this._columnModelListener == null) {
            this._columnModelListener = new FilterFieldColumnModelListener();
        }
        if (propertyChangeEvent.getOldValue() instanceof TableColumnModel) {
            ((TableColumnModel)propertyChangeEvent.getOldValue()).removeColumnModelListener(this._columnModelListener);
        }
        if (propertyChangeEvent.getNewValue() instanceof TableColumnModel) {
            ((TableColumnModel)propertyChangeEvent.getNewValue()).addColumnModelListener(this._columnModelListener);
        }
    }

    public void setTable(JTable jTable) {
        if (JideSwingUtilities.equals(this._table, jTable)) {
            return;
        }
        if (this._table != null) {
            if (this._columnModelListener != null) {
                this._table.getColumnModel().removeColumnModelListener(this._columnModelListener);
            }
            this._table.removePropertyChangeListener("columnModel", this);
        }
        this._table = jTable;
        if (this._table != null) {
            if (this._columnModelListener == null) {
                this._columnModelListener = new FilterFieldColumnModelListener();
            }
            this._table.getColumnModel().addColumnModelListener(this._columnModelListener);
            this._table.addPropertyChangeListener("columnModel", this);
        }
    }

    @Override
    protected Filter createFilter() {
        return new FieldTableFilter();
    }

    protected boolean compare(Object object, String string, int n, int n2) {
        Object object2;
        if (string != null && !this.isCaseSensitive()) {
            string = string.toLowerCase();
        }
        if (this._tableModel instanceof DefaultGroupTableModel && this._columnIndices != null && (object2 = ((DefaultGroupTableModel)this._tableModel).getRowAt(n)) instanceof DefaultGroupRow) {
            boolean bl = false;
            int n3 = ((DefaultGroupRow)object2).getConditionColumn(((DefaultGroupRow)object2).getNumberOfConditions() - 1);
            for (int n4 : this._columnIndices) {
                if (n4 != n3) continue;
                bl = true;
            }
            if (!bl) {
                return false;
            }
        }
        if (string != null) {
            object2 = this.convertElementToString(object, n, n2);
            return object2 != null && this.compare((String)(this.isCaseSensitive() ? object2 : ((String)object2).toLowerCase()), string);
        }
        return true;
    }

    protected String convertElementToString(Object object, int n, int n2) {
        if (this.needConvert()) {
            ConverterContext converterContext = ((ContextSensitiveTableModel)this.getTableModel()).getConverterContextAt(n, n2);
            Class<?> clazz = ((ContextSensitiveTableModel)this.getTableModel()).getCellClassAt(n, n2);
            return ObjectConverterManager.toString(object, clazz, converterContext);
        }
        return this.convertElementToString(object);
    }

    public boolean isObjectConverterManagerEnabled() {
        return this._objectConverterManagerEnabled;
    }

    public void setObjectConverterManagerEnabled(boolean bl) {
        this._objectConverterManagerEnabled = bl;
        this._objectConverterManagerEnabledConfigured = true;
    }

    @Override
    protected boolean isConfigurationChanged() {
        return this._filter != null && this._filter instanceof FieldTableFilter && ((FieldTableFilter)this._filter).isConfigureChanged();
    }

    @Override
    protected void setConfigurationChanged(boolean bl) {
        if (this._filter != null && this._filter instanceof FieldTableFilter) {
            ((FieldTableFilter)this._filter).setConfigureChanged(bl);
        }
    }

    private boolean needConvert() {
        if (!this._objectConverterManagerEnabledConfigured) {
            return this._tableModel instanceof ContextSensitiveTableModel;
        }
        return this.isObjectConverterManagerEnabled() && this._tableModel instanceof ContextSensitiveTableModel;
    }

    protected TableColumnChooserDialog createFilterChooserDialog(Window window, String string, JTable jTable) {
        TableColumnChooserDialog tableColumnChooserDialog = null;
        int[] nArray = this.getHiddenColumns();
        if (window instanceof Frame) {
            tableColumnChooserDialog = new TableColumnChooserDialog((Frame)window, string, jTable){

                @Override
                public String getLabelText(String string) {
                    if (string == null || string.equals("TableColumnChooserDialog.dispayMessage")) {
                        return this.getResourceString(QuickTableFilterField.LABEL_TEXT_NORMAL);
                    }
                    return super.getLabelText(string);
                }

                @Override
                protected AbstractAction getOkAction() {
                    return new AbstractAction(JideSwingUtilities.getOKString(QuickTableFilterField.this.getLocale())){
                        private static final long serialVersionUID = 1051918942053460016L;

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            int[] nArray = null;
                            if (_tree != null) {
                                nArray = this.getSelectedModelIndices(this.getSelectedColumns());
                            } else if (_list != null) {
                                nArray = this.getSelectedModelIndices(this.getSelectedColumns());
                            } else if (_dualList != null) {
                                nArray = this.getSelectedColumns();
                            }
                            if (nArray != null) {
                                QuickTableFilterField.this.setSearchingColumnIndices(nArray);
                            }
                            this.setDialogResult(0);
                            this.setVisible(false);
                        }
                    };
                }
            };
            if (jTable != null) {
                tableColumnChooserDialog.setHiddenColumns(nArray);
            }
        } else if (window instanceof Dialog) {
            tableColumnChooserDialog = new TableColumnChooserDialog((Dialog)window, string, jTable){

                @Override
                public String getLabelText(String string) {
                    if (string == null || string.equals("TableColumnChooserDialog.dispayMessage")) {
                        return this.getResourceString(QuickTableFilterField.LABEL_TEXT_NORMAL);
                    }
                    return super.getLabelText(string);
                }

                @Override
                protected AbstractAction getOkAction() {
                    return new AbstractAction(JideSwingUtilities.getOKString(QuickTableFilterField.this.getLocale())){
                        private static final long serialVersionUID = 1051918942053460016L;

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            int[] nArray = null;
                            if (_tree != null) {
                                nArray = this.getSelectedModelIndices(this.getSelectedColumns());
                            } else if (_list != null) {
                                nArray = this.getSelectedModelIndices(this.getSelectedColumns());
                            } else if (_dualList != null) {
                                nArray = this.getSelectedColumns();
                            }
                            if (nArray != null) {
                                QuickTableFilterField.this.setSearchingColumnIndices(nArray);
                            }
                            this.setDialogResult(0);
                            this.setVisible(false);
                        }
                    };
                }
            };
            if (jTable != null) {
                tableColumnChooserDialog.setHiddenColumns(nArray);
            }
        }
        return tableColumnChooserDialog;
    }

    private int[] getHiddenColumns() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int i = 0; i < this._displayTableModel.getColumnCount(); ++i) {
            if (this._displayTableModel.isColumnVisible(i)) continue;
            arrayList.add(i);
        }
        int[] nArray = new int[arrayList.size()];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = (Integer)arrayList.get(i);
        }
        return nArray;
    }

    protected class FieldTableFilter
    extends AbstractTableFilter {
        String _searchingText;
        private boolean _configureChanged;
        private static final long serialVersionUID = -4726586141238390688L;

        protected FieldTableFilter() {
        }

        public String getSearchingText() {
            return this._searchingText;
        }

        public void setSearchingText(String string) {
            this._searchingText = string;
        }

        public boolean isConfigureChanged() {
            return this._configureChanged;
        }

        public void setConfigureChanged(boolean bl) {
            this._configureChanged = bl;
        }

        @Override
        public boolean isValueFiltered(Object object) {
            if (QuickTableFilterField.this.needConvert()) {
                return !QuickTableFilterField.this.compare(object, this._searchingText, this.getRowIndex(), this.getColumnIndex());
            }
            return !QuickTableFilterField.this.compare(object, this._searchingText);
        }

        @Override
        public boolean stricterThan(Filter filter) {
            if (this.isConfigureChanged()) {
                return false;
            }
            if (QuickTableFilterField.this.isWildcardEnabled()) {
                return false;
            }
            if (QuickTableFilterField.this.isRegexEnabled()) {
                return false;
            }
            if (this.getClass() != filter.getClass()) {
                return false;
            }
            String string = ((FieldTableFilter)filter).getSearchingText();
            if (string == null) {
                return true;
            }
            if (this.getSearchingText() == null) {
                return false;
            }
            if (QuickTableFilterField.this.isFromStart() && QuickTableFilterField.this.isFromEnd()) {
                return this.getSearchingText().equals(string);
            }
            if (!QuickTableFilterField.this.isFromStart() && !QuickTableFilterField.this.isFromEnd()) {
                int n = this.getSearchingText().indexOf(string);
                if (n < 0) {
                    return false;
                }
                if (n == 0) {
                    return true;
                }
                String string2 = this.getSearchingText().substring(0, n);
                return !string2.contains("*");
            }
            if (!QuickTableFilterField.this.isFromStart() && QuickTableFilterField.this.isFromEnd()) {
                int n = this.getSearchingText().indexOf(string);
                if (n < 0) {
                    return false;
                }
                if (n + string.length() == this.getSearchingText().length()) {
                    return true;
                }
                String string3 = this.getSearchingText().substring(n + string.length());
                return !string3.contains("*");
            }
            if (QuickTableFilterField.this.isFromStart() && !QuickTableFilterField.this.isFromEnd()) {
                int n = this.getSearchingText().indexOf(string);
                if (n != 0) {
                    return false;
                }
                String string4 = this.getSearchingText().substring(n + string.length());
                return !string4.contains("*");
            }
            return false;
        }

        public Set<Integer> getActualSearchingColumnIndices() {
            return QuickTableFilterField.this._actualSearchingColumnIndices;
        }
    }

    private class FilterFieldColumnModelListener
    implements TableColumnModelListener,
    Serializable {
        private static final long serialVersionUID = 7623514082646486075L;

        private FilterFieldColumnModelListener() {
        }

        @Override
        public void columnAdded(TableColumnModelEvent tableColumnModelEvent) {
            this.applyFilterOnColumnChange();
        }

        @Override
        public void columnRemoved(TableColumnModelEvent tableColumnModelEvent) {
            this.applyFilterOnColumnChange();
        }

        @Override
        public void columnMoved(TableColumnModelEvent tableColumnModelEvent) {
        }

        @Override
        public void columnMarginChanged(ChangeEvent changeEvent) {
        }

        @Override
        public void columnSelectionChanged(ListSelectionEvent listSelectionEvent) {
        }

        private void applyFilterOnColumnChange() {
            boolean bl = false;
            IFilterableTableModel iFilterableTableModel = QuickTableFilterField.this.getDisplayTableModel();
            if (iFilterableTableModel != null && !iFilterableTableModel.isFilteringPaused() && !iFilterableTableModel.isFiltersApplied()) {
                if (iFilterableTableModel instanceof FilterableTableModel) {
                    bl = ((FilterableTableModel)iFilterableTableModel).isNeedFilterAllData();
                    ((FilterableTableModel)iFilterableTableModel).setNeedFilterAllData(true);
                }
                try {
                    QuickTableFilterField.this.applyFilter();
                }
                finally {
                    if (iFilterableTableModel instanceof FilterableTableModel) {
                        ((FilterableTableModel)iFilterableTableModel).setNeedFilterAllData(bl);
                    }
                }
            }
        }
    }
}

