/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.grid;

import com.jidesoft.grid.PagedTablePane;
import com.jidesoft.grid.TableModelWrapperUtils;
import com.jidesoft.paging.PageNavigationBar;
import com.jidesoft.paging.PageNavigationEvent;
import com.jidesoft.paging.PageNavigationListener;
import com.jidesoft.paging.PageNavigationSupport;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.TableModel;

public class PagedTablePaneNavigationBar
extends PageNavigationBar {
    private PagedTablePane _pane;

    public PagedTablePaneNavigationBar(PagedTablePane pagedTablePane) {
        this._pane = pagedTablePane;
        int n = 20;
        final JTable[] jTableArray = this._pane.getTables();
        int n2 = jTableArray.length;
        for (int i = 0; i < n2; ++i) {
            final JTable jTable = jTableArray[i];
            jTable.addMouseWheelListener(this.createMouseWheelListener());
            jTable.getSelectionModel().addListSelectionListener(this.createSelectionListener());
            TableModel object = TableModelWrapperUtils.getActualTableModel(jTable.getModel(), PageNavigationSupport.class);
            n = jTable.getPreferredScrollableViewportSize().height / jTable.getRowHeight();
            if (this._pageNavigationSupport == null) {
                if (object instanceof PageNavigationSupport) {
                    this._pageNavigationSupport = (PageNavigationSupport)((Object)object);
                } else {
                    this._pageNavigationSupport = this.createPageTableModel(jTable.getModel(), n);
                    jTable.setModel((TableModel)((Object)this._pageNavigationSupport));
                }
                this._pageNavigationSupport.addPageNavigationListener(this.createPageNavigationListener());
                final JScrollPane jScrollPane = (JScrollPane)SwingUtilities.getAncestorOfClass(JScrollPane.class, jTable);
                if (jScrollPane != null) {
                    jScrollPane.addComponentListener(new ComponentAdapter(){

                        @Override
                        public void componentResized(ComponentEvent componentEvent) {
                            int n = jScrollPane.getViewport().getHeight() / jTable.getRowHeight();
                            int n2 = jTableArray.length;
                            for (int i = 0; i < n2; ++i) {
                                JTable jTable2 = jTableArray[i];
                                PageNavigationSupport pageNavigationSupport = (PageNavigationSupport)((Object)TableModelWrapperUtils.getActualTableModel(jTable2.getModel(), PageNavigationSupport.class));
                                if (pageNavigationSupport == null) continue;
                                pageNavigationSupport.setPageSize(n);
                                pageNavigationSupport.setCurrentPage(i);
                            }
                        }
                    });
                }
            }
            if (!(object instanceof PageNavigationSupport)) continue;
            ((PageNavigationSupport)((Object)object)).setPageSize(n);
            ((PageNavigationSupport)((Object)object)).setCurrentPage(i);
        }
        this.initComponents();
        for (JTable jTable : jTableArray) {
            this.registerKeyboardActions(jTable);
        }
        if (this._pageNavigationSupport != null) {
            this._pageNavigationSupport.addPageNavigationListener(new PageNavigationListener(){

                @Override
                public void pageNavigationEventFired(PageNavigationEvent pageNavigationEvent) {
                    if (pageNavigationEvent.getID() == 14101) {
                        int n = pageNavigationEvent.getNewValue();
                        JTable[] jTableArray = PagedTablePaneNavigationBar.this._pane.getTables();
                        for (int i = 1; i < jTableArray.length; ++i) {
                            TableModel tableModel = TableModelWrapperUtils.getActualTableModel(jTableArray[i].getModel(), PageNavigationSupport.class);
                            if (tableModel == PagedTablePaneNavigationBar.this._pageNavigationSupport || !(tableModel instanceof PageNavigationSupport)) continue;
                            ((PageNavigationSupport)((Object)tableModel)).setCurrentPage(n + i);
                        }
                    }
                }
            });
            this._pageNavigationSupport.setPageSize(n);
        }
        this.updateNavigationField();
        this.updateButtonPanel();
    }

    @Override
    public void lastPage() {
        if (this._pageNavigationSupport != null) {
            int n = this.getSelectedRecordIndex();
            int n2 = this._pane.getTables().length;
            this._pageNavigationSupport.setCurrentPage(this._pageNavigationSupport.getPageCount() - n2);
            this.setSelectedRecordIndex(n);
            this.updateButtonPanel();
        }
    }

    @Override
    protected int getPageSize() {
        return this._pane.getTables().length * this._pageNavigationSupport.getPageSize();
    }

    @Override
    protected int getSelectedRecordIndex() {
        JTable[] jTableArray = this._pane.getTables();
        for (int i = 0; i < jTableArray.length; ++i) {
            JTable jTable = jTableArray[i];
            if (!jTable.hasFocus()) continue;
            return i * this._pageNavigationSupport.getPageSize() + jTable.getSelectedRow();
        }
        return -1;
    }

    @Override
    protected void setSelectedRecordIndex(int n) {
        JTable[] jTableArray = this._pane.getTables();
        int n2 = n / this._pageNavigationSupport.getPageSize();
        int n3 = n % this._pageNavigationSupport.getPageSize();
        if (jTableArray[n2] != null) {
            if (!jTableArray[n2].hasFocus()) {
                jTableArray[n2].requestFocus();
            }
            jTableArray[n2].getSelectionModel().setSelectionInterval(n3, n3);
        }
    }

    @Override
    protected void changeCurrentPage(int n) {
        this._pageNavigationSupport.setCurrentPage(n);
    }
}

