/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.grid;

import com.jidesoft.grid.DefaultPageTableModel;
import com.jidesoft.grid.JideTable;
import com.jidesoft.grid.SortableTable;
import com.jidesoft.grid.TableAdapter;
import com.jidesoft.grid.TableUtils;
import java.awt.GridLayout;
import java.awt.KeyboardFocusManager;
import java.util.TreeSet;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableModel;

public class PagedTablePane
extends JPanel
implements TableAdapter {
    private int _columns = 2;
    private int _visibleRows = 20;
    private TableModel _tableModel;
    private TableModel[] _models;
    private JTable[] _tables;
    protected boolean _rowSelectionAllowed = true;
    protected boolean _columnSelectionAllowed = false;
    protected boolean _nonContiguousCellSelectionAllowed = false;

    public PagedTablePane(TableModel tableModel) {
        this(tableModel, 2);
    }

    public PagedTablePane(TableModel tableModel, int n) {
        this._tableModel = tableModel;
        this._columns = n;
        this.setLayout(new GridLayout(1, this._columns));
        this._models = new TableModel[this._columns];
        this._tables = new JTable[this._columns];
        for (int i = 0; i < this._columns; ++i) {
            DefaultPageTableModel defaultPageTableModel = new DefaultPageTableModel(this._tableModel, this._visibleRows);
            this._models[i] = defaultPageTableModel;
            this._tables[i] = this.createTable(defaultPageTableModel);
            defaultPageTableModel.setCurrentPage(i);
            this.add(new JScrollPane(this._tables[i]));
        }
        TableUtils.synchronizeTableColumnWidth(this._tables);
        TableUtils.unifyTableRowSelection(this._tables);
    }

    @Override
    public void setModel(TableModel tableModel) {
        this._tableModel = tableModel;
        for (int i = 0; i < this._columns; ++i) {
            DefaultPageTableModel defaultPageTableModel = new DefaultPageTableModel(this._tableModel, this._visibleRows);
            this._models[i] = defaultPageTableModel;
            this._tables[i].setModel(defaultPageTableModel);
            defaultPageTableModel.setCurrentPage(i);
        }
    }

    @Override
    public TableModel getModel() {
        return this._tableModel;
    }

    protected JTable createTable(TableModel tableModel) {
        return new SortableTable(tableModel);
    }

    public JTable[] getTables() {
        return this._tables;
    }

    @Override
    public void setRowSelectionAllowed(boolean bl) {
        boolean bl2 = this._rowSelectionAllowed;
        this._rowSelectionAllowed = bl;
        if (bl2 != bl) {
            this.repaint();
            this.firePropertyChange("rowSelectionAllowed", bl2, bl);
            this.resynchronizeTablesSelection();
        }
    }

    @Override
    public boolean getRowSelectionAllowed() {
        return this._rowSelectionAllowed || this.isNonContiguousCellSelectionAllowed();
    }

    @Override
    public void setColumnSelectionAllowed(boolean bl) {
        boolean bl2 = this._columnSelectionAllowed;
        this._columnSelectionAllowed = bl;
        if (bl2 != bl) {
            this.repaint();
            this.firePropertyChange("columnSelectionAllowed", bl2, bl);
            this.resynchronizeTablesSelection();
        }
    }

    @Override
    public boolean getColumnSelectionAllowed() {
        return this._columnSelectionAllowed || this.isNonContiguousCellSelectionAllowed();
    }

    @Override
    public void setCellSelectionEnabled(boolean bl) {
        boolean bl2 = this.getCellSelectionEnabled();
        this.setRowSelectionAllowed(bl);
        this.setColumnSelectionAllowed(bl);
        this.firePropertyChange("cellSelectionEnabled", bl2, bl);
        this.resynchronizeTablesSelection();
    }

    @Override
    public boolean getCellSelectionEnabled() {
        return this.getRowSelectionAllowed() && this.getColumnSelectionAllowed();
    }

    public void setNonContiguousCellSelectionAllowed(boolean bl) {
        boolean bl2 = this._nonContiguousCellSelectionAllowed;
        this._nonContiguousCellSelectionAllowed = bl;
        if (bl2 != bl) {
            this.repaint();
            this.firePropertyChange("nonContiguousCellSelectionAllowed", bl2, bl);
            this.resynchronizeTablesSelection();
        }
    }

    public boolean isNonContiguousCellSelectionAllowed() {
        return this._nonContiguousCellSelectionAllowed;
    }

    protected void resynchronizeTablesSelection() {
        for (JTable jTable : this._tables) {
            if (jTable instanceof JideTable) {
                ((JideTable)jTable).setNonContiguousCellSelection(this.isNonContiguousCellSelectionAllowed());
            }
            jTable.setColumnSelectionAllowed(this.getColumnSelectionAllowed());
            jTable.setRowSelectionAllowed(this.getRowSelectionAllowed());
        }
    }

    @Override
    public int getRowCount() {
        int n = 0;
        for (JTable jTable : this._tables) {
            n += jTable.getRowCount();
        }
        return n;
    }

    @Override
    public int getColumnCount() {
        TablePosition tablePosition = this.getTableAtRow(0);
        return tablePosition.table != null ? tablePosition.table.getColumnCount() : 0;
    }

    public TablePosition getTableAtRow(int n) {
        for (JTable jTable : this._tables) {
            if (n < jTable.getRowCount()) {
                return new TablePosition(jTable, n, -1);
            }
            n -= jTable.getRowCount();
        }
        return null;
    }

    public TablePosition getTableAtCell(int n, int n2) {
        TablePosition tablePosition = this.getTableAtRow(n);
        return new TablePosition(tablePosition.table, tablePosition.row, n2);
    }

    @Override
    public String getColumnName(int n) {
        TablePosition tablePosition = this.getTableAtRow(0);
        return tablePosition != null ? tablePosition.table.getColumnName(n) : "";
    }

    @Override
    public Class<?> getColumnClass(int n) {
        TablePosition tablePosition = this.getTableAtRow(0);
        return tablePosition != null ? tablePosition.table.getColumnClass(n) : null;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        TablePosition tablePosition = this.getTableAtCell(n, n2);
        return tablePosition != null ? tablePosition.table.getValueAt(tablePosition.row, tablePosition.column) : null;
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        TablePosition tablePosition = this.getTableAtCell(n, n2);
        if (tablePosition != null) {
            tablePosition.table.setValueAt(object, tablePosition.row, tablePosition.column);
        }
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        TablePosition tablePosition = this.getTableAtCell(n, n2);
        return tablePosition != null ? Boolean.valueOf(tablePosition.table.isCellEditable(tablePosition.row, tablePosition.column)) : null;
    }

    @Override
    public int getSelectedRow() {
        int n = 0;
        for (JTable jTable : this._tables) {
            int n2 = jTable.getSelectedRow();
            if (n2 != -1) {
                return n2 + n;
            }
            n += jTable.getRowCount();
        }
        return -1;
    }

    @Override
    public int getSelectedColumn() {
        TablePosition tablePosition = this.getTableAtRow(0);
        return tablePosition != null ? tablePosition.table.getSelectedColumn() : -1;
    }

    @Override
    public int[] getSelectedRows() {
        int n = 0;
        int[][] nArrayArray = new int[this._tables.length][];
        int n2 = this._tables.length;
        for (int i = 0; i < n2; ++i) {
            JTable jTable = this._tables[i];
            nArrayArray[i] = jTable.getSelectedRows();
            for (int n3 : nArrayArray[i]) {
                n3 += n;
            }
            n += jTable.getRowCount();
        }
        return this.concat(nArrayArray);
    }

    @Override
    public int convertColumnIndexToView(int n) {
        TablePosition tablePosition = this.getTableAtRow(0);
        return tablePosition.table != null ? tablePosition.table.convertColumnIndexToView(n) : -1;
    }

    @Override
    public int convertColumnIndexToModel(int n) {
        TablePosition tablePosition = this.getTableAtRow(0);
        return tablePosition.table != null ? tablePosition.table.convertColumnIndexToModel(n) : -1;
    }

    private int[] concat(int[] ... nArray) {
        int n = 0;
        for (int[] nArray2 : nArray) {
            n += nArray2.length;
        }
        int[] nArray3 = new int[n];
        int n2 = 0;
        for (int[] nArray4 : nArray) {
            System.arraycopy(nArray4, 0, nArray3, n2, nArray4.length);
            n2 += nArray4.length;
        }
        return nArray3;
    }

    private int[] union(int[] ... nArray) {
        TreeSet<Integer> treeSet = new TreeSet<Integer>();
        int[][] object = nArray;
        int n = object.length;
        for (int iterator = 0; iterator < n; ++iterator) {
            int[] nArray2;
            for (int n2 : nArray2 = object[iterator]) {
                treeSet.add(n2);
            }
        }
        int[] nArray3 = new int[treeSet.size()];
        n = 0;
        for (Integer n3 : treeSet) {
            nArray3[n] = n3;
            ++n;
        }
        return nArray3;
    }

    @Override
    public int[] getSelectedColumns() {
        TablePosition tablePosition = this.getTableAtRow(0);
        return tablePosition.table != null ? tablePosition.table.getSelectedColumns() : null;
    }

    @Override
    public int getSelectedRowCount() {
        return this.getSelectedRows().length;
    }

    @Override
    public int getSelectedColumnCount() {
        return this.getSelectedColumns().length;
    }

    @Override
    public boolean isRowSelected(int n) {
        for (JTable jTable : this._tables) {
            boolean bl = jTable.isRowSelected(n);
            if (bl) {
                return true;
            }
            n -= jTable.getRowCount();
        }
        return false;
    }

    @Override
    public boolean isColumnSelected(int n) {
        TablePosition tablePosition = this.getTableAtRow(0);
        return tablePosition != null && tablePosition.table.isColumnSelected(n);
    }

    @Override
    public boolean isCellSelected(int n, int n2) {
        return !(!this.getRowSelectionAllowed() && !this.getColumnSelectionAllowed() || this.getRowSelectionAllowed() && !this.isRowSelected(n) || this.getColumnSelectionAllowed() && !this.isColumnSelected(n2));
    }

    @Override
    public void clearSelection() {
        for (JTable jTable : this._tables) {
            jTable.clearSelection();
        }
    }

    @Override
    public void changeSelection(int n, int n2, boolean bl, boolean bl2) {
        TablePosition tablePosition = this.getTableAtCell(n, n2);
        if (this.isAncestorOf(KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner())) {
            tablePosition.table.requestFocus();
        }
        tablePosition.table.changeSelection(tablePosition.row, tablePosition.column, bl, bl2);
    }

    public static class TablePosition {
        JTable table;
        int row = -1;
        int column = 1;

        public TablePosition(JTable jTable, int n, int n2) {
            this.table = jTable;
            this.row = n;
            this.column = n2;
        }

        public JTable getTable() {
            return this.table;
        }

        public int getRow() {
            return this.row;
        }

        public int getColumn() {
            return this.column;
        }
    }
}

