/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.grid;

import com.jidesoft.grid.ContextSensitiveTable;
import com.jidesoft.grid.NavigableModel;
import com.jidesoft.grid.TableModelWrapper;
import com.jidesoft.grid.TableModelWrapperUtils;
import java.awt.event.KeyEvent;
import java.util.Vector;
import javax.swing.InputMap;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class NavigableTable
extends ContextSensitiveTable {
    private static final String uiClassID = "NavigableTableUI";
    private KeyStroke _navigationKeyStroke = null;

    public NavigableTable() {
    }

    public NavigableTable(int n, int n2) {
        super(n, n2);
    }

    public NavigableTable(TableModel tableModel) {
        super(tableModel);
    }

    public NavigableTable(Object[][] objectArray, Object[] objectArray2) {
        super(objectArray, objectArray2);
    }

    public NavigableTable(Vector<? extends Vector> vector, Vector<?> vector2) {
        super(vector, vector2);
    }

    public NavigableTable(TableModel tableModel, TableColumnModel tableColumnModel) {
        super(tableModel, tableColumnModel);
    }

    public NavigableTable(TableModel tableModel, TableColumnModel tableColumnModel, ListSelectionModel listSelectionModel) {
        super(tableModel, tableColumnModel, listSelectionModel);
    }

    public TableModel getNavigableModel() {
        TableModel tableModel = this.getModel();
        if (tableModel instanceof NavigableModel) {
            return tableModel;
        }
        TableModel tableModel2 = TableModelWrapperUtils.getActualTableModel(tableModel, NavigableModel.class);
        if (tableModel2 != null) {
            return tableModel2;
        }
        return tableModel;
    }

    public TableModel getNextNavigableModel(TableModel tableModel) {
        if (tableModel instanceof TableModelWrapper) {
            return TableModelWrapperUtils.getActualTableModel(((TableModelWrapper)((Object)tableModel)).getActualModel(), NavigableModel.class);
        }
        return null;
    }

    public boolean isCellNavigable(int n, int n2) {
        if (n2 < 0 || n2 >= this.getColumnModel().getColumnCount()) {
            return true;
        }
        int n3 = this.convertColumnIndexToModel(n2);
        TableModel tableModel = this.getNavigableModel();
        while (tableModel != null) {
            if (tableModel instanceof NavigableModel && ((NavigableModel)((Object)tableModel)).isNavigationOn()) {
                int n4 = TableModelWrapperUtils.getActualRowAt(this.getModel(), n, tableModel);
                int n5 = TableModelWrapperUtils.getActualColumnAt(this.getModel(), n3, tableModel);
                if (n4 == -1 || n5 == -1) break;
                boolean bl = ((NavigableModel)((Object)tableModel)).isNavigableAt(n4, n5);
                if (!bl) {
                    return false;
                }
            }
            tableModel = this.getNextNavigableModel(tableModel);
        }
        return true;
    }

    protected boolean isNavigationKey(KeyStroke keyStroke) {
        return keyStroke == null || keyStroke.getKeyCode() == 9 || keyStroke.getKeyCode() == 10;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean processKeyBinding(KeyStroke keyStroke, KeyEvent keyEvent, int n, boolean bl) {
        try {
            if (bl && this.isNavigationKey(keyStroke)) {
                this._navigationKeyStroke = keyStroke;
            }
            boolean bl2 = super.processKeyBinding(keyStroke, keyEvent, n, bl);
            return bl2;
        }
        finally {
            this._navigationKeyStroke = null;
        }
    }

    @Override
    public void changeSelection(int n, int n2, boolean bl, boolean bl2) {
        if (!this.isCellNavigable(n, n2)) {
            this.scrollRectToVisible(this.getCellRect(n, n2, true));
            int n3 = this.getSelectedRow();
            int n4 = this.getSelectedColumn();
            int n5 = n;
            int n6 = n2;
            int n7 = this.getRowCount();
            int n8 = this.getColumnCount();
            int[] nArray = null;
            if (this.isNavigationKey(this._navigationKeyStroke) && this._navigationKeyStroke != null) {
                InputMap inputMap = this.getInputMap(1);
                Object object = inputMap.get(this._navigationKeyStroke);
                if ("selectNextColumnCell".equals(object)) {
                    nArray = this.findNextNavigableCell(n, n2, n3, n4, n7, n8);
                } else if ("selectPreviousColumnCell".equals(object)) {
                    nArray = this.findPreviousNavigableCell(n, n2, n3, n4, n7, n8);
                } else if ("selectNextRowCell".equals(object)) {
                    nArray = this.findNextNavigableCellVertically(n, n2, n3, n4, n7, n8);
                } else if ("selectPreviousRowCell".equals(object)) {
                    nArray = this.findPreviousNavigableCellVertically(n, n2, n3, n4, n7, n8);
                } else if ("selectNextColumn".equals(object) || "selectNextColumnExtendSelection".equals(object)) {
                    if (bl2) {
                        --n6;
                    }
                    nArray = this.findNextNavigableCellInRow(n, n2, n8);
                } else if ("selectPreviousColumn".equals(object) || "selectPreviousColumnExtendSelection".equals(object)) {
                    if (bl2) {
                        ++n6;
                    }
                    nArray = this.findPreviousNavigableCellInRow(n, n2);
                } else if ("selectNextRow".equals(object) || "selectNextRowExtendSelection".equals(object)) {
                    if (bl2) {
                        --n5;
                    }
                    nArray = this.findNextNavigableCellInColumn(n, n2, n7);
                } else if ("selectPreviousRow".equals(object) || "selectPreviousRowExtendSelection".equals(object)) {
                    if (bl2) {
                        ++n5;
                    }
                    nArray = this.findPreviousNavigableCellInColumn(n, n2);
                } else if ("selectFirstColumn".equals(object)) {
                    nArray = this.findNextNavigableCellInRow(n, n2, n8);
                } else if ("selectFirstRow".equals(object)) {
                    nArray = this.findNextNavigableCellInColumn(n, n2, n7);
                } else if ("selectLastColumn".equals(object)) {
                    nArray = this.findPreviousNavigableCellInRow(n, n2);
                } else if ("selectLastRow".equals(object)) {
                    nArray = this.findPreviousNavigableCellInColumn(n, n2);
                } else if ("scrollUpChangeSelection".equals(object)) {
                    nArray = this.findPreviousNavigableCellInColumn(n, n2);
                } else if ("scrollLeftChangeSelection".equals(object)) {
                    nArray = this.findNextNavigableCellInRow(n, n2, n8);
                } else if ("scrollDownChangeSelection".equals(object)) {
                    nArray = this.findNextNavigableCellInColumn(n, n2, n7);
                } else if ("scrollRightChangeSelection".equals(object)) {
                    nArray = this.findPreviousNavigableCellInRow(n, n2);
                }
                if (nArray == null && !bl2) {
                    nArray = new int[]{n3, n4};
                }
            }
            if (nArray != null) {
                n5 = nArray[0];
                n6 = nArray[1];
            }
            super.changeSelection(n5, n6, bl, bl2);
        } else {
            super.changeSelection(n, n2, bl, bl2);
        }
    }

    protected int[] findNextNavigableCell(int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = n5 * n6;
        do {
            if (++n2 >= n6) {
                n2 = 0;
                if (++n >= n5) {
                    n = 0;
                }
            }
            if (n == n3 && n2 == n4) {
                return null;
            }
            if (!this.isCellNavigable(n, n2)) continue;
            return new int[]{n, n2};
        } while (--n7 > 0);
        return null;
    }

    protected int[] findNextNavigableCellVertically(int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = n5 * n6;
        do {
            if (++n >= n5) {
                n = 0;
                if (++n2 >= n6) {
                    n2 = 0;
                }
            }
            if (n2 == n4 && n == n3) {
                return null;
            }
            if (!this.isCellNavigable(n, n2)) continue;
            return new int[]{n, n2};
        } while (--n7 > 0);
        return null;
    }

    protected int[] findPreviousNavigableCell(int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = n5 * n6;
        do {
            if (--n2 < 0) {
                n2 = n6 - 1;
                if (--n < 0) {
                    n = n5 - 1;
                }
            }
            if (n == n3 && n2 == n4) {
                return null;
            }
            if (!this.isCellNavigable(n, n2)) continue;
            return new int[]{n, n2};
        } while (--n7 > 0);
        return null;
    }

    protected int[] findPreviousNavigableCellVertically(int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = n5 * n6;
        do {
            if (--n < 0) {
                n = n5 - 1;
                if (--n2 < 0) {
                    n2 = n6 - 1;
                }
            }
            if (n2 == n4 && n == n3) {
                return null;
            }
            if (!this.isCellNavigable(n, n2)) continue;
            return new int[]{n, n2};
        } while (--n7 > 0);
        return null;
    }

    protected int[] findNextNavigableCellInRow(int n, int n2, int n3) {
        do {
            if (++n2 < n3) continue;
            return null;
        } while (!this.isCellNavigable(n, n2));
        return new int[]{n, n2};
    }

    protected int[] findPreviousNavigableCellInRow(int n, int n2) {
        do {
            if (--n2 >= 0) continue;
            return null;
        } while (!this.isCellNavigable(n, n2));
        return new int[]{n, n2};
    }

    protected int[] findNextNavigableCellInColumn(int n, int n2, int n3) {
        do {
            if (++n < n3) continue;
            return null;
        } while (!this.isCellNavigable(n, n2));
        return new int[]{n, n2};
    }

    protected int[] findPreviousNavigableCellInColumn(int n, int n2) {
        do {
            if (--n >= 0) continue;
            return null;
        } while (!this.isCellNavigable(n, n2));
        return new int[]{n, n2};
    }

    protected int[] findNearestNavigableCellInRow(int n, int n2, int n3, int n4, int n5, int n6) {
        int[] nArray;
        if (n2 > n4) {
            nArray = this.findPreviousNavigableCellInRow(n, n2);
            if (nArray != null && nArray[0] == n3 && nArray[1] == n4) {
                nArray = this.findPreviousNavigableCellInRow(n3, n4);
            }
            if (nArray == null) {
                nArray = this.findNextNavigableCellInRow(n, n2, n6);
            }
        } else {
            nArray = this.findNextNavigableCellInRow(n, n2, n6);
            if (nArray != null && nArray[0] == n3 && nArray[1] == n4) {
                nArray = this.findNextNavigableCellInRow(n3, n4, n6);
            }
            if (nArray == null) {
                nArray = this.findPreviousNavigableCellInRow(n, n2);
            }
        }
        return nArray;
    }

    protected int[] findNearestNavigableCellInColumn(int n, int n2, int n3, int n4, int n5, int n6) {
        int[] nArray;
        if (n2 > n4) {
            nArray = this.findPreviousNavigableCellInColumn(n2, n2);
            if (nArray != null && nArray[0] == n4 && nArray[1] == n4) {
                nArray = this.findPreviousNavigableCellInColumn(n4, n4);
            }
            if (nArray == null) {
                nArray = this.findNextNavigableCellInColumn(n2, n2, n5);
            }
        } else {
            nArray = this.findNextNavigableCellInColumn(n2, n2, n5);
            if (nArray != null && nArray[0] == n4 && nArray[1] == n4) {
                nArray = this.findNextNavigableCellInColumn(n4, n4, n5);
            }
            if (nArray == null) {
                nArray = this.findPreviousNavigableCellInColumn(n2, n2);
            }
        }
        return nArray;
    }
}

