/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.grid;

import com.jidesoft.grid.JideTable;
import com.jidesoft.grid.TableModelWrapperUtils;
import com.jidesoft.grid.TableSelectionModel;
import com.jidesoft.grid.TableUndoableSupport;
import com.jidesoft.grid.TableUtils;
import com.jidesoft.swing.UndoableSupport;
import com.jidesoft.utils.BasicTransferable;
import com.jidesoft.utils.PortingUtils;
import com.jidesoft.utils.SystemInfo;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Vector;
import javax.swing.DropMode;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.TransferHandler;
import javax.swing.table.TableModel;

public class JideTableTransferHandler
extends TransferHandler {
    private static final long serialVersionUID = 7764619447770703404L;
    int[] _rows;
    int[] _cols;
    private int[] _droppedRows;
    private int[] _droppedCols;
    private boolean _insertRows;
    private boolean _acceptImport = false;

    public JideTableTransferHandler(String string) {
        super(string);
    }

    public JideTableTransferHandler() {
    }

    @Override
    protected Transferable createTransferable(JComponent jComponent) {
        this.cleanUpFields();
        if (jComponent instanceof JTable) {
            JTable jTable = (JTable)jComponent;
            int[] nArray = this.getSelectedRows(jTable);
            int[] nArray2 = this.getSelectedColumns(jTable);
            if (nArray == null || nArray2 == null || nArray.length == 0 || nArray2.length == 0 || !this.isValidSelection(jTable, nArray, nArray2)) {
                PortingUtils.notifyUser(jTable);
                return null;
            }
            StringBuffer stringBuffer = new StringBuffer();
            StringBuffer stringBuffer2 = new StringBuffer();
            stringBuffer2.append("<html>\n<body>\n<table>\n");
            for (int n : nArray) {
                stringBuffer2.append("<tr>\n");
                for (int n2 : nArray2) {
                    Object object = null;
                    if (jTable.isCellSelected(n, n2)) {
                        object = jTable.getValueAt(n, n2);
                    }
                    String string = this.convertElementToString(jTable, n, n2, object);
                    stringBuffer.append(string).append("\t");
                    stringBuffer2.append("  <td>").append(string).append("</td>\n");
                }
                stringBuffer.deleteCharAt(stringBuffer.length() - 1).append("\n");
                stringBuffer2.append("</tr>\n");
            }
            stringBuffer.deleteCharAt(stringBuffer.length() - 1);
            stringBuffer2.append("</table>\n</body>\n</html>");
            this._rows = nArray;
            this._cols = nArray2;
            return new BasicTransferable(stringBuffer.toString(), stringBuffer2.toString());
        }
        return null;
    }

    protected boolean isValidSelection(JTable jTable, int[] nArray, int[] nArray2) {
        if (jTable instanceof JideTable && ((JideTable)jTable).isNonContiguousCellSelection()) {
            for (int n : nArray) {
                for (int n2 : nArray2) {
                    if (jTable.isCellSelected(n, n2)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean importData(JComponent jComponent, Transferable transferable) {
        if (this.canImport(jComponent, transferable.getTransferDataFlavors())) {
            try {
                String string = (String)transferable.getTransferData(DataFlavor.stringFlavor);
                Field[] fieldArray = transferable.getClass().getDeclaredFields();
                boolean bl = false;
                for (Field field : fieldArray) {
                    if (!"isLocal".equals(field.getName())) continue;
                    boolean bl2 = field.isAccessible();
                    field.setAccessible(true);
                    try {
                        bl = field.getBoolean(transferable);
                        break;
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        break;
                    }
                    finally {
                        field.setAccessible(bl2);
                    }
                }
                if (!this.importString(jComponent, string, bl)) {
                    PortingUtils.notifyUser(jComponent);
                    return false;
                }
                return true;
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return false;
    }

    @Override
    public boolean canImport(JComponent jComponent, DataFlavor[] dataFlavorArray) {
        if (!(jComponent instanceof JTable) || !jComponent.isEnabled() || ((JTable)jComponent).isEditing() || !this.isAcceptImport()) {
            return false;
        }
        JTable jTable = (JTable)jComponent;
        if (SystemInfo.isJdk6Above() && (jTable.getDropMode() == DropMode.INSERT_COLS || jTable.getDropMode() == DropMode.ON_OR_INSERT_COLS)) {
            return false;
        }
        for (DataFlavor dataFlavor : dataFlavorArray) {
            if (!DataFlavor.stringFlavor.equals(dataFlavor)) continue;
            return true;
        }
        return false;
    }

    protected boolean importString(JComponent jComponent, String string, boolean bl) {
        if (!(jComponent instanceof JTable) || !jComponent.isEnabled() || ((JTable)jComponent).isEditing()) {
            return false;
        }
        JTable jTable = (JTable)jComponent;
        TableModel tableModel = TableModelWrapperUtils.getActualTableModel(jTable.getModel(), TableUndoableSupport.class);
        int n = tableModel instanceof TableUndoableSupport ? tableModel.getColumnCount() : 0;
        this._insertRows = false;
        if (SystemInfo.isJdk6Above() && jTable.getDropLocation() != null) {
            Object[] objectArray;
            int n2;
            JTable.DropLocation dropLocation = jTable.getDropLocation();
            if (dropLocation.isInsertColumn()) {
                return false;
            }
            this._insertRows = dropLocation.isInsertRow();
            int n3 = dropLocation.getRow();
            int n4 = jTable.getRowCount();
            if (n3 < 0 || n3 > n4) {
                n3 = n4;
            }
            String[] stringArray = string.split("\n");
            int n5 = jTable.getColumnCount();
            if (tableModel instanceof UndoableSupport) {
                ((UndoableSupport)((Object)tableModel)).beginCompoundEdit(false);
            }
            this._droppedRows = new int[stringArray.length];
            int n6 = 0;
            int n7 = dropLocation.getColumn();
            int n8 = -1;
            String[] stringArray2 = stringArray;
            int n9 = stringArray2.length;
            for (n2 = 0; n2 < n9; ++n2) {
                objectArray = stringArray2[n2];
                String[] stringArray3 = objectArray.split("\t", jTable.getColumnCount());
                if (n8 < 0) {
                    n8 = stringArray3.length;
                    continue;
                }
                if (n8 == stringArray3.length) continue;
                return false;
            }
            if (n8 + n7 > jTable.getColumnCount()) {
                n7 = 0;
            }
            boolean bl2 = this.isCellSelection(jTable);
            HashSet<Integer> hashSet = new HashSet<Integer>();
            int n10 = n2 = tableModel instanceof TableUndoableSupport ? TableModelWrapperUtils.getActualRowAt(jTable.getModel(), n3, tableModel) : -1;
            if (n2 < 0) {
                n2 = tableModel.getRowCount();
            }
            for (String string2 : stringArray) {
                int n11;
                String[] stringArray4 = string2.split("\t", jTable.getColumnCount());
                Vector<Object> vector = new Vector<Object>();
                if (dropLocation.isInsertRow()) {
                    int n12;
                    int n13;
                    for (n13 = 0; n13 < n5; ++n13) {
                        vector.add(null);
                    }
                    for (n13 = 0; n13 < stringArray4.length; ++n13) {
                        n12 = n13 + n7;
                        if (bl2 && this._cols != null && this._cols.length == stringArray4.length && dropLocation.getColumn() == this._cols[0]) {
                            n12 = this._cols[n13];
                        }
                        if (n12 >= n5) break;
                        try {
                            vector.remove(n12);
                            vector.add(n12, this.convertStringToElement(jTable, n3, n12, stringArray4[n13]));
                            hashSet.add(n12);
                            continue;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    Object[] objectArray2 = new Object[tableModel.getColumnCount()];
                    for (n12 = 0; n12 < tableModel.getColumnCount(); ++n12) {
                        int n14 = jTable.convertColumnIndexToView(TableModelWrapperUtils.getColumnAt(jTable.getModel(), tableModel, n12));
                        if (n14 < 0 || n14 >= vector.size()) continue;
                        objectArray2[n12] = vector.get(n14);
                    }
                    Vector<Object> vector2 = new Vector<Object>();
                    vector2.addAll(Arrays.asList(objectArray2));
                    ((TableUndoableSupport)((Object)tableModel)).undoableInsertRow(n2, vector2);
                    this._droppedRows[n6++] = n2++;
                    continue;
                }
                int n15 = n11 = tableModel instanceof TableUndoableSupport ? TableModelWrapperUtils.getActualRowAt(jTable.getModel(), n3, tableModel) : -1;
                if (tableModel instanceof TableUndoableSupport) {
                    for (int i = 0; i < n; ++i) {
                        vector.add(tableModel.getValueAt(n11, i));
                    }
                }
                for (int i = 0; i < stringArray4.length; ++i) {
                    int n16 = i + n7;
                    if (bl2 && this._cols != null && this._cols.length == stringArray4.length && dropLocation.getColumn() == this._cols[0]) {
                        n16 = this._cols[i];
                    }
                    if (n16 >= n5) break;
                    if (!jTable.isCellEditable(n3, n16)) {
                        PortingUtils.notifyUser(jTable);
                        continue;
                    }
                    try {
                        Object object = this.convertStringToElement(jTable, n3, n16, stringArray4[i]);
                        if (tableModel == null) {
                            jTable.setValueAt(object, n3, n16);
                        } else {
                            int n17 = TableModelWrapperUtils.getActualColumnAt(jTable.getModel(), jTable.convertColumnIndexToModel(n16), tableModel);
                            if (n17 >= 0 && n17 < vector.size()) {
                                vector.remove(n17);
                                vector.add(n17, object);
                            }
                        }
                        hashSet.add(n16);
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (tableModel instanceof TableUndoableSupport) {
                    ((TableUndoableSupport)((Object)tableModel)).undoableUpdateRow(n11, vector);
                }
                this._droppedRows[n6++] = n11;
                ++n3;
            }
            if (hashSet.size() > 0) {
                this._droppedCols = new int[hashSet.size()];
                objectArray = hashSet.toArray(new Integer[hashSet.size()]);
                for (int i = 0; i < objectArray.length; ++i) {
                    this._droppedCols[i] = (Integer)objectArray[i];
                }
                Arrays.sort(this._droppedCols);
            }
            if (tableModel instanceof UndoableSupport) {
                ((UndoableSupport)((Object)tableModel)).endCompoundEdit();
            }
            if (!bl) {
                if (this._droppedRows != null) {
                    for (int i = 0; i < this._droppedRows.length; ++i) {
                        this._droppedRows[i] = TableModelWrapperUtils.getRowAt(jTable.getModel(), tableModel, this._droppedRows[i]);
                    }
                }
                if (this._droppedRows != null && this._droppedRows.length > 0) {
                    if (this._droppedCols == null) {
                        this.adjustSelection(jTable, this._droppedRows, new int[]{jTable.getSelectedColumn()}, this._droppedRows.length, 1, this._droppedRows[0], jTable.getSelectedColumn());
                    } else {
                        this.adjustSelection(jTable, this._droppedRows, this._droppedCols, this._droppedRows.length, this._droppedCols.length, this._droppedRows[0], this._droppedCols[0]);
                    }
                }
                this._droppedRows = null;
            }
        } else {
            Object object;
            int n18;
            int n19;
            int[] nArray = this.getSelectedRows(jTable);
            int[] nArray2 = this.getSelectedColumns(jTable);
            if (nArray == null || nArray2 == null || !this.isValidSelection(jTable, nArray, nArray2)) {
                return false;
            }
            String[] stringArray = string.split("\n");
            int n20 = nArray.length;
            int n21 = nArray2.length;
            int n22 = nArray.length == 0 ? 0 : nArray[0];
            for (n19 = 1; n19 < nArray.length; ++n19) {
                if (n22 <= nArray[n19]) continue;
                n22 = nArray[n19];
            }
            n19 = nArray2.length == 0 ? 0 : nArray2[0];
            for (n18 = 1; n18 < nArray2.length; ++n18) {
                if (n19 <= nArray2[n18]) continue;
                n19 = nArray2[n18];
            }
            n18 = stringArray.length;
            if (n18 <= 0) {
                return false;
            }
            int n23 = -1;
            for (String string3 : stringArray) {
                object = string3.split("\t", jTable.getColumnCount());
                if (n23 < 0) {
                    n23 = ((String[])object).length;
                    continue;
                }
                if (n23 == ((String[])object).length) continue;
                return false;
            }
            if (n20 < n18) {
                n20 = n18;
                for (int i = 0; i < nArray2.length; ++i) {
                    if (nArray2[i] == n19 + i) continue;
                    return false;
                }
            } else if (n20 % n18 != 0) {
                n20 = n18;
            }
            if (n21 < n23) {
                n21 = n23;
                for (int i = 0; i < nArray.length; ++i) {
                    if (nArray[i] == n22 + i) continue;
                    return false;
                }
            } else if (n21 % n23 != 0) {
                n21 = n23;
            }
            if (n19 + n21 > jTable.getColumnCount()) {
                return false;
            }
            if (tableModel instanceof UndoableSupport) {
                ((UndoableSupport)((Object)tableModel)).beginCompoundEdit(false);
            }
            for (int i = 0; i < n20; ++i) {
                int n24;
                int n25;
                String string4 = stringArray[i % n18];
                String[] stringArray5 = string4.split("\t", jTable.getColumnCount());
                int n26 = i < nArray.length ? nArray[i] : n22 + i;
                object = new Vector();
                int n27 = n25 = tableModel instanceof TableUndoableSupport ? TableModelWrapperUtils.getActualRowAt(jTable.getModel(), n26, tableModel) : -1;
                if (tableModel instanceof TableUndoableSupport) {
                    for (n24 = 0; n24 < n; ++n24) {
                        ((Vector)object).add(tableModel.getValueAt(n25, n24));
                    }
                }
                for (n24 = 0; n24 < n21; ++n24) {
                    int n28;
                    int n29 = n28 = n24 < nArray2.length ? nArray2[n24] : n19 + n24;
                    if (!jTable.isCellEditable(n26, n28)) {
                        PortingUtils.notifyUser(jTable);
                        continue;
                    }
                    try {
                        Object object2 = this.convertStringToElement(jTable, n26, n28, stringArray5[n24 % n23]);
                        if (tableModel == null) {
                            jTable.setValueAt(object2, n26, n28);
                            continue;
                        }
                        int n30 = TableModelWrapperUtils.getActualColumnAt(jTable.getModel(), jTable.convertColumnIndexToModel(n28), tableModel);
                        if (n30 < 0 || n30 >= ((Vector)object).size()) continue;
                        ((Vector)object).remove(n30);
                        ((Vector)object).add(n30, object2);
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (!(tableModel instanceof TableUndoableSupport)) continue;
                if (n25 >= jTable.getRowCount()) {
                    ((TableUndoableSupport)((Object)tableModel)).undoableInsertRow(n25, (Vector<Object>)object);
                    continue;
                }
                ((TableUndoableSupport)((Object)tableModel)).undoableUpdateRow(n25, (Vector<Object>)object);
            }
            if (tableModel instanceof UndoableSupport) {
                ((UndoableSupport)((Object)tableModel)).endCompoundEdit();
            }
            if (n20 != nArray.length || n21 != nArray2.length) {
                this.adjustSelection(jTable, nArray, nArray2, n20, n21, n22, n19);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void adjustSelection(JTable jTable, int[] nArray, int[] nArray2, int n, int n2, int n3, int n4) {
        ListSelectionModel listSelectionModel = jTable.getSelectionModel();
        ListSelectionModel listSelectionModel2 = jTable.getColumnModel().getSelectionModel();
        if (jTable instanceof JideTable && ((JideTable)jTable).isNonContiguousCellSelection()) {
            TableSelectionModel tableSelectionModel = ((JideTable)jTable).getTableSelectionModel();
            tableSelectionModel.setValueAdjusting(true);
            listSelectionModel.setValueIsAdjusting(true);
            listSelectionModel2.setValueIsAdjusting(true);
            try {
                tableSelectionModel.clearSelection();
                if (n > nArray.length) {
                    for (int i = 0; i < n; ++i) {
                        int n5;
                        if (n2 > nArray2.length) {
                            for (n5 = 0; n5 < n2; ++n5) {
                                tableSelectionModel.addSelection(n3 + i, n4 + n5);
                            }
                            continue;
                        }
                        for (n5 = 0; n5 < n2; ++n5) {
                            tableSelectionModel.addSelection(n3 + i, nArray2[n5]);
                        }
                    }
                } else {
                    for (int i = 0; i < n; ++i) {
                        int n6;
                        if (n2 > nArray2.length) {
                            for (n6 = 0; n6 < n2; ++n6) {
                                tableSelectionModel.addSelection(nArray[i], n4 + n6);
                            }
                            continue;
                        }
                        for (n6 = 0; n6 < n2; ++n6) {
                            tableSelectionModel.addSelection(nArray[i], nArray2[n6]);
                        }
                    }
                }
                tableSelectionModel.moveLeadSelection(nArray[0], nArray2[0]);
                listSelectionModel.addSelectionInterval(nArray[0], nArray[0]);
                listSelectionModel2.addSelectionInterval(nArray2[0], nArray2[0]);
                return;
            }
            finally {
                tableSelectionModel.setValueAdjusting(false);
                listSelectionModel.setValueIsAdjusting(false);
                listSelectionModel2.setValueIsAdjusting(false);
            }
        }
        if (jTable.getRowSelectionAllowed() && !jTable.getColumnSelectionAllowed()) {
            int n7 = jTable.getSelectedColumn();
            listSelectionModel.setValueIsAdjusting(true);
            listSelectionModel2.setValueIsAdjusting(true);
            try {
                listSelectionModel.clearSelection();
                listSelectionModel2.clearSelection();
                if (n > nArray.length) {
                    listSelectionModel.addSelectionInterval(n3, n3 + n - 1);
                } else {
                    for (int i = 0; i < n; ++i) {
                        listSelectionModel.addSelectionInterval(nArray[i], nArray[i]);
                    }
                }
                if (n7 >= 0) {
                    listSelectionModel2.addSelectionInterval(n7, n7);
                }
            }
            finally {
                listSelectionModel.setValueIsAdjusting(false);
                listSelectionModel2.setValueIsAdjusting(false);
            }
            TableUtils.ensureRowSelectionVisible(jTable);
            return;
        }
        if (!jTable.getRowSelectionAllowed() && jTable.getColumnSelectionAllowed()) {
            listSelectionModel2.setValueIsAdjusting(true);
            listSelectionModel.setValueIsAdjusting(true);
            try {
                int n8 = jTable.getSelectedRow();
                listSelectionModel.clearSelection();
                listSelectionModel2.clearSelection();
                if (n2 > nArray2.length) {
                    listSelectionModel2.addSelectionInterval(n4, n4 + n2 - 1);
                } else {
                    for (int i = 0; i < n2; ++i) {
                        listSelectionModel2.addSelectionInterval(nArray2[i], nArray2[i]);
                    }
                }
                if (n8 < 0) return;
                listSelectionModel.addSelectionInterval(n8, n8);
                return;
            }
            finally {
                listSelectionModel.setValueIsAdjusting(false);
                listSelectionModel2.setValueIsAdjusting(false);
            }
        }
        listSelectionModel2.setValueIsAdjusting(true);
        listSelectionModel.setValueIsAdjusting(true);
        try {
            listSelectionModel.clearSelection();
            listSelectionModel2.clearSelection();
            listSelectionModel.addSelectionInterval(n3, n3 + n - 1);
            listSelectionModel2.addSelectionInterval(n4, n4 + n2 - 1);
            return;
        }
        finally {
            listSelectionModel.setValueIsAdjusting(false);
            listSelectionModel2.setValueIsAdjusting(false);
        }
    }

    @Deprecated
    protected boolean insertRow(JTable jTable, int n, Vector<Object> vector) {
        TableUndoableSupport tableUndoableSupport = (TableUndoableSupport)((Object)TableModelWrapperUtils.getActualTableModel(jTable.getModel(), TableUndoableSupport.class));
        if (tableUndoableSupport == null || !(tableUndoableSupport instanceof TableModel)) {
            return false;
        }
        n = TableModelWrapperUtils.getActualRowAt(jTable.getModel(), n, (TableModel)((Object)tableUndoableSupport));
        Object[] objectArray = new Object[((TableModel)((Object)tableUndoableSupport)).getColumnCount()];
        for (int i = 0; i < ((TableModel)((Object)tableUndoableSupport)).getColumnCount(); ++i) {
            int n2 = jTable.convertColumnIndexToView(TableModelWrapperUtils.getColumnAt(jTable.getModel(), (TableModel)((Object)tableUndoableSupport), i));
            if (n2 < 0 || n2 >= vector.size()) continue;
            objectArray[i] = vector.get(n2);
        }
        Vector<Object> vector2 = new Vector<Object>();
        vector2.addAll(Arrays.asList(objectArray));
        tableUndoableSupport.undoableInsertRow(n, vector2);
        return true;
    }

    @Deprecated
    protected boolean removeRow(JTable jTable, int n) {
        TableUndoableSupport tableUndoableSupport = (TableUndoableSupport)((Object)TableModelWrapperUtils.getActualTableModel(jTable.getModel(), TableUndoableSupport.class));
        if (tableUndoableSupport == null || !(tableUndoableSupport instanceof TableModel)) {
            return false;
        }
        n = TableModelWrapperUtils.getActualRowAt(jTable.getModel(), n, (TableModel)((Object)tableUndoableSupport));
        tableUndoableSupport.undoableRemoveRow(n);
        return true;
    }

    protected String convertElementToString(JTable jTable, int n, int n2, Object object) {
        return object == null ? "" : object.toString();
    }

    protected Object convertStringToElement(JTable jTable, int n, int n2, String string) {
        return string;
    }

    protected int[] getSelectedRows(JTable jTable) {
        int[] nArray;
        if (jTable instanceof JideTable && ((JideTable)jTable).isNonContiguousCellSelection()) {
            nArray = jTable.getSelectedRows();
        } else {
            if (!jTable.getRowSelectionAllowed() && !jTable.getColumnSelectionAllowed()) {
                return null;
            }
            if (!jTable.getRowSelectionAllowed()) {
                int n = jTable.getRowCount();
                nArray = new int[n];
                for (int i = 0; i < n; ++i) {
                    nArray[i] = i;
                }
            } else {
                nArray = jTable.getSelectedRows();
            }
        }
        return nArray;
    }

    protected int[] getSelectedColumns(JTable jTable) {
        int[] nArray;
        if (jTable instanceof JideTable && ((JideTable)jTable).isNonContiguousCellSelection()) {
            nArray = jTable.getSelectedColumns();
        } else {
            if (!jTable.getRowSelectionAllowed() && !jTable.getColumnSelectionAllowed()) {
                return null;
            }
            if (!jTable.getColumnSelectionAllowed()) {
                int n = jTable.getColumnCount();
                nArray = new int[n];
                for (int i = 0; i < n; ++i) {
                    nArray[i] = i;
                }
            } else {
                nArray = jTable.getSelectedColumns();
            }
        }
        return nArray;
    }

    @Override
    public int getSourceActions(JComponent jComponent) {
        if (!(jComponent instanceof JTable)) {
            return 0;
        }
        if (!SystemInfo.isJdk6Above()) {
            return 3;
        }
        if (!(((JTable)jComponent).getDropLocation() == null || !((JTable)jComponent).getRowSelectionAllowed() || ((JTable)jComponent).getColumnSelectionAllowed() || jComponent instanceof JideTable && ((JideTable)jComponent).isNonContiguousCellSelection())) {
            return 2;
        }
        return 3;
    }

    @Override
    protected void exportDone(JComponent jComponent, Transferable transferable, int n) {
        super.exportDone(jComponent, transferable, n);
        this.cleanup(jComponent, n == 2);
    }

    protected void cleanup(JComponent jComponent, boolean bl) {
        int n;
        int n2;
        if (!(jComponent instanceof JTable)) {
            this.cleanUpFields();
            return;
        }
        if (!bl && !this._insertRows && this._droppedRows == null) {
            this.cleanUpFields();
            return;
        }
        JTable jTable = (JTable)jComponent;
        TableModel tableModel = TableModelWrapperUtils.getActualTableModel(jTable.getModel(), TableUndoableSupport.class);
        if (tableModel instanceof UndoableSupport) {
            ((UndoableSupport)((Object)tableModel)).beginCompoundEdit(false);
        }
        int[] nArray = null;
        boolean bl2 = this.isCellSelection(jTable);
        if (bl && this._rows != null && tableModel != null) {
            nArray = new int[this._rows.length];
            for (n2 = 0; n2 < this._rows.length; ++n2) {
                nArray[n2] = TableModelWrapperUtils.getActualRowAt(jTable.getModel(), this._rows[n2], tableModel);
                if (this._droppedRows == null || this._droppedRows.length <= 0 || tableModel == jTable.getModel() || !this._insertRows || nArray[n2] < this._droppedRows[0]) continue;
                int n3 = n2;
                nArray[n3] = nArray[n3] + this._droppedRows.length;
            }
        }
        if (bl && this._rows != null) {
            if (!bl2 || this._cols == null || this._cols.length <= 0) {
                if (tableModel instanceof TableUndoableSupport) {
                    Arrays.sort(nArray);
                    for (n2 = nArray.length - 1; n2 >= 0; --n2) {
                        ((TableUndoableSupport)((Object)tableModel)).undoableRemoveRow(nArray[n2]);
                    }
                }
            } else if (nArray != null) {
                for (n2 = nArray.length - 1; n2 >= 0; --n2) {
                    Vector<Object> vector = new Vector<Object>();
                    int n4 = nArray[n2];
                    if (tableModel instanceof TableUndoableSupport) {
                        for (int i = 0; i < tableModel.getColumnCount(); ++i) {
                            vector.add(tableModel.getValueAt(n4, i));
                        }
                    }
                    int[] nArray2 = this._cols;
                    n = nArray2.length;
                    for (int i = 0; i < n; ++i) {
                        int n5 = nArray2[i];
                        if (!jTable.isCellEditable(this._rows[n2], n5)) {
                            PortingUtils.notifyUser(jTable);
                            continue;
                        }
                        try {
                            if (tableModel == null) {
                                jTable.setValueAt(null, this._rows[n2], n5);
                                continue;
                            }
                            int n6 = TableModelWrapperUtils.getActualColumnAt(jTable.getModel(), jTable.convertColumnIndexToModel(n5), tableModel);
                            if (n6 < 0 || n6 >= vector.size()) continue;
                            vector.remove(n6);
                            vector.add(n6, null);
                            continue;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (!(tableModel instanceof TableUndoableSupport)) continue;
                    ((TableUndoableSupport)((Object)tableModel)).undoableUpdateRow(n4, vector);
                }
            }
        }
        if (!(nArray == null || this._droppedRows == null || bl2 && this._cols != null && this._cols.length > 0)) {
            for (int n7 : nArray) {
                for (n = 0; n < this._droppedRows.length; ++n) {
                    if (this._droppedRows[n] < n7) continue;
                    int n8 = n;
                    this._droppedRows[n8] = this._droppedRows[n8] - 1;
                }
            }
        }
        if (tableModel instanceof UndoableSupport) {
            ((UndoableSupport)((Object)tableModel)).endCompoundEdit();
        }
        if (this._droppedRows != null) {
            for (int i = 0; i < this._droppedRows.length; ++i) {
                this._droppedRows[i] = TableModelWrapperUtils.getRowAt(jTable.getModel(), tableModel, this._droppedRows[i]);
            }
        }
        if (this._droppedRows != null && this._droppedRows.length > 0) {
            if (bl2 && this._droppedCols != null && this._droppedCols.length > 0) {
                this.adjustSelection(jTable, this._droppedRows, this._droppedCols, this._droppedRows.length, this._droppedCols.length, this._droppedRows[0], this._droppedCols[0]);
            } else if (bl2 && this._cols != null && this._cols.length > 0) {
                this.adjustSelection(jTable, this._droppedRows, this._cols, this._droppedRows.length, this._cols.length, this._droppedRows[0], this._cols[0]);
            } else {
                this.adjustSelection(jTable, this._droppedRows, new int[]{jTable.getSelectedColumn()}, this._droppedRows.length, 1, this._droppedRows[0], jTable.getSelectedColumn());
            }
        } else {
            jTable.clearSelection();
        }
        this.cleanUpFields();
    }

    protected void cleanUpFields() {
        this._insertRows = false;
        this._droppedRows = null;
        this._droppedCols = null;
        this._rows = null;
        this._cols = null;
    }

    protected boolean isCellSelection(JTable jTable) {
        return jTable instanceof JideTable && ((JideTable)jTable).isNonContiguousCellSelection() || jTable.getRowSelectionAllowed() && jTable.getColumnSelectionAllowed();
    }

    public boolean isAcceptImport() {
        return this._acceptImport;
    }

    public void setAcceptImport(boolean bl) {
        this._acceptImport = bl;
    }
}

