/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.grid;

import com.jidesoft.grid.AutoFilterTableHeader;
import com.jidesoft.grid.GridResource;
import com.jidesoft.grid.GroupModelProvider;
import com.jidesoft.grid.GroupTableInputListener;
import com.jidesoft.grid.TableModelWrapperUtils;
import com.jidesoft.plaf.DelegateTableHeaderUI;
import com.jidesoft.plaf.basic.BasicGroupTableHeaderUIDelegate;
import com.jidesoft.swing.JideSwingUtilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JTable;
import javax.swing.SizeSequence;

public class GroupTableHeader
extends AutoFilterTableHeader {
    private static final Insets GROUP_HEADER_MARGIN = new Insets(3, 1, 3, 1);
    private final GroupTableInputListener _listener;
    private final SizeSequence _groupedWidths = new SizeSequence();
    public static final String PROPERTY_MARGIN = "margin";
    public static final String PROPERTY_VERTICAL_INDENTION = "verticalIndention";
    public static final String PROPERTY_CONNECTION_LINE_VISIBLE = "connectionLineVisible";
    public static final String PROPERTY_GROUP_HEADER_ENABLED = "groupHeaderEnabled";
    public static final String PROPERTY_GROUP_AREA_BACKGROUND = "groupAreaBackground";
    public static final String PROPERTY_GROUP_AREA_FOREGROUND = "groupAreaForeground";
    public static final String PROPERTY_GROUP_AREA_LABEL_FONT = "groupAreaLabelFont";
    static final int GROUP_COLUMN_RESERVED = -2;
    private Insets _margin = GROUP_HEADER_MARGIN;
    private int _focusedGroupIndex = -1;
    private int _verticalIndention = -1;
    private int _labelHeight = -1;
    private Font _labelFont;
    private Color _groupAreaBackground;
    private Color _groupAreaForeground = Color.GRAY;
    private boolean _connectionLineVisible = true;
    private boolean _groupHeaderEnabled;
    private static final String uiClassID = "GroupTableHeaderUI";
    private static final String uiDelegateClassID = "TableHeader.groupTableHeaderUIDelegate";

    public GroupTableHeader(JTable jTable) {
        super(jTable);
        this._listener = this.createGroupTableInputListener();
    }

    @Override
    public String getActualUIClassID() {
        return uiClassID;
    }

    @Override
    public String getUIDelegateClassID() {
        return uiDelegateClassID;
    }

    @Override
    public void setTable(JTable jTable) {
        if (jTable == null || TableModelWrapperUtils.getActualTableModel(jTable.getModel(), GroupModelProvider.class) == null) {
            // empty if block
        }
        super.setTable(jTable);
    }

    @Override
    public void setComponentOrientation(ComponentOrientation componentOrientation) {
        super.setComponentOrientation(componentOrientation);
        Component component = this.getDefaultRenderer().getTableCellRendererComponent(this.getTable(), "", false, false, -1, -1);
        component.applyComponentOrientation(componentOrientation);
        this.repaint();
    }

    public Color getGroupAreaBackground() {
        return this._groupAreaBackground;
    }

    public void setGroupAreaBackground(Color color) {
        Color color2 = this._groupAreaBackground;
        if (color2 != color) {
            this._groupAreaBackground = color;
            this.firePropertyChange(PROPERTY_GROUP_AREA_BACKGROUND, color2, this._groupAreaBackground);
        }
    }

    public Color getGroupAreaForeground() {
        return this._groupAreaForeground;
    }

    public void setGroupAreaForeground(Color color) {
        Color color2 = this._groupAreaForeground;
        if (color2 != color) {
            this._groupAreaForeground = color;
            this.firePropertyChange(PROPERTY_GROUP_AREA_FOREGROUND, color2, this._groupAreaForeground);
        }
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (this._listener.isDragging()) {
            this._listener.drawItem(graphics);
        }
    }

    private int getLeftMargin() {
        boolean bl = this.getComponentOrientation().isLeftToRight();
        return bl ? this.getMargin().left : this.getMargin().right;
    }

    public int getActualHeaderHeight() {
        return this.getUI() instanceof DelegateTableHeaderUI && ((DelegateTableHeaderUI)((Object)this.getUI())).getHeaderUIDelegate() instanceof BasicGroupTableHeaderUIDelegate ? ((BasicGroupTableHeaderUIDelegate)((DelegateTableHeaderUI)((Object)this.getUI())).getHeaderUIDelegate()).getActualHeaderHeight() : super.getPreferredSize().height;
    }

    @Override
    public int getActualHeaderY() {
        if (!this.isGroupHeaderEnabled()) {
            return 0;
        }
        return this.getHeight() - this.getActualHeaderHeight();
    }

    GroupModelProvider getGroupTableModel() {
        return (GroupModelProvider)((Object)TableModelWrapperUtils.getActualTableModel(this.getTable().getModel(), GroupModelProvider.class));
    }

    @Override
    public Rectangle getHeaderRect(int n) {
        Rectangle rectangle = super.getHeaderRect(n);
        if (!this.isGroupHeaderEnabled()) {
            return rectangle;
        }
        rectangle.y = this.getActualHeaderY();
        rectangle.height = this.getActualHeaderHeight();
        return rectangle;
    }

    @Override
    public int columnAtPoint(Point point) {
        if (!this.isGroupHeaderEnabled()) {
            return super.columnAtPoint(point);
        }
        int n = this.getActualHeaderY();
        if (point.y >= n) {
            return super.columnAtPoint(point);
        }
        return -1;
    }

    public int groupedColumnAtPoint(Point point) {
        if (this.isGroupHeaderEnabled() && point.y < this.getActualHeaderY() - this.getMargin().bottom) {
            int n;
            int n2 = point.x;
            if (!this.getComponentOrientation().isLeftToRight()) {
                n2 = this.getWidth() - n2;
            }
            if (n2 > this._groupedWidths.getPosition(n = this._groupedWidths.getSizes().length) + this._groupedWidths.getSize(n)) {
                return -1;
            }
            return this._groupedWidths.getIndex(n2 - this.getLeftMargin());
        }
        return -1;
    }

    public Rectangle getGroupedHeaderRect(int n) {
        GroupModelProvider groupModelProvider = this.getGroupTableModel();
        if (!this.isGroupHeaderEnabled() || groupModelProvider == null) {
            return new Rectangle();
        }
        if (n >= groupModelProvider.getGroupColumnCount()) {
            return new Rectangle();
        }
        boolean bl = this.getComponentOrientation().isLeftToRight();
        Rectangle rectangle = new Rectangle();
        if (this.getUI() instanceof DelegateTableHeaderUI && ((DelegateTableHeaderUI)((Object)this.getUI())).getHeaderUIDelegate() instanceof BasicGroupTableHeaderUIDelegate) {
            BasicGroupTableHeaderUIDelegate basicGroupTableHeaderUIDelegate = (BasicGroupTableHeaderUIDelegate)((DelegateTableHeaderUI)((Object)this.getUI())).getHeaderUIDelegate();
            rectangle.x = this.getLeftMargin();
            rectangle.y = this.getMargin() == null ? 0 : this.getMargin().top;
            rectangle.width = basicGroupTableHeaderUIDelegate.getActualModelPreferredWidth(groupModelProvider.getGroupColumnAt(n));
            rectangle.height = basicGroupTableHeaderUIDelegate.getGroupColumnPreferredHeight(n);
            for (int i = 0; i < n; ++i) {
                rectangle.x += basicGroupTableHeaderUIDelegate.getActualModelPreferredWidth(groupModelProvider.getGroupColumnAt(i)) + this.getMargin().left + this.getMargin().right;
                rectangle.y += this.getActualVerticalIndention(i + 1);
            }
        } else {
            rectangle.height = this.getActualHeaderHeight();
            rectangle.y = this.getMargin().top + n * this.getActualVerticalIndention();
            int n2 = groupModelProvider.getGroupColumnCount();
            if (n < 0) {
                rectangle.x = this.getLeftMargin();
            } else {
                boolean bl2;
                boolean bl3 = bl2 = n >= n2;
                if (bl2) {
                    n = n2 - 1;
                }
                rectangle.x = this._groupedWidths.getPosition(n) + this.getLeftMargin();
                rectangle.width = this._groupedWidths.getSize(n) - this.getMargin().left - this.getMargin().right;
                if (bl2) {
                    rectangle.x += rectangle.width + this.getMargin().left + this.getMargin().right;
                    rectangle.width = 0;
                }
            }
        }
        if (!bl) {
            rectangle.x = this.getWidth() - rectangle.x - rectangle.width;
        }
        return rectangle;
    }

    public void setGroupedWidths(int[] nArray) {
        this._groupedWidths.setSizes(nArray);
    }

    protected GroupTableInputListener createGroupTableInputListener() {
        return new GroupTableInputListener(this);
    }

    public void setMargin(Insets insets) {
        if (this._margin != insets) {
            Insets insets2 = this._margin;
            this._margin = insets;
            this.firePropertyChange(PROPERTY_MARGIN, insets2, this._margin);
        }
    }

    public Insets getMargin() {
        return this._margin;
    }

    public int getRollOverGroupColumn() {
        return this._focusedGroupIndex;
    }

    void setGroupedRollOverColumn(int n) {
        if (n != this._focusedGroupIndex) {
            int n2 = this._focusedGroupIndex;
            this._focusedGroupIndex = n;
            if (n2 != -1) {
                this.repaint(this.getGroupedHeaderRect(n2));
            }
            if (n != -1) {
                this.repaint(this.getGroupedHeaderRect(n));
            }
        }
    }

    protected int toggleSortOrder(int n) {
        if (n == 0) {
            return 1;
        }
        if (n == 1) {
            return -1;
        }
        return 1;
    }

    public String getResourceString(String string) {
        return GridResource.getResourceBundle(this.getLocale()).getString(string);
    }

    private int getActualVerticalIndention(int n) {
        if (this.getVerticalIndention() < 0 && this.getUI() instanceof DelegateTableHeaderUI && ((DelegateTableHeaderUI)((Object)this.getUI())).getHeaderUIDelegate() instanceof BasicGroupTableHeaderUIDelegate) {
            return ((BasicGroupTableHeaderUIDelegate)((DelegateTableHeaderUI)((Object)this.getUI())).getHeaderUIDelegate()).getGroupColumnPreferredHeight(n) / 2;
        }
        return this.getVerticalIndention();
    }

    private int getActualVerticalIndention() {
        if (this.getVerticalIndention() < 0) {
            return this.getActualHeaderHeight() / 2;
        }
        return this.getVerticalIndention();
    }

    public int getVerticalIndention() {
        return this._verticalIndention;
    }

    public void setVerticalIndention(int n) {
        if (this._verticalIndention != n) {
            int n2 = this._verticalIndention;
            this._verticalIndention = n;
            this.firePropertyChange(PROPERTY_VERTICAL_INDENTION, n2, this._verticalIndention);
            this.revalidate();
            this.repaint();
            if (this.getParent() != null) {
                this.getParent().invalidate();
                this.getParent().repaint();
            }
        }
    }

    public boolean isConnectionLineVisible() {
        return this._connectionLineVisible;
    }

    public void setConnectionLineVisible(boolean bl) {
        if (this._connectionLineVisible != bl) {
            boolean bl2 = this._connectionLineVisible;
            this._connectionLineVisible = bl;
            this.firePropertyChange(PROPERTY_CONNECTION_LINE_VISIBLE, bl2, this._connectionLineVisible);
            this.revalidate();
            this.repaint();
        }
    }

    public boolean isGroupHeaderEnabled() {
        return this._groupHeaderEnabled;
    }

    public void setGroupHeaderEnabled(boolean bl) {
        if (this._groupHeaderEnabled != bl) {
            boolean bl2 = this._groupHeaderEnabled;
            this._groupHeaderEnabled = bl;
            if (this._groupHeaderEnabled) {
                JideSwingUtilities.insertMouseListener(this, this._listener, 0);
                JideSwingUtilities.insertMouseMotionListener(this, this._listener, 0);
            } else {
                this.removeMouseListener(this._listener);
                this.removeMouseListener(this._listener);
            }
            this.firePropertyChange(PROPERTY_GROUP_HEADER_ENABLED, bl2, this._groupHeaderEnabled);
            this.revalidate();
            this.repaint();
            if (this.getParent() != null) {
                this.getParent().invalidate();
                this.getParent().repaint();
            }
        }
    }

    public int getLabelHeight() {
        return this._labelHeight;
    }

    public void setLabelHeight(int n) {
        if (this._labelHeight == n) {
            return;
        }
        this._labelHeight = n;
        this.invalidate();
        this.repaint();
        if (this.getParent() != null) {
            this.getParent().invalidate();
            this.getParent().doLayout();
        }
    }

    public Font getLabelFont() {
        return this._labelFont;
    }

    public void setLabelFont(Font font) {
        Font font2 = this._labelFont;
        if (font2 != font) {
            this._labelFont = font;
            this.firePropertyChange(PROPERTY_GROUP_AREA_LABEL_FONT, font2, this._labelFont);
        }
    }
}

