/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.grid;

import com.jidesoft.converter.ConverterContext;
import com.jidesoft.converter.ObjectConverterManager;
import com.jidesoft.grid.ContextSensitiveCellEditor;
import com.jidesoft.swing.JideSwingUtilities;
import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.text.Format;
import java.text.ParseException;
import javax.swing.InputMap;
import javax.swing.JFormattedTextField;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.text.DefaultFormatterFactory;

public class FormattedTextFieldCellEditor
extends ContextSensitiveCellEditor
implements FocusListener {
    protected JFormattedTextField _textField;
    private Class<?> _class;
    private static final long serialVersionUID = -4551936760002995641L;
    private boolean _settingEditorValue;
    private boolean _textValid;

    public FormattedTextFieldCellEditor() {
        this(String.class);
    }

    public FormattedTextFieldCellEditor(Class<?> clazz) {
        this(clazz, (Format)null);
    }

    public FormattedTextFieldCellEditor(Class<?> clazz, Format format) {
        this._class = clazz;
        this._textField = this.createFormattedTextField(format);
        this.setupTextField();
    }

    public FormattedTextFieldCellEditor(Class<?> clazz, JFormattedTextField.AbstractFormatter abstractFormatter) {
        this._class = clazz;
        this._textField = this.createFormattedTextField(abstractFormatter);
        this.setupTextField();
    }

    protected JFormattedTextField createFormattedTextField(Format format) {
        return new JFormattedTextField(format){

            @Override
            protected void invalidEdit() {
                if (FormattedTextFieldCellEditor.this._settingEditorValue) {
                    FormattedTextFieldCellEditor.this._textValid = false;
                } else {
                    super.invalidEdit();
                }
            }
        };
    }

    protected JFormattedTextField createFormattedTextField(JFormattedTextField.AbstractFormatter abstractFormatter) {
        return new JFormattedTextField(abstractFormatter){

            @Override
            protected void invalidEdit() {
                if (FormattedTextFieldCellEditor.this._settingEditorValue) {
                    FormattedTextFieldCellEditor.this._textValid = false;
                } else {
                    super.invalidEdit();
                }
            }
        };
    }

    protected void customizeTextField() {
        this._textField.setBorder(DEFAULT_CELL_EDITOR_BORDER);
    }

    protected void setupTextField() {
        this._textField.addFocusListener(this);
        this._textField.setFocusLostBehavior(1);
        InputMap inputMap = this._textField.getInputMap(0);
        while (inputMap.getParent() != null) {
            inputMap = inputMap.getParent();
        }
        inputMap.remove(KeyStroke.getKeyStroke(10, 0));
        inputMap.remove(KeyStroke.getKeyStroke(27, 0));
    }

    @Override
    public void setConverterContext(ConverterContext converterContext) {
        super.setConverterContext(converterContext);
        this.setTextFieldFormat();
    }

    private void setTextFieldFormat() {
        if (this.getConverterContext() != null && this.getConverterContext().getUserObject() instanceof JFormattedTextField.AbstractFormatter) {
            this._textField.setFormatterFactory(new DefaultFormatterFactory((JFormattedTextField.AbstractFormatter)this.getConverterContext().getUserObject()));
        }
    }

    @Override
    public Object getCellEditorValue() {
        try {
            if (this._textField.getFormatter() != null) {
                return this._textField.getFormatter().stringToValue(this._textField.getText());
            }
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        if (this.getConverter() != null) {
            return this.getConverter().fromString(this._textField.getText(), this.getConverterContext());
        }
        return ObjectConverterManager.fromString(this._textField.getText(), this._class, this.getConverterContext());
    }

    public void setCellEditorValue(Object object) {
        String string = object == null ? "" : (this.getConverter() != null ? this.getConverter().toString(object, this.getConverterContext()) : ObjectConverterManager.toString(object, this._class, this.getConverterContext()));
        try {
            this._settingEditorValue = true;
            this._textValid = true;
            this._textField.setText(string);
            if (!this._textValid) {
                this._textField.setValue(null);
            } else {
                this._textField.setValue(object);
            }
        }
        finally {
            this._settingEditorValue = false;
            this._textValid = false;
        }
        String string2 = this._textField.getSelectedText();
        if (string2 != null) {
            this._textField.selectAll();
        }
    }

    @Override
    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        if (jTable != null) {
            this.customizeTextField();
            JideSwingUtilities.installColorsAndFont(this._textField, jTable.getBackground(), jTable.getForeground(), jTable.getFont());
        }
        this.setCellEditorValue(object);
        if (this._textField != null && this.getEditorStyle() != 0) {
            this._textField.setEditable(this.getEditorStyle() == 3);
        }
        return this._textField;
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
    }

    protected JFormattedTextField.AbstractFormatterFactory getFormatFactory() {
        return this._textField.getFormatterFactory();
    }

    @Override
    public boolean isEditorStyleSupported(int n) {
        return n == 0 || n == 2 || n == 3;
    }
}

