/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.grid;

import com.jidesoft.filter.Filter;
import com.jidesoft.filter.NotFilter;
import com.jidesoft.grid.AutoFilterTableHeader;
import com.jidesoft.grid.AutoFilterTableModel;
import com.jidesoft.grid.DynamicTableFilter;
import com.jidesoft.grid.GroupModelProvider;
import com.jidesoft.grid.IFilterableTableModel;
import com.jidesoft.grid.MultipleValuesFilter;
import com.jidesoft.grid.SingleValueFilter;
import com.jidesoft.grid.TableHeaderCellDecorator;
import com.jidesoft.grid.TableModelWrapper;
import com.jidesoft.grid.TableModelWrapperUtils;
import com.jidesoft.plaf.basic.BasicAutoFilterTableHeaderUIDelegate;
import com.jidesoft.plaf.basic.BasicGroupTableHeaderUIDelegate;
import com.jidesoft.utils.ReflectionUtils;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.ImageIcon;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableModel;

public class FilterableTableHeaderCellDecorator
implements TableHeaderCellDecorator {
    public static final int GAP = 4;
    private static final String CLIENT_PROPERTY_CELL_DECORATOR_PROPERTIES = "TableHeaderUIDelegate.cellDecoratorProperties";
    private static final String CLIENT_PROPERTY_MOUSEOVER_GROUP_COLUMN_INDEX = "TableHeaderUIDelegate.mouseoverGroupColumnIndex";
    private boolean _showVerticalLine = true;

    @Override
    public Insets getInsets(Graphics graphics, JTableHeader jTableHeader, int n, Rectangle rectangle) {
        if (!(jTableHeader instanceof AutoFilterTableHeader && ((AutoFilterTableHeader)jTableHeader).isAutoFilterEnabled() && ((AutoFilterTableHeader)jTableHeader).isUseNativeHeaderRenderer() && this.needPaintFilterIcon(jTableHeader, n))) {
            return null;
        }
        int n2 = this.getMaxIconWidth(n, jTableHeader);
        return n2 == 0 ? null : new Insets(0, 0, 0, n2 + 4 + 2);
    }

    @Override
    public void paint(Graphics graphics, JTableHeader jTableHeader, int n, Rectangle rectangle, boolean bl) {
        if (!(jTableHeader instanceof AutoFilterTableHeader && ((AutoFilterTableHeader)jTableHeader).isAutoFilterEnabled() && ((AutoFilterTableHeader)jTableHeader).isUseNativeHeaderRenderer())) {
            return;
        }
        boolean bl2 = this.hasFilter(jTableHeader, n);
        ImageIcon imageIcon = ((AutoFilterTableHeader)jTableHeader).getFilterIcon(n, bl, bl2);
        int n2 = this.getMaxIconWidth(n, jTableHeader);
        if (imageIcon != null) {
            int n3 = jTableHeader.getComponentOrientation().isLeftToRight() ? rectangle.x + rectangle.width - n2 - 4 + (n2 - imageIcon.getIconWidth()) / 2 : rectangle.x + 4 + (n2 - imageIcon.getIconWidth()) / 2;
            if (this.needPaintFilterIcon(jTableHeader, n)) {
                Graphics2D graphics2D = (Graphics2D)graphics.create();
                imageIcon.paintIcon(jTableHeader, graphics2D, n3, rectangle.y + (rectangle.height - imageIcon.getIconHeight()) / 2);
                if (this.isShowVerticalLine()) {
                    Object object = jTableHeader.getClientProperty("TableHeaderUIDelegate.instance");
                    Object object2 = jTableHeader.getClientProperty(CLIENT_PROPERTY_CELL_DECORATOR_PROPERTIES);
                    if (object instanceof BasicAutoFilterTableHeaderUIDelegate) {
                        Object[] objectArray;
                        Rectangle rectangle2 = new Rectangle(rectangle);
                        rectangle2.width = jTableHeader.getComponentOrientation().isLeftToRight() ? (rectangle2.width -= n2 + 4 + 1) : n2 + 8;
                        graphics2D.setClip(new Rectangle(rectangle2.x + rectangle2.width - 2, rectangle2.y, 2, rectangle2.height));
                        boolean bl3 = false;
                        boolean bl4 = false;
                        if (object2 instanceof Object[] && (objectArray = (Object[])object2).length >= 1) {
                            if (objectArray[0] instanceof Boolean && ((Boolean)objectArray[0]).booleanValue()) {
                                bl3 = true;
                            }
                            if (objectArray.length >= 2 && objectArray[1] instanceof Boolean && ((Boolean)objectArray[1]).booleanValue()) {
                                bl4 = true;
                            }
                        }
                        if (n >= 0) {
                            ReflectionUtils.callAnyWithoutException(object, BasicAutoFilterTableHeaderUIDelegate.class, "paintCell", new Class[]{Graphics.class, Rectangle.class, Integer.TYPE, Object.class, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE}, new Object[]{graphics2D, rectangle2, n, "", bl3, bl4, false});
                        } else if (n <= -2) {
                            ReflectionUtils.callAnyWithoutException(object, BasicGroupTableHeaderUIDelegate.class, "paintGroupCell", new Class[]{Graphics.class, Rectangle.class, Integer.TYPE, Object.class, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE}, new Object[]{graphics2D, rectangle2, -2 - n, "", bl3, bl4, false});
                        }
                    }
                }
                graphics2D.dispose();
            }
        }
    }

    protected boolean needPaintFilterIcon(JTableHeader jTableHeader, int n) {
        Object object;
        TableModel tableModel = null;
        int n2 = -1;
        if (jTableHeader.getTable() != null) {
            IFilterableTableModel iFilterableTableModel = tableModel = jTableHeader instanceof AutoFilterTableHeader ? ((AutoFilterTableHeader)jTableHeader).getFilterableTableModel() : null;
            if (tableModel == null || !(tableModel instanceof AutoFilterTableModel)) {
                tableModel = TableModelWrapperUtils.getActualTableModel(jTableHeader.getTable().getModel(), AutoFilterTableModel.class);
            }
            if (n >= 0) {
                n2 = jTableHeader.getTable().convertColumnIndexToModel(n);
            } else if (n <= -2 && TableModelWrapperUtils.getActualTableModel((TableModel)(object = (GroupModelProvider)((Object)TableModelWrapperUtils.getActualTableModel(jTableHeader.getTable().getModel(), GroupModelProvider.class))), AutoFilterTableModel.class) == tableModel && -2 - n < object.getGroupColumnCount()) {
                n2 = object.getGroupColumnAt(-2 - n);
            }
        }
        if (n2 < 0 || tableModel instanceof AutoFilterTableModel && !((AutoFilterTableModel)((Object)tableModel)).isColumnAutoFilterable(n2)) {
            return false;
        }
        object = jTableHeader.getClientProperty("TableHeaderUIDelegate.filterCellDecoratorProperties");
        boolean bl = this.hasFilter(jTableHeader, n);
        boolean bl2 = false;
        if (object != null) {
            for (int n3 : (int[])object) {
                if (n3 >= 0 && n3 == n) {
                    bl2 = true;
                    break;
                }
                if (n3 > -2 || n3 != n) continue;
                bl2 = true;
                break;
            }
        }
        if (!bl2 && (object = jTableHeader.getClientProperty(CLIENT_PROPERTY_MOUSEOVER_GROUP_COLUMN_INDEX)) instanceof Integer && n < 0 && (Integer)object == -2 - n) {
            bl2 = true;
        }
        return jTableHeader instanceof AutoFilterTableHeader && (bl || bl2 || ((AutoFilterTableHeader)jTableHeader).isShowFilterIcon());
    }

    private boolean hasFilter(JTableHeader jTableHeader, int n) {
        int n2;
        int n3 = -1;
        IFilterableTableModel iFilterableTableModel = null;
        if (jTableHeader.getTable() != null) {
            GroupModelProvider groupModelProvider;
            TableModel tableModel = iFilterableTableModel = jTableHeader instanceof AutoFilterTableHeader ? ((AutoFilterTableHeader)jTableHeader).getFilterableTableModel() : TableModelWrapperUtils.getActualTableModel(jTableHeader.getTable().getModel(), IFilterableTableModel.class);
            if (n >= 0) {
                n2 = jTableHeader.getTable().convertColumnIndexToModel(n);
                n3 = TableModelWrapperUtils.getActualColumnAt(jTableHeader.getTable().getModel(), n2, iFilterableTableModel);
            } else if (n <= -2 && (groupModelProvider = (GroupModelProvider)((Object)TableModelWrapperUtils.getActualTableModel(jTableHeader.getTable().getModel(), GroupModelProvider.class))) instanceof TableModelWrapper && TableModelWrapperUtils.getActualTableModel((TableModel)((Object)groupModelProvider), IFilterableTableModel.class) == iFilterableTableModel && -2 - n < groupModelProvider.getGroupColumnCount()) {
                n3 = TableModelWrapperUtils.getActualColumnAt(((TableModelWrapper)((Object)groupModelProvider)).getActualModel(), groupModelProvider.getGroupColumnAt(-2 - n), iFilterableTableModel);
            }
        }
        n2 = 0;
        if (iFilterableTableModel instanceof IFilterableTableModel && n3 >= 0) {
            Filter[] filterArray;
            for (Filter filter : filterArray = iFilterableTableModel.getFilters(n3)) {
                if (!(filter instanceof SingleValueFilter) && !(filter instanceof MultipleValuesFilter) && (!(filter instanceof NotFilter) || !(((NotFilter)filter).getFilter() instanceof MultipleValuesFilter)) && !(filter instanceof DynamicTableFilter) && filter.getFilterFactory() == null) continue;
                n2 = 1;
                break;
            }
        }
        return n2 != 0;
    }

    private int getMaxIconWidth(int n, JTableHeader jTableHeader) {
        int n2 = 0;
        if (!(jTableHeader instanceof AutoFilterTableHeader)) {
            return n2;
        }
        ImageIcon imageIcon = ((AutoFilterTableHeader)jTableHeader).getFilterIcon(n, true, true);
        ImageIcon imageIcon2 = ((AutoFilterTableHeader)jTableHeader).getFilterIcon(n, true, false);
        ImageIcon imageIcon3 = ((AutoFilterTableHeader)jTableHeader).getFilterIcon(n, false, true);
        ImageIcon imageIcon4 = ((AutoFilterTableHeader)jTableHeader).getFilterIcon(n, false, false);
        if (imageIcon != null) {
            n2 = Math.max(n2, imageIcon2.getIconWidth());
        }
        if (imageIcon2 != null) {
            n2 = Math.max(n2, imageIcon2.getIconWidth());
        }
        if (imageIcon3 != null) {
            n2 = Math.max(n2, imageIcon3.getIconWidth());
        }
        if (imageIcon4 != null) {
            n2 = Math.max(n2, imageIcon4.getIconWidth());
        }
        return n2;
    }

    public boolean isShowVerticalLine() {
        return this._showVerticalLine;
    }

    public void setShowVerticalLine(boolean bl) {
        this._showVerticalLine = bl;
    }
}

