/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.grid;

import com.jidesoft.grid.CellStyle;
import com.jidesoft.grid.CellStyleCustomizer;
import com.jidesoft.grid.EditableColumnTableModel;
import com.jidesoft.grid.SortableTableHeader;
import com.jidesoft.grid.TableModelWrapperUtils;
import com.jidesoft.grid.TextFieldCellEditor;
import com.jidesoft.plaf.DelegateTableHeaderUI;
import com.jidesoft.plaf.basic.BasicCellStyleTableHeaderUIDelegate;
import com.jidesoft.swing.AlignmentSupport;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.utils.Lm;
import com.jidesoft.utils.Q;
import com.jidesoft.utils.SystemInfo;
import java.applet.Applet;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.KeyboardFocusManager;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.PointerInfo;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.EventListener;
import java.util.EventObject;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class EditableTableHeader
extends SortableTableHeader
implements CellEditorListener {
    private static final String uiClassID = "EditableTableHeaderUI";
    private static final String uiDelegateClassID = "TableHeader.editableTableHeaderUIDelegate";
    public final int HEADER_ROW = -1;
    protected transient int _editingColumn = -1;
    protected transient TableCellEditor _cellEditor = null;
    protected transient Component _editorComp;
    protected TableCellEditor _defaultEditor;
    private PropertyChangeListener _editorRemover = null;
    private boolean _rolloverEnabled = false;
    private MouseMotionListener _retargetMouseMotionListener;
    private boolean _clickToStartEditing = true;

    public EditableTableHeader(JTable jTable) {
        this(jTable.getColumnModel());
        this.setTable(jTable);
    }

    public EditableTableHeader(TableColumnModel tableColumnModel) {
        super(tableColumnModel);
        this.updateUI();
        this.setDefaultEditor(this.createDefaultEditor());
    }

    @Override
    public String getUIDelegateClassID() {
        return uiDelegateClassID;
    }

    @Override
    public String getActualUIClassID() {
        return uiClassID;
    }

    public boolean isRolloverEnabled() {
        return this._rolloverEnabled;
    }

    public void setRolloverEnabled(boolean bl) {
        this._rolloverEnabled = bl;
    }

    @Override
    public void resizeAndRepaint() {
        this.stopEditing();
        super.resizeAndRepaint();
    }

    void originalResizeAndRepaint() {
        super.resizeAndRepaint();
    }

    public void stopEditing() {
        if (this.isEditing()) {
            this.getCellEditor().stopCellEditing();
        }
    }

    public void cancelEditing() {
        if (this.isEditing()) {
            this.getCellEditor().cancelCellEditing();
        }
    }

    protected TableCellEditor createDefaultEditor() {
        return new TextFieldCellEditor(String.class){
            private static final long serialVersionUID = 7000472489985396150L;

            @Override
            protected JTextField createTextField() {
                JTextField jTextField = new JTextField();
                jTextField.registerKeyboardAction(new AbstractAction(){
                    private static final long serialVersionUID = 1237176950615312409L;

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        this.cancelCellEditing();
                    }
                }, KeyStroke.getKeyStroke(27, 0), 0);
                return jTextField;
            }
        };
    }

    public void setDefaultEditor(TableCellEditor tableCellEditor) {
        this._defaultEditor = tableCellEditor;
    }

    public TableCellEditor getDefaultEditor() {
        return this._defaultEditor;
    }

    public boolean editCellAt(int n) {
        return this.editCellAt(n, null);
    }

    @Override
    public void setDraggedColumn(TableColumn tableColumn) {
        if (tableColumn == null && this.getDraggedColumn() != null && !this.isRolloverEnabled()) {
            this.stopEditing();
        }
        super.setDraggedColumn(tableColumn);
    }

    public boolean editCellAt(int n, EventObject eventObject) {
        Object object;
        if (this._cellEditor != null && !this._cellEditor.stopCellEditing()) {
            return false;
        }
        if (n < 0 || n >= this.getColumnModel().getColumnCount()) {
            return false;
        }
        if (!this.isCellEditable(n)) {
            return false;
        }
        if (this._editorRemover == null) {
            object = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            this._editorRemover = new CellEditorRemover((KeyboardFocusManager)object);
            ((KeyboardFocusManager)object).addPropertyChangeListener("permanentFocusOwner", this._editorRemover);
        }
        if ((object = this.getCellEditor(n)) != null && object.isCellEditable(eventObject)) {
            this._editorComp = this.prepareEditor((TableCellEditor)object, n);
            this.customizeEditorComponent(this._editorComp, this.getRowCount() - 1, n);
            this._editorComp.setBounds(this.getHeaderRect(n));
            this.addRetargetMouseMotionListener(this._editorComp);
            this.add(this._editorComp);
            this._editorComp.validate();
            if (this.isAutoRequestFocus()) {
                this._editorComp.requestFocusInWindow();
            }
            this.setCellEditor((TableCellEditor)object);
            this.setEditingColumn(n);
            object.addCellEditorListener(this);
            return true;
        }
        return false;
    }

    protected void customizeEditorComponent(Component component, int n, int n2) {
        CellStyleCustomizer[] cellStyleCustomizerArray;
        if (component == null) {
            return;
        }
        component.applyComponentOrientation(this.getComponentOrientation());
        CellStyle cellStyle = this.getCellStyleAt(n, n2);
        if (cellStyle == null) {
            return;
        }
        Color color = cellStyle.getBackground();
        Color color2 = cellStyle.getForeground();
        if (!(color == null || color.equals(component.getBackground()) && color.equals(component.getBackground()))) {
            component.setBackground(color);
            if (component instanceof JComponent) {
                ((JComponent)component).setOpaque(true);
            }
        }
        if (!(color2 == null || color2.equals(component.getForeground()) && color2.equals(component.getForeground()))) {
            component.setForeground(color2);
        }
        if (!(cellStyle.getFont() == null || cellStyle.getFont().equals(component.getFont()) && cellStyle.getFont().equals(component.getFont()))) {
            component.setFont(cellStyle.getFont());
        } else if (cellStyle.getFontStyle() != -1 && cellStyle.getFontStyle() != (component.getFont() == null ? 0 : component.getFont().getStyle()) && (cellStyleCustomizerArray = component.getFont()) != null) {
            int n3 = cellStyle.getFontStyle();
            Font font = cellStyleCustomizerArray.deriveFont(n3);
            component.setFont(font);
        }
        if (cellStyle.getBorder() != null && component instanceof JComponent && !cellStyle.getBorder().equals(((JComponent)component).getBorder())) {
            ((JComponent)component).setBorder(cellStyle.getBorder());
        }
        if (component instanceof JLabel) {
            if (cellStyle.getIcon() != null) {
                ((JLabel)component).setIcon(cellStyle.getIcon());
            }
            if (cellStyle.getHorizontalAlignment() != -1) {
                ((JLabel)component).setHorizontalAlignment(cellStyle.getHorizontalAlignment());
            }
            if (cellStyle.getVerticalAlignment() != -1) {
                ((JLabel)component).setVerticalAlignment(cellStyle.getVerticalAlignment());
            }
            if (cellStyle.getHorizontalTextPosition() != -1) {
                ((JLabel)component).setHorizontalTextPosition(cellStyle.getHorizontalTextPosition());
            }
            if (cellStyle.getVerticalTextPosition() != -1) {
                ((JLabel)component).setVerticalTextPosition(cellStyle.getVerticalTextPosition());
            }
        } else if (component instanceof AbstractButton) {
            if (cellStyle.getIcon() != null) {
                ((AbstractButton)component).setIcon(cellStyle.getIcon());
            }
            if (cellStyle.getHorizontalAlignment() != -1) {
                ((AbstractButton)component).setHorizontalAlignment(cellStyle.getHorizontalAlignment());
            }
            if (cellStyle.getVerticalAlignment() != -1) {
                ((AbstractButton)component).setVerticalAlignment(cellStyle.getVerticalAlignment());
            }
            if (cellStyle.getHorizontalTextPosition() != -1) {
                ((AbstractButton)component).setHorizontalTextPosition(cellStyle.getHorizontalTextPosition());
            }
            if (cellStyle.getVerticalTextPosition() != -1) {
                ((AbstractButton)component).setVerticalTextPosition(cellStyle.getVerticalTextPosition());
            }
        } else if (component instanceof JTextField) {
            if (cellStyle.getHorizontalAlignment() != -1) {
                ((JTextField)component).setHorizontalAlignment(cellStyle.getHorizontalAlignment());
            }
        } else if (component instanceof AlignmentSupport) {
            if (cellStyle.getHorizontalAlignment() != -1) {
                ((AlignmentSupport)((Object)component)).setHorizontalAlignment(cellStyle.getHorizontalAlignment());
            }
            if (cellStyle.getVerticalAlignment() != -1) {
                ((AlignmentSupport)((Object)component)).setVerticalAlignment(cellStyle.getVerticalAlignment());
            }
        }
        if (cellStyle.getToolTipText() != null && component instanceof JComponent) {
            ((JComponent)component).setToolTipText(cellStyle.getToolTipText());
        }
        if (this.getCellStyleCustomizers() != null) {
            for (CellStyleCustomizer cellStyleCustomizer : this.getCellStyleCustomizers()) {
                cellStyleCustomizer.customizeEditorComponent(n, n2, component, cellStyle);
            }
        }
    }

    private void removeRetargetMouseMotionListener(Component component) {
        if (this._retargetMouseMotionListener != null) {
            JideSwingUtilities.setRecursively(component, new JideSwingUtilities.Handler(){

                @Override
                public void action(Component component) {
                    if (JideSwingUtilities.isListenerRegistered(component, MouseMotionListener.class, (EventListener)EditableTableHeader.this._retargetMouseMotionListener)) {
                        component.removeMouseMotionListener(EditableTableHeader.this._retargetMouseMotionListener);
                    }
                }

                @Override
                public void postAction(Component component) {
                }

                @Override
                public boolean condition(Component component) {
                    return true;
                }
            });
            this._retargetMouseMotionListener = null;
        }
    }

    private void addRetargetMouseMotionListener(Component component) {
        if (this._retargetMouseMotionListener == null) {
            this._retargetMouseMotionListener = new MouseMotionAdapter(){

                @Override
                public void mouseMoved(MouseEvent mouseEvent) {
                    JideSwingUtilities.retargetMouseEvent(mouseEvent.getID(), mouseEvent, EditableTableHeader.this);
                }
            };
        }
        JideSwingUtilities.setRecursively(component, new JideSwingUtilities.Handler(){

            @Override
            public void action(Component component) {
                if (!JideSwingUtilities.isListenerRegistered(component, MouseMotionListener.class, (EventListener)EditableTableHeader.this._retargetMouseMotionListener)) {
                    component.addMouseMotionListener(EditableTableHeader.this._retargetMouseMotionListener);
                }
            }

            @Override
            public void postAction(Component component) {
            }

            @Override
            public boolean condition(Component component) {
                return true;
            }
        });
    }

    public boolean isCellEditable(int n) {
        TableColumn tableColumn = this.columnModel.getColumn(n);
        int n2 = tableColumn.getModelIndex();
        TableModel tableModel = TableModelWrapperUtils.getActualTableModel(this.getTable().getModel(), EditableColumnTableModel.class);
        return tableModel == null || ((EditableColumnTableModel)((Object)tableModel)).isColumnHeaderEditable(n2);
    }

    public TableCellEditor getCellEditor(int n) {
        TableColumn tableColumn = this.columnModel.getColumn(n);
        int n2 = tableColumn.getModelIndex();
        TableCellEditor tableCellEditor = null;
        TableModel tableModel = TableModelWrapperUtils.getActualTableModel(this.getTable().getModel(), EditableColumnTableModel.class);
        if (tableModel != null) {
            tableCellEditor = ((EditableColumnTableModel)((Object)tableModel)).getColumnHeaderCellEditor(n2);
        }
        return tableCellEditor == null ? this.getDefaultEditor() : tableCellEditor;
    }

    protected void setCellEditor(TableCellEditor tableCellEditor) {
        TableCellEditor tableCellEditor2 = this._cellEditor;
        this._cellEditor = tableCellEditor;
        if (tableCellEditor2 != null) {
            tableCellEditor2.removeCellEditorListener(this);
        }
        if (tableCellEditor != null) {
            tableCellEditor.addCellEditorListener(this);
        }
    }

    public Component prepareEditor(TableCellEditor tableCellEditor, int n) {
        Object object = this.columnModel.getColumn(n).getHeaderValue();
        boolean bl = true;
        int n2 = -1;
        JTable jTable = this.getTable();
        return tableCellEditor.getTableCellEditorComponent(jTable, object, bl, n2, n);
    }

    public TableCellEditor getCellEditor() {
        return this._cellEditor;
    }

    public Component getEditorComponent() {
        return this._editorComp;
    }

    public void setEditingColumn(int n) {
        this._editingColumn = n;
    }

    public int getEditingColumn() {
        return this._editingColumn;
    }

    public void removeEditor() {
        KeyboardFocusManager.getCurrentKeyboardFocusManager().removePropertyChangeListener("permanentFocusOwner", this._editorRemover);
        this._editorRemover = null;
        TableCellEditor tableCellEditor = this.getCellEditor();
        if (tableCellEditor != null) {
            tableCellEditor.removeCellEditorListener(this);
            this.removeRetargetMouseMotionListener(this._editorComp);
            this.remove(this._editorComp);
            int n = this.getEditingColumn();
            Rectangle rectangle = this.getHeaderRect(n);
            this.setCellEditor(null);
            this.setEditingColumn(-1);
            this._editorComp = null;
            this.repaint(rectangle);
        }
    }

    public boolean isEditing() {
        return this._cellEditor != null;
    }

    @Override
    public void editingStopped(ChangeEvent changeEvent) {
        TableCellEditor tableCellEditor = this.getCellEditor();
        if (tableCellEditor != null) {
            Object object = tableCellEditor.getCellEditorValue();
            int n = this.getEditingColumn();
            if (n >= 0 && n < this.columnModel.getColumnCount()) {
                this.columnModel.getColumn(n).setHeaderValue(object);
                if (this.getUI() instanceof DelegateTableHeaderUI && ((DelegateTableHeaderUI)((Object)this.getUI())).getHeaderUIDelegate() instanceof BasicCellStyleTableHeaderUIDelegate) {
                    ((BasicCellStyleTableHeaderUIDelegate)((DelegateTableHeaderUI)((Object)this.getUI())).getHeaderUIDelegate()).invalidateCache(true);
                }
            }
            this.removeEditor();
        }
    }

    @Override
    public void editingCanceled(ChangeEvent changeEvent) {
        this.removeEditor();
    }

    @Override
    public void removeNotify() {
        KeyboardFocusManager.getCurrentKeyboardFocusManager().removePropertyChangeListener("permanentFocusOwner", this._editorRemover);
        this._editorRemover = null;
        super.removeNotify();
    }

    public boolean isClickToStartEditing() {
        return this._clickToStartEditing;
    }

    public void setClickToStartEditing(boolean bl) {
        this._clickToStartEditing = bl;
    }

    protected boolean isAutoRequestFocus() {
        return true;
    }

    static {
        try {
            if (Lm.class.getDeclaredMethods().length != 29 && Lm.class.getDeclaredMethods().length != 31) {
                System.err.println("The Lm class is invalid, exiting ... " + Lm.class.getDeclaredMethods().length);
                System.exit(-1);
            }
        }
        catch (Exception exception) {
            System.exit(-1);
        }
        if (!Q.zz(4)) {
            Lm.showInvalidProductMessage(EditableTableHeader.class.getName(), 4);
        }
    }

    class CellEditorRemover
    implements PropertyChangeListener {
        KeyboardFocusManager focusManager;

        public CellEditorRemover(KeyboardFocusManager keyboardFocusManager) {
            this.focusManager = keyboardFocusManager;
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            Object object;
            Object object2;
            if (!EditableTableHeader.this.isEditing()) {
                return;
            }
            if (SystemInfo.isJdk15Above()) {
                try {
                    object2 = MouseInfo.getPointerInfo();
                    if (object2 != null) {
                        object = ((PointerInfo)object2).getLocation();
                        SwingUtilities.convertPointFromScreen((Point)object, EditableTableHeader.this);
                        if (EditableTableHeader.this.contains((Point)object)) {
                            return;
                        }
                    }
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
            }
            if ((object = EditableTableHeader.this.getCellEditor()) != null) {
                for (object2 = this.focusManager.getPermanentFocusOwner(); object2 != null; object2 = ((Component)object2).getParent()) {
                    if (object2 == EditableTableHeader.this) {
                        return;
                    }
                    if (!(object2 instanceof Window) && (!(object2 instanceof Applet) || ((Component)object2).getParent() != null)) continue;
                    if (object2 != SwingUtilities.getRoot(EditableTableHeader.this) || object.stopCellEditing()) break;
                    object.cancelCellEditing();
                    break;
                }
            }
        }
    }
}

