/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.grid;

import com.jidesoft.grid.ContextSensitiveTableTransferHandler;
import com.jidesoft.grid.DualTable;
import com.jidesoft.grid.TableUtils;
import com.jidesoft.list.DefaultListModelWrapper;
import com.jidesoft.list.DualListModel;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.util.Arrays;
import javax.swing.JComponent;
import javax.swing.JTable;

class DualTableTransferHandler
extends ContextSensitiveTableTransferHandler {
    private static final long serialVersionUID = 6145036090035192163L;
    private boolean _dualTableImported;

    public boolean isExporting() {
        return this._rows != null && this._cols != null;
    }

    public boolean isDualTableImported() {
        return this._dualTableImported;
    }

    @Override
    public boolean canImport(JComponent jComponent, DataFlavor[] dataFlavorArray) {
        boolean bl = super.canImport(jComponent, dataFlavorArray);
        if (bl) {
            boolean bl2;
            JTable jTable = (JTable)jComponent;
            Object object = jTable.getClientProperty("DualTable.dualTable");
            if (!(object instanceof DualTable) || ((DualTable)object).getSelectedTable() != jTable || this.isExporting()) {
                return bl;
            }
            int[] nArray = ((DualTable)object).getSelectedIndices(((DualTable)object).getOriginalTable());
            boolean bl3 = bl2 = nArray.length > 0;
            if (bl2 && (((DualTable)object).getSelectionMode() == 2 && !((DualTable)object).isAllowDuplicates() || ((DualTable)object).getSelectionMode() == 1)) {
                for (int i = 0; i < nArray.length; ++i) {
                    nArray[i] = ((DualTable)object).getActualIndex(((DualTable)object).getOriginalTable(), nArray[i], null);
                }
                int[] nArray2 = ((DualTable)object).getSelectedIndices();
                for (int n : nArray) {
                    for (int n2 : nArray2) {
                        if (n != n2) continue;
                        bl2 = false;
                        break;
                    }
                    if (!bl2) break;
                }
            }
            bl = bl2;
        }
        return bl;
    }

    @Override
    protected void exportDone(JComponent jComponent, Transferable transferable, int n) {
        boolean bl;
        if (!(jComponent instanceof JTable)) {
            super.exportDone(jComponent, transferable, n);
            return;
        }
        JTable jTable = (JTable)jComponent;
        Object object = jTable.getClientProperty("DualTable.dualTable");
        if (!(object instanceof DualTable)) {
            super.exportDone(jComponent, transferable, n);
            return;
        }
        JTable jTable2 = ((DualTable)object).getOriginalTable();
        JTable jTable3 = ((DualTable)object).getSelectedTable();
        boolean bl2 = bl = this == jTable2.getTransferHandler();
        if (!(jTable2.getTransferHandler() instanceof DualTableTransferHandler) || !(jTable3.getTransferHandler() instanceof DualTableTransferHandler)) {
            if (bl) {
                super.exportDone(jComponent, transferable, n);
            }
            return;
        }
        DualTableTransferHandler dualTableTransferHandler = (DualTableTransferHandler)jTable2.getTransferHandler();
        DualTableTransferHandler dualTableTransferHandler2 = (DualTableTransferHandler)jTable3.getTransferHandler();
        if (!dualTableTransferHandler.isDualTableImported() && !dualTableTransferHandler2.isDualTableImported()) {
            if (bl) {
                super.exportDone(jComponent, transferable, n);
            }
            return;
        }
        if (bl && dualTableTransferHandler.isDualTableImported()) {
            super.exportDone(jComponent, transferable, n);
        }
        this.cleanUpFields();
    }

    @Override
    protected boolean importString(JComponent jComponent, String string, boolean bl) {
        DualTableTransferHandler dualTableTransferHandler;
        JTable jTable;
        this._dualTableImported = false;
        if (!(jComponent instanceof JTable)) {
            return false;
        }
        JTable jTable2 = (JTable)jComponent;
        Object object = jTable2.getClientProperty("DualTable.dualTable");
        if (!(object instanceof DualTable)) {
            return super.importString(jComponent, string, bl);
        }
        JTable jTable3 = ((DualTable)object).getOriginalTable();
        JTable jTable4 = ((DualTable)object).getSelectedTable();
        boolean bl2 = this == jTable3.getTransferHandler();
        JTable.DropLocation dropLocation = jTable2.getDropLocation();
        if (dropLocation == null || !(jTable3.getTransferHandler() instanceof DualTableTransferHandler) || !(jTable4.getTransferHandler() instanceof DualTableTransferHandler)) {
            return bl2 && super.importString(jComponent, string, bl);
        }
        DualTableTransferHandler dualTableTransferHandler2 = (DualTableTransferHandler)jTable3.getTransferHandler();
        DualTableTransferHandler dualTableTransferHandler3 = (DualTableTransferHandler)jTable4.getTransferHandler();
        JTable jTable5 = bl2 ? jTable4 : (jTable = dualTableTransferHandler3 == this ? jTable3 : null);
        if (jTable == null) {
            return false;
        }
        DualTableTransferHandler dualTableTransferHandler4 = dualTableTransferHandler = bl2 ? dualTableTransferHandler3 : dualTableTransferHandler2;
        if (!dualTableTransferHandler.isExporting() && !this.isExporting()) {
            return bl2 && super.importString(jComponent, string, false);
        }
        bl = !dualTableTransferHandler.isExporting();
        DualListModel dualListModel = ((DualTable)object)._model;
        DefaultListModelWrapper defaultListModelWrapper = ((DualTable)object)._selectedListModel;
        if (bl) {
            int n;
            int n2;
            if (bl2) {
                return super.importString(jComponent, string, bl);
            }
            int[] nArray = ((DualTable)object).getSelectedIndices(jTable4);
            Arrays.sort(nArray);
            int n3 = dropLocation.getRow();
            for (n2 = nArray.length - 1; n2 >= 0; --n2) {
                n = nArray[n2];
                if (n >= n3) continue;
                --n3;
            }
            dualListModel.setValueIsAdjusting(true);
            n2 = 0;
            while (n2 < nArray.length) {
                if (nArray[n2] != n3) {
                    int n4;
                    if (nArray[n2] > n3) {
                        n = ((DualTable)object).getActualIndex(jTable4, nArray[n2], defaultListModelWrapper);
                        n4 = ((DualTable)object).getActualIndex(jTable4, n3, defaultListModelWrapper);
                        dualListModel.moveSelection(n, n, n4, true);
                        nArray[n2] = n3;
                    } else {
                        n = ((DualTable)object).getActualIndex(jTable4, nArray[n2], defaultListModelWrapper);
                        n4 = ((DualTable)object).getActualIndex(jTable4, n3, defaultListModelWrapper);
                        dualListModel.moveSelection(n, n, n4, false);
                        nArray[n2] = n3;
                    }
                }
                ++n2;
                ++n3;
            }
            dualListModel.setValueIsAdjusting(false);
            ((DualTable)object).setSelectedIndices(jTable4, nArray);
            TableUtils.ensureRowSelectionVisible(jTable4);
        } else if (bl2) {
            ((DualTable)object).moveLeft();
        } else {
            jTable4.clearSelection();
            jTable4.getSelectionModel().setSelectionInterval(dropLocation.getRow(), dropLocation.getRow());
            boolean bl3 = dropLocation.getRow() >= jTable4.getRowCount();
            int n = jTable3.getSelectedRowCount();
            ((DualTable)object).moveRight();
            if (bl3) {
                jTable4.clearSelection();
                jTable4.getSelectionModel().setSelectionInterval(dropLocation.getRow(), dropLocation.getRow() + n - 1);
            }
        }
        this._dualTableImported = true;
        return true;
    }
}

